/*====================================+=====================================+
! File CPanPrefsComp.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                        Computation Preferences                            !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/textdlg.h>
#include "CApp.h"
#include "common/CSTEllipsize.h"
#include "prefs/CDlgPrefs.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CPanPrefsComp::CPanPrefsComp( wxWindow *parent )
             : CPanPrefsCompBase( parent )
{
   /*----------------------------------------------------------------------*/
   m_boo_imm_recompute->SetValue( wxGetApp().M_boo_imm_recompute.get() ) ;
   m_boo_exp_dir_ext->SetValue( wxGetApp().M_boo_exp_dir_ext.get() ) ;
   m_boo_id3v1aud_nvl->SetValue( wxGetApp().M_boo_id3v1aud_nvl.get() ) ;
   m_s_chars_tab_sep->SetValue( wxGetApp().M_s_chars_tab_sep.get() ) ;
   m_s_chars_word_sep->SetValue( wxGetApp().M_s_chars_word_sep.get() ) ;
   m_i_max_name_len->SetValue( wxGetApp().M_i_max_name_len.get() ) ;
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_s_chars_tab_sep , true ) ;
   sr::set_font_fix( m_s_chars_word_sep, true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsComp::~CPanPrefsComp()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsComp::init_default()
{
   /*----------------------------------------------------------------------*/
   m_boo_imm_recompute->SetValue( wxGetApp().M_boo_imm_recompute.get_def() );
   m_boo_exp_dir_ext->SetValue(wxGetApp().M_boo_exp_dir_ext.get_def() ) ;
   m_boo_id3v1aud_nvl->SetValue(wxGetApp().M_boo_id3v1aud_nvl.get_def() ) ;
   m_s_chars_tab_sep->SetValue( wxGetApp().M_s_chars_tab_sep.get_def() ) ;
   m_s_chars_word_sep->SetValue( wxGetApp().M_s_chars_word_sep.get_def() ) ;
   m_i_max_name_len->SetValue( wxGetApp().M_i_max_name_len.get_def() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsComp::validate_changes()
{
   /*----------------------------------------------------------------------*/
   int i_max_name_len = m_i_max_name_len->GetValue() ;

   /*--( Check maximum name length )---------------------------------------*/
   if( i_max_name_len != 0 && i_max_name_len < g_co_i_min_name_len )
   {
      /*-------------------------------------------------------------------*/
      sr::error_message( wxString::Format(
                    _( "A file name must be at least %d character(s) long" ),
                    g_co_i_min_name_len
                                          )
                       ) ;
      return( m_i_max_name_len ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsComp::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   bool     boo_imm_recompute = m_boo_imm_recompute->GetValue() ;
   bool     boo_exp_dir_ext = m_boo_exp_dir_ext->GetValue() ;
   bool     boo_id3v1aud_nvl = m_boo_id3v1aud_nvl->GetValue() ;
   wxString s_chars_tab_sep( sr::keep_one_of( m_s_chars_tab_sep->GetValue()
                                            )
                           ) ;
   wxString s_chars_word_sep( sr::keep_one_of( m_s_chars_word_sep->GetValue()
                                             )
                            ) ;
   int      i_max_name_len = m_i_max_name_len->GetValue() ;

   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_imm_recompute.get() != boo_imm_recompute )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_imm_recompute.set( boo_imm_recompute ) ;
      wxGetApp().m_frame->setup_immediate_recompute() ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if(    boo_exp_dir_ext  != wxGetApp().M_boo_exp_dir_ext.get()
       || boo_id3v1aud_nvl != wxGetApp().M_boo_id3v1aud_nvl.get()
       || s_chars_tab_sep  != wxGetApp().M_s_chars_tab_sep.get()
       || s_chars_word_sep != wxGetApp().M_s_chars_word_sep.get()
       || i_max_name_len   != wxGetApp().M_i_max_name_len.get()
     )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_exp_dir_ext.set( boo_exp_dir_ext ) ;
      wxGetApp().M_s_chars_tab_sep.set( s_chars_tab_sep ) ;
      wxGetApp().M_boo_id3v1aud_nvl.set( boo_id3v1aud_nvl ) ;
      wxGetApp().M_s_chars_word_sep.set( s_chars_word_sep ) ;
      wxGetApp().M_i_max_name_len.set( i_max_name_len ) ;
      /*-------------------------------------------------------------------*/
      dw_poa |= SR_PPA_COMPUTE ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsChar::CPanPrefsChar( wxWindow *parent )
             : CPanPrefsCharBase( parent )
{
   /*----------------------------------------------------------------------*/
   m_s_del_chars->SetValue( wxGetApp().M_s_del_chars.get() ) ;
   m_s_del_repeat_chars->SetValue( wxGetApp().M_s_del_repeat_chars.get() ) ;
   m_s_rep_chars_from->SetValue( wxGetApp().M_s_rep_chars_from.get() ) ;
   m_s_rep_chars_to->SetValue( wxGetApp().M_s_rep_chars_to.get() ) ;
   m_s_rep_char_inv->SetValue( wxGetApp().M_s_rep_char_inv.get() ) ;
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_s_del_chars       , true ) ;
   sr::set_font_fix( m_s_del_repeat_chars, true ) ;
   sr::set_font_fix( m_s_rep_chars_from  , true ) ;
   sr::set_font_fix( m_s_rep_chars_to    , true ) ;
   sr::set_font_fix( m_s_rep_char_inv    , true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsChar::~CPanPrefsChar()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsChar::OnText( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxString  s_from = m_s_rep_chars_from->GetValue() ;
   wxString  s_to   = m_s_rep_chars_to->GetValue() ;
   wxString  s_info ;
   const wxString co_s_arr( L" \x2192 " ) ;
   size_t sz_num ;

   /*----------------------------------------------------------------------*/
   for( sz_num = 0 ; sz_num < s_from.size() && sz_num < s_to.size() ;
        ++sz_num
      )
   {
      /*-------------------------------------------------------------------*/
      if( sz_num > 0 ) { s_info += ", " ; }
      /*-------------------------------------------------------------------*/
      if( sz_num < s_to.size() - 1 )
      {  s_info += s_from[ sz_num ] ; }
      else
      {  s_info += s_from.substr( sz_num ) ; }
      /*-------------------------------------------------------------------*/
      s_info += co_s_arr + s_to[ sz_num ] ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( s_info.empty() && s_from.empty() != s_to.empty() )
   {  s_info = _( "No modification" ) ; }

   /*----------------------------------------------------------------------*/
   m_s_rep_info->SetLabel( s_info ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsChar::init_default()
{
   /*----------------------------------------------------------------------*/
   m_s_del_chars->SetValue( wxGetApp().M_s_del_chars.get_def() ) ;
   m_s_del_repeat_chars->SetValue( wxGetApp().M_s_del_repeat_chars.get_def()
                                 ) ;
   m_s_rep_chars_from->SetValue(wxGetApp().M_s_rep_chars_from.get_def() ) ;
   m_s_rep_chars_to->SetValue( wxGetApp().M_s_rep_chars_to.get_def() ) ;
   m_s_rep_char_inv->SetValue( wxGetApp().M_s_rep_char_inv.get_def() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsChar::validate_changes()
{
   /*----------------------------------------------------------------------*/
   wxString s_rep_chars_from( m_s_rep_chars_from->GetValue() ) ;
   wxString s_rep_chars_to( m_s_rep_chars_to->GetValue() ) ;
   wxString s_rep_char_inv( m_s_rep_char_inv->GetValue() ) ;

   /*----------------------------------------------------------------------*/
   if( s_rep_chars_to.empty() && !s_rep_chars_from.empty() )
   {  /*-------------------------------------------------------------------*/
      sr::error_message( _( "\"To\" can't be empty if \"From\" is not" ) ) ;
      return( m_s_rep_chars_to ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if(    !s_rep_char_inv.empty()
       && wxFileName::GetForbiddenChars().find( s_rep_char_inv[ 0 ]
                                              ) != wxString::npos
      )
   {  /*-------------------------------------------------------------------*/
      sr::error_message( wxString::Format(
                      _( "The replacement character cannot be one of : %s" ),
                      wxFileName::GetForbiddenChars()
                        )
                       ) ;
      return( m_s_rep_char_inv ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsChar::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   wxString s_del_chars( sr::keep_one_of( m_s_del_chars->GetValue() ) ) ;
   wxString s_del_repeat_chars( sr::keep_one_of(
                                             m_s_del_repeat_chars->GetValue()
                                               )
                              ) ;
   /*----------------------------------------------------------------------*/
   wxString s_rep_chars_from( m_s_rep_chars_from->GetValue() ) ;
   wxString s_rep_chars_to( m_s_rep_chars_to->GetValue() ) ;
   wxString s_rep_char_inv( m_s_rep_char_inv->GetValue() ) ;

   /*----------------------------------------------------------------------*/
   if(    s_del_chars        != wxGetApp().M_s_del_chars.get()
       || s_del_repeat_chars != wxGetApp().M_s_del_repeat_chars.get()
       || s_rep_chars_from   != wxGetApp().M_s_rep_chars_from.get()
       || s_rep_chars_to     != wxGetApp().M_s_rep_chars_to.get()
       || s_rep_char_inv     != wxGetApp().M_s_rep_char_inv.get()
     )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_s_del_chars.set( s_del_chars )               ;
      wxGetApp().M_s_del_repeat_chars.set( s_del_repeat_chars ) ;
      wxGetApp().M_s_rep_chars_from.set( s_rep_chars_from )     ;
      wxGetApp().M_s_rep_chars_to.set( s_rep_chars_to )         ;
      wxGetApp().M_s_rep_char_inv.set( s_rep_char_inv )         ;
      /*-------------------------------------------------------------------*/
      dw_poa |= SR_PPA_COMPUTE ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsCase::CPanPrefsCase( wxWindow *parent )
             : CPanPrefsCaseBase( parent )
{
   /*----------------------------------------------------------------------*/
   const int co_i_nb_word = wxGetApp().M_as_force_case_word.Count() ;
   int i_num_word ;
   /*----------------------------------------------------------------------*/
   m_boo_force_case_word->SetValue( wxGetApp().M_boo_force_case_word.get() );
   /*----------------------------------------------------------------------*/
   m_lv_word->InsertColumn( 0, _( "Word" ), wxLIST_FORMAT_LEFT, 200 ) ;
   /*----------------------------------------------------------------------*/
   for( i_num_word = 0 ; i_num_word < co_i_nb_word ; ++i_num_word )
   {  m_lv_word->InsertItem( i_num_word,
                             wxGetApp().M_as_force_case_word[ i_num_word ]
                           ) ;
   }
   /*----------------------------------------------------------------------*/
   if( co_i_nb_word > 0 )
   {  m_lv_word->set_item_active( 0 ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsCase::~CPanPrefsCase()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::init_default()
{
   /*----------------------------------------------------------------------*/
   m_boo_force_case_word->SetValue(wxGetApp().M_boo_force_case_word.get_def()
                                  ) ;
   /*----------------------------------------------------------------------*/
   m_lv_word->DeleteAllItems() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsCase::validate_changes()
{
   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   bool boo_force_case_word( m_boo_force_case_word->GetValue() ) ;
   /*----------------------------------------------------------------------*/
   wxArrayString as_force_case_word ;
   int           i_nb_word  ;
   int           i_num_word ;

   /*----------------------------------------------------------------------*/
   if( boo_force_case_word != wxGetApp().M_boo_force_case_word.get() )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_boo_force_case_word.set( boo_force_case_word ) ;
      dw_poa |= SR_PPA_COMPUTE ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Transfer the words from the list window )-------------------------*/
   i_nb_word = m_lv_word->GetItemCount() ;
   for( i_num_word = 0 ; i_num_word < i_nb_word ; ++i_num_word )
   {  as_force_case_word.Add( m_lv_word->GetItemText( i_num_word ) ) ; }

   /*--( Siren's sort function )-------------------------------------------*/
   as_force_case_word.Sort( sr::ic_comp ) ;
   /*--( The transfer is done only if a change has been done )-------------*/
   if( wxGetApp().M_as_force_case_word.get() != as_force_case_word )
   {
      /*-------------------------------------------------------------------*/
      wxGetApp().M_as_force_case_word.set( as_force_case_word ) ;
      dw_poa |= SR_PPA_COMPUTE ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::OnBtAdd( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   edit( -1 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::OnBtModify( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   edit( m_lv_word->get_item_focus() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::OnBtDelete( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_lv_word->delete_hil() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::OnListItemActivated( wxListEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   edit( m_lv_word->get_item_focus() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsCase::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   switch( event.GetKeyCode() )
   {
      /*--( Highlight all elements )---------------------------------------*/
      case 'A' :
         if( event.GetModifiers() == wxMOD_CMD )
         {  m_lv_word->set_item_hil( -1, true ) ; }
         else
         {  event.Skip() ; }
         break ;

      /*-------------------------------------------------------------------*/
      case WXK_DELETE :
         if( event.GetModifiers() == 0 )
         {  m_lv_word->delete_hil() ; }
         else
         {  event.Skip() ; }
         break ;

      /*--( Ctrl+Alt+F5: Test generate elements )--------------------------*/
#ifdef __WXDEBUG__
      case WXK_F5 :
      {
         /*----------------------------------------------------------------*/
         if( event.GetModifiers() != ( wxMOD_CMD | wxMOD_ALT ) )
         {  event.Skip() ; break ; }
         /*----------------------------------------------------------------*/
         int i_num     = m_lv_word->GetItemCount() ;
         int i_num_max = i_num + 10 ;
         /*----------------------------------------------------------------*/
         for( ; i_num < i_num_max ; ++i_num )
         {  m_lv_word->InsertItem( i_num,
                                   wxString::Format( _( "Word %d" ), i_num )
                                 ) ;
         }
         /*----------------------------------------------------------------*/
         m_lv_word->set_item_active( i_num - 1 ) ;
         /*----------------------------------------------------------------*/
      }
#endif // __WXDEBUG__
      /*-------------------------------------------------------------------*/
      default:
         event.Skip() ;
         break ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*--( -1 means "add" )-----------------------------------------------------*/
int CPanPrefsCase::edit( long l_item )
{
   /*----------------------------------------------------------------------*/
   wxString s            ;
   long     l_item_found ;
   bool     boo_exists   ;

   /*--( New item ? )------------------------------------------------------*/
   if( l_item >= 0 && l_item < m_lv_word->GetItemCount() )
   {  s = m_lv_word->get_item_text( l_item ) ; }

   /*----------------------------------------------------------------------*/
   do
   {  /*--( Get the trimmed value )----------------------------------------*/
      s = wxGetTextFromUser( _( "Enter the word :" ),
                             _( "Forced case words edition" ),
                             s, this
                           ).Trim( false ).Trim() ;
      /*-------------------------------------------------------------------*/
      if( s.empty() ) { return( 0 ) ; }

      /*--( Value already exists ? )---------------------------------------*/
      l_item_found = m_lv_word->FindItem( -1, s ) ;
      boo_exists = ( l_item_found >= 0 && l_item_found != l_item ) ;
      if( boo_exists )
      {  sr::error_message( _( "Word already present in the list" ) ) ; }
      /*-------------------------------------------------------------------*/
   } while( boo_exists ) ;

   /*--( Apply the change to the list )------------------------------------*/
   if( l_item >= 0 )
   {  m_lv_word->SetItemText( l_item, s ) ; }
   else
   {  l_item = m_lv_word->InsertItem( m_lv_word->GetItemCount(), s ) ;
      m_lv_word->set_item_active( l_item ) ;
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsDate::CPanPrefsDate( wxWindow *parent )
             : CPanPrefsDateBase( parent )
{
   /*----------------------------------------------------------------------*/
   m_s_fmt_date->SetValue( wxGetApp().M_s_fmt_date.get() ) ;
   m_s_fmt_time->SetValue( wxGetApp().M_s_fmt_time.get() ) ;
   m_s_fmt_date_time->SetValue( wxGetApp().M_s_fmt_date_time.get() ) ;
   m_i_fmt_date_add->SetValue(
             sr::duration_to_string( wxGetApp().M_i_fmt_date_add.get(), '+' )
                             ) ;
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_s_fmt_date, true )      ;
   sr::set_font_fix( m_s_fmt_time, true )      ;
   sr::set_font_fix( m_s_fmt_date_time, true ) ;
   sr::set_font_fix( m_i_fmt_date_add, true )  ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsDate::~CPanPrefsDate()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsDate::init_default()
{
   /*----------------------------------------------------------------------*/
   m_s_fmt_date->SetValue( wxGetApp().M_s_fmt_date.get_def() ) ;
   m_s_fmt_time->SetValue( wxGetApp().M_s_fmt_time.get_def() ) ;
   m_s_fmt_date_time->SetValue( wxGetApp().M_s_fmt_date_time.get_def() ) ;
   m_i_fmt_date_add->SetValue(
         sr::duration_to_string( wxGetApp().M_i_fmt_date_add.get_def(), '+' )
                             ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsDate::validate_changes()
{
   /*----------------------------------------------------------------------*/
   wxString s_fmt_date_add( m_i_fmt_date_add->GetValue() ) ;
   int      i_fmt_date_add ;
   wxWindow *p_win_err ;

   /*----------------------------------------------------------------------*/
   if(    ( p_win_err = check_mandatory( m_s_fmt_date ) ) != NULL
       || ( p_win_err = check_mandatory( m_s_fmt_time ) ) != NULL
       || ( p_win_err = check_mandatory( m_s_fmt_date_time ) ) != NULL
     )
   {  return( p_win_err ) ; }

   /*--( Extract an check the value )--------------------------------------*/
   if(    !s_fmt_date_add.empty()
       && sr::conv_time_to_nb_sec( s_fmt_date_add.begin(),
                                   s_fmt_date_add.end(),
                                   i_fmt_date_add
                                 ) != s_fmt_date_add.end()
     )
   {  /*-------------------------------------------------------------------*/
      sr::error_message( _( "Invalid duration" ) ) ;
      return( m_i_fmt_date_add ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsDate::apply_changes( wxUint32 &dw_poa )
{
   /*----------------------------------------------------------------------*/
   wxString s_fmt_date( m_s_fmt_date->GetValue() ) ;
   wxString s_fmt_time( m_s_fmt_time->GetValue() ) ;
   wxString s_fmt_date_time( m_s_fmt_date_time->GetValue() ) ;
   wxString s_fmt_date_add( m_i_fmt_date_add->GetValue() ) ;
   int      i_fmt_date_add = 0 ;

   /*----------------------------------------------------------------------*/
   if(    s_fmt_date_add.empty()
       || sr::conv_time_to_nb_sec( s_fmt_date_add.begin(),
                                   s_fmt_date_add.end(),
                                   i_fmt_date_add
                                 ) != s_fmt_date_add.end()
     )
   {  i_fmt_date_add = 0 ; }

   /*----------------------------------------------------------------------*/
   if(    s_fmt_date      != wxGetApp().M_s_fmt_date.get()
       || s_fmt_time      != wxGetApp().M_s_fmt_time.get()
       || s_fmt_date_time != wxGetApp().M_s_fmt_date_time.get()
       || i_fmt_date_add  != wxGetApp().M_i_fmt_date_add.get()
     )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_s_fmt_date.set( s_fmt_date ) ;
      wxGetApp().M_s_fmt_time.set( s_fmt_time ) ;
      wxGetApp().M_s_fmt_date_time.set( s_fmt_date_time ) ;
      wxGetApp().M_i_fmt_date_add.set( i_fmt_date_add ) ;
      /*-------------------------------------------------------------------*/
      dw_poa |= SR_PPA_COMPUTE ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsDate::OnBtHelp( wxCommandEvent & WXUNUSED( event ) )
{  wxGetApp().m_frame->show_help( HELP_DATE ) ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsDate::OnBtTest( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxString   s_fmt_date_add( m_i_fmt_date_add->GetValue() ) ;
   int        i_fmt_date_add = 0                             ;
   wxDateTime dt_test = wxDateTime::Now()                    ;
   wxString   s_format                                       ;

   /*----------------------------------------------------------------------*/
   if(    s_fmt_date_add.empty()
       || sr::conv_time_to_nb_sec( s_fmt_date_add.begin(),
                                   s_fmt_date_add.end(),
                                   i_fmt_date_add
                                 ) != s_fmt_date_add.end()
     )
   {  i_fmt_date_add = 0 ; }
   /*----------------------------------------------------------------------*/
   dt_test.Add( wxTimeSpan( 0, 0, i_fmt_date_add ) ) ;

   /*--( Avoid assert if format is empty )---------------------------------*/
   s_format = m_s_fmt_date->GetValue() ;
   m_s_fmt_date_test->SetLabel( s_format.empty()
                                ? s_format : dt_test.Format( s_format )
                              ) ;
   /*----------------------------------------------------------------------*/
   s_format = m_s_fmt_time->GetValue() ;
   m_s_fmt_time_test->SetLabel( s_format.empty()
                                ? s_format : dt_test.Format( s_format )
                              ) ;
   /*----------------------------------------------------------------------*/
   s_format = m_s_fmt_date_time->GetValue() ;
   m_s_fmt_date_time_test->SetLabel( s_format.empty()
                                     ? s_format : dt_test.Format( s_format )
                                   ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsNum::CPanPrefsNum( wxWindow *parent )
            : CPanPrefsNumBase( parent )
{
   /*----------------------------------------------------------------------*/
   const int co_i_min = std::numeric_limits< int >::min() ;
   const int co_i_max = std::numeric_limits< int >::max() ;
   /*----------------------------------------------------------------------*/
   m_i_sel_num_pad->SetValue( wxGetApp().M_i_sel_num_pad.get() ) ;
   m_i_sel_num_beg->SetValue( wxGetApp().M_i_sel_num_beg.get() ) ;
   m_i_sel_num_inc->SetValue( wxGetApp().M_i_sel_num_inc.get() ) ;
   m_i_num_in_name_pad->SetValue( wxGetApp().M_i_num_in_name_pad.get() );
   m_i_num_in_name_add->SetValue( wxGetApp().M_i_num_in_name_add.get() );
   m_i_track_pad->SetValue( wxGetApp().M_i_track_pad.get() ) ;
   m_i_rand_len->SetValue( wxGetApp().M_i_rand_len.get() ) ;
   /*----------------------------------------------------------------------*/
   m_i_sel_num_pad->SetRange( g_co_i_min_num_pad, g_co_i_max_num_pad ) ;
   m_i_sel_num_beg->SetRange( co_i_min, co_i_max ) ;
   m_i_sel_num_inc->SetRange( co_i_min, co_i_max ) ;
   m_i_num_in_name_pad->SetRange( g_co_i_min_num_pad, g_co_i_max_num_pad ) ;
   m_i_num_in_name_add->SetRange( co_i_min, co_i_max ) ;
   m_i_track_pad->SetRange( g_co_i_min_num_pad, g_co_i_max_num_pad ) ;
   m_i_rand_len->SetRange( g_co_i_min_rand_len, g_co_i_max_rand_len ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CPanPrefsNum::~CPanPrefsNum()
{  ; }

/*-------------------------------------------------------------------------*/
void CPanPrefsNum::init_default()
{
   /*----------------------------------------------------------------------*/
   m_i_sel_num_pad->SetValue( wxGetApp().M_i_sel_num_pad.get_def() ) ;
   m_i_sel_num_beg->SetValue( wxGetApp().M_i_sel_num_beg.get_def() ) ;
   m_i_sel_num_inc->SetValue( wxGetApp().M_i_sel_num_inc.get_def() ) ;
   m_i_num_in_name_pad->SetValue( wxGetApp().M_i_num_in_name_pad.get_def() );
   m_i_num_in_name_add->SetValue( wxGetApp().M_i_num_in_name_add.get_def() );
   m_i_track_pad->SetValue( wxGetApp().M_i_track_pad.get_def() ) ;
   m_i_rand_len->SetValue( wxGetApp().M_i_rand_len.get_def() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxWindow *CPanPrefsNum::validate_changes()
{
   /*----------------------------------------------------------------------*/
   return( NULL ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CPanPrefsNum::apply_changes( wxUint32 &dw_poa )
{
   /*--( The values are supposed to be ok ... )----------------------------*/
   int i_sel_num_pad     = m_i_sel_num_pad->GetValue() ;
   int i_sel_num_beg     = m_i_sel_num_beg->GetValue() ;
   int i_sel_num_inc     = m_i_sel_num_inc->GetValue() ;
   int i_num_in_name_pad = m_i_num_in_name_pad->GetValue() ;
   int i_num_in_name_add = m_i_num_in_name_add->GetValue() ;
   int i_track_pad       = m_i_track_pad->GetValue() ;
   int i_rand_len        = m_i_rand_len->GetValue() ;

   /*----------------------------------------------------------------------*/
   if(    i_sel_num_pad     != wxGetApp().M_i_sel_num_pad.get()
       || i_sel_num_beg     != wxGetApp().M_i_sel_num_beg.get()
       || i_sel_num_inc     != wxGetApp().M_i_sel_num_inc.get()
       || i_num_in_name_pad != wxGetApp().M_i_num_in_name_pad.get()
       || i_num_in_name_add != wxGetApp().M_i_num_in_name_add.get()
       || i_track_pad       != wxGetApp().M_i_track_pad.get()
       || i_rand_len        != wxGetApp().M_i_rand_len.get()
     )
   {
      /*-------------------------------------------------------------------*/
      wxGetApp().M_i_sel_num_pad.set( i_sel_num_pad )         ;
      wxGetApp().M_i_sel_num_beg.set( i_sel_num_beg )         ;
      wxGetApp().M_i_sel_num_inc.set( i_sel_num_inc )         ;
      wxGetApp().M_i_num_in_name_pad.set( i_num_in_name_pad ) ;
      wxGetApp().M_i_num_in_name_add.set( i_num_in_name_add ) ;
      wxGetApp().M_i_track_pad.set( i_track_pad )             ;
      wxGetApp().M_i_rand_len.set( i_rand_len )               ;
      /*-------------------------------------------------------------------*/
      dw_poa |= SR_PPA_COMPUTE ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                     End of file CPanPrefsComp.cpp                         !
+==========================================================================*/
