/*====================================+=====================================+
! File CDlgPrefs.cpp                  ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/msgdlg.h>
#include <wx/treebook.h>
#include "CApp.h"
#include "CDirTree.h"
#include "prefs/CDlgPrefs.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CDlgPrefs, wxPropertySheetDialog )
   /*----------------------------------------------------------------------*/
   EVT_BUTTON( wxID_OK, CDlgPrefs::OnBtOk )
   EVT_BUTTON( wxID_APPLY, CDlgPrefs::OnBtApply )
   EVT_BUTTON( wxID_HELP, CDlgPrefs::OnBtResetPageDefaults )
   /*----------------------------------------------------------------------*/
#ifdef __WXMSW__
   EVT_TREEBOOK_PAGE_CHANGED( wxID_ANY, CDlgPrefs::OnPageChanged )
#endif // __WXMSW__
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
size_t CDlgPrefs::st_sz_last_visited_page = 0 ;

/*-------------------------------------------------------------------------*/
CDlgPrefs::CDlgPrefs( wxWindow *parent )
{
   /*--( Avoid problem in "page changed" during creation )-----------------*/
   m_bt_reset = NULL ;
   /*----------------------------------------------------------------------*/
   SetSheetStyle( wxPROPSHEET_TREEBOOK ) ;
   /*----------------------------------------------------------------------*/
   if( !Create( parent, wxID_ANY, _( "Preferences" ),
                wxDefaultPosition, wxDefaultSize,
                wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER
              )
     )
   {  sr::error_message( "Error creating wxPropertySheetDialog" ) ;
      return ;
   }

   /*----------------------------------------------------------------------*/
   wxTreebook *book = static_cast< wxTreebook * >( GetBookCtrl() ) ;
   /*----------------------------------------------------------------------*/
   CPanPrefsGen  *p_gen  = new CPanPrefsGen( book )  ;
   CPanPrefsDisp *p_disp = new CPanPrefsDisp( book ) ;
   CPanPrefsComp *p_comp = new CPanPrefsComp( book ) ;
   CPanPrefsChar *p_char = new CPanPrefsChar( book ) ;
   CPanPrefsCase *p_case = new CPanPrefsCase( book ) ;
   CPanPrefsDate *p_date = new CPanPrefsDate( book ) ;
   CPanPrefsNum  *p_num  = new CPanPrefsNum( book )  ;
   CPanPrefsCol  *p_col  = new CPanPrefsCol( book )  ;
   CPanPrefsCbc  *p_cbc  = new CPanPrefsCbc( book )  ;
#ifdef __WXMSW__
   CPanPrefsScut *p_scut = new CPanPrefsScut( book ) ;
#endif // __WXMSW__

   /*----------------------------------------------------------------------*/
   book->AddPage( p_gen , _( "General" ) ) ;
   book->AddPage( p_disp, _( "Display" ) ) ;

   /*----------------------------------------------------------------------*/
   book->AddPage( p_comp, _( "New name computation" ) ) ;
   int i_comp_page_id = book->GetPageCount() - 1 ;
   /*----------------------------------------------------------------------*/
   book->AddSubPage( p_char, _( "Characters" ) ) ;
   book->AddSubPage( p_case, _( "Force case" ) ) ;
   book->AddSubPage( p_date, _( "Dates" ) ) ;
   book->AddSubPage( p_num , _( "Numbers" ) ) ;

   /*--( Open the node else the tree window won't have the right width )---*/
   book->ExpandNode( i_comp_page_id ) ;

   /*----------------------------------------------------------------------*/
   book->AddPage( p_col , _( "Columns" ) ) ;
   m_sz_col_page_num = book->GetPageCount() - 1 ;
   /*----------------------------------------------------------------------*/
   book->AddPage( p_cbc , _( "Clipboard" ) ) ;
#ifdef __WXMSW__
   book->AddPage( p_scut, _( "Shortcuts" ) ) ;
   m_sz_scut_page_num = book->GetPageCount() - 1 ;
#endif // __WXMSW__

   /*-----------------------------------------------------------------------+
   ! "Help" button is used for restore page defaults                        !
   +-----------------------------------------------------------------------*/
   CreateButtons( wxOK | wxAPPLY | wxCANCEL | wxHELP ) ;
   /*----------------------------------------------------------------------*/
   m_bt_reset = FindWindow( wxID_HELP ) ;
   if( m_bt_reset != NULL )
   {  /*--( Change displayed information )---------------------------------*/
      m_bt_reset->SetLabel( _( "&Reset current page" ) ) ;
      m_bt_reset->SetToolTip(
                            _( "Reset the current page with default values" )
                            ) ;
      /*--( Move the button in first position )----------------------------*/
      wxSizer *sizer = m_bt_reset->GetContainingSizer() ;
      if( sizer != NULL )
      {  /*----------------------------------------------------------------*/
         sizer->Detach( m_bt_reset ) ;
         sizer->Prepend( m_bt_reset ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   LayoutDialog() ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, wxGetApp().M_rec_prefs ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgPrefs::~CDlgPrefs()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_prefs ) ;
   /*----------------------------------------------------------------------*/
   st_sz_last_visited_page = get_current_page() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgPrefs::OnBtOk( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   if( validate_changes() )
   {  apply_changes() ; EndModal( wxID_OK ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgPrefs::OnBtApply( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   if( validate_changes() ) { apply_changes() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgPrefs::OnBtResetPageDefaults( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   get_page( get_current_page() )->init_default() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
void CDlgPrefs::OnPageChanged( wxBookCtrlEvent &event )
{
   /*--( Reset values not available on the Shortcut page )-----------------*/
   if( m_bt_reset != NULL )
   {  m_bt_reset->Enable(    ( size_t )event.GetSelection()
                          != m_sz_scut_page_num
                        ) ;
   }
   /*----------------------------------------------------------------------*/
}
#endif // __WXMSW__

/*--( If validation fails, the focus is set to the concerned field )-------*/
bool CDlgPrefs::validate_changes()
{
   /*----------------------------------------------------------------------*/
   size_t   sz_num ;
   wxWindow *p_win_err ;
   /*----------------------------------------------------------------------*/
   for( sz_num = 0 ; sz_num < get_nb_page() ; ++sz_num )
   {
      /*-------------------------------------------------------------------*/
      if( ( p_win_err = get_page( sz_num )->validate_changes() ) != NULL )
      {
         /*----------------------------------------------------------------*/
         set_current_page( sz_num ) ;
         p_win_err->SetFocus() ;
         /*----------------------------------------------------------------*/
         return( false ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgPrefs::apply_changes()
{
   /*----------------------------------------------------------------------*/
   size_t   sz_num ;
   wxUint32 dw_poa = SR_PPA_NOTHING ;

   /*--( Each panel will tell the actions to take after ... )--------------*/
   for( sz_num = 0 ; sz_num < get_nb_page() ; ++sz_num )
   {
      /*-------------------------------------------------------------------*/
      get_page( sz_num )->apply_changes( dw_poa ) ;
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! Refreshing the directory tree implies a reload of current directory    !
   ! Reloading generates recompute, sort ...                                !
   +-----------------------------------------------------------------------*/
   if( ( dw_poa & SR_PPA_REFRESH_DT ) != 0 )
   {  wxGetApp().m_frame->m_dt->refresh() ; }
   else
   if( ( dw_poa & SR_PPA_RELOAD ) != 0 )
   {  wxGetApp().m_frame->load_directory() ; }
   else
   {
      /*-------------------------------------------------------------------*/
      if( ( dw_poa & SR_PPA_REFRESH_FL ) != 0 )
      {  wxGetApp().get_fl()->Refresh() ; }
      /*-------------------------------------------------------------------*/
      if( ( dw_poa & SR_PPA_DISP_IMG ) != 0 )
      {  wxGetApp().m_frame->visu_file() ; }
      /*-------------------------------------------------------------------*/
      if( ( dw_poa & SR_PPA_COMPUTE ) != 0 )
      {  wxGetApp().get_fl()->compute_data_and_new_names() ; }
      /*-------------------------------------------------------------------*/
      if( ( dw_poa & SR_PPA_SORT ) != 0 )
      {  wxGetApp().get_fl()->sort_file_list( CFileList::SFL_DO_RESFRESH ) ;}
      /*-------------------------------------------------------------------*/
      if( ( dw_poa & SR_PPA_COLUMN ) != 0 )
      {
         /*----------------------------------------------------------------*/
         CFileList *p_fl = wxGetApp().get_fl() ;
         /*----------------------------------------------------------------*/
         wxGetApp().m_colgroup.synchro_used_disp_button() ;
         /*----------------------------------------------------------------*/
         p_fl->create_all_col( CFileList::CAC_DO_FORCE_CREATION ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDlgPrefs::get_modal()
{
   /*----------------------------------------------------------------------*/
   if( st_sz_last_visited_page < get_nb_page() )
   {  set_current_page( st_sz_last_visited_page ) ; }
   /*----------------------------------------------------------------------*/
   return( ShowModal() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDlgPrefs::get_modal_col()
{
   /*----------------------------------------------------------------------*/
   set_current_page( m_sz_col_page_num ) ;
   /*----------------------------------------------------------------------*/
   return( ShowModal() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CDlgPrefs.cpp                           !
+==========================================================================*/
