/*====================================+=====================================+
! File CFrame_On.cpp                  ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/filesys.h>
#include <wx/menu.h>
#include <wx/msgdlg.h>
#include <wx/socket.h>
#include "siren_info.h"
#include "siren.h"
#include "CApp.h"
#include "CFileList.h"
#include "CCombo.h"
#include "CDirTree.h"
#include "CColGroup.h"
#include "CDlgFilter.h"
#include "prefs/CDlgPrefs.h"
#include "CLoadDir.h"
#include "CWizard.h"
#include "CTestbed.h"
#include "CFSWatcher.h"
#include "dynmenu/CFavourite.h"
#include "CCompletion.h"
#include "CTagVisu.h"
#include "CCheckVersion.h"
#include "sr_about.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
DEFINE_EVENT_TYPE( EVT_SR_LOADDIR_END )
DEFINE_EVENT_TYPE( EVT_SR_CHECKVERSION_AUTO_END )
DEFINE_EVENT_TYPE( EVT_SR_DISP_INFO )
DEFINE_EVENT_TYPE( EVT_SR_SET_BT_STOP_LOADING )
DEFINE_EVENT_TYPE( EVT_SR_CLEAR_FILE_LIST )
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CFrame, wxFrame )
   /*----------------------------------------------------------------------*/
   EVT_MENU( IDM_CBC_LIST      , CFrame::OnCbcList      )
   EVT_MENU( IDM_CBC_LIST_NAME , CFrame::OnCbcListName  )
   /*----------------------------------------------------------------------*/
   EVT_MENU( IDM_FIND          , CFrame::OnFind         )
   EVT_MENU( IDM_FIND_FIRST    , CFrame::OnFindFirst    )
   EVT_MENU( IDM_FIND_NEXT     , CFrame::OnFindNext     )
   EVT_MENU( IDM_FIND_PREV     , CFrame::OnFindPrev     )
   EVT_MENU( IDM_FIND_LAST     , CFrame::OnFindLast     )
   EVT_MENU( IDM_FIND_SEL_FIRST, CFrame::OnFindSelFirst )
   EVT_MENU( IDM_FIND_SEL_NEXT , CFrame::OnFindSelNext  )
   EVT_MENU( IDM_FIND_SEL_PREV , CFrame::OnFindSelPrev  )
   EVT_MENU( IDM_FIND_SEL_LAST , CFrame::OnFindSelLast  )
   EVT_MENU( IDM_HIL_FIL       , CFrame::OnHilFil       )
   EVT_MENU( IDM_HIL_SEL       , CFrame::OnHilSel       )
   /*----------------------------------------------------------------------*/
   EVT_MENU( IDM_TOOLBAR_GRP   , CFrame::OnToolbarGrp    )
   EVT_MENU( IDM_THREE_TOOLBARS, CFrame::OnThreeToolbars )
   EVT_MENU( IDM_VISU_OFF      , CFrame::OnVisuOff       )
   EVT_MENU( IDM_VISU_LEFT     , CFrame::OnVisuLeft      )
   EVT_MENU( IDM_VISU_RIGHT    , CFrame::OnVisuRight     )
   EVT_MENU( IDM_SHOW_STATUSBAR, CFrame::OnShowStatusbar )
   EVT_MENU( IDM_THUMBNAIL     , CFrame::OnThumbnail     )
   /*----------------------------------------------------------------------*/
   EVT_MENU( ID_ACT_COMPUTE    , CFrame::OnCompute      )
   EVT_MENU( ID_ACT_RENAME     , CFrame::OnRename       )
   EVT_MENU( ID_ACT_COPY       , CFrame::OnCopy         )
   EVT_MENU( ID_ACT_UNDO       , CFrame::OnUndo         )
   EVT_MENU( ID_ACT_REDO       , CFrame::OnRedo         )
   EVT_MENU( wxID_PREFERENCES  , CFrame::OnPrefs        )
   /*----------------------------------------------------------------------*/
   EVT_MENU( ID_SEL_ALL        , CFrame::OnSelAll       )
   EVT_MENU( ID_UNSEL_ALL      , CFrame::OnUnselAll     )
   EVT_MENU( ID_SEL_INV        , CFrame::OnSelInv       )
   EVT_MENU( ID_SEL_UNSEL_HIL  , CFrame::OnSelUnselHil  )
   EVT_MENU( ID_SEL_HIL        , CFrame::OnSelHil       )
   EVT_MENU( ID_UNSEL_HIL      , CFrame::OnUnselHil     )
   EVT_MENU( ID_SEL_FIL        , CFrame::OnSelFil       )
   EVT_MENU( ID_UNSEL_FIL      , CFrame::OnUnselFil     )
   /*----------------------------------------------------------------------*/
   EVT_MENU_RANGE( ID_GRP_BASE , ID_GRP_DOC, CFrame::OnColGroup )
   /*----------------------------------------------------------------------*/
   EVT_MENU( wxID_EXIT         , CFrame::OnQuit         )
   EVT_MENU( IDM_FIRST_CONTACT , CFrame::OnFirstContact )
   EVT_MENU( IDM_CHECKVERSION_MANUAL, CFrame::OnCheckVersionManual )
   EVT_MENU( IDM_MAKE_DONATION , CFrame::OnMakeDonation )
   EVT_MENU( wxID_HELP         , CFrame::OnHelp         )
   EVT_MENU( IDM_TESTBED       , CFrame::OnTestbed      )
   EVT_MENU( wxID_ABOUT        , CFrame::OnAbout        )
   /*----------------------------------------------------------------------*/
   EVT_MENU( IDM_FAV_ADD     , CFrame::OnFavouriteAdd )
   EVT_MENU( IDM_FAV_ORGANIZE, CFrame::OnFavouriteOrganize )
   EVT_MENU_RANGE( FAV_MENU_ID_START,
                   FAV_MENU_ID_START + g_co_i_reserve_menu_id - 1,
                   CFrame::OnFavouriteMenuItemChosen
                 )
   /*----------------------------------------------------------------------*/
   EVT_MENU( IDM_TOOL_ADD     , CFrame::OnToolAdd )
   EVT_MENU( IDM_TOOL_ORGANIZE, CFrame::OnToolOrganize )
   EVT_MENU_RANGE( TOOL_MENU_ID_START,
                   TOOL_MENU_ID_START + g_co_i_reserve_menu_id - 1,
                   CFrame::OnToolMenuItemChosen
                 )
   /*----------------------------------------------------------------------*/
   EVT_MENU( ID_TB_DIR_BACK   , CFrame::OnDirHistory   )
   EVT_MENU( ID_TB_DIR_FORWARD, CFrame::OnDirHistory   )
   EVT_TOOL_DROPDOWN( ID_TB_DIR_BACK   , CFrame::OnDirHistoryMenu )
   EVT_TOOL_DROPDOWN( ID_TB_DIR_FORWARD, CFrame::OnDirHistoryMenu )
   EVT_MENU_RANGE( HIS_MENU_ID_START,
                   HIS_MENU_ID_START + g_co_i_reserve_menu_id - 1,
                   CFrame::OnDirHistoryMenuItemChosen
                 )
   /*----------------------------------------------------------------------*/
   EVT_MENU( ID_TB_DIR_CHOOSE , CFrame::OnDirChoose )
   EVT_MENU( ID_TB_DIR_UP     , CFrame::OnDirUp )
   EVT_MENU( ID_TB_DIR_REFRESH, CFrame::OnDirRefresh )
   EVT_MENU( ID_TB_DIR_RECURSE, CFrame::OnDirRecurse )
   EVT_MENU( ID_TB_DIR_STOP_LOADING, CFrame::OnDirStopLoading )
   EVT_MENU( IDM_EXPLORE_DIR, CFrame::OnExploreDir )
   /*----------------------------------------------------------------------*/
   EVT_COMBOBOX( ID_CB_EXP  , CFrame::OnExpChange )
   EVT_COMBOBOX( ID_CB_DIR  , CFrame::OnDirChange )
   EVT_COMBOBOX( ID_CB_FIL  , CFrame::OnFilChange )
   EVT_TEXT_ENTER( ID_CB_EXP, CFrame::OnExpChange )
   EVT_TEXT_ENTER( ID_CB_DIR, CFrame::OnDirChange )
   EVT_TEXT_ENTER( ID_CB_FIL, CFrame::OnFilChange )
   /*----------------------------------------------------------------------*/
   EVT_TOOL( ID_BT_ACO_DIR, CFrame::OnAddDirToCbDir )
   /*----------------------------------------------------------------------*/
   EVT_COMMAND( wxID_ANY, EVT_SR_LOADDIR_END, CFrame::OnLoadDirEnd )
   EVT_COMMAND( wxID_ANY, EVT_SR_CHECKVERSION_AUTO_END,
                CFrame::OnCheckVersionAutoEnd
              )
   EVT_MENU( IDM_GET_NEW_VERSION, CFrame::OnGetNewVersion )
   EVT_COMMAND( wxID_ANY, EVT_SR_DISP_INFO, CFrame::OnDispInfo )
   EVT_COMMAND( wxID_ANY, EVT_SR_SET_BT_STOP_LOADING,
                CFrame::OnSetBtStopLoading
              )
   EVT_COMMAND( wxID_ANY, EVT_SR_CLEAR_FILE_LIST, CFrame::OnClearFileList )
   /*----------------------------------------------------------------------*/
   EVT_MENU( ID_BT_COMPLETION, CFrame::OnCompletion )
   EVT_MENU( ID_BT_WIZARD, CFrame::OnWizard )
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*--( Activated via idle event )-------------------------------------------*/
void CFrame::OnFirstIdle( wxIdleEvent &event )
{
   /*--( One is enough )---------------------------------------------------*/
   Unbind( wxEVT_IDLE, &CFrame::OnFirstIdle, this ) ;

   /*-----------------------------------------------------------------------+
   ! After the creation of the windows some displays have to be fixed       !
   +-----------------------------------------------------------------------*/
#ifndef __WXMSW__
   m_fl->init_view_sel() ;
#endif // ! __WXMSW__
   m_dt->ensurevisible_current_path() ;

   /*--( Command line operation asked without immediate "quit" )-----------*/
   wxGetApp().apply_cmdline_oper() ;

   /*--( "First contact" to be displayed ? )-------------------------------*/
   if( wxGetApp().get_first_start_ever() )
   {  first_contact_dialog() ; }

   /*--( Check for update ? )----------------------------------------------*/
   if(    wxGetApp().M_boo_chkver_auto.get()
       &&    wxGetApp().M_s_last_chkver_auto.get()
          != wxDateTime::Now().FormatISODate()
     )
   {  /*-------------------------------------------------------------------*/
      wxGetApp().M_s_last_chkver_auto.set(wxDateTime::Now().FormatISODate());
      /*--( Mandatory if actions are done in threads )---------------------*/
      wxSocketBase::Initialize() ;
      m_checkversion.thread_start() ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnLoadDirEnd( wxCommandEvent & WXUNUSED( event ) )
{
   /*-----------------------------------------------------------------------+
   ! In this function, the process current directory will be changed and    !
   ! "wxGetApp().M_s_dir" is set accordingly.                               !
   +-----------------------------------------------------------------------*/
   m_fl->post_loading( m_loaddir ) ;

   /*----------------------------------------------------------------------*/
   if( !m_loaddir.get_same_dir() )
   {
      /*-------------------------------------------------------------------*/
      m_dt->set_path( wxGetApp().M_s_dir.get() ) ;
      m_cb_dir->SetValue( wxGetApp().M_s_dir.get() ) ;
      /*--( Add it to history ? )------------------------------------------*/
      if( m_loaddir.m_param.get_add_dir_to_hist() )
      {  m_dir_history.add( wxGetApp().M_s_dir.get() ) ; }
      /*-------------------------------------------------------------------*/
      gui_update_dir() ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   gui_update_oper() ;
   visu_file() ;
   /*-----------------------------------------------------------------------+
   ! Monitoring current directory.                                          !
   ! An active loop has to be active before creation.                       !
   +-----------------------------------------------------------------------*/
   if( m_fswatcher != NULL )
   {  m_fswatcher->start() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnCheckVersionAutoEnd( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetInt() != CCheckVersion::CVC_NEW_VERSION )
   {  return ; }

   /*----------------------------------------------------------------------*/
   wxMenu *menu ;
   /*----------------------------------------------------------------------*/
   menu = new wxMenu() ;
   menu->Append( IDM_GET_NEW_VERSION,
                 _( "&Go to web site to download it" )
               ) ;
   /*----------------------------------------------------------------------*/
   GetMenuBar()->Append( menu,
                         wxString::Format( _( "&Version \"%s\" available" ),
                                           event.GetString()
                                         )
                       ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnGetNewVersion( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxLaunchDefaultBrowser( SIREN_URL_DOWNLOAD ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDispInfo( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   g_disp_info( event.GetString() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnSetBtStopLoading( wxCommandEvent &event )
{
   /*--( The event "int" is used as a boolean )----------------------------*/
   gui_enable_stop_loading( ( event.GetInt() != 0 ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnClearFileList( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   m_fl->SetItemCount( 0 ) ;
   m_fl->Refresh() ;
   m_fl->Update() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnFavouriteAdd( wxCommandEvent & WXUNUSED( event ) )
{  wxGetApp().m_favourite.add() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFavouriteOrganize( wxCommandEvent & WXUNUSED( event ) )
{  wxGetApp().m_favourite.organize() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFavouriteMenuItemChosen( wxCommandEvent &event )
{  wxGetApp().m_favourite.menu_item_action( event.GetId() ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnToolAdd( wxCommandEvent & WXUNUSED( event ) )
{  wxGetApp().m_tool.add() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnToolOrganize( wxCommandEvent & WXUNUSED( event ) )
{  wxGetApp().m_tool.organize() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnToolMenuItemChosen( wxCommandEvent &event )
{  wxGetApp().m_tool.menu_item_action( event.GetId() ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnExpChange( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetEventType() == wxEVT_COMMAND_TEXT_ENTER )
   {  m_cb_exp->add_current_value_to_list() ; }
   /*----------------------------------------------------------------------*/
   m_fl->compute_new_names() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirChange( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   static bool st_boo_in_change_directory = false ;

   /*-----------------------------------------------------------------------+
   ! This can look odd ... but it is necessary. If we are in this function  !
   ! it is because the directory has been changed in the directory          !
   ! combo : the "Enter" key has been pressed or a combo choice has been    !
   ! made.                                                                  !
   ! If the directory is not accessible an error message is displayed. This !
   ! implies that the combo will loose the focus too.                       !
   ! Loosing the focus means that another call to this function will be     !
   ! made. Therefore two error messages will be displayed ...               !
   ! This code is supposed to avoid this ...                                !
   +-----------------------------------------------------------------------*/
   if( !st_boo_in_change_directory )
   {
      /*-------------------------------------------------------------------*/
      st_boo_in_change_directory = true ;
      /*--( The user may have typed environment variables, dots ... )------*/
      change_directory( sr::expand_path( m_cb_dir->GetValue() ) ) ;
      /*-------------------------------------------------------------------*/
      st_boo_in_change_directory = false ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnFilChange( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetEventType() == wxEVT_COMMAND_TEXT_ENTER )
   {  m_cb_fil->add_current_value_to_list() ; }
   /*----------------------------------------------------------------------*/
   load_directory() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnAddDirToCbDir( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_cb_dir->add_current_value_to_list() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnCompute( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->compute_new_names() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnCbcList( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->selected_list_to_clipboard() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnCbcListName( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->col_selected_list_to_clipboard( COL_NONE_NAME ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnFind( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = CDlgFilterSearch( this ).get_modal() ) == wxID_CANCEL )
   {  return ; }
   /*--( Now the "dependent" searches can be done )------------------------*/
   m_boo_search_dialog_done = true ;
   gui_enable_search() ;
   /*----------------------------------------------------------------------*/
   switch( i_ret )
   {
      /*-------------------------------------------------------------------*/
      case DLG_IDM_FIND_FIRST : OnFindFirst( event ) ; break ;
      case DLG_IDM_FIND_NEXT  : OnFindNext( event )  ; break ;
      case DLG_IDM_FIND_PREV  : OnFindPrev( event )  ; break ;
      case DLG_IDM_FIND_LAST  : OnFindLast( event )  ; break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnFindFirst( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_fil_next( CFileList::FOC_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindNext( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_fil_next( CFileList::FOC_NOT_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindPrev( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_fil_prev( CFileList::FOC_NOT_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindLast( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_fil_prev( CFileList::FOC_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindSelFirst( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_sel_next( CFileList::FOC_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindSelNext( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_sel_next( CFileList::FOC_NOT_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindSelPrev( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_sel_prev( CFileList::FOC_NOT_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnFindSelLast( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->search_sel_prev( CFileList::FOC_FIRST_OCC ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnHilFil( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   CDlgFilter dlg( this, _( "Highlight" ),
                   _( "Highlight files" ),
                   _( "highlight directories too" )
                 ) ;
   /*----------------------------------------------------------------------*/
   if( dlg.get_modal() != wxID_CANCEL && !wxGetApp().M_s_opfil.empty() )
   {
      /*-------------------------------------------------------------------*/
      int i_flags = 0 ;
      /*-------------------------------------------------------------------*/
      if( wxGetApp().M_boo_opfil_match.get() )
      {  i_flags |= SEARCH_FILTER_MATCH ; }
      if( wxGetApp().M_boo_opfil_dir.get() )
      {  i_flags |= SEARCH_FILTER_DIR ; }
      /*-------------------------------------------------------------------*/
      m_fl->hil_fil( wxGetApp().M_s_opfil.get(), i_flags ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}
/*-------------------------------------------------------------------------*/
void CFrame::OnHilSel( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->hil_sel() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnToolbarGrp( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().M_boo_toolbar_grp.set( event.IsChecked() ) ;
   /*--( The end of the divider line is drawn by "sel" or "grp" toolbar ? )*/
   m_bsz_act->GetItem( m_to_sel )->SetProportion(
                                   wxGetApp().M_boo_toolbar_grp.get() ? 0 : 1
                                                ) ;
   /*----------------------------------------------------------------------*/
   m_bsz_act->Show( m_to_grp, wxGetApp().M_boo_toolbar_grp.get() ) ;
   m_bsz_act->Layout() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnThreeToolbars( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().M_boo_three_toolbars.set( event.IsChecked() ) ;
   adapt_toolbars_layout() ;
   /*--( Relayout panel )--------------------------------------------------*/
   m_panel->Layout() ;
   m_panel->Refresh() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnVisuOff( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   set_global_layout( LAYOUT_VISU_OFF ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnVisuLeft( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   set_global_layout( LAYOUT_VISU_LEFT ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnVisuRight( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   set_global_layout( LAYOUT_VISU_RIGHT ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnShowStatusbar( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().M_boo_show_statusbar.set( event.IsChecked() ) ;
   /*----------------------------------------------------------------------*/
   m_statusbar->Show( wxGetApp().M_boo_show_statusbar.get() ) ;
   /*--( Force window relayout )-------------------------------------------*/
   SendSizeEvent() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnThumbnail( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   long l_item = m_fl->get_item_focus() ;
   /*----------------------------------------------------------------------*/
   wxGetApp().M_boo_thumbnail.set( event.IsChecked() ) ;
   /*----------------------------------------------------------------------*/
   if(    l_item >= 0
       && l_item < m_fl->m_dir.size()
       && m_fl->m_dir[ l_item ].has_thumbnail()
     )
   {  visu_file( l_item ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnRename( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->oper_do( OFILE_RENAME ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnCopy( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->oper_do( OFILE_COPY ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnUndo( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->oper_undo() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnRedo( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->oper_redo() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnPrefs( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   CDlgPrefs( this ).get_modal() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnQuit( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   Close() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnFirstContact( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   first_contact_dialog() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnAbout( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   CAbout         dlg( this ) ;
   const wxString co_s_version(   SIREN_VERSION
                                  " ("  + wxGetApp().get_canonical_name()
                                + '/'
                                + wxGetApp().get_system_canonical_name()
                                + ')'
                              ) ;

   /*--( Set image to a size independent of the source : looks nice 32x32 )*/
   wxImage img_siren( dlg.m_bmp_siren->GetBitmap().ConvertToImage() ) ;
   img_siren.Rescale( 32, 32 ) ;
   dlg.m_bmp_siren->SetBitmap( wxBitmap( img_siren ) ) ;

   /*----------------------------------------------------------------------*/
   dlg.m_st_name->SetLabelText( SIREN_DISPLAY_NAME ) ;
   dlg.m_st_version->SetLabelText( co_s_version ) ;
   dlg.m_st_copyright->SetLabelText( SIREN_COPYRIGHT ) ;
   dlg.m_st_description->SetLabelText(wxGetTranslation( SIREN_DESCRIPTION ));
   dlg.m_hl_url_license->SetLabelText( wxGetTranslation( SIREN_LICENSE ) ) ;
   dlg.m_hl_url_license->SetURL( SIREN_LICENSE_URL ) ;

   /*-----------------------------------------------------------------------+
   ! Under GTK, "http://" generates 2 url open calls                        !
   +-----------------------------------------------------------------------*/
   dlg.m_hl_url_site->SetLabelText( SIREN_URL_SITE ) ;
   dlg.m_hl_url_site->SetURL( SIREN_URL_SITE ) ;
   dlg.m_hl_url_forum->SetLabelText( SIREN_URL_FORUM ) ;
   dlg.m_hl_url_forum->SetURL( SIREN_URL_FORUM ) ;

   /*----------------------------------------------------------------------*/
   dlg.m_hl_mail->SetLabelText( SIREN_MAIL ) ;
   dlg.m_hl_mail->SetURL( "mailto:" SIREN_MAIL
                          "?subject=" SIREN_DISPLAY_NAME " " + co_s_version
                          + " - " + wxGetOsDescription()
                        ) ;
   /*--( The translator name is taken from translation file )--------------*/
   wxString s_mail_translator
          = wxTranslations::Get()->GetHeaderValue( "Language-Team" ) ;
   if( s_mail_translator.empty() )
   {  s_mail_translator = SIREN_MAIL_TRANSLATOR ; }
   dlg.m_hl_mail_translator->SetLabelText( s_mail_translator ) ;
   dlg.m_hl_mail_translator->SetURL(   "mailto:" + s_mail_translator
                                     + "?subject=Translation "
                                     + SIREN_DISPLAY_NAME " "
                                     + co_s_version
                                     + " - " + wxGetOsDescription()
                                   ) ;
   /*----------------------------------------------------------------------*/
   dlg.m_bt_ok->SetFocus() ;
   /*----------------------------------------------------------------------*/
   dlg.Layout() ;
   dlg.SetSize( dlg.GetEffectiveMinSize() ) ;
   dlg.CentreOnParent() ;
   /*----------------------------------------------------------------------*/
   dlg.ShowModal() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnHelp( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   const wxWindow *p_win_focus = wxWindow::FindFocus() ;
   wxString s_help_page ;

   /*-----------------------------------------------------------------------+
   ! This event is treated in this particular way for the combos because    !
   ! it is linked to the accelerator key "F1" and do not pass through       !
   ! the "OnKeyDown" window (procedure) where "F1" has been stroked.        !
   ! (at least it looks like this ...)                                      !
   +-----------------------------------------------------------------------*/
   if( p_win_focus == m_tv )
   {  m_tv->help() ;
      return ;
   }
   /*----------------------------------------------------------------------*/
   if(    p_win_focus == m_cb_exp
       || p_win_focus == m_cb_dir
       || p_win_focus == m_cb_fil
     )
   {    s_help_page
      = static_cast< const CCombo * >( p_win_focus )->get_help_page() ;
   }
   /*----------------------------------------------------------------------*/
   show_help( s_help_page ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirHistory( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxString s_dir ;
   /*----------------------------------------------------------------------*/
   if(    (    event.GetId() == ID_TB_DIR_BACK
            && m_dir_history.move_back( s_dir ) == 0
          )
       || (    event.GetId() == ID_TB_DIR_FORWARD
            && m_dir_history.move_forward( s_dir ) == 0
          )
     )
   {  m_loaddir_param.set_add_dir_to_hist( false ) ;
      load_directory( s_dir ) ;
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirHistoryMenu( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxMenu *p_menu = new wxMenu() ;
   /*----------------------------------------------------------------------*/
   m_dir_history.fill_menu( p_menu,
                            event.GetId() == ID_TB_DIR_BACK
                            ? CDirHistory::DH_BACK : CDirHistory::DH_FORWARD
                          ) ;
   /*--( The menu popup function called later will delete the menu )-------*/
   m_to_dir->SetDropdownMenu( event.GetId(), p_menu ) ;
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirHistoryMenuItemChosen( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxString s_dir ;
   /*----------------------------------------------------------------------*/
   if( m_dir_history.move_to( event.GetId() - HIS_MENU_ID_START, s_dir
                            ) == 0
     )
   {  m_loaddir_param.set_add_dir_to_hist( false ) ;
      load_directory( s_dir ) ;
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirUp( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxString   s_dir_save( wxGetApp().M_s_dir.get() ) ;
   wxFileName parent( s_dir_save, wxEmptyString ) ;

   /*--( Can't go upper than root )----------------------------------------*/
   if( parent.GetDirCount() == 0 ) { return ; }

   /*-----------------------------------------------------------------------+
   ! An eventual loading has to be stopped else the directory to jump to    !
   ! could be lost.                                                         !
   +-----------------------------------------------------------------------*/
   stop_current_load_directory( SEEVT_DONT_SEND_END_EVENT ) ;

   /*-----------------------------------------------------------------------+
   ! The "active" item in the loaded parent list will be the current        !
   ! directory: the last element of the path                                !
   +-----------------------------------------------------------------------*/
   m_loaddir_param.set_repos_name(parent.GetDirs()[parent.GetDirCount()-1]) ;
   parent.RemoveLastDir() ;

   /*-----------------------------------------------------------------------+
   ! Force this because else repeated "dir up" would not work has expected. !
   ! "GetFullPath" is not used because a path separator would be added at   !
   ! the end.                                                               !
   +-----------------------------------------------------------------------*/
   wxGetApp().M_s_dir.set( parent.GetPath() ) ;

   /*----------------------------------------------------------------------*/
   if( load_directory( parent.GetPath() ) != 0 )
   {  wxGetApp().M_s_dir.set( s_dir_save ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirRefresh( wxCommandEvent & WXUNUSED( event ) )
{
   /*--( If the tree has the focus it is refreshed first )-----------------*/
   if( wxWindow::FindFocus() == m_dt->GetTreeCtrl() )
   {  m_dt->recreate_and_refresh() ; }
   else
   {  load_directory() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirRecurse( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   set_recurse( !get_recurse() ) ;
   gui_update_recurse() ;
   /*--( Current file should be same after reload )------------------------*/
   CFile *p_file = m_fl->get_p_file_focus() ;
   if( p_file != NULL )
   {  m_loaddir_param.set_repos_name( p_file->get_full_name() ) ; }
   /*----------------------------------------------------------------------*/
   load_directory() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirStopLoading( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   stop_current_load_directory( SEEVT_DO_SEND_END_EVENT ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnExploreDir( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_fl->launch_file_explorer() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnSelAll( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->sel_all() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnUnselAll( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->unsel_all() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnSelInv( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->inv_sel() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnSelUnselHil( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->sel_unsel_hil_following_focus() ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnSelHil( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->sel_unsel_hil( true ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnUnselHil( wxCommandEvent & WXUNUSED( event ) )
{  m_fl->sel_unsel_hil( false ) ; }

/*-------------------------------------------------------------------------*/
void CFrame::OnSelFil( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   CDlgFilter dlg( this, _( "Select" ),
                   _( "Select files" ),
                   _( "select directories too" )
                 ) ;
   /*----------------------------------------------------------------------*/
   if( dlg.get_modal() != wxID_CANCEL && !wxGetApp().M_s_opfil.empty() )
   {
      /*-------------------------------------------------------------------*/
      int i_flags = 0 ;
      /*-------------------------------------------------------------------*/
      if( wxGetApp().M_boo_opfil_match.get() )
      {  i_flags |= SEARCH_FILTER_MATCH ; }
      if( wxGetApp().M_boo_opfil_dir.get() )
      {  i_flags |= SEARCH_FILTER_DIR ; }
      /*-------------------------------------------------------------------*/
      m_fl->sel_fil( wxGetApp().M_s_opfil.get(), i_flags ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnUnselFil( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   CDlgFilter dlg( this, _( "Unselect" ),
                   _( "Unselect files" ),
                   _( "unselect directories too" )
                 ) ;
   /*----------------------------------------------------------------------*/
   if( dlg.get_modal() != wxID_CANCEL && !wxGetApp().M_s_opfil.empty()  )
   {
      /*-------------------------------------------------------------------*/
      int i_flags = 0 ;
      /*-------------------------------------------------------------------*/
      if( wxGetApp().M_boo_opfil_match.get() )
      {  i_flags |= SEARCH_FILTER_MATCH ; }
      /*-------------------------------------------------------------------*/
      if( wxGetApp().M_boo_opfil_dir.get() )
      {  i_flags |= SEARCH_FILTER_DIR ; }
      /*-------------------------------------------------------------------*/
      m_fl->unsel_fil( wxGetApp().M_s_opfil.get(), i_flags ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnColGroup( wxCommandEvent &event )
{
   /*--( Convert button to group id )--------------------------------------*/
   int i_grp = wxGetApp().m_colgroup.get_id_bt_grp( event.GetId() ) ;
   if( !wxGetApp().m_colgroup.get_grp_ok( i_grp ) ) { return ; }

   /*--( The current value is inverted )-----------------------------------*/
   CColGroup::str_group *p_grp = &wxGetApp().m_colgroup.m_tb_group[ i_grp ] ;
   p_grp->M_cb_checked.set( !p_grp->M_cb_checked.get() ) ;

   /*--( Recreated columns for this modification to be taken into account )*/
   m_fl->create_all_col() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnCompletion( wxCommandEvent & WXUNUSED( event ) )
{
   /*--( The action opens/closes the completion window )-------------------*/
   if( m_completion != NULL )
   {  m_completion->Destroy() ; }
   else
   {  /*-------------------------------------------------------------------*/
        m_completion
      = new CCompletion( m_cb_exp, m_to_exp->FindById( ID_BT_COMPLETION ),
                         GetMenuBar()->FindItem( ID_BT_COMPLETION ),
                         _( "Completion" ),
                         m_completion, wxGetApp().M_rec_completion
                       ) ;
      /*-------------------------------------------------------------------*/
      m_completion->assign_focus() ;
      m_completion->show_current_var() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnDirChoose( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxDirDialog dirdialog( this ) ;
   /*----------------------------------------------------------------------*/
   if( dirdialog.ShowModal() == wxID_OK )
   {  change_directory( dirdialog.GetPath() ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnWizard( wxCommandEvent & WXUNUSED( event ) )
{
   /*--( The dialog is not destroyed. Useful to review the parameters )----*/
   if( m_wizard == NULL )
   {  m_wizard = new CWizard( this ) ; }
   else
   {  /*--( The file "selection" may have changed )------------------------*/
      m_wizard->init_example() ;
      m_wizard->recompute_example() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   m_wizard->get_modal() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnTestbed( wxCommandEvent & WXUNUSED( event ) )
{
   /*--( The dialog is not destroyed. Useful to review the parameters )----*/
   if( m_testbed == NULL )
   {  m_testbed = new CTestbed( this ) ; }
   else
   {  /*--( The preferences may have been changed )------------------------*/
      m_testbed->compute() ;
      /*-------------------------------------------------------------------*/
   }
   /*--( Testbed is used modeless. See source header for explanation )-----*/
   m_testbed->Show() ;
   /*----------------------------------------------------------------------*/
}

/*--( Activated via the frame menu )---------------------------------------*/
void CFrame::OnCheckVersionManual( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxString                  s_info ;
   CCheckVersion::e_ret_code ret_code ;

   /*----------------------------------------------------------------------*/
   {  CInfoFrame win_info( this, _( "Connecting to site ..." ) ) ;
      ret_code = CCheckVersion().non_threaded_exec( s_info ) ;
   }

   /*----------------------------------------------------------------------*/
   if( ret_code == CCheckVersion::CVC_LAST_VERSION )
   {  sr::info_message( s_info ) ; }
   else
   if( ret_code == CCheckVersion::CVC_NEW_VERSION )
   {
      /*-------------------------------------------------------------------*/
      if( wxMessageBox( wxString::Format( _( "Version \"%s\" is available\n"
                                             "\n"
                                             "Do you want to go to the web "
                                             "site to download it ?"
                                           ),
                                          s_info
                                        ),
                        _( "New version available" ),
                        wxYES_NO | wxICON_INFORMATION, this
                      ) == wxYES
        )
      {  wxLaunchDefaultBrowser( SIREN_URL_DOWNLOAD ) ; }
      /*-------------------------------------------------------------------*/
   }
   else
   {  sr::error_message( s_info ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::OnMakeDonation( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxLaunchDefaultBrowser( "https://www.paypal.com/cgi-bin/webscr?"
                           "cmd=_s-xclick&hosted_button_id=BHASPCZZFZU62"
                         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFrame_On.cpp                           !
+==========================================================================*/
