/*====================================+=====================================+
! File CFrame_Init.cpp                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include <wx/dcclient.h>
#include <wx/splitter.h>
#include <wx/statline.h>
#include <wx/html/helpctrl.h>
#include "siren.h"
#include "siren_info.h"
#include "CApp.h"
#include "CFileList.h"
#include "CCombo.h"
#include "CDirTree.h"
#include "CDragAndDrop.h"
#include "CNbVisu.h"
#include "CImageVisu.h"
#include "CTagVisu.h"
#include "CCompletion.h"
#include "CWizard.h"
#include "CTestbed.h"
#include "CFSWatcher.h"

/*--( Icons )--------------------------------------------------------------*/
#include "small-icons/act_rename.xpm"
#include "small-icons/act_compute.xpm"
#include "small-icons/act_copy.xpm"
#include "small-icons/act_undo.xpm"
#include "small-icons/act_redo.xpm"
#include "small-icons/act_prefs.xpm"
#include "sel_all.xpm"
#include "sel_unsel_all.xpm"
#include "sel_inv.xpm"
#include "sel_hil.xpm"
#include "sel_unsel_hil.xpm"
#include "sel_fil.xpm"
#include "sel_unsel_fil.xpm"
#include "small-icons/completion.xpm"
#include "famfamfam/wizard.xpm"
#include "famfamfam/dir_refresh.xpm"
#include "dir_recurse.xpm"
#include "dir_stop_loading.xpm"
#ifndef __WXMSW__
#include "siren.xpm"
#endif // ! __WXMSW__
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CFrame::CFrame()
{
   /*----------------------------------------------------------------------*/
   m_boo_search_dialog_done = false ;
   /*----------------------------------------------------------------------*/
   m_p_win_disabler = NULL ;
   m_completion     = NULL ;
   m_wizard         = NULL ;
   m_testbed        = NULL ;
   m_fswatcher      = NULL ;
   m_help           = NULL ;

   /*--( Choose "_SHORT" or "_LONG" version information )------------------*/
   wxString s_title( SIREN_DISPLAY_NAME " " SIREN_VERSION ) ;
   /*--( If the user chooses another config file, it is shown )------------*/
   if( !wxGetApp().get_default_config_file() )
   {  s_title += " - " + wxGetApp().get_config_filename() ; }
   /*----------------------------------------------------------------------*/
   Create( NULL, wxID_ANY, s_title, wxDefaultPosition,
           wxDefaultSize, wxDEFAULT_FRAME_STYLE, "SIREN"
         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CFrame::~CFrame()
{
   /*--( An eventual loading thread has to be stopped )--------------------*/
   stop_current_load_directory( SEEVT_DONT_SEND_END_EVENT ) ;
   /*--( An eventual version checking thread has to be stopped )-----------*/
   m_checkversion.thread_stop() ;

   /*--( It is supposed to be safe to delete a NULL pointer )--------------*/
   delete m_completion ;
   delete m_wizard     ;
   delete m_testbed    ;
   delete m_fswatcher  ;
   delete m_help       ;

   /*--( A command line option allows to not save data on end )------------*/
   if( wxGetApp().get_cmdline_save_config() )
   {
      /*-------------------------------------------------------------------*/
      m_fl->save_all_col_width()        ;
      m_fl->transfert_col_info_to_cfg() ;

      /*--------------------------------------------------------------------+
      ! There is a problem when getting the size of a maximized window.     !
      ! It returns the displayed size and not the "normal" one.             !
      +--------------------------------------------------------------------*/
      wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_main ) ;
      wxGetApp().M_boo_main_maxi.set( IsMaximized() ) ;
      wxGetApp().M_nb_sel_page.set( m_nb->GetSelection() ) ;
      /*-------------------------------------------------------------------*/
      wxGetApp().M_s_exp.set( m_cb_exp->GetValue() )    ;
      wxGetApp().M_as_exp.set( m_cb_exp->GetStrings() ) ;
      wxGetApp().M_as_dir.set( m_cb_dir->GetStrings() ) ;
      wxGetApp().M_s_fil.set( m_cb_fil->GetValue() )    ;
      wxGetApp().M_as_fil.set( m_cb_fil->GetStrings() ) ;
      /*-------------------------------------------------------------------*/
      if( m_spl_ver->IsSplit() )
      {  wxGetApp().M_i_spl_ver_pos.set( m_spl_ver->GetSashPosition() ) ; }
      if( m_spl_hor->IsSplit() )
      {  wxGetApp().M_i_spl_hor_pos.set( m_spl_hor->GetSashPosition() ) ; }

      /*--------------------------------------------------------------------+
      ! Save the configuration information.                                 !
      ! It's done here because it doesn't seem to work when called from     !
      ! wxApp::OnExit                                                       !
      +--------------------------------------------------------------------*/
      wxGetApp().save_config_info() ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::init()
{
   /*----------------------------------------------------------------------*/
   add_menu_bar() ;
   add_status_bar() ;
   add_layout_components() ;

   /*-----------------------------------------------------------------------+
   ! It seems that, at least under XP:                                      !
   ! - to appear in the "alt-tab" window the icon must be at least 32x32    !
   ! - resized to 16x16 the icon appearing in the taskbar is ugly           !
   ! So for MSW an icon file with those two sizes of image is used.         !
   +-----------------------------------------------------------------------*/
#ifdef __WXMSW__
   SetIcon( wxIcon( "A_SIREN_ICON" ) ) ;
#else
   SetIcon( wxIcon( siren_xpm ) ) ;
#endif // __WXMSW__

   /*-----------------------------------------------------------------------+
   ! Position and size of the window                                        !
   ! The default value is set the first time or if it is invalid            !
   +-----------------------------------------------------------------------*/
   wxRect rec_cur( wxGetApp().M_rec_main.get() ) ;
   /*----------------------------------------------------------------------*/
   if( rec_cur.GetSize() == wxDefaultSize )
   {
      /*-------------------------------------------------------------------*/
      const wxRect rec_scr( wxGetClientDisplayRect() ) ;
      /*--------------------------------------------------------------------+
      ! Default frame size.                                                 !
      ! The default height is in 4/3. Looks better ...                      !
      +--------------------------------------------------------------------*/
      rec_cur.width  = wxMax( 800, rec_scr.width / 3.0 * 2.0 ) ;
      rec_cur.height = wxMax( 600, rec_cur.width / 4.0 * 2.5 ) ;
      /*-------------------------------------------------------------------*/
      rec_cur.SetPosition( wxDefaultPosition ) ;
      wxGetApp().M_rec_main.set( rec_cur ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   wxGetApp().tlw_set_rect( this, wxGetApp().M_rec_main.get() ) ;
   m_nb->SetSelection( wxGetApp().M_nb_sel_page.get() ) ;

   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_main_maxi.get() ) { Maximize() ; }

   /*--( Splitters )-------------------------------------------------------*/
   wxSize clt_size( GetClientSize() ) ;
   if( wxGetApp().M_i_spl_ver_pos.get() == -1 )
   {  wxGetApp().M_i_spl_ver_pos.set( (int)( clt_size.GetWidth() / 4.0 ) ) ;}
   /*--( Keeping/setting it to 0 (middle) doesn't work well under GTK )----*/
   if( wxGetApp().M_i_spl_hor_pos.get() == -1 )
   {  wxGetApp().M_i_spl_hor_pos.set( (int)( clt_size.GetHeight() / 2.0 ) );}
   /*--( And set them ... )------------------------------------------------*/
   m_spl_hor->SetSashPosition( wxGetApp().M_i_spl_hor_pos.get() ) ;
   m_spl_ver->SetSashPosition( wxGetApp().M_i_spl_ver_pos.get() ) ;
   adapt_splitter_layout() ;

   /*-----------------------------------------------------------------------+
   ! Append seems to change the current value (at least under XP) so it is  !
   ! done before the "SetValue"                                             !
   +-----------------------------------------------------------------------*/
   m_cb_exp->Append( wxGetApp().M_as_exp.get() ) ;
   m_cb_exp->SetValue( wxGetApp().M_s_exp.get() ) ;
   sr::set_font_fix( m_cb_exp, wxGetApp().M_boo_exp_fix.get() ) ;
   /*----------------------------------------------------------------------*/
   m_cb_dir->Append( wxGetApp().M_as_dir.get() ) ;

   /*----------------------------------------------------------------------*/
   m_cb_fil->Append( wxGetApp().M_as_fil.get() ) ;
   m_cb_fil->SetValue( wxGetApp().M_s_fil.get() ) ;
   sr::set_font_fix( m_cb_fil, wxGetApp().M_boo_fil_fix.get() ) ;

   /*--( Define the possible "drop targets" )------------------------------*/
   m_cb_dir->init_drop_target() ;
   m_dt->init_drop_target() ;
   m_fl->init_drop_target() ;

   /*----------------------------------------------------------------------*/
   m_dt->apply_hidden() ;

   /*----------------------------------------------------------------------*/
   setup_immediate_recompute() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::create_fswatcher()
{
   /*----------------------------------------------------------------------*/
   if( m_fswatcher == NULL )
   {
      /*-------------------------------------------------------------------*/
      m_fswatcher = new CFSWatcher() ;
      /*--------------------------------------------------------------------+
      ! A start has to be done here because a loading done during           !
      ! "CApp::Onint" won't do it.                                          !
      +--------------------------------------------------------------------*/
      m_fswatcher->start() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::add_menu_bar()
{
   /*-----------------------------------------------------------------------+
   ! Menu :                                                                 !
   ! The accelerator key modifiers "Shift", "Ctrl" and "Alt" must not be    !
   ! translated. They are "automatically" translated by the menuing system  !
   ! if the following translations are given.                               !
   +-----------------------------------------------------------------------*/
#define DUMMY_TRANSLATIONS wxTRANSLATE( "ctrl" )  \
                           wxTRANSLATE( "shift" ) \
                           wxTRANSLATE( "alt" )
#undef DUMMY_TRANSLATIONS
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu_bar ;
   wxMenu    *menu     ;
   wxMenu    *sub_menu ;
   /*----------------------------------------------------------------------*/
   menu_bar = new wxMenuBar() ;
   /*-----------------------------------------------------------------------+
   ! File                                                                   !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;
   menu->Append( wxID_PREFERENCES, _( "&Preferences" ) ) ;
   menu->AppendSeparator() ;
   menu->Append( ID_TB_DIR_UP,
                 _( "Par&ent directory\tAlt+Up" ),
                 _( "Go to parent directory" )
               ) ;
   menu->Append( ID_TB_DIR_REFRESH,
                 _( "&Reload\tF5" ), _( "Reload current directory" )
               ) ;
   menu->AppendCheckItem( ID_TB_DIR_RECURSE,
                 _( "Load s&ub directories\tCtrl+F5" ),
                 _( "Load the sub directories of the current one" )
                        )->Check( false ) ;
   menu->Append( ID_TB_DIR_STOP_LOADING,
                 _( "&Stop current loading" ),
                 _( "Stop current directory loading" )
               ) ;
   menu->Append( IDM_EXPLORE_DIR,
                 _( "Start file e&xplorer\tAlt+W" ),
                 _( "Open current directory in the file explorer" )
               ) ;
   menu->AppendSeparator() ;
   menu->Append( wxID_EXIT, _( "&Quit" ) ) ;
   menu_bar->Append( menu, _( "&File" ) ) ;
   /*-----------------------------------------------------------------------+
   ! Edit                                                                   !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;

   /*--( Copy to clipboard )-----------------------------------------------*/
   sub_menu = new wxMenu() ;
   sub_menu->Append( IDM_CBC_LIST,
                     _( "&List with header\tCtrl+P" ),
                     _( "Copy the selected files list to the clipboard" )
                   ) ;
   sub_menu->Append( IDM_CBC_LIST_NAME, _( "Current &names\tCtrl+Shift+P" ));
   menu->AppendSubMenu( sub_menu, _( "&Copy the selection" ) ) ;

   /*--( Find )------------------------------------------------------------*/
   sub_menu = new wxMenu() ;
   sub_menu->Append( IDM_FIND, _( "&Find\tCtrl+F" ),
                     _( "Find a file in the list" )
                   ) ;
   sub_menu->AppendSeparator() ;
   sub_menu->Append( IDM_FIND_FIRST, _( "F&irst\tCtrl+F3" ),
                     _( "Find the first file in the list" )
                   )->Enable( false ) ;
   sub_menu->Append( IDM_FIND_NEXT, _( "&Next\tF3" ),
                     _( "Find a file after the current one in the list" )
                   )->Enable( false ) ;
   sub_menu->Append( IDM_FIND_PREV,
                     _( "&Previous\tShift+F3" ),
                     _( "Find a file before the current one in the list" )
                   )->Enable( false ) ;
   sub_menu->Append( IDM_FIND_LAST, _( "&Last\tCtrl+Shift+F3" ),
                     _( "Find the last file in the list" )
                   )->Enable( false ) ;
   menu->AppendSubMenu( sub_menu, _( "&Find file" ) ) ;

   /*--( Find selected file )----------------------------------------------*/
   sub_menu = new wxMenu() ;
   sub_menu->Append( IDM_FIND_SEL_FIRST, _( "F&irst\tCtrl+F4" ),
                     _( "First selected file in the list" )
                   ) ;
   sub_menu->Append( IDM_FIND_SEL_NEXT, _( "&Next\tF4" ),
                     _( "Next selected file after the current one "
                        "in the list"
                      )
                   ) ;
   sub_menu->Append( IDM_FIND_SEL_PREV,
                     _( "&Previous\tShift+F4" ),
                     _( "Previous selected file before the current one "
                        "in the list"
                      )
                   ) ;
   sub_menu->Append( IDM_FIND_SEL_LAST, _( "&Last\tCtrl+Shift+F4" ),
                     _( "Last selected file in the list" )
                   ) ;
   menu->AppendSubMenu( sub_menu, _( "Find &selected file" ) ) ;

   /*----------------------------------------------------------------------*/
   menu->AppendSeparator() ;
   menu->Append( IDM_HIL_FIL,
                 _( "&Highlight\tCtrl+H" ),
                 _( "Highlight files with a file filter" )
               ) ;
   menu->Append( IDM_HIL_SEL,
                 _( "Highligh&t the selected files\tCtrl+Shift+H" )
               ) ;
   menu_bar->Append( menu, _( "&Edit" ) ) ;

   /*-----------------------------------------------------------------------+
   ! View                                                                   !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;

   /*--( Visualisation "notebook" )----------------------------------------*/
   sub_menu = new wxMenu() ;
   /*----------------------------------------------------------------------*/
   sub_menu->AppendRadioItem( IDM_VISU_OFF, _( "&Hide" )
                            )->Check(    wxGetApp().M_i_layout.get()
                                      == LAYOUT_VISU_OFF
                                    ) ;
   sub_menu->AppendRadioItem( IDM_VISU_LEFT, _( "&Left" )
                            )->Check(    wxGetApp().M_i_layout.get()
                                      == LAYOUT_VISU_LEFT
                                    ) ;
   sub_menu->AppendRadioItem( IDM_VISU_RIGHT, _( "&Right" )
                            )->Check(    wxGetApp().M_i_layout.get()
                                      == LAYOUT_VISU_RIGHT
                                    ) ;
   menu->AppendSubMenu( sub_menu, _( "&Visualisation window" ) ) ;

   /*----------------------------------------------------------------------*/
   menu->AppendCheckItem( IDM_TOOLBAR_GRP,
                          _( "Column &group toolbar" ),
                          _( "Display the column group toolbar" )
                        )->Check( wxGetApp().M_boo_toolbar_grp.get() ) ;
   menu->AppendCheckItem( IDM_THREE_TOOLBARS,
                    _( "&Three toolbars" ),
                    _( "Choose between a layout with two or three toolbars" )
                        )->Check( wxGetApp().M_boo_three_toolbars.get() ) ;
   menu->AppendCheckItem( IDM_SHOW_STATUSBAR,
                          _( "&Status bar" ),
                          _( "Display the status bar" )
                        )->Check( wxGetApp().M_boo_show_statusbar.get() ) ;
   menu->AppendSeparator() ;
   menu->AppendCheckItem( IDM_THUMBNAIL,
                          _( "&Thumbnail image\tCtrl+T" ),
                          _( "Display thumbnail image if available" )
                        )->Check( wxGetApp().M_boo_thumbnail.get() ) ;
   menu->AppendSeparator() ;
   menu->AppendCheckItem( ID_BT_COMPLETION,
                          _( "&Completion\tCtrl+F11" ),
                   _( "All available elements to build a rename expression" )
                        ) ;
   menu->Append( ID_BT_WIZARD,
                 _( "&Wizard\tCtrl+F12" ),
                 _( "Help to create a simple rename expression" )
               ) ;
   menu_bar->Append( menu, _( "&View" ) ) ;

   /*-----------------------------------------------------------------------+
   ! Favourites                                                             !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;
   menu->Append( IDM_FAV_ADD,
                 _( "&Add current expression to favourites" ),
                 _( "Add current expression to the favourite expressions "
                    "list/menu"
                  )
               ) ;
   menu->Append( IDM_FAV_ORGANIZE,
                 _( "&Organize favourites" ),
                 _( "Modify the list/menu of favourite expressions" )
               ) ;
   menu->AppendSeparator() ;
   menu_bar->Append( menu, _( "F&avourites" ) ) ;

   /*-----------------------------------------------------------------------+
   ! Tools                                                                  !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;
   menu->Append( IDM_TOOL_ADD,
                 _( "&Associate current expression to a tool" ),
                 _( "Associate current expression to the tools list/menu"
                  )
               ) ;
   menu->Append( IDM_TOOL_ORGANIZE,
                 _( "&Organize tools" ),
                 _( "Modify the list/menu of tools" )
               ) ;
   menu->AppendSeparator() ;
   menu_bar->Append( menu, _( "T&ools" ) ) ;

   /*-----------------------------------------------------------------------+
   ! Select                                                                 !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;
   menu->Append( ID_SEL_ALL, _( "&All\tCtrl+A" ),
                 _( "Select all files" )
               ) ;
   menu->Append( ID_UNSEL_ALL, _( "&None\tCtrl+D" ),
                 _( "Unselect all files" )
               ) ;
   menu->Append( ID_SEL_INV, _( "&Invert\tCtrl+I" ),
                 _( "Invert current selection" )
               ) ;
   menu->AppendSeparator() ;
   /*-----------------------------------------------------------------------+
   ! The keys "names" are interpreted by wxWidgets and the keys-press       !
   ! events are "global" (intercepted whatever the focused window).         !
   ! Therefore "Space" can't be specified here to select/unselect files     !
   ! (else space won't be usable in the combos ...).                        !
   ! It is handled directly in the file list control.                       !
   +-----------------------------------------------------------------------*/
   sub_menu = new wxMenu() ;
   sub_menu->Append( ID_SEL_UNSEL_HIL,
                     _( "&Select/Unselect\tF9" ),
                     _( "Select/Unselect highlighted files "
                        "following the current file"
                      )
                   ) ;
   sub_menu->Append( ID_SEL_HIL,
                     _( "Se&lect\tCtrl+F9" ),
                     _( "Select highlighted files" )
                   ) ;
   sub_menu->Append( ID_UNSEL_HIL,
                     _( "&Unselect\tShift+F9" ),
                     _( "Unselect highlighted files" )
                   ) ;
   menu->AppendSubMenu( sub_menu, _( "&Highlighted files" ) ) ;
   /*----------------------------------------------------------------------*/
   sub_menu = new wxMenu() ;
   sub_menu->Append( ID_SEL_FIL,
                     _( "&Select\tCtrl+S" ),
                     _( "Select files with a filter" )
                   ) ;
   sub_menu->Append( ID_UNSEL_FIL,
                     _( "&Unselect\tCtrl+L" ),
                     _( "Unselect files with a filter" )
                   ) ;
   menu->AppendSubMenu( sub_menu, _( "&Filter" ) ) ;
   /*----------------------------------------------------------------------*/
   menu_bar->Append( menu, _( "&Select" ) ) ;

   /*-----------------------------------------------------------------------+
   ! Action                                                                 !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;

   menu->Append( ID_ACT_RENAME, _( "&Rename\tCtrl+R" ),
                 _( "Rename the selected files" )
               ) ;
   menu->Append( ID_ACT_COMPUTE, _( "Re&compute\tCtrl+K" ),
                 _( "Recompute the \"New names\"" )
               ) ;
   menu->Append( ID_ACT_COPY, _( "Create &copies\tCtrl+M" ),
                 _( "Create copies of the selected files named after "
                    "their \"New names\""
                  )
               ) ;
   menu->Append( ID_ACT_UNDO, _( "&Undo\tCtrl+U" ),
                 _( "Undo an operation" )
               ) ;
   menu->Append( ID_ACT_REDO, _( "Red&o\tCtrl+Y" ),
                 _( "Redo an undone operation" )
               ) ;
   menu_bar->Append( menu, _( "&Action" ) ) ;

   /*-----------------------------------------------------------------------+
   ! ?                                                                      !
   +-----------------------------------------------------------------------*/
   menu = new wxMenu() ;
   menu->Append( IDM_CHECKVERSION_MANUAL,
                 _( "&Check if a new version is available" )
               ) ;
   menu->Append( IDM_MAKE_DONATION, _( "Make a &donation" ) ) ;
   menu->AppendSeparator() ;
   menu->Append( IDM_FIRST_CONTACT, _( "&First contact" ) ) ;
   menu->Append( wxID_HELP, _( "&Help\tF1" ) ) ;
   menu->Append( IDM_TESTBED, _( "Expression &testbed" ) ) ;
   menu->AppendSeparator() ;
   menu->Append( wxID_ABOUT, _( "&About ..." ) ) ;
   menu_bar->Append( menu, _( "&?" ) ) ;
   /*----------------------------------------------------------------------*/
   SetMenuBar( menu_bar ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::add_layout_components()
{
   /*----------------------------------------------------------------------*/
   wxBoxSizer *bsz_dir ;

   /*-----------------------------------------------------------------------+
   ! The Panel will give the right background colour to combos titles and   !
   ! "ends" of toolbars                                                     !
   +-----------------------------------------------------------------------*/
   m_panel = new wxPanel( this ) ;

   /*-----------------------------------------------------------------------+
   ! Toolbar ACTION                                                         !
   +-----------------------------------------------------------------------*/
   m_to_act = new wxToolBar( m_panel, wxID_ANY, wxDefaultPosition,
                             wxDefaultSize, wxTB_FLAT
                           ) ;
   m_to_act->SetToolBitmapSize( g_co_size_tool ) ;
   m_to_act->AddTool( ID_ACT_RENAME, wxEmptyString,
                      wxBitmap( act_rename_xpm ), _( "Rename" )
                    )->Enable( false ) ;
   m_to_act->AddTool( ID_ACT_COMPUTE, wxEmptyString,
                      wxBitmap( act_compute_xpm ), _( "Recompute" )
                    )->Enable( false ) ;
   m_to_act->AddTool( ID_ACT_COPY, wxEmptyString,
                      wxBitmap( act_copy_xpm ), _( "Create copies" )
                    )->Enable( false ) ;
   m_to_act->AddTool( ID_ACT_UNDO, wxEmptyString,
                      wxBitmap( act_undo_xpm ), _( "Undo" )
                    )->Enable( false ) ;
   m_to_act->AddTool( ID_ACT_REDO, wxEmptyString,
                      wxBitmap( act_redo_xpm ), _( "Redo" )
                    )->Enable( false ) ;
   m_to_act->AddTool( wxID_PREFERENCES, wxEmptyString,
                      wxBitmap( act_prefs_xpm ), _( "Preferences" )
                    ) ;
   m_to_act->Realize() ;

   /*-----------------------------------------------------------------------+
   ! Toolbar SELECTION                                                      !
   +-----------------------------------------------------------------------*/
   m_to_sel = new wxToolBar( m_panel, wxID_ANY, wxDefaultPosition,
                             wxDefaultSize, wxTB_FLAT
                           ) ;
   m_to_sel->SetToolBitmapSize( g_co_size_tool ) ;
   m_to_sel->AddSeparator() ;
   m_to_sel->AddTool( ID_SEL_ALL, wxEmptyString,
                      wxBitmap( sel_all_xpm ), _( "Select all" )
                    ) ;
   m_to_sel->AddTool( ID_UNSEL_ALL, wxEmptyString,
                      wxBitmap( sel_unsel_all_xpm ), _( "Unselect all" )
                    ) ;
   m_to_sel->AddTool( ID_SEL_INV, wxEmptyString,
                      wxBitmap( sel_inv_xpm ), _( "Invert selection" )
                    ) ;
   m_to_sel->AddTool( ID_SEL_HIL, wxEmptyString,
                      wxBitmap( sel_hil_xpm ),
                      _( "Select highlighted files" )
                    ) ;
   m_to_sel->AddTool( ID_UNSEL_HIL, wxEmptyString,
                      wxBitmap( sel_unsel_hil_xpm ),
                      _( "Unselect highlighted files" )
                    ) ;
   m_to_sel->AddTool( ID_SEL_FIL, wxEmptyString,
                      wxBitmap( sel_fil_xpm ),
                      _( "Select with a file filter" )
                    ) ;
   m_to_sel->AddTool( ID_UNSEL_FIL, wxEmptyString,
                      wxBitmap( sel_unsel_fil_xpm ),
                      _( "Unselect with a file filter" )
                    ) ;
   m_to_sel->Realize() ;

   /*-----------------------------------------------------------------------+
   ! Toolbar columns groups                                                 !
   +-----------------------------------------------------------------------*/
   m_to_grp = new wxToolBar( m_panel, wxID_ANY, wxDefaultPosition,
                             wxDefaultSize, wxTB_FLAT
                           ) ;
   m_to_grp->SetToolBitmapSize( g_co_size_tool ) ;
   m_to_grp->AddSeparator() ;
   wxGetApp().m_colgroup.add_buttons( m_to_grp ) ;
   m_to_grp->Realize() ;

   /*-----------------------------------------------------------------------+
   ! Toolbar Expression                                                     !
   ! The menu is supposed to already have been created.                     !
   +-----------------------------------------------------------------------*/
   m_cb_exp = new CComboExp( m_panel, ID_CB_EXP,
                             wxEmptyString, wxDefaultPosition,
                             wxDefaultSize, 0, NULL, wxTE_PROCESS_ENTER
                           ) ;
   m_to_exp = new wxToolBar( m_panel, wxID_ANY, wxDefaultPosition,
                             wxDefaultSize, wxTB_FLAT | wxTB_NODIVIDER
                           ) ;
   m_to_exp->SetToolBitmapSize( g_co_size_tool ) ;
   m_to_exp->AddCheckTool( ID_BT_COMPLETION, wxEmptyString,
                           wxBitmap( completion_xpm ), wxNullBitmap,
                        GetMenuBar()->FindItem( ID_BT_COMPLETION )->GetHelp()
                         ) ;
   m_to_exp->AddTool( ID_BT_WIZARD, wxEmptyString,
                      wxBitmap( wizard_xpm ),
                      GetMenuBar()->FindItem( ID_BT_WIZARD )->GetHelp()
                    ) ;
   m_to_exp->Realize() ;

   /*-----------------------------------------------------------------------+
   ! Toolbar combo Directory                                                !
   +-----------------------------------------------------------------------*/
   m_cb_dir = new CComboDir( m_panel, ID_CB_DIR,
                             wxEmptyString, wxDefaultPosition,
                             wxDefaultSize, 0, NULL, wxTE_PROCESS_ENTER
                           ) ;
   m_cb_dir->SetMinSize( wxSize( 20, -1 ) ) ;

   m_to_aco_dir = new wxToolBar( m_panel, ID_TB_ACO_DIR, wxDefaultPosition,
                                 wxDefaultSize, wxTB_FLAT | wxTB_NODIVIDER
                               ) ;
   m_to_aco_dir->SetToolBitmapSize( g_co_size_tool ) ;
   m_to_aco_dir->AddTool( ID_BT_ACO_DIR, wxEmptyString,
                          get_toolbar_bmp( wxART_PLUS ),
                          _( "Add path to combo" )
                        ) ;
   m_to_aco_dir->Realize() ;

   /*-----------------------------------------------------------------------+
   ! Toolbar Directory                                                      !
   +-----------------------------------------------------------------------*/
   m_to_dir = new wxToolBar( m_panel, wxID_ANY, wxDefaultPosition,
                             wxDefaultSize, wxTB_FLAT | wxTB_NODIVIDER
                           ) ;
   m_to_dir->SetToolBitmapSize( g_co_size_tool ) ;
   m_to_dir->AddSeparator() ;
   m_to_dir->AddTool( ID_TB_DIR_BACK, wxEmptyString,
                      get_toolbar_bmp( wxART_GO_BACK ), _( "Back" ),
                      wxITEM_DROPDOWN
                    )->Enable( false ) ;
   m_to_dir->AddTool( ID_TB_DIR_FORWARD, wxEmptyString,
                      get_toolbar_bmp( wxART_GO_FORWARD ), _( "Forward" ),
                      wxITEM_DROPDOWN
                    )->Enable( false ) ;
   m_to_dir->AddTool( ID_TB_DIR_CHOOSE, wxEmptyString,
                      get_toolbar_bmp( wxART_FOLDER_OPEN ),
                      _( "Choose current directory" )
                    ) ;
   m_to_dir->AddTool( ID_TB_DIR_UP, wxEmptyString,
                      get_toolbar_bmp( wxART_GO_DIR_UP ),
                      _( "Parent directory" )
                    ) ;
   m_to_dir->AddTool( ID_TB_DIR_REFRESH, wxEmptyString,
                      wxBitmap( dir_refresh_xpm ),
                      _( "Reload current directory" )
                    ) ;
   m_to_dir->AddCheckTool( ID_TB_DIR_RECURSE, wxEmptyString,
                           wxBitmap( dir_recurse_xpm ), wxNullBitmap,
                           _( "Load the sub directories" )
                         ) ;
   m_to_dir->AddTool( ID_TB_DIR_STOP_LOADING, wxEmptyString,
                      wxBitmap( dir_stop_loading_xpm ),
                      _( "Stop current loading" )
                    ) ;
   m_to_dir->AddSeparator() ;
   m_to_dir->Realize() ;

   m_to_dir->ToggleTool( ID_TB_DIR_RECURSE, get_recurse() ) ;
   m_to_dir->EnableTool( ID_TB_DIR_STOP_LOADING, false ) ;

   /*-----------------------------------------------------------------------+
   ! Toolbar combo filter                                                   !
   +-----------------------------------------------------------------------*/
   m_cb_fil = new CComboFil( m_panel, ID_CB_FIL,
                             wxEmptyString, wxDefaultPosition,
                             wxDefaultSize, 0, NULL, wxTE_PROCESS_ENTER
                           ) ;
   m_cb_fil->SetMinSize( wxSize( 20, -1 ) ) ;
   m_cb_fil->SetSize( wxSize( 90, -1 ) ) ;

   /*-----------------------------------------------------------------------+
   ! Tree + Separator + List + Separator + Display                          !
   ! The "layout" (display image at the left or right) will be done later   !
   +-----------------------------------------------------------------------*/
     m_spl_ver
   = new wxSplitterWindow( m_panel, wxID_ANY, wxDefaultPosition,
                           wxDefaultSize, wxSP_LIVE_UPDATE
                         ) ;
     m_spl_hor
   = new wxSplitterWindow( m_spl_ver, wxID_ANY, wxDefaultPosition,
                           wxDefaultSize, wxSP_LIVE_UPDATE
                         ) ;
   /*----------------------------------------------------------------------*/
   m_dt = new CDirTree( m_panel ) ;
   m_fl = new CFileList( m_panel ) ;

   /*--( The notebook will always be attached to the horizontal splitter )-*/
   m_nb = new CNbVisu( m_spl_hor, ID_NB ) ;
   /*--( Members of a notebook have to be its children )-------------------*/
   wxPanel *panel_iv = new wxPanel( m_nb ) ;
   m_iv = new CImageVisu( panel_iv, wxID_ANY ) ;
   sr::attach_win_to_panel( m_iv, panel_iv ) ;
   /*----------------------------------------------------------------------*/
   wxPanel *panel_tv = new wxPanel( m_nb ) ;
   m_tv = new CTagVisu( panel_tv, wxID_ANY ) ;
   sr::attach_win_to_panel( m_tv, panel_tv ) ;
   /*----------------------------------------------------------------------*/
   m_nb->AddPage( panel_iv, _( "Image" ) ) ;
   m_nb->AddPage( panel_tv, _( "Tag" ) ) ;

   /*--( Minimal pane sizes set to 1 to avoid "unsplits" )-----------------*/
   m_spl_ver->SetMinimumPaneSize( 1 ) ;
   m_spl_hor->SetMinimumPaneSize( 1 ) ;

   /*-----------------------------------------------------------------------+
   ! Sizer Action                                                           !
   +-----------------------------------------------------------------------*/
   m_bsz_act = new wxBoxSizer( wxHORIZONTAL ) ;
   m_bsz_act->Add( m_to_act, 0, wxLEFT | wxRIGHT ) ;
   /*--( The end of the divider line is drawn by "sel" or "grp" toolbar ? )*/
   m_bsz_act->Add( m_to_sel, wxGetApp().M_boo_toolbar_grp.get() ? 0 : 1,
                   wxLEFT | wxRIGHT
                 ) ;
   m_bsz_act->Add( m_to_grp, 1, wxLEFT | wxRIGHT
                 )->Show( wxGetApp().M_boo_toolbar_grp.get() ) ;

   /*-----------------------------------------------------------------------+
   ! Sizer Expression                                                       !
   +-----------------------------------------------------------------------*/
   m_bsz_exp = new wxBoxSizer( wxHORIZONTAL ) ;
   m_bsz_exp->Add( new wxStaticText( m_panel, wxID_ANY, _( "Expression" ) ),
                   0, wxLEFT | wxRIGHT | wxALIGN_CENTER, 5
                 ) ;
   m_bsz_exp->Add( m_cb_exp, 1, wxEXPAND ) ;
   m_bsz_exp->Add( m_to_exp, 0, wxLEFT | wxRIGHT ) ;
   m_bsz_exp_glob = NULL ;

   /*-----------------------------------------------------------------------+
   ! Sizer Directory                                                        !
   +-----------------------------------------------------------------------*/
   bsz_dir = new wxBoxSizer( wxHORIZONTAL ) ;
   bsz_dir->Add( new wxStaticText( m_panel, wxID_ANY, _( "Directory" ) ),
                 0, wxLEFT | wxRIGHT | wxALIGN_CENTER, 5
               ) ;
   bsz_dir->Add( m_cb_dir, 4, wxEXPAND ) ;
   bsz_dir->Add( m_to_aco_dir, 0, wxEXPAND ) ;
   bsz_dir->Add( m_to_dir, 0, wxEXPAND, 10 ) ;
   bsz_dir->Add( new wxStaticText( m_panel, wxID_ANY, _( "Filter" ) ),
                 0, wxLEFT | wxRIGHT | wxALIGN_CENTER, 5
               ) ;
   bsz_dir->Add( m_cb_fil, 1, wxEXPAND ) ;

   /*-----------------------------------------------------------------------+
   ! Sizer General                                                          !
   +-----------------------------------------------------------------------*/
   m_bsz_gen = new wxBoxSizer( wxVERTICAL ) ;
   m_bsz_gen->Add( m_bsz_act, 0, wxEXPAND ) ;

   adapt_toolbars_layout() ;

   m_bsz_gen->Add( new wxStaticLine( m_panel ), 0, wxEXPAND ) ;
   m_bsz_gen->Add( bsz_dir, 0, wxEXPAND ) ;
   m_bsz_gen->Add( m_spl_ver, 1, wxEXPAND ) ;
   /*----------------------------------------------------------------------*/
   m_panel->SetSizer( m_bsz_gen ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFrame::add_status_bar()
{
   /*----------------------------------------------------------------------*/
   m_statusbar = new wxStatusBar( this ) ;
   /*----------------------------------------------------------------------*/
   m_statusbar->Show( wxGetApp().M_boo_show_statusbar.get() ) ;
   /*----------------------------------------------------------------------*/
   wxWindowDC dc_sb( m_statusbar ) ;
   const int co_tb_sb_style[ SB_NB ]
     = { wxSB_FLAT, wxSB_NORMAL, wxSB_NORMAL, wxSB_NORMAL } ;
   int tb_sb_width[ SB_NB ] = { -1 } ;
   /*----------------------------------------------------------------------*/
     tb_sb_width[ SB_OPER ]
   = dc_sb.GetTextExtent( _( "Oper : XXX/XXX" ) ).GetWidth() ;
     tb_sb_width[ SB_SEL_DURATION ]
   = dc_sb.GetTextExtent( _( "Sel duration : XXXXhXXmXXs" ) ).GetWidth() ;
     tb_sb_width[ SB_SEL_SIZE ]
   = dc_sb.GetTextExtent( _( "Sel size : XXXX.XX XXX" ) ).GetWidth() ;
   /*-----------------------------------------------------------------------+
   ! The statusbar contains on its right the "size grip" which is generally !
   ! square. To avoid it to be "overwritten", a statusbar height is added   !
   ! to the last field length.                                              !
   +-----------------------------------------------------------------------*/
     tb_sb_width[ SB_SEL_NB ]
   =   dc_sb.GetTextExtent( _( "Sel : XXXXX/XXXXX" ) ).GetWidth()
     + m_statusbar->GetSize().GetHeight() ;
   /*----------------------------------------------------------------------*/
   m_statusbar->SetFieldsCount( SB_NB, tb_sb_width ) ;
   m_statusbar->SetStatusStyles( SB_NB, co_tb_sb_style ) ;
   SetStatusBar( m_statusbar ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFrame_Init.cpp                          !
+==========================================================================*/
