/*====================================+=====================================+
! File CFileList_On.cpp               ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include <wx/time.h>
#include "common/sr_lib.h"
#include "common/msw/sr_ctxmnu.h"
#include "CApp.h"
#include "CFileList.h"
#include "prefs/CDlgPrefs.h"
#include "CDirTree.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CFileList, wxListCtrl )
   /*----------------------------------------------------------------------*/
   EVT_CHAR( CFileList::OnChar )
   EVT_KEY_DOWN( CFileList::OnKeyDown )
   EVT_LEFT_DOWN( CFileList::OnMouseLeftDown )
   EVT_LIST_COL_CLICK( wxID_ANY, CFileList::OnColClick )
   EVT_LIST_COL_RIGHT_CLICK( wxID_ANY, CFileList::OnColRightClick )
   EVT_LIST_ITEM_RIGHT_CLICK( wxID_ANY, CFileList::OnItemRightClick )
   EVT_LIST_ITEM_ACTIVATED( wxID_ANY, CFileList::OnItemActivated )
   EVT_LIST_ITEM_FOCUSED( wxID_ANY, CFileList::OnItemFocused )
   /*----------------------------------------------------------------------*/
   EVT_LIST_COL_BEGIN_DRAG( wxID_ANY, CFileList::OnColBeginDrag )
   EVT_LIST_BEGIN_DRAG( wxID_ANY, CFileList::OnBeginDrag )
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*--( Search name by prefix )----------------------------------------------*/
void CFileList::OnChar( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxLongLong ll_search_char = wxGetLocalTimeMillis() ;
   int        i_start        = get_item_focus()       ;
   int        i_num ;

   /*--( Timeout between keystrokes )--------------------------------------*/
   if( ll_search_char - m_ll_last_search_char > 1000 )
   {  m_s_search_by_char.clear() ; }

   /*----------------------------------------------------------------------*/
   m_ll_last_search_char = ll_search_char ;
   /*--( One character added to the searched name )------------------------*/
   m_s_search_by_char += event.GetUnicodeKey() ;

   /*--( Search with full prefix )-----------------------------------------*/
   i_num = m_dir.file_with_prefix_circle( i_start, m_s_search_by_char ) ;

   /*-----------------------------------------------------------------------+
   ! If not found then search with the char typed starting at the next file !
   +-----------------------------------------------------------------------*/
   if( i_num < 0 && !m_s_search_by_char.empty() )
   {
      /*-------------------------------------------------------------------*/
      m_s_search_by_char = event.GetUnicodeKey() ;
      /*-------------------------------------------------------------------*/
      i_num = m_dir.file_with_prefix_circle( i_start + 1,
                                             m_s_search_by_char
                                           ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( i_num >= 0 )
   {  set_item_active( i_num ) ; }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   switch( event.GetKeyCode() )
   {
      /*--------------------------------------------------------------------+
      ! The "space" key is handy to achieve selection/unselection directly  !
      ! in the file list window.                                            !
      +--------------------------------------------------------------------*/
      case WXK_SPACE :
         wxGetApp().m_frame->ProcessCommand( ID_SEL_UNSEL_HIL ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case WXK_F2 :
         manual_rename( get_item_focus() ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case WXK_DELETE :
         del_hil() ;
         break ;
      /*-------------------------------------------------------------------*/
      case WXK_BACK :
         /*--( Convert backspace to dir up action )------------------------*/
         wxGetApp().m_frame->ProcessCommand( ID_TB_DIR_UP ) ;
         break ;
      /*-------------------------------------------------------------------*/
#ifdef __WXMSW__
      case WXK_WINDOWS_MENU :
         shell_contextual_menu() ;
         break ;
#endif // __WXMSW__
      /*-------------------------------------------------------------------*/
      default :
         event.Skip() ;
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnMouseLeftDown( wxMouseEvent &event )
{
   /*----------------------------------------------------------------------*/
   int  flags ;
   long l_item = HitTest( event.GetPosition(), flags ) ;

   /*--( Click in checkbox ? )---------------------------------------------*/
   if( l_item > -1 && ( flags & wxLIST_HITTEST_ONITEMICON ) != 0 )
   {
      /*-------------------------------------------------------------------*/
      const CFile *p_file = m_dir.get_p_file( l_item ) ;
      if( p_file == NULL ) { return ; }
      /*-------------------------------------------------------------------*/
      if( p_file->is_selected() )
      {  unsel( l_item ) ; }
      else
      {  sel( l_item ) ; }
      /*--( The user can click without having validated the exp )----------*/
      compute_new_names() ;
      /*-------------------------------------------------------------------*/
      wxGetApp().m_frame->gui_update_oper() ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnColClick( wxListEvent &event )
{
   /*--( Some columns can't be used as sort criteria )---------------------*/
   if( get_col_disp_col( event.GetColumn() ).m_sort != SORT_NB )
   {  /*-------------------------------------------------------------------*/
      change_column_sort_image( event.GetColumn() ) ;
      sort_file_list( SFL_DO_RESFRESH ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnColRightClick( wxListEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxMenu menu  ;
   int    i_col ;

   /*-----------------------------------------------------------------------+
   ! At least under wxMSW 2.9.4, a Right Click on the N + 1 column is       !
   ! possible (pseudo column header on the right of the last created one).  !
   +-----------------------------------------------------------------------*/
   if( !is_disp_col_ok( event.GetColumn() ) )
   {  return ; }
   /*----------------------------------------------------------------------*/
   i_col = get_ind_col_disp_col( event.GetColumn() ) ;

   /*--( Menu useless for some columns )-----------------------------------*/
   if(     m_tb_col[ i_col ].m_boo_on_forced
       &&  m_tb_col[ i_col ].m_grp == GRP_NONE
       && !m_tb_col[ i_col ].m_boo_width_modifiable
     )
   {  return ; }

   /*----------------------------------------------------------------------*/
   if( m_tb_col[ i_col ].m_boo_width_modifiable )
   {  /*-------------------------------------------------------------------*/
      menu.Append( IDM_COL_DEF_WIDTH, _( "&Default width" ) ) ;
      menu.Append( IDM_COL_AUTOSIZE , _( "&Fit width to data" ),
                   _( "Fit column width to the maximum data length it "
                      "contains"
                    )
                 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( m_dir.get_nb_sel() != 0 )
   {  menu.Append( IDM_COL_DATA_CBC , _( "&Copy selected files data" ),
                   _( "Copy to the clipboard the data of the selected files "
                      "contained in this column"
                    )
                 ) ;
   }
   /*----------------------------------------------------------------------*/
   if( !m_tb_col[ i_col ].m_boo_on_forced )
   {  menu.Append( IDM_COL_OFF, _( "&Hide" ),
                   _( "Do not display this column any more" )
                 ) ;
   }
   /*----------------------------------------------------------------------*/
   if( m_tb_col[ i_col ].m_grp != GRP_NONE )
   {
      /*-------------------------------------------------------------------*/
      wxString s_grp_name
             = wxGetApp().m_colgroup.get_name( m_tb_col[ i_col ].m_grp ) ;
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_COL_ON_GRP_OFF,
                   wxString::Format( _( "Hide &other columns of the \"%s\" "
                                        "group"
                                      ), s_grp_name
                                   ),
                   _( "Do not display any column of the group except "
                      "this one"
                    )
                 ) ;
      menu.Append( IDM_COL_GRP_OFF,
                   wxString::Format( _( "Hide &all columns of the \"%s\" "
                                        "group"
                                      ), s_grp_name
                                   ),
                   _( "Do not display any column of the group this "
                      "column belongs to"
                    )
                 ) ;
      menu.Append( IDM_COL_GRP_ON,
                   wxString::Format( _( "&Display all columns of the "
                                        "\"%s\" group"
                                      ), s_grp_name
                                   ),
                   _( "Display all the columns of the group this "
                      "column belongs to"
                    )
                 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   menu.Append( IDM_COL_CUSTOMIZE, _( "Customi&ze ..." ),
                _( "Access the page regarding the columns of the "
                   "Preferences"
                 )
              ) ;

   /*----------------------------------------------------------------------*/
   switch( GetPopupMenuSelectionFromUser( menu, event.GetPoint() ) )
   {
      /*-------------------------------------------------------------------*/
      case IDM_COL_OFF :
         m_tb_col[ i_col ].m_boo_on = false ;
         create_all_col() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_ON_GRP_OFF :
         turn_all_grp_col_off_except( i_col ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_GRP_OFF :
         turn_all_grp_col_on_off( m_tb_col[ i_col ].m_grp, false ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_GRP_ON :
         turn_all_grp_col_on_off( m_tb_col[ i_col ].m_grp, true ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_DEF_WIDTH :
         SetColumnWidth( m_tb_col[ i_col ].m_i_col_disp,
                         m_tb_col[ i_col ].m_i_width_def
                       ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_AUTOSIZE :
         col_auto_size( i_col ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_DATA_CBC :
         col_selected_list_to_clipboard( m_tb_col[ i_col ].m_i_subitem ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COL_CUSTOMIZE :
         CDlgPrefs( this ).get_modal_col() ;
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnItemRightClick( wxListEvent &event )
{
   /*----------------------------------------------------------------------*/
   long     l_item              ;
   long     l_disp_col          ;
   int      i_col               ;
   wxMenu   menu                ;
   wxString s_var               ;
   wxString s_val               ;
   bool     boo_add_sep = false ;

   /*--( Displayed column )------------------------------------------------*/
   if( get_item_col_at_point( event.GetPoint(), l_item, l_disp_col ) != 0 )
   {  return ; }

   /*--( Internal column structure )---------------------------------------*/
   i_col = get_ind_col_disp_col( l_disp_col ) ;

   /*--( Variable name associated to this column )-------------------------*/
   s_var = m_tb_col[ i_col ].m_s_var_name ;
   /*----------------------------------------------------------------------*/
   if( !s_var.empty() )
   {
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_INS_VAR,
                   wxString::Format(
                        _( "&Insert pointed variable into expression (%s)" ),
                        s_var
                                   )
                 ) ;
      /*-------------------------------------------------------------------*/
      boo_add_sep = true ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Value associated to this column )---------------------------------*/
   CFile *p_file = m_dir.get_p_file( l_item ) ;
   if( p_file != NULL )
   {  s_val = p_file->get_s_val( m_tb_col[ i_col ].m_i_subitem ) ; }
   /*----------------------------------------------------------------------*/
   if( !s_val.empty() )
   {
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_INS_VAL,
                   _( "I&nsert pointed value into expression" )
                 ) ;
      menu.Append( IDM_COPY_VAL_CLIPBOARD,
                   _( "&Copy pointed value to clipboard" )
                 ) ;
      /*-------------------------------------------------------------------*/
      boo_add_sep = true ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( !s_var.empty() )
   {
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_HELP_VAR,
                   wxString::Format( _( "&Help about pointed variable (%s)"),
                                     s_var
                                   )
                 ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( boo_add_sep ) { menu.AppendSeparator() ; }

   /*----------------------------------------------------------------------*/
   menu.Append( IDM_EDIT_FILENAME, _( "Manual &rename\tF2" ),
                _( "Edit current file name" )
              )->Enable(    p_file != NULL && p_file->is_selectable()
                         && wxGetApp().m_frame->get_fswatcher_active()
                       ) ;
   menu.Append( IDM_FILE_OPEN, _( "&Open\tEnter" ),
                _( "Open highlighted file(s)" )
              ) ;
   menu.Append( IDM_FILE_DELETE, _( "&Delete\tDelete" ),
                _( "Delete highlighted file(s)" )
              ) ;
   menu.Append( IDM_FILE_CONTENT_EXTRACTION,
                _( "File content &extraction (debug)" )
              ) ;

   /*----------------------------------------------------------------------*/
   boo_add_sep = true ;

   /*----------------------------------------------------------------------*/
   if( wxGetApp().m_tool.get_nb_active() > 0 )
   {
      /*-------------------------------------------------------------------*/
      if( boo_add_sep ) { menu.AppendSeparator() ; boo_add_sep = false ; }
      /*-------------------------------------------------------------------*/
      wxMenu *p_tool_menu = new wxMenu() ;
      wxGetApp().m_tool.append_to_menu( p_tool_menu ) ;
      menu.AppendSubMenu( p_tool_menu, _( "&Tools" ) ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( p_file != NULL )
   {
      /*-------------------------------------------------------------------*/
      if( boo_add_sep ) { menu.AppendSeparator() ; boo_add_sep = false ; }
      /*-------------------------------------------------------------------*/
      menu.Append( IDM_EXPLORE_DIR, _( "Start file e&xplorer" ),
                   _( "Open the directory containing this file or this "
                      "directory in the file explorer"
                    )
                 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
#ifdef __WXMSW__
   if( boo_add_sep ) { menu.AppendSeparator() ; boo_add_sep = false ; }
   menu.Append( IDM_SHELL_CONTEXTUAL_MENU, _( "S&hell contextual menu" ) ) ;
#endif // __WXMSW__

   /*----------------------------------------------------------------------*/
   int i_choice = GetPopupMenuSelectionFromUser( menu, event.GetPoint() ) ;
   /*----------------------------------------------------------------------*/
   switch( i_choice )
   {
      /*-------------------------------------------------------------------*/
      case IDM_INS_VAR :
         wxGetApp().m_frame->m_cb_exp->WriteText( s_var ) ;
         compute_new_names() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_HELP_VAR :
         wxGetApp().m_frame->show_help( HELP_VAR "#" + s_var ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_INS_VAL :
         wxGetApp().m_frame->m_cb_exp->WriteText( s_val ) ;
         compute_new_names() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_COPY_VAL_CLIPBOARD :
         sr::set_clipboard( s_val ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_EDIT_FILENAME :
         manual_rename( get_item_focus() ) ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_FILE_OPEN :
         exec_hil() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_FILE_DELETE :
         del_hil() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_FILE_CONTENT_EXTRACTION :
         file_content_extraction() ;
         break ;
      /*-------------------------------------------------------------------*/
      case IDM_EXPLORE_DIR :
         /*----------------------------------------------------------------*/
         if( p_file != NULL ) { launch_file_explorer() ; }
         /*----------------------------------------------------------------*/
         break ;
      /*-------------------------------------------------------------------*/
#ifdef __WXMSW__
      case IDM_SHELL_CONTEXTUAL_MENU :
         shell_contextual_menu() ;
         break ;
#endif // __WXMSW__
      /*--( Else it should be an option of the "Tools" menu )--------------*/
      default :
         /*----------------------------------------------------------------*/
         wxGetApp().m_frame->ProcessCommand( i_choice ) ;
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnItemActivated( wxListEvent &event )
{
   /*----------------------------------------------------------------------*/
   exec_hil() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnItemFocused( wxListEvent &event )
{
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->visu_file( event.GetIndex() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnColBeginDrag( wxListEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( !get_col_disp_col( event.GetColumn() ).m_boo_width_modifiable )
   {  event.Veto() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileList::OnBeginDrag( wxListEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   wxFileDataObject data           ;
   wxDropSource     source( this ) ;
   long             l_num = -1     ;

   /*----------------------------------------------------------------------*/
   while( ( l_num = get_next_hil_item( l_num ) ) != -1 )
   {
      /*--------------------------------------------------------------------+
      ! This "complicate" operation because after a rename, a file may not  !
      ! be part of the current directory tree.                              !
      ! "AddFile" is not supposed to work under something else than MSW ... !
      +--------------------------------------------------------------------*/
      data.AddFile(   sr::absolute_path( m_dir[ l_num ].get_name(),
                                         wxGetApp().M_s_dir.get()
                                       )
                    + m_dir[ l_num ].get_full_name()
                  ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   source.SetData( data ) ;

   /*--( Don't want to drop from the list on itself or to dir tree )-------*/
   reset_drop_target() ;
   wxGetApp().m_frame->m_dt->reset_drop_target() ;
   wxGetApp().m_frame->m_cb_dir->reset_drop_target() ;
   source.DoDragDrop() ;
   init_drop_target()  ;
   wxGetApp().m_frame->m_dt->init_drop_target() ;
   wxGetApp().m_frame->m_cb_dir->init_drop_target() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxListItemAttr *CFileList::OnGetItemAttr( long item ) const
{
   /*----------------------------------------------------------------------*/
   const CFile *p_file = m_dir.get_p_file( item ) ;
   /*----------------------------------------------------------------------*/
   if( p_file == NULL ) { return( NULL ) ; }
   /*----------------------------------------------------------------------*/
   static wxListItemAttr st_attr ;
   /*----------------------------------------------------------------------*/
   if( p_file->is_oper_err() )
   {  st_attr.SetBackgroundColour( item % 2 == 0
                                   ? wxColour( 252, 120, 100 )
                                   : wxColour( 252, 110,  90 )
                                 ) ;
   }
   else
   if( p_file->is_selected() )
   {  st_attr.SetBackgroundColour( item % 2 == 0
                                   ? wxColour( 210, 252, 255 )
                                   : wxColour( 210, 242, 245 )
                                 ) ;
   }
   else
   if( item % 2 == 1 && wxGetApp().M_boo_list_alt_attr.get() )
   {  st_attr.SetBackgroundColour( get_alternate_attr() ) ; }
   else
   {  return( NULL ) ; }
   /*----------------------------------------------------------------------*/
   return( &st_attr ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileList::OnGetItemColumnImage( long item, long column ) const
{
   /*-----------------------------------------------------------------------+
   ! This cast ( CFile * ) because it seems that gcc doesn't seem to see    !
   ! the "non const" version of "get_p_file"                                !
   +-----------------------------------------------------------------------*/
   CFile *p_file = ( CFile * )m_dir.get_p_file( item ) ;
   if( p_file == NULL ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   int i_si = m_vec_i_col_subitem[ column ] ;
   /*----------------------------------------------------------------------*/
   if( i_si == COL_NONE_CHECKBOX )
   {  /*-------------------------------------------------------------------*/
      if( !p_file->is_selectable() ) { return( -1 ) ; }
      /*-------------------------------------------------------------------*/
      return( p_file->is_selected()
              ? m_p_image_list->get_check()
              : m_p_image_list->get_uncheck()
            ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( i_si == COL_NONE_ICON )
   {  /*-------------------------------------------------------------------*/
      if( !p_file->is_ico_initialized() )
      {
         /*----------------------------------------------------------------*/
         if( p_file->is_dir() )
         {  p_file->set_i_ico( m_p_image_list->get_dir() ) ; }
         else
         {  p_file->set_i_ico( m_p_image_list->icon_index( *p_file ) ) ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      return( p_file->get_i_ico() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( -1 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxString CFileList::OnGetItemText( long item, long column ) const
{
   /*----------------------------------------------------------------------*/
   const CFile *p_file = m_dir.get_p_file( item ) ;
   /*----------------------------------------------------------------------*/
   if( p_file == NULL ) { return( wxEmptyString ) ; }
   /*----------------------------------------------------------------------*/
   return( p_file->get_s_val( m_vec_i_col_subitem[ column ] ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileList_On.cpp                         !
+==========================================================================*/
