/*====================================+=====================================+
! File CFileList_Init.cpp             ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifdef __WXMSW__
#include <wx/msw/wrapshl.h>
#endif // __WXMSW__
#include <wx/imaglist.h>
#include "CFileList.h"
#include "CApp.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
int CFileList::init()
{
   /*-----------------------------------------------------------------------+
   ! Don't know how to handle a column drag/drop for a wxListCtrl.          !
   ! That is why this feature is disabled under MSW.                        !
   +-----------------------------------------------------------------------*/
#ifdef __WXMSW__
   ListView_SetExtendedListViewStyleEx( GetHandle(),
                                        LVS_EX_HEADERDRAGDROP,
                                        ~LVS_EX_HEADERDRAGDROP
                                      ) ;
#endif // __WXMSW__

   /*----------------------------------------------------------------------*/
   show_grid( wxGetApp().M_boo_grid_fl.get() ) ;

   /*----------------------------------------------------------------------*/
   m_p_image_list = new CImageFileList() ;
   SetImageList( m_p_image_list, wxIMAGE_LIST_SMALL ) ;

   /*----------------------------------------------------------------------*/
   m_dir.zero()         ;
   m_vec_otfile.clear() ;
   m_i_num_otfile = 0   ;

   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_NONE_CHECKBOX   ].m_i_width_def = 25                       ;
   m_tb_col[ COL_NONE_CHECKBOX   ].m_grp    = GRP_NONE                      ;
   m_tb_col[ COL_NONE_CHECKBOX   ].m_boo_on_forced = true                   ;
   m_tb_col[ COL_NONE_CHECKBOX   ].m_boo_width_modifiable = false           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_NONE_ICON       ].m_i_width_def = 25                       ;
   m_tb_col[ COL_NONE_ICON       ].m_grp    = GRP_NONE                      ;
   m_tb_col[ COL_NONE_ICON       ].m_boo_on_forced = true                   ;
   m_tb_col[ COL_NONE_ICON       ].m_boo_width_modifiable = false           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_NONE_NAME       ].m_i_width_def = 150                      ;
   m_tb_col[ COL_NONE_NAME       ].m_s_name = _( "Current name" )           ;
   m_tb_col[ COL_NONE_NAME       ].m_grp    = GRP_NONE                      ;
   m_tb_col[ COL_NONE_NAME       ].m_boo_on_forced = true                   ;
   m_tb_col[ COL_NONE_NAME       ].m_s_var_name = "%f"                      ;
   m_tb_col[ COL_NONE_NAME       ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_NONE_NEW_NAME   ].m_i_width_def = 150                      ;
   m_tb_col[ COL_NONE_NEW_NAME   ].m_s_name = _( "New name" )               ;
   m_tb_col[ COL_NONE_NEW_NAME   ].m_grp    = GRP_NONE                      ;
   m_tb_col[ COL_NONE_NEW_NAME   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_NONE_SEL_NUM    ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_NONE_SEL_NUM    ].m_i_width_def = 40                       ;
   m_tb_col[ COL_NONE_SEL_NUM    ].m_s_name = _( "Sel" )                    ;
   m_tb_col[ COL_NONE_SEL_NUM    ].m_grp    = GRP_NONE                      ;
   m_tb_col[ COL_NONE_SEL_NUM    ].m_s_var_name = "%n"                      ;
   m_tb_col[ COL_NONE_SEL_NUM    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_DOS_NAME   ].m_i_width_def = 100                      ;
   m_tb_col[ COL_BASE_DOS_NAME   ].m_s_name = _( "DOS name" )               ;
   m_tb_col[ COL_BASE_DOS_NAME   ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_DOS_NAME   ].m_s_var_name = "%fd"                     ;
   m_tb_col[ COL_BASE_DOS_NAME   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_TYPE       ].m_i_width_def = 120                      ;
   m_tb_col[ COL_BASE_TYPE       ].m_s_name = _( "Type" )                   ;
   m_tb_col[ COL_BASE_TYPE       ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_TYPE       ].m_s_var_name = "%y"                      ;
   m_tb_col[ COL_BASE_TYPE       ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_TYPE_DET   ].m_i_width_def = 120                      ;
   m_tb_col[ COL_BASE_TYPE_DET   ].m_s_name = _( "Type detected" )          ;
   m_tb_col[ COL_BASE_TYPE_DET   ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_TYPE_DET   ].m_s_var_name = "%yd"                     ;
   m_tb_col[ COL_BASE_TYPE_DET   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_SIZE       ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_BASE_SIZE       ].m_i_width_def = 90                       ;
   m_tb_col[ COL_BASE_SIZE       ].m_s_name = _( "Size" )                   ;
   m_tb_col[ COL_BASE_SIZE       ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_SIZE       ].m_s_var_name = "%s"                      ;
   m_tb_col[ COL_BASE_SIZE       ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_CRE_DATE   ].m_s_name = _( "Creation" )               ;
   m_tb_col[ COL_BASE_CRE_DATE   ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_CRE_DATE   ].m_s_var_name = "%dc"                     ;
   m_tb_col[ COL_BASE_CRE_DATE   ].m_sort   = SORT_DATETIME                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_ACC_DATE   ].m_s_name = _( "Access" )                 ;
   m_tb_col[ COL_BASE_ACC_DATE   ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_ACC_DATE   ].m_s_var_name = "%da"                     ;
   m_tb_col[ COL_BASE_ACC_DATE   ].m_sort   = SORT_DATETIME                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_MOD_DATE   ].m_s_name = _( "Modification" )           ;
   m_tb_col[ COL_BASE_MOD_DATE   ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_MOD_DATE   ].m_s_var_name = "%dm"                     ;
   m_tb_col[ COL_BASE_MOD_DATE   ].m_sort   = SORT_DATETIME                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_BASE_ATTR       ].m_i_width_def = 70                       ;
   m_tb_col[ COL_BASE_ATTR       ].m_s_name = _( "Attributes" )             ;
   m_tb_col[ COL_BASE_ATTR       ].m_grp    = GRP_BASE                      ;
   m_tb_col[ COL_BASE_ATTR       ].m_s_var_name = "%a"                      ;
   m_tb_col[ COL_BASE_ATTR       ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDIO_BITRATE   ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_AUDIO_BITRATE   ].m_i_width_def = 80                       ;
   m_tb_col[ COL_AUDIO_BITRATE   ].m_s_name = _( "Aud-Bitrate" )            ;
   m_tb_col[ COL_AUDIO_BITRATE   ].m_grp    = GRP_AUDIO                     ;
   m_tb_col[ COL_AUDIO_BITRATE   ].m_s_var_name = "%Ab"                     ;
   m_tb_col[ COL_AUDIO_BITRATE   ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDIO_SAMPRATE  ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_AUDIO_SAMPRATE  ].m_i_width_def = 90                       ;
   m_tb_col[ COL_AUDIO_SAMPRATE  ].m_s_name = _( "Aud-Sampling" )           ;
   m_tb_col[ COL_AUDIO_SAMPRATE  ].m_grp    = GRP_AUDIO                     ;
   m_tb_col[ COL_AUDIO_SAMPRATE  ].m_s_var_name = "%As"                     ;
   m_tb_col[ COL_AUDIO_SAMPRATE  ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDIO_DURATION  ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_AUDIO_DURATION  ].m_i_width_def = 90                       ;
   m_tb_col[ COL_AUDIO_DURATION  ].m_s_name = _( "Aud-Duration" )           ;
   m_tb_col[ COL_AUDIO_DURATION  ].m_grp    = GRP_AUDIO                     ;
   m_tb_col[ COL_AUDIO_DURATION  ].m_s_var_name = "%Ad"                     ;
   m_tb_col[ COL_AUDIO_DURATION  ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDIO_INFO      ].m_i_width_def = 100                      ;
   m_tb_col[ COL_AUDIO_INFO      ].m_s_name = _( "Aud-Info" )               ;
   m_tb_col[ COL_AUDIO_INFO      ].m_grp    = GRP_AUDIO                     ;
   m_tb_col[ COL_AUDIO_INFO      ].m_s_var_name = "%Ai"                     ;
   m_tb_col[ COL_AUDIO_INFO      ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDIO_CHANNEL   ].m_i_width_def = 80                       ;
   m_tb_col[ COL_AUDIO_CHANNEL   ].m_s_name = _( "Aud-Mode" )               ;
   m_tb_col[ COL_AUDIO_CHANNEL   ].m_grp    = GRP_AUDIO                     ;
   m_tb_col[ COL_AUDIO_CHANNEL   ].m_s_var_name = "%AM"                     ;
   m_tb_col[ COL_AUDIO_CHANNEL   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_TITLE     ].m_i_width_def = 150                      ;
   m_tb_col[ COL_ID3V1_TITLE     ].m_s_name = _( "M1-Title" )               ;
   m_tb_col[ COL_ID3V1_TITLE     ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_TITLE     ].m_s_var_name = "%mt"                     ;
   m_tb_col[ COL_ID3V1_TITLE     ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_ARTIST    ].m_i_width_def = 150                      ;
   m_tb_col[ COL_ID3V1_ARTIST    ].m_s_name = _( "M1-Artist" )              ;
   m_tb_col[ COL_ID3V1_ARTIST    ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_ARTIST    ].m_s_var_name = "%ma"                     ;
   m_tb_col[ COL_ID3V1_ARTIST    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_ALBUM     ].m_i_width_def = 150                      ;
   m_tb_col[ COL_ID3V1_ALBUM     ].m_s_name = _( "M1-Album" )               ;
   m_tb_col[ COL_ID3V1_ALBUM     ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_ALBUM     ].m_s_var_name = "%mA"                     ;
   m_tb_col[ COL_ID3V1_ALBUM     ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_YEAR      ].m_i_width_def = 70                       ;
   m_tb_col[ COL_ID3V1_YEAR      ].m_s_name = _( "M1-Year" )                ;
   m_tb_col[ COL_ID3V1_YEAR      ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_YEAR      ].m_s_var_name = "%my"                     ;
   m_tb_col[ COL_ID3V1_YEAR      ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_COMMENT   ].m_i_width_def = 150                      ;
   m_tb_col[ COL_ID3V1_COMMENT   ].m_s_name = _( "M1-Comment" )             ;
   m_tb_col[ COL_ID3V1_COMMENT   ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_COMMENT   ].m_s_var_name = "%mc"                     ;
   m_tb_col[ COL_ID3V1_COMMENT   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_TRACK_NUM ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_ID3V1_TRACK_NUM ].m_i_width_def = 100                      ;
   m_tb_col[ COL_ID3V1_TRACK_NUM ].m_s_name = _( "M1-Track Num" )           ;
   m_tb_col[ COL_ID3V1_TRACK_NUM ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_TRACK_NUM ].m_s_var_name = "%mT"                     ;
   m_tb_col[ COL_ID3V1_TRACK_NUM ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_ID3V1_GENRE     ].m_i_width_def = 100                      ;
   m_tb_col[ COL_ID3V1_GENRE     ].m_s_name = _( "M1-Genre" )               ;
   m_tb_col[ COL_ID3V1_GENRE     ].m_grp    = GRP_ID3V1                     ;
   m_tb_col[ COL_ID3V1_GENRE     ].m_s_var_name = "%mg"                     ;
   m_tb_col[ COL_ID3V1_GENRE     ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_TITLE    ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_TITLE    ].m_s_name = _( "At-Title" )               ;
   m_tb_col[ COL_AUDTAG_TITLE    ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_TITLE    ].m_s_var_name = "%At"                     ;
   m_tb_col[ COL_AUDTAG_TITLE    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_ARTIST   ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_ARTIST   ].m_s_name = _( "At-Artist" )              ;
   m_tb_col[ COL_AUDTAG_ARTIST   ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_ARTIST   ].m_s_var_name = "%Aa"                     ;
   m_tb_col[ COL_AUDTAG_ARTIST   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_ALBUM    ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_ALBUM    ].m_s_name = _( "At-Album" )               ;
   m_tb_col[ COL_AUDTAG_ALBUM    ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_ALBUM    ].m_s_var_name = "%AA"                     ;
   m_tb_col[ COL_AUDTAG_ALBUM    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_YEAR     ].m_i_width_def = 65                       ;
   m_tb_col[ COL_AUDTAG_YEAR     ].m_s_name = _( "At-Year" )                ;
   m_tb_col[ COL_AUDTAG_YEAR     ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_YEAR     ].m_s_var_name = "%Ay"                     ;
   m_tb_col[ COL_AUDTAG_YEAR     ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_COMMENT  ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_COMMENT  ].m_s_name = _( "At-Comment" )             ;
   m_tb_col[ COL_AUDTAG_COMMENT  ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_COMMENT  ].m_s_var_name = "%Ac"                     ;
   m_tb_col[ COL_AUDTAG_COMMENT  ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_TRACK_NUM].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_AUDTAG_TRACK_NUM].m_i_width_def = 90                       ;
   m_tb_col[ COL_AUDTAG_TRACK_NUM].m_s_name = _( "At-Track Num" )           ;
   m_tb_col[ COL_AUDTAG_TRACK_NUM].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_TRACK_NUM].m_s_var_name = "%AT"                     ;
   m_tb_col[ COL_AUDTAG_TRACK_NUM].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_TRACK_NB ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_AUDTAG_TRACK_NB ].m_i_width_def = 90                       ;
   m_tb_col[ COL_AUDTAG_TRACK_NB ].m_s_name = _( "At-Nb Tracks" )           ;
   m_tb_col[ COL_AUDTAG_TRACK_NB ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_TRACK_NB ].m_s_var_name = "%An"                     ;
   m_tb_col[ COL_AUDTAG_TRACK_NB ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_TRACK    ].m_i_width_def = 100                      ;
   m_tb_col[ COL_AUDTAG_TRACK    ].m_s_name = _( "At-Track" )               ;
   m_tb_col[ COL_AUDTAG_TRACK    ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_TRACK    ].m_s_var_name = "%Ak"                     ;
   m_tb_col[ COL_AUDTAG_TRACK    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_DISK     ].m_i_width_def = 100                      ;
   m_tb_col[ COL_AUDTAG_DISK     ].m_s_name = _( "At-Disk" )                ;
   m_tb_col[ COL_AUDTAG_DISK     ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_DISK     ].m_s_var_name = "%AD"                     ;
   m_tb_col[ COL_AUDTAG_DISK     ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_GENRE    ].m_i_width_def = 100                      ;
   m_tb_col[ COL_AUDTAG_GENRE    ].m_s_name = _( "At-Genre" )               ;
   m_tb_col[ COL_AUDTAG_GENRE    ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_GENRE    ].m_s_var_name = "%Ag"                     ;
   m_tb_col[ COL_AUDTAG_GENRE    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_COMPOS   ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_COMPOS   ].m_s_name = _( "At-Composer" )            ;
   m_tb_col[ COL_AUDTAG_COMPOS   ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_COMPOS   ].m_s_var_name = "%Ap"                     ;
   m_tb_col[ COL_AUDTAG_COMPOS   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_ORG_ART  ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_ORG_ART  ].m_s_name = _( "At-Original artist" )     ;
   m_tb_col[ COL_AUDTAG_ORG_ART  ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_ORG_ART  ].m_s_var_name = "%Ao"                     ;
   m_tb_col[ COL_AUDTAG_ORG_ART  ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_COPYRIGHT].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_COPYRIGHT].m_s_name = _( "At-Copyright" )           ;
   m_tb_col[ COL_AUDTAG_COPYRIGHT].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_COPYRIGHT].m_s_var_name = "%AC"                     ;
   m_tb_col[ COL_AUDTAG_COPYRIGHT].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_URL      ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_URL      ].m_s_name = _( "At-URL" )                 ;
   m_tb_col[ COL_AUDTAG_URL      ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_URL      ].m_s_var_name = "%Au"                     ;
   m_tb_col[ COL_AUDTAG_URL      ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_ENCOD_BY ].m_i_width_def = 150                      ;
   m_tb_col[ COL_AUDTAG_ENCOD_BY ].m_s_name = _( "At-Encoded by" )          ;
   m_tb_col[ COL_AUDTAG_ENCOD_BY ].m_grp    = GRP_AUDTAG                    ;
   m_tb_col[ COL_AUDTAG_ENCOD_BY ].m_s_var_name = "%Ae"                     ;
   m_tb_col[ COL_AUDTAG_ENCOD_BY ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_AUDTAG_IMG_FORMAT ].m_i_width_def = 90                     ;
   m_tb_col[ COL_AUDTAG_IMG_FORMAT ].m_s_name = _( "At-ImgFormat" )         ;
   m_tb_col[ COL_AUDTAG_IMG_FORMAT ].m_grp    = GRP_AUDTAG                  ;
   m_tb_col[ COL_AUDTAG_IMG_FORMAT ].m_s_var_name = "%AIf"                  ;
   m_tb_col[ COL_AUDTAG_IMG_FORMAT ].m_sort   = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_X         ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_VIDEO_X         ].m_i_width_def = 80                       ;
   m_tb_col[ COL_VIDEO_X         ].m_s_name = _( "Vid-Width" )              ;
   m_tb_col[ COL_VIDEO_X         ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_X         ].m_s_var_name = "%Vx"                     ;
   m_tb_col[ COL_VIDEO_X         ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_Y         ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_VIDEO_Y         ].m_i_width_def = 80                       ;
   m_tb_col[ COL_VIDEO_Y         ].m_s_name = _( "Vid-Height" )             ;
   m_tb_col[ COL_VIDEO_Y         ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_Y         ].m_s_var_name = "%Vy"                     ;
   m_tb_col[ COL_VIDEO_Y         ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_SAMPRATE  ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_VIDEO_SAMPRATE  ].m_i_width_def = 90                       ;
   m_tb_col[ COL_VIDEO_SAMPRATE  ].m_s_name = _( "Vid-Samprate" )           ;
   m_tb_col[ COL_VIDEO_SAMPRATE  ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_SAMPRATE  ].m_s_var_name = "%Vs"                     ;
   m_tb_col[ COL_VIDEO_SAMPRATE  ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_CHANNEL   ].m_i_width_def = 80                       ;
   m_tb_col[ COL_VIDEO_CHANNEL   ].m_s_name = _( "Vid-Mode" )               ;
   m_tb_col[ COL_VIDEO_CHANNEL   ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_CHANNEL   ].m_s_var_name = "%VM"                     ;
   m_tb_col[ COL_VIDEO_CHANNEL   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_DURATION  ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_VIDEO_DURATION  ].m_i_width_def = 80                       ;
   m_tb_col[ COL_VIDEO_DURATION  ].m_s_name = _( "Vid-Duration" )           ;
   m_tb_col[ COL_VIDEO_DURATION  ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_DURATION  ].m_s_var_name = "%Vd"                     ;
   m_tb_col[ COL_VIDEO_DURATION  ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_FPS       ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_VIDEO_FPS       ].m_i_width_def = 60                       ;
   m_tb_col[ COL_VIDEO_FPS       ].m_s_name = _( "Vid-FPS" )                ;
   m_tb_col[ COL_VIDEO_FPS       ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_FPS       ].m_s_var_name = "%Vf"                     ;
   m_tb_col[ COL_VIDEO_FPS       ].m_sort   = SORT_DOUBLE                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDEO_INFO      ].m_i_width_def = 150                      ;
   m_tb_col[ COL_VIDEO_INFO      ].m_s_name = _( "Vid-Info" )               ;
   m_tb_col[ COL_VIDEO_INFO      ].m_grp    = GRP_VIDEO                     ;
   m_tb_col[ COL_VIDEO_INFO      ].m_s_var_name = "%Vi"                     ;
   m_tb_col[ COL_VIDEO_INFO      ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_TITLE    ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_TITLE    ].m_s_name = _( "Vt-Title" )               ;
   m_tb_col[ COL_VIDTAG_TITLE    ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_TITLE    ].m_s_var_name = "%Vt"                     ;
   m_tb_col[ COL_VIDTAG_TITLE    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_SUBJECT  ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_SUBJECT  ].m_s_name = _( "Vt-Subject" )             ;
   m_tb_col[ COL_VIDTAG_SUBJECT  ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_SUBJECT  ].m_s_var_name = "%VU"                     ;
   m_tb_col[ COL_VIDTAG_SUBJECT  ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_ARTIST   ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_ARTIST   ].m_s_name = _( "Vt-Artist" )              ;
   m_tb_col[ COL_VIDTAG_ARTIST   ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_ARTIST   ].m_s_var_name = "%Va"                     ;
   m_tb_col[ COL_VIDTAG_ARTIST   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_COMMENT  ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_COMMENT  ].m_s_name = _( "Vt-Comment" )             ;
   m_tb_col[ COL_VIDTAG_COMMENT  ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_COMMENT  ].m_s_var_name = "%Vc"                     ;
   m_tb_col[ COL_VIDTAG_COMMENT  ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_KEYWORDS ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_KEYWORDS ].m_s_name = _( "Vt-Keywords" )            ;
   m_tb_col[ COL_VIDTAG_KEYWORDS ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_KEYWORDS ].m_s_var_name = "%Vk"                     ;
   m_tb_col[ COL_VIDTAG_KEYWORDS ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_ENGINEER ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_ENGINEER ].m_s_name = _( "Vt-Engineer" )            ;
   m_tb_col[ COL_VIDTAG_ENGINEER ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_ENGINEER ].m_s_var_name = "%VE"                     ;
   m_tb_col[ COL_VIDTAG_ENGINEER ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_TECHNICIAN ].m_i_width_def = 120                    ;
   m_tb_col[ COL_VIDTAG_TECHNICIAN ].m_s_name = _( "Vt-Technician" )        ;
   m_tb_col[ COL_VIDTAG_TECHNICIAN ].m_grp    = GRP_VIDTAG                  ;
   m_tb_col[ COL_VIDTAG_TECHNICIAN ].m_s_var_name = "%VT"                   ;
   m_tb_col[ COL_VIDTAG_TECHNICIAN ].m_sort   = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_GENRE    ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_GENRE    ].m_s_name = _( "Vt-Genre" )               ;
   m_tb_col[ COL_VIDTAG_GENRE    ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_GENRE    ].m_s_var_name = "%Vg"                     ;
   m_tb_col[ COL_VIDTAG_GENRE    ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_CRE_DATE ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_CRE_DATE ].m_s_name = _( "Vt-Creation" )            ;
   m_tb_col[ COL_VIDTAG_CRE_DATE ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_CRE_DATE ].m_s_var_name = "%Vn"                     ;
   m_tb_col[ COL_VIDTAG_CRE_DATE ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_SOURCE   ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_SOURCE   ].m_s_name = _( "Vt-Source" )              ;
   m_tb_col[ COL_VIDTAG_SOURCE   ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_SOURCE   ].m_s_var_name = "%VO"                     ;
   m_tb_col[ COL_VIDTAG_SOURCE   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_COPYRIGHT].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_COPYRIGHT].m_s_name = _( "Vt-Copyright" )           ;
   m_tb_col[ COL_VIDTAG_COPYRIGHT].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_COPYRIGHT].m_s_var_name = "%VC"                     ;
   m_tb_col[ COL_VIDTAG_COPYRIGHT].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_SOFTWARE ].m_i_width_def = 120                      ;
   m_tb_col[ COL_VIDTAG_SOFTWARE ].m_s_name = _( "Vt-Software" )            ;
   m_tb_col[ COL_VIDTAG_SOFTWARE ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_SOFTWARE ].m_s_var_name = "%VS"                     ;
   m_tb_col[ COL_VIDTAG_SOFTWARE ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_IMG_FORMAT ].m_i_width_def = 90                     ;
   m_tb_col[ COL_VIDTAG_IMG_FORMAT ].m_s_name = _( "Vt-ImgFormat" )         ;
   m_tb_col[ COL_VIDTAG_IMG_FORMAT ].m_grp    = GRP_VIDTAG                  ;
   m_tb_col[ COL_VIDTAG_IMG_FORMAT ].m_s_var_name = "%VIf"                  ;
   m_tb_col[ COL_VIDTAG_IMG_FORMAT ].m_sort   = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_DV_DATE  ].m_s_name = _( "Vt-DV Date" )             ;
   m_tb_col[ COL_VIDTAG_DV_DATE  ].m_grp    = GRP_VIDTAG                    ;
   m_tb_col[ COL_VIDTAG_DV_DATE  ].m_s_var_name = "%VDd"                    ;
   m_tb_col[ COL_VIDTAG_DV_DATE  ].m_sort   = SORT_DATETIME                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_VIDTAG_DV_TIMECODE ].m_i_width_def = 110                   ;
   m_tb_col[ COL_VIDTAG_DV_TIMECODE ].m_s_name = _( "Vt-DV TimeCode" )      ;
   m_tb_col[ COL_VIDTAG_DV_TIMECODE ].m_grp      = GRP_VIDTAG               ;
   m_tb_col[ COL_VIDTAG_DV_TIMECODE ].m_s_var_name = "%VDt"                 ;
   m_tb_col[ COL_VIDTAG_DV_TIMECODE ].m_sort     = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IMG_X           ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_IMG_X           ].m_i_width_def = 80                       ;
   m_tb_col[ COL_IMG_X           ].m_s_name = _( "Img-Width" )              ;
   m_tb_col[ COL_IMG_X           ].m_grp    = GRP_IMG                       ;
   m_tb_col[ COL_IMG_X           ].m_s_var_name = "%Ix"                     ;
   m_tb_col[ COL_IMG_X           ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IMG_Y           ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_IMG_Y           ].m_i_width_def = 85                       ;
   m_tb_col[ COL_IMG_Y           ].m_s_name = _( "Img-Height" )             ;
   m_tb_col[ COL_IMG_Y           ].m_grp    = GRP_IMG                       ;
   m_tb_col[ COL_IMG_Y           ].m_s_var_name = "%Iy"                     ;
   m_tb_col[ COL_IMG_Y           ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IMG_BPP         ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_IMG_BPP         ].m_i_width_def = 110                      ;
   m_tb_col[ COL_IMG_BPP         ].m_s_name = _( "Img-Bits per pixel" )     ;
   m_tb_col[ COL_IMG_BPP         ].m_grp    = GRP_IMG                       ;
   m_tb_col[ COL_IMG_BPP         ].m_s_var_name = "%Ib"                     ;
   m_tb_col[ COL_IMG_BPP         ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IMG_INFO        ].m_i_width_def = 120                      ;
   m_tb_col[ COL_IMG_INFO        ].m_s_name = _( "Img-Info" )               ;
   m_tb_col[ COL_IMG_INFO        ].m_grp    = GRP_IMG                       ;
   m_tb_col[ COL_IMG_INFO        ].m_s_var_name = "%Ii"                     ;
   m_tb_col[ COL_IMG_INFO        ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_IMAGEDESCRIPTION ].m_i_width_def = 150                ;
   m_tb_col[ COL_EXIF_IMAGEDESCRIPTION ].m_s_name
                                              = _( "Xif-ImageDescription" ) ;
   m_tb_col[ COL_EXIF_IMAGEDESCRIPTION ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_IMAGEDESCRIPTION ].m_s_var_name = "%Xde"              ;
   m_tb_col[ COL_EXIF_IMAGEDESCRIPTION ].m_sort   = SORT_STRING             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_MAKE       ].m_i_width_def = 150                      ;
   m_tb_col[ COL_EXIF_MAKE       ].m_s_name = _( "Xif-Make" )               ;
   m_tb_col[ COL_EXIF_MAKE       ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_MAKE       ].m_s_var_name = "%Xmk"                    ;
   m_tb_col[ COL_EXIF_MAKE       ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_MODEL      ].m_i_width_def = 150                      ;
   m_tb_col[ COL_EXIF_MODEL      ].m_s_name = _( "Xif-Model" )              ;
   m_tb_col[ COL_EXIF_MODEL      ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_MODEL      ].m_s_var_name = "%Xmo"                    ;
   m_tb_col[ COL_EXIF_MODEL      ].m_sort     = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_ORIENTATION].m_i_width_def = 100                      ;
   m_tb_col[ COL_EXIF_ORIENTATION].m_s_name = _( "Xif-Orientation" )        ;
   m_tb_col[ COL_EXIF_ORIENTATION].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_ORIENTATION].m_s_var_name = "%Xor"                    ;
   m_tb_col[ COL_EXIF_ORIENTATION].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_XRESOLUTION].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_EXIF_XRESOLUTION].m_i_width_def = 100                      ;
   m_tb_col[ COL_EXIF_XRESOLUTION].m_s_name = _( "Xif-XResolution" )        ;
   m_tb_col[ COL_EXIF_XRESOLUTION].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_XRESOLUTION].m_s_var_name = "%Xxr"                    ;
   m_tb_col[ COL_EXIF_XRESOLUTION].m_sort   = SORT_DOUBLE                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_YRESOLUTION].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_EXIF_YRESOLUTION].m_i_width_def = 100                      ;
   m_tb_col[ COL_EXIF_YRESOLUTION].m_s_name = _( "Xif-YResolution" )        ;
   m_tb_col[ COL_EXIF_YRESOLUTION].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_YRESOLUTION].m_s_var_name = "%Xyr"                    ;
   m_tb_col[ COL_EXIF_YRESOLUTION].m_sort   = SORT_DOUBLE                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_RESOLUTIONUNIT ].m_i_width_def = 110                  ;
   m_tb_col[ COL_EXIF_RESOLUTIONUNIT ].m_s_name = _( "Xif-ResolutionUnit" ) ;
   m_tb_col[ COL_EXIF_RESOLUTIONUNIT ].m_grp    = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_RESOLUTIONUNIT ].m_s_var_name = "%Xru"                ;
   m_tb_col[ COL_EXIF_RESOLUTIONUNIT ].m_sort   = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SOFTWARE   ].m_i_width_def = 150                      ;
   m_tb_col[ COL_EXIF_SOFTWARE   ].m_s_name = _( "Xif-Software" )           ;
   m_tb_col[ COL_EXIF_SOFTWARE   ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_SOFTWARE   ].m_s_var_name = "%Xso"                    ;
   m_tb_col[ COL_EXIF_SOFTWARE   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_ARTIST     ].m_i_width_def = 100                      ;
   m_tb_col[ COL_EXIF_ARTIST     ].m_s_name = _( "Xif-Artist" )             ;
   m_tb_col[ COL_EXIF_ARTIST     ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_ARTIST     ].m_s_var_name = "%Xar"                    ;
   m_tb_col[ COL_EXIF_ARTIST     ].m_sort     = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_DATETIME   ].m_s_name = _( "Xif-DateTime" )           ;
   m_tb_col[ COL_EXIF_DATETIME   ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_DATETIME   ].m_s_var_name = "%Xdt"                    ;
   m_tb_col[ COL_EXIF_DATETIME   ].m_sort   = SORT_DATETIME                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SUBSECTIME ].m_i_width_def = 120                      ;
   m_tb_col[ COL_EXIF_SUBSECTIME ].m_s_name = _( "Xif-SubsecTime" )         ;
   m_tb_col[ COL_EXIF_SUBSECTIME ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_SUBSECTIME ].m_s_var_name = "%XSt"                    ;
   m_tb_col[ COL_EXIF_SUBSECTIME ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_WHITEPOINT ].m_i_width_def = 120                      ;
   m_tb_col[ COL_EXIF_WHITEPOINT ].m_s_name = _( "Xif-WhitePoint" )         ;
   m_tb_col[ COL_EXIF_WHITEPOINT ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_WHITEPOINT ].m_s_var_name = "%Xwp"                    ;
   m_tb_col[ COL_EXIF_WHITEPOINT ].m_sort     = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_PRIMARYCHROMATICITIES ].m_i_width_def = 150           ;
   m_tb_col[ COL_EXIF_PRIMARYCHROMATICITIES ].m_s_name
                                         = _( "Xif-PrimaryChromaticities" ) ;
   m_tb_col[ COL_EXIF_PRIMARYCHROMATICITIES ].m_grp    = GRP_EXIF           ;
   m_tb_col[ COL_EXIF_PRIMARYCHROMATICITIES ].m_s_var_name = "%Xpc"         ;
   m_tb_col[ COL_EXIF_PRIMARYCHROMATICITIES ].m_sort   = SORT_STRING        ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_YCBCRCOEFFICIENTS ].m_i_width_def = 130               ;
   m_tb_col[ COL_EXIF_YCBCRCOEFFICIENTS ].m_s_name
                                             = _( "Xif-YCbCrCoefficients" ) ;
   m_tb_col[ COL_EXIF_YCBCRCOEFFICIENTS ].m_grp    = GRP_EXIF               ;
   m_tb_col[ COL_EXIF_YCBCRCOEFFICIENTS ].m_s_var_name = "%Xyc"             ;
   m_tb_col[ COL_EXIF_YCBCRCOEFFICIENTS ].m_sort   = SORT_STRING            ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_YCBCRPOSITIONING  ].m_i_width_def = 125               ;
   m_tb_col[ COL_EXIF_YCBCRPOSITIONING  ].m_s_name
                                              = _( "Xif-YCbCrPositioning" ) ;
   m_tb_col[ COL_EXIF_YCBCRPOSITIONING  ].m_grp    = GRP_EXIF               ;
   m_tb_col[ COL_EXIF_YCBCRPOSITIONING  ].m_s_var_name = "%Xyp"             ;
   m_tb_col[ COL_EXIF_YCBCRPOSITIONING  ].m_sort   = SORT_STRING            ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_REFERENCEBLACKWHITE ].m_i_width_def = 145             ;
   m_tb_col[ COL_EXIF_REFERENCEBLACKWHITE ].m_s_name
                                           = _( "Xif-ReferenceBlackWhite" ) ;
   m_tb_col[ COL_EXIF_REFERENCEBLACKWHITE ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_REFERENCEBLACKWHITE ].m_s_var_name = "%Xbw"           ;
   m_tb_col[ COL_EXIF_REFERENCEBLACKWHITE ].m_sort   = SORT_STRING          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_COPYRIGHT  ].m_i_width_def = 110                      ;
   m_tb_col[ COL_EXIF_COPYRIGHT  ].m_s_name = _( "Xif-Copyright" )          ;
   m_tb_col[ COL_EXIF_COPYRIGHT  ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_COPYRIGHT  ].m_s_var_name = "%Xcy"                    ;
   m_tb_col[ COL_EXIF_COPYRIGHT  ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXIFOFFSET ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_EXIF_EXIFOFFSET ].m_i_width_def =  80                      ;
   m_tb_col[ COL_EXIF_EXIFOFFSET ].m_s_name = _( "Xif-ExifOffset" )         ;
   m_tb_col[ COL_EXIF_EXIFOFFSET ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_EXIFOFFSET ].m_s_var_name = "%Xeo"                    ;
   m_tb_col[ COL_EXIF_EXIFOFFSET ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSOFFSET  ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_EXIF_GPSOFFSET  ].m_i_width_def =  90                      ;
   m_tb_col[ COL_EXIF_GPSOFFSET  ].m_s_name = _( "Xif-GPSOffset" )          ;
   m_tb_col[ COL_EXIF_GPSOFFSET  ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_GPSOFFSET  ].m_s_var_name = "%Xgo"                    ;
   m_tb_col[ COL_EXIF_GPSOFFSET  ].m_sort   = SORT_INTEGER                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_THUMBNAIL_OFFSET ].m_i_fmt  = wxLIST_FORMAT_RIGHT     ;
   m_tb_col[ COL_EXIF_THUMBNAIL_OFFSET ].m_i_width_def = 80                 ;
   m_tb_col[ COL_EXIF_THUMBNAIL_OFFSET ].m_s_name
                                               = _( "Xif-ThumbnailOffset" ) ;
   m_tb_col[ COL_EXIF_THUMBNAIL_OFFSET ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_THUMBNAIL_OFFSET ].m_s_var_name = "%Xto"              ;
   m_tb_col[ COL_EXIF_THUMBNAIL_OFFSET ].m_sort     = SORT_INTEGER          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_THUMBNAIL_SIZE ].m_i_fmt  = wxLIST_FORMAT_RIGHT       ;
   m_tb_col[ COL_EXIF_THUMBNAIL_SIZE ].m_i_width_def = 120                  ;
   m_tb_col[ COL_EXIF_THUMBNAIL_SIZE ].m_s_name = _( "Xif-ThumbnailSize" )  ;
   m_tb_col[ COL_EXIF_THUMBNAIL_SIZE ].m_grp    = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_THUMBNAIL_SIZE ].m_s_var_name = "%Xts"                ;
   m_tb_col[ COL_EXIF_THUMBNAIL_SIZE ].m_sort   = SORT_INTEGER              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXPOSURETIME ].m_i_width_def = 100                    ;
   m_tb_col[ COL_EXIF_EXPOSURETIME ].m_s_name = _( "Xif-ExposureTime" )     ;
   m_tb_col[ COL_EXIF_EXPOSURETIME ].m_grp    = GRP_EXIF                    ;
   m_tb_col[ COL_EXIF_EXPOSURETIME ].m_s_var_name = "%Xet"                  ;
   m_tb_col[ COL_EXIF_EXPOSURETIME ].m_sort   = SORT_DOUBLE                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FNUMBER    ].m_i_fmt  = wxLIST_FORMAT_RIGHT           ;
   m_tb_col[ COL_EXIF_FNUMBER    ].m_i_width_def =  80                      ;
   m_tb_col[ COL_EXIF_FNUMBER    ].m_s_name = _( "Xif-FNumber" )            ;
   m_tb_col[ COL_EXIF_FNUMBER    ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_FNUMBER    ].m_s_var_name = "%Xfn"                    ;
   m_tb_col[ COL_EXIF_FNUMBER    ].m_sort   = SORT_DOUBLE                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXPOSUREPROGRAM ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_EXPOSUREPROGRAM ].m_s_name = _( "Xif-ExposureProgram");
   m_tb_col[ COL_EXIF_EXPOSUREPROGRAM ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_EXPOSUREPROGRAM ].m_s_var_name = "%Xep"               ;
   m_tb_col[ COL_EXIF_EXPOSUREPROGRAM ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SPECTRALSENSITIVITY ].m_i_width_def = 80              ;
   m_tb_col[ COL_EXIF_SPECTRALSENSITIVITY ].m_s_name
                                           = _( "Xif-SpectralSensitivity" ) ;
   m_tb_col[ COL_EXIF_SPECTRALSENSITIVITY ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_SPECTRALSENSITIVITY ].m_s_var_name = "%Xsy"           ;
   m_tb_col[ COL_EXIF_SPECTRALSENSITIVITY ].m_sort   = SORT_STRING          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_ISOSPEEDRATINGS ].m_i_fmt  = wxLIST_FORMAT_RIGHT      ;
   m_tb_col[ COL_EXIF_ISOSPEEDRATINGS ].m_i_width_def = 120                 ;
   m_tb_col[ COL_EXIF_ISOSPEEDRATINGS ].m_s_name = _( "Xif-ISOSpeedRatings");
   m_tb_col[ COL_EXIF_ISOSPEEDRATINGS ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_ISOSPEEDRATINGS ].m_s_var_name = "%Xsr"               ;
   m_tb_col[ COL_EXIF_ISOSPEEDRATINGS ].m_sort   = SORT_INTEGER             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXIFVERSION ].m_i_width_def = 80                      ;
   m_tb_col[ COL_EXIF_EXIFVERSION ].m_s_name = _( "Xif-ExifVersion" )       ;
   m_tb_col[ COL_EXIF_EXIFVERSION ].m_grp    = GRP_EXIF                     ;
   m_tb_col[ COL_EXIF_EXIFVERSION ].m_s_var_name = "%Xve"                   ;
   m_tb_col[ COL_EXIF_EXIFVERSION ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_DATETIMEORIGINAL ].m_s_name
                                              = _( "Xif-DateTimeOriginal" ) ;
   m_tb_col[ COL_EXIF_DATETIMEORIGINAL ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_DATETIMEORIGINAL ].m_s_var_name = "%Xdo"              ;
   m_tb_col[ COL_EXIF_DATETIMEORIGINAL ].m_sort   = SORT_DATETIME           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SUBSECTIMEORIGINAL ].m_i_width_def = 40               ;
   m_tb_col[ COL_EXIF_SUBSECTIMEORIGINAL ].m_s_name
                                            = _( "Xif-SubsecTimeOriginal" ) ;
   m_tb_col[ COL_EXIF_SUBSECTIMEORIGINAL ].m_grp    = GRP_EXIF              ;
   m_tb_col[ COL_EXIF_SUBSECTIMEORIGINAL ].m_s_var_name = "%XSo"            ;
   m_tb_col[ COL_EXIF_SUBSECTIMEORIGINAL ].m_sort   = SORT_STRING           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_DATETIMEDIGITIZED ].m_s_name
                                             = _( "Xif-DateTimeDigitized" ) ;
   m_tb_col[ COL_EXIF_DATETIMEDIGITIZED ].m_grp    = GRP_EXIF               ;
   m_tb_col[ COL_EXIF_DATETIMEDIGITIZED ].m_s_var_name = "%Xdd"             ;
   m_tb_col[ COL_EXIF_DATETIMEDIGITIZED ].m_sort = SORT_DATETIME            ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SUBSECTIMEDIGITIZED ].m_i_width_def = 40              ;
   m_tb_col[ COL_EXIF_SUBSECTIMEDIGITIZED ].m_s_name
                                           = _( "Xif-SubsecTimeDigitized" ) ;
   m_tb_col[ COL_EXIF_SUBSECTIMEDIGITIZED ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_SUBSECTIMEDIGITIZED ].m_s_var_name = "%XSd"           ;
   m_tb_col[ COL_EXIF_SUBSECTIMEDIGITIZED ].m_sort   = SORT_STRING          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_COMPONENTCONFIGURATION ].m_i_width_def = 80           ;
   m_tb_col[ COL_EXIF_COMPONENTCONFIGURATION ].m_s_name
                                        = _( "Xif-ComponentConfiguration" ) ;
   m_tb_col[ COL_EXIF_COMPONENTCONFIGURATION ].m_grp    = GRP_EXIF          ;
   m_tb_col[ COL_EXIF_COMPONENTCONFIGURATION ].m_s_var_name = "%Xcc"        ;
   m_tb_col[ COL_EXIF_COMPONENTCONFIGURATION ].m_sort   = SORT_STRING       ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_COMPRESSEDBITSPERPIXEL ].m_i_fmt = wxLIST_FORMAT_RIGHT;
   m_tb_col[ COL_EXIF_COMPRESSEDBITSPERPIXEL ].m_i_width_def = 80           ;
   m_tb_col[ COL_EXIF_COMPRESSEDBITSPERPIXEL ].m_s_name
                                        = _( "Xif-CompressedBitsPerPixel" ) ;
   m_tb_col[ COL_EXIF_COMPRESSEDBITSPERPIXEL ].m_grp    = GRP_EXIF          ;
   m_tb_col[ COL_EXIF_COMPRESSEDBITSPERPIXEL ].m_s_var_name = "%Xbp"        ;
   m_tb_col[ COL_EXIF_COMPRESSEDBITSPERPIXEL ].m_sort   = SORT_DOUBLE       ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SHUTTERSPEEDVALUE ].m_i_width_def = 80                ;
   m_tb_col[ COL_EXIF_SHUTTERSPEEDVALUE ].m_s_name
                                             = _( "Xif-ShutterSpeedValue" ) ;
   m_tb_col[ COL_EXIF_SHUTTERSPEEDVALUE ].m_grp    = GRP_EXIF               ;
   m_tb_col[ COL_EXIF_SHUTTERSPEEDVALUE ].m_s_var_name = "%Xss"             ;
   m_tb_col[ COL_EXIF_SHUTTERSPEEDVALUE ].m_sort    = SORT_DOUBLE           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_APERTUREVALUE ].m_i_fmt  = wxLIST_FORMAT_RIGHT        ;
   m_tb_col[ COL_EXIF_APERTUREVALUE ].m_i_width_def = 80                    ;
   m_tb_col[ COL_EXIF_APERTUREVALUE ].m_s_name = _( "Xif-ApertureValue" )   ;
   m_tb_col[ COL_EXIF_APERTUREVALUE ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_APERTUREVALUE ].m_s_var_name = "%Xav"                 ;
   m_tb_col[ COL_EXIF_APERTUREVALUE ].m_sort   = SORT_DOUBLE                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_BRIGHTNESSVALUE ].m_i_fmt  = wxLIST_FORMAT_RIGHT      ;
   m_tb_col[ COL_EXIF_BRIGHTNESSVALUE ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_BRIGHTNESSVALUE ].m_s_name
                                               = _( "Xif-BrightnessValue" ) ;
   m_tb_col[ COL_EXIF_BRIGHTNESSVALUE ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_BRIGHTNESSVALUE ].m_s_var_name = "%Xbv"               ;
   m_tb_col[ COL_EXIF_BRIGHTNESSVALUE ].m_sort   = SORT_DOUBLE              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXPOSUREBIASVALUE ].m_i_fmt  = wxLIST_FORMAT_RIGHT    ;
   m_tb_col[ COL_EXIF_EXPOSUREBIASVALUE ].m_i_width_def = 80                ;
   m_tb_col[ COL_EXIF_EXPOSUREBIASVALUE ].m_s_name
                                             = _( "Xif-ExposureBiasValue" ) ;
   m_tb_col[ COL_EXIF_EXPOSUREBIASVALUE ].m_grp    = GRP_EXIF               ;
   m_tb_col[ COL_EXIF_EXPOSUREBIASVALUE ].m_s_var_name = "%Xev"             ;
   m_tb_col[ COL_EXIF_EXPOSUREBIASVALUE ].m_sort   = SORT_DOUBLE            ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_MAXAPERTUREVALUE ].m_i_fmt  = wxLIST_FORMAT_RIGHT     ;
   m_tb_col[ COL_EXIF_MAXAPERTUREVALUE ].m_i_width_def = 80                 ;
   m_tb_col[ COL_EXIF_MAXAPERTUREVALUE ].m_s_name
                                              = _( "Xif-MaxApertureValue" ) ;
   m_tb_col[ COL_EXIF_MAXAPERTUREVALUE ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_MAXAPERTUREVALUE ].m_s_var_name = "%Xma"              ;
   m_tb_col[ COL_EXIF_MAXAPERTUREVALUE ].m_sort   = SORT_DOUBLE             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SUBJECTDISTANCE ].m_i_fmt  = wxLIST_FORMAT_RIGHT      ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCE ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCE ].m_s_name = _( "Xif-SubjectDistance");
   m_tb_col[ COL_EXIF_SUBJECTDISTANCE ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCE ].m_s_var_name = "%Xsd"               ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCE ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_METERINGMODE ].m_i_width_def = 80                     ;
   m_tb_col[ COL_EXIF_METERINGMODE ].m_s_name = _( "Xif-MeteringMode" )     ;
   m_tb_col[ COL_EXIF_METERINGMODE ].m_grp    = GRP_EXIF                    ;
   m_tb_col[ COL_EXIF_METERINGMODE ].m_s_var_name = "%Xmm"                  ;
   m_tb_col[ COL_EXIF_METERINGMODE ].m_sort    = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_LIGHTSOURCE ].m_i_width_def = 80                      ;
   m_tb_col[ COL_EXIF_LIGHTSOURCE ].m_s_name = _( "Xif-LightSource" )       ;
   m_tb_col[ COL_EXIF_LIGHTSOURCE ].m_grp    = GRP_EXIF                     ;
   m_tb_col[ COL_EXIF_LIGHTSOURCE ].m_s_var_name = "%Xls"                   ;
   m_tb_col[ COL_EXIF_LIGHTSOURCE ].m_sort    = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FLASH      ].m_i_width_def = 80                       ;
   m_tb_col[ COL_EXIF_FLASH      ].m_s_name = _( "Xif-Flash" )              ;
   m_tb_col[ COL_EXIF_FLASH      ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_FLASH      ].m_s_var_name = "%Xfa"                    ;
   m_tb_col[ COL_EXIF_FLASH      ].m_sort    = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FOCALLENGTH ].m_i_fmt  = wxLIST_FORMAT_RIGHT          ;
   m_tb_col[ COL_EXIF_FOCALLENGTH ].m_i_width_def = 80                      ;
   m_tb_col[ COL_EXIF_FOCALLENGTH ].m_s_name = _( "Xif-FocalLength" )       ;
   m_tb_col[ COL_EXIF_FOCALLENGTH ].m_grp    = GRP_EXIF                     ;
   m_tb_col[ COL_EXIF_FOCALLENGTH ].m_s_var_name = "%Xfl"                   ;
   m_tb_col[ COL_EXIF_FOCALLENGTH ].m_sort    = SORT_DOUBLE                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FLASHENERGY ].m_i_fmt      = wxLIST_FORMAT_RIGHT      ;
   m_tb_col[ COL_EXIF_FLASHENERGY ].m_i_width_def = 80                      ;
   m_tb_col[ COL_EXIF_FLASHENERGY ].m_s_name = _( "Xif-FlashEnergy" )       ;
   m_tb_col[ COL_EXIF_FLASHENERGY ].m_grp        = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_FLASHENERGY ].m_s_var_name = "%Xfe"                   ;
   m_tb_col[ COL_EXIF_FLASHENERGY ].m_sort       = SORT_DOUBLE              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_USERCOMMENT ].m_i_width_def = 120                     ;
   m_tb_col[ COL_EXIF_USERCOMMENT ].m_s_name = _( "Xif-UserComment" )       ;
   m_tb_col[ COL_EXIF_USERCOMMENT ].m_grp    = GRP_EXIF                     ;
   m_tb_col[ COL_EXIF_USERCOMMENT ].m_s_var_name = "%Xuc"                   ;
   m_tb_col[ COL_EXIF_USERCOMMENT ].m_sort    = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FLASHPIXVERSION ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_FLASHPIXVERSION ].m_s_name = _( "Xif-FlashPixVersion");
   m_tb_col[ COL_EXIF_FLASHPIXVERSION ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_FLASHPIXVERSION ].m_s_var_name = "%Xfv"               ;
   m_tb_col[ COL_EXIF_FLASHPIXVERSION ].m_sort    = SORT_STRING             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_COLORSPACE ].m_i_width_def = 80                       ;
   m_tb_col[ COL_EXIF_COLORSPACE ].m_s_name = _( "Xif-ColorSpace" )         ;
   m_tb_col[ COL_EXIF_COLORSPACE ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_COLORSPACE ].m_s_var_name = "%Xcs"                    ;
   m_tb_col[ COL_EXIF_COLORSPACE ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXIFIMAGEWIDTH ].m_i_fmt  = wxLIST_FORMAT_RIGHT       ;
   m_tb_col[ COL_EXIF_EXIFIMAGEWIDTH ].m_i_width_def = 80                   ;
   m_tb_col[ COL_EXIF_EXIFIMAGEWIDTH ].m_s_name = _( "Xif-ExifImageWidth" ) ;
   m_tb_col[ COL_EXIF_EXIFIMAGEWIDTH ].m_grp    = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_EXIFIMAGEWIDTH ].m_s_var_name = "%Xiw"                ;
   m_tb_col[ COL_EXIF_EXIFIMAGEWIDTH ].m_sort   = SORT_INTEGER              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXIFIMAGEHEIGHT ].m_i_fmt  = wxLIST_FORMAT_RIGHT      ;
   m_tb_col[ COL_EXIF_EXIFIMAGEHEIGHT ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_EXIFIMAGEHEIGHT ].m_s_name = _( "Xif-ExifImageHeight");
   m_tb_col[ COL_EXIF_EXIFIMAGEHEIGHT ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_EXIFIMAGEHEIGHT ].m_s_var_name = "%Xih"               ;
   m_tb_col[ COL_EXIF_EXIFIMAGEHEIGHT ].m_sort   = SORT_INTEGER             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_RELATEDSOUNDFILE ].m_i_width_def = 80                 ;
   m_tb_col[ COL_EXIF_RELATEDSOUNDFILE ].m_s_name
                                              = _( "Xif-RelatedSoundFile" ) ;
   m_tb_col[ COL_EXIF_RELATEDSOUNDFILE ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_RELATEDSOUNDFILE ].m_s_var_name = "%Xsf"              ;
   m_tb_col[ COL_EXIF_RELATEDSOUNDFILE ].m_sort   = SORT_STRING             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FOCALPLANEXRESOLUTION ].m_i_fmt  = wxLIST_FORMAT_RIGHT;
   m_tb_col[ COL_EXIF_FOCALPLANEXRESOLUTION ].m_i_width_def = 80            ;
   m_tb_col[ COL_EXIF_FOCALPLANEXRESOLUTION ].m_s_name
                                         = _( "Xif-FocalPlaneXResolution" ) ;
   m_tb_col[ COL_EXIF_FOCALPLANEXRESOLUTION ].m_grp    = GRP_EXIF           ;
   m_tb_col[ COL_EXIF_FOCALPLANEXRESOLUTION ].m_s_var_name = "%Xfx"         ;
   m_tb_col[ COL_EXIF_FOCALPLANEXRESOLUTION ].m_sort   = SORT_DOUBLE        ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FOCALPLANEYRESOLUTION ].m_i_fmt = wxLIST_FORMAT_RIGHT ;
   m_tb_col[ COL_EXIF_FOCALPLANEYRESOLUTION ].m_i_width_def = 80            ;
   m_tb_col[ COL_EXIF_FOCALPLANEYRESOLUTION ].m_s_name
                                         = _( "Xif-FocalPlaneYResolution" ) ;
   m_tb_col[ COL_EXIF_FOCALPLANEYRESOLUTION ].m_grp    = GRP_EXIF           ;
   m_tb_col[ COL_EXIF_FOCALPLANEYRESOLUTION ].m_s_var_name = "%Xfy"         ;
   m_tb_col[ COL_EXIF_FOCALPLANEYRESOLUTION ].m_sort  = SORT_DOUBLE         ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FOCALPLANERESOLUTIONUNIT ].m_i_width_def = 80         ;
   m_tb_col[ COL_EXIF_FOCALPLANERESOLUTIONUNIT ].m_s_name
                                      = _( "Xif-FocalPlaneResolutionUnit" ) ;
   m_tb_col[ COL_EXIF_FOCALPLANERESOLUTIONUNIT ].m_grp    = GRP_EXIF        ;
   m_tb_col[ COL_EXIF_FOCALPLANERESOLUTIONUNIT ].m_s_var_name = "%Xfu"      ;
   m_tb_col[ COL_EXIF_FOCALPLANERESOLUTIONUNIT ].m_sort = SORT_STRING       ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXPOSUREINDEX ].m_i_fmt  = wxLIST_FORMAT_RIGHT        ;
   m_tb_col[ COL_EXIF_EXPOSUREINDEX ].m_i_width_def = 80                    ;
   m_tb_col[ COL_EXIF_EXPOSUREINDEX ].m_s_name = _( "Xif-ExposureIndex" )   ;
   m_tb_col[ COL_EXIF_EXPOSUREINDEX ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_EXPOSUREINDEX ].m_s_var_name = "%Xei"                 ;
   m_tb_col[ COL_EXIF_EXPOSUREINDEX ].m_sort   = SORT_DOUBLE                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SENSINGMETHOD ].m_i_width_def = 80                    ;
   m_tb_col[ COL_EXIF_SENSINGMETHOD ].m_s_name = _( "Xif-SensingMethod" )   ;
   m_tb_col[ COL_EXIF_SENSINGMETHOD ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_SENSINGMETHOD ].m_s_var_name = "%Xsm"                 ;
   m_tb_col[ COL_EXIF_SENSINGMETHOD ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FILESOURCE    ].m_i_width_def = 80                    ;
   m_tb_col[ COL_EXIF_FILESOURCE    ].m_s_name = _( "Xif-FileSource" )      ;
   m_tb_col[ COL_EXIF_FILESOURCE    ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_FILESOURCE    ].m_s_var_name = "%Xfs"                 ;
   m_tb_col[ COL_EXIF_FILESOURCE    ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SCENETYPE     ].m_i_width_def = 80                    ;
   m_tb_col[ COL_EXIF_SCENETYPE     ].m_s_name = _( "Xif-SceneType" )       ;
   m_tb_col[ COL_EXIF_SCENETYPE     ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_SCENETYPE     ].m_s_var_name = "%Xst"                 ;
   m_tb_col[ COL_EXIF_SCENETYPE     ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_CUSTOMRENDERED ].m_i_width_def = 80                   ;
   m_tb_col[ COL_EXIF_CUSTOMRENDERED ].m_s_name = _( "Xif-CustomRendered" ) ;
   m_tb_col[ COL_EXIF_CUSTOMRENDERED ].m_grp    = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_CUSTOMRENDERED ].m_s_var_name = "%Xcr"                ;
   m_tb_col[ COL_EXIF_CUSTOMRENDERED ].m_sort   = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_EXPOSUREMODE ].m_i_width_def = 80                     ;
   m_tb_col[ COL_EXIF_EXPOSUREMODE ].m_s_name   = _( "Xif-ExposureMode" )   ;
   m_tb_col[ COL_EXIF_EXPOSUREMODE ].m_grp      = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_EXPOSUREMODE ].m_s_var_name = "%Xem"                  ;
   m_tb_col[ COL_EXIF_EXPOSUREMODE ].m_sort     = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_WHITEBALANCE ].m_i_width_def = 80                     ;
   m_tb_col[ COL_EXIF_WHITEBALANCE ].m_s_name   = _( "Xif-WhiteBalance" )   ;
   m_tb_col[ COL_EXIF_WHITEBALANCE ].m_grp      = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_WHITEBALANCE ].m_s_var_name = "%Xwb"                  ;
   m_tb_col[ COL_EXIF_WHITEBALANCE ].m_sort     = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_DIGITALZOOMRATIO ].m_i_fmt  = wxLIST_FORMAT_RIGHT     ;
   m_tb_col[ COL_EXIF_DIGITALZOOMRATIO ].m_i_width_def = 80                 ;
   m_tb_col[ COL_EXIF_DIGITALZOOMRATIO ].m_s_name
                                              = _( "Xif-DigitalZoomRatio" ) ;
   m_tb_col[ COL_EXIF_DIGITALZOOMRATIO ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_DIGITALZOOMRATIO ].m_s_var_name = "%Xdz"              ;
   m_tb_col[ COL_EXIF_DIGITALZOOMRATIO ].m_sort   = SORT_DOUBLE             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_FOCALLENGTHIN35MMFILM ].m_i_fmt = wxLIST_FORMAT_RIGHT ;
   m_tb_col[ COL_EXIF_FOCALLENGTHIN35MMFILM ].m_i_width_def = 80            ;
   m_tb_col[ COL_EXIF_FOCALLENGTHIN35MMFILM ].m_s_name
                                         = _( "Xif-FocalLengthIn35mmFilm" ) ;
   m_tb_col[ COL_EXIF_FOCALLENGTHIN35MMFILM ].m_grp   = GRP_EXIF            ;
   m_tb_col[ COL_EXIF_FOCALLENGTHIN35MMFILM ].m_s_var_name = "%XfL"         ;
   m_tb_col[ COL_EXIF_FOCALLENGTHIN35MMFILM ].m_sort = SORT_INTEGER         ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SCENECAPTURETYPE ].m_i_width_def = 80                 ;
   m_tb_col[ COL_EXIF_SCENECAPTURETYPE ].m_s_name
                                              = _( "Xif-SceneCaptureType" ) ;
   m_tb_col[ COL_EXIF_SCENECAPTURETYPE ].m_grp    = GRP_EXIF                ;
   m_tb_col[ COL_EXIF_SCENECAPTURETYPE ].m_s_var_name = "%Xsc"              ;
   m_tb_col[ COL_EXIF_SCENECAPTURETYPE ].m_sort   = SORT_STRING             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GAINCONTROL ].m_i_width_def = 80                      ;
   m_tb_col[ COL_EXIF_GAINCONTROL ].m_s_name = _( "Xif-GainControl" )       ;
   m_tb_col[ COL_EXIF_GAINCONTROL ].m_grp    = GRP_EXIF                     ;
   m_tb_col[ COL_EXIF_GAINCONTROL ].m_s_var_name = "%Xgc"                   ;
   m_tb_col[ COL_EXIF_GAINCONTROL ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_CONTRAST   ].m_i_width_def = 80                       ;
   m_tb_col[ COL_EXIF_CONTRAST   ].m_s_name = _( "Xif-Contrast" )           ;
   m_tb_col[ COL_EXIF_CONTRAST   ].m_grp    = GRP_EXIF                      ;
   m_tb_col[ COL_EXIF_CONTRAST   ].m_s_var_name = "%Xct"                    ;
   m_tb_col[ COL_EXIF_CONTRAST   ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SATURATION ].m_i_width_def = 80                       ;
   m_tb_col[ COL_EXIF_SATURATION ].m_s_name = _( "Xif-Saturation" )         ;
   m_tb_col[ COL_EXIF_SATURATION ].m_grp        = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_SATURATION ].m_s_var_name = "%Xsu"                    ;
   m_tb_col[ COL_EXIF_SATURATION ].m_sort       = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SHARPNESS  ].m_i_width_def = 80                       ;
   m_tb_col[ COL_EXIF_SHARPNESS  ].m_s_name = _( "Xif-Sharpness" )          ;
   m_tb_col[ COL_EXIF_SHARPNESS  ].m_grp        = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_SHARPNESS  ].m_s_var_name = "%Xsh"                    ;
   m_tb_col[ COL_EXIF_SHARPNESS  ].m_sort       = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_SUBJECTDISTANCERANGE ].m_i_width_def = 80             ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCERANGE ].m_s_name
                                          = _( "Xif-SubjectDistanceRange" ) ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCERANGE ].m_grp    = GRP_EXIF            ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCERANGE ].m_s_var_name = "%XsD"          ;
   m_tb_col[ COL_EXIF_SUBJECTDISTANCERANGE ].m_sort   = SORT_STRING         ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_IMAGEUNIQUEID ].m_i_width_def = 120                   ;
   m_tb_col[ COL_EXIF_IMAGEUNIQUEID ].m_s_name = _( "Xif-ImageUniqueID" )   ;
   m_tb_col[ COL_EXIF_IMAGEUNIQUEID ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_IMAGEUNIQUEID ].m_s_var_name = "%Xui"                 ;
   m_tb_col[ COL_EXIF_IMAGEUNIQUEID ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSVERSIONID  ].m_i_width_def = 80                    ;
   m_tb_col[ COL_EXIF_GPSVERSIONID  ].m_s_name = _( "Xif-GPSVersionID" )    ;
   m_tb_col[ COL_EXIF_GPSVERSIONID  ].m_grp    = GRP_EXIF                   ;
   m_tb_col[ COL_EXIF_GPSVERSIONID  ].m_s_var_name = "%Xgv"                 ;
   m_tb_col[ COL_EXIF_GPSVERSIONID  ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSLATITUDEREF  ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSLATITUDEREF  ].m_s_name = _( "Xif-GPSLatitudeRef" );
   m_tb_col[ COL_EXIF_GPSLATITUDEREF  ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSLATITUDEREF  ].m_s_var_name = "%XlA"               ;
   m_tb_col[ COL_EXIF_GPSLATITUDEREF  ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSLATITUDE     ].m_i_width_def = 120                 ;
   m_tb_col[ COL_EXIF_GPSLATITUDE     ].m_s_name = _( "Xif-GPSLatitude" )   ;
   m_tb_col[ COL_EXIF_GPSLATITUDE     ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSLATITUDE     ].m_s_var_name = "%Xla"               ;
   m_tb_col[ COL_EXIF_GPSLATITUDE     ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSLONGITUDEREF ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSLONGITUDEREF ].m_s_name = _( "Xif-GPSLongitudeRef");
   m_tb_col[ COL_EXIF_GPSLONGITUDEREF ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSLONGITUDEREF ].m_s_var_name = "%XlO"               ;
   m_tb_col[ COL_EXIF_GPSLONGITUDEREF ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSLONGITUDE    ].m_i_width_def = 120                 ;
   m_tb_col[ COL_EXIF_GPSLONGITUDE    ].m_s_name = _( "Xif-GPSLongitude" )  ;
   m_tb_col[ COL_EXIF_GPSLONGITUDE    ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSLONGITUDE    ].m_s_var_name = "%Xlo"               ;
   m_tb_col[ COL_EXIF_GPSLONGITUDE    ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSALTITUDEREF  ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSALTITUDEREF  ].m_s_name = _( "Xif-GPSAltitudeRef" );
   m_tb_col[ COL_EXIF_GPSALTITUDEREF  ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSALTITUDEREF  ].m_s_var_name = "%XaL"               ;
   m_tb_col[ COL_EXIF_GPSALTITUDEREF  ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSALTITUDE     ].m_i_width_def = 120                 ;
   m_tb_col[ COL_EXIF_GPSALTITUDE     ].m_s_name = _( "Xif-GPSAltitude" )   ;
   m_tb_col[ COL_EXIF_GPSALTITUDE     ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSALTITUDE     ].m_s_var_name = "%Xal"               ;
   m_tb_col[ COL_EXIF_GPSALTITUDE     ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSTIMESTAMP    ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSTIMESTAMP    ].m_s_name = _( "Xif-GPSTimeStamp" )  ;
   m_tb_col[ COL_EXIF_GPSTIMESTAMP    ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSTIMESTAMP    ].m_s_var_name = "%XTS"               ;
   m_tb_col[ COL_EXIF_GPSTIMESTAMP    ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSSATELLITES   ].m_i_width_def = 100                 ;
   m_tb_col[ COL_EXIF_GPSSATELLITES   ].m_s_name = _( "Xif-GPSSatellites" ) ;
   m_tb_col[ COL_EXIF_GPSSATELLITES   ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSSATELLITES   ].m_s_var_name = "%Xsa"               ;
   m_tb_col[ COL_EXIF_GPSSATELLITES   ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSSTATUS       ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSSTATUS       ].m_s_name = _( "Xif-GPSStatus" )     ;
   m_tb_col[ COL_EXIF_GPSSTATUS       ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSSTATUS       ].m_s_var_name = "%Xus"               ;
   m_tb_col[ COL_EXIF_GPSSTATUS       ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSMEASUREMODE  ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSMEASUREMODE  ].m_s_name = _( "Xif-GPSMeasureMode" );
   m_tb_col[ COL_EXIF_GPSMEASUREMODE  ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSMEASUREMODE  ].m_s_var_name = "%XmM"               ;
   m_tb_col[ COL_EXIF_GPSMEASUREMODE  ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDOP          ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSDOP          ].m_s_name = _( "Xif-GPSDOP" )        ;
   m_tb_col[ COL_EXIF_GPSDOP          ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSDOP          ].m_s_var_name = "%Xdp"               ;
   m_tb_col[ COL_EXIF_GPSDOP          ].m_sort   = SORT_DOUBLE              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSSPEEDREF     ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSSPEEDREF     ].m_s_name = _( "Xif-GPSSpeedRef" )   ;
   m_tb_col[ COL_EXIF_GPSSPEEDREF     ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSSPEEDREF     ].m_s_var_name = "%XsP"               ;
   m_tb_col[ COL_EXIF_GPSSPEEDREF     ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSSPEED        ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSSPEED        ].m_s_name = _( "Xif-GPSSpeed" )      ;
   m_tb_col[ COL_EXIF_GPSSPEED        ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSSPEED        ].m_s_var_name = "%Xsp"               ;
   m_tb_col[ COL_EXIF_GPSSPEED        ].m_sort   = SORT_DOUBLE              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSTRACKREF     ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSTRACKREF     ].m_s_name = _( "Xif-GPSTrackRef" )   ;
   m_tb_col[ COL_EXIF_GPSTRACKREF     ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSTRACKREF     ].m_s_var_name = "%XtR"               ;
   m_tb_col[ COL_EXIF_GPSTRACKREF     ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSTRACK        ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSTRACK        ].m_s_name = _( "Xif-GPSTrack" )      ;
   m_tb_col[ COL_EXIF_GPSTRACK        ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSTRACK        ].m_s_var_name = "%Xtr"               ;
   m_tb_col[ COL_EXIF_GPSTRACK        ].m_sort   = SORT_DOUBLE              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSIMGDIRECTIONREF ].m_i_width_def = 80               ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTIONREF ].m_s_name
                                            = _( "Xif-GPSImgDirectionRef" ) ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTIONREF ].m_grp    = GRP_EXIF              ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTIONREF ].m_s_var_name = "%XiD"            ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTIONREF ].m_sort   = SORT_STRING           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSIMGDIRECTION ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTION ].m_s_name = _( "Xif-GPSImgDirection");
   m_tb_col[ COL_EXIF_GPSIMGDIRECTION ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTION ].m_s_var_name = "%Xid"               ;
   m_tb_col[ COL_EXIF_GPSIMGDIRECTION ].m_sort   = SORT_DOUBLE              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSMAPDATUM     ].m_i_width_def = 80                  ;
   m_tb_col[ COL_EXIF_GPSMAPDATUM     ].m_s_name = _( "Xif-GPSMapDatum" )   ;
   m_tb_col[ COL_EXIF_GPSMAPDATUM     ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSMAPDATUM     ].m_s_var_name = "%Xmd"               ;
   m_tb_col[ COL_EXIF_GPSMAPDATUM     ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTLATITUDEREF ].m_i_width_def = 80               ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDEREF ].m_s_name
                                            = _( "Xif-GPSDestLatitudeRef" ) ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDEREF ].m_grp    = GRP_EXIF              ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDEREF ].m_s_var_name = "%XLA"            ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDEREF ].m_sort  = SORT_STRING            ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTLATITUDE ].m_i_width_def = 120                 ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDE ].m_s_name = _( "Xif-GPSDestLatitude");
   m_tb_col[ COL_EXIF_GPSDESTLATITUDE ].m_grp    = GRP_EXIF                 ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDE ].m_s_var_name = "%XLa"               ;
   m_tb_col[ COL_EXIF_GPSDESTLATITUDE ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDEREF ].m_i_width_def = 80              ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDEREF ].m_s_name
                                           = _( "Xif-GPSDestLongitudeRef" ) ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDEREF ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDEREF ].m_s_var_name = "%XLO"           ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDEREF ].m_sort   = SORT_STRING          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDE    ].m_i_width_def = 120             ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDE    ].m_s_name
                                              = _( "Xif-GPSDestLongitude" ) ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDE    ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDE    ].m_s_var_name = "%XLo"           ;
   m_tb_col[ COL_EXIF_GPSDESTLONGITUDE    ].m_sort  = SORT_STRING           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTBEARINGREF   ].m_i_width_def = 80              ;
   m_tb_col[ COL_EXIF_GPSDESTBEARINGREF   ].m_s_name
                                             = _( "Xif-GPSDestBearingRef" ) ;
   m_tb_col[ COL_EXIF_GPSDESTBEARINGREF   ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_GPSDESTBEARINGREF   ].m_s_var_name = "%XbE"           ;
   m_tb_col[ COL_EXIF_GPSDESTBEARINGREF   ].m_sort   = SORT_STRING          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTBEARING ].m_i_width_def = 120                  ;
   m_tb_col[ COL_EXIF_GPSDESTBEARING ].m_s_name = _( "Xif-GPSDestBearing" ) ;
   m_tb_col[ COL_EXIF_GPSDESTBEARING ].m_grp    = GRP_EXIF                  ;
   m_tb_col[ COL_EXIF_GPSDESTBEARING ].m_s_var_name = "%Xbe"                ;
   m_tb_col[ COL_EXIF_GPSDESTBEARING ].m_sort   = SORT_DOUBLE               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTDISTANCEREF  ].m_i_width_def = 80              ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCEREF  ].m_s_name
                                            = _( "Xif-GPSDestDistanceRef" ) ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCEREF  ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCEREF  ].m_s_var_name = "%XDR"           ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCEREF  ].m_sort  = SORT_STRING           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_EXIF_GPSDESTDISTANCE     ].m_i_width_def = 80              ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCE     ].m_s_name
                                               = _( "Xif-GPSDestDistance" ) ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCE     ].m_grp    = GRP_EXIF             ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCE     ].m_s_var_name = "%XDr"           ;
   m_tb_col[ COL_EXIF_GPSDESTDISTANCE     ].m_sort  = SORT_DOUBLE           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_BYLINE     ].m_i_width_def = 100                      ;
   m_tb_col[ COL_IPTC_BYLINE     ].m_s_name = _( "Ip-ByLine" )              ;
   m_tb_col[ COL_IPTC_BYLINE     ].m_grp    = GRP_IPTC                      ;
   m_tb_col[ COL_IPTC_BYLINE     ].m_s_var_name = "%Ybl"                    ;
   m_tb_col[ COL_IPTC_BYLINE     ].m_sort   = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_BYLINE_TITLE ].m_i_width_def = 100                    ;
   m_tb_col[ COL_IPTC_BYLINE_TITLE ].m_s_name = _( "Ip-BylineTitle" )       ;
   m_tb_col[ COL_IPTC_BYLINE_TITLE ].m_grp    = GRP_IPTC                    ;
   m_tb_col[ COL_IPTC_BYLINE_TITLE ].m_s_var_name = "%Ybt"                  ;
   m_tb_col[ COL_IPTC_BYLINE_TITLE ].m_sort   = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_COPYRIGHT ].m_i_width_def = 100                       ;
   m_tb_col[ COL_IPTC_COPYRIGHT ].m_s_name = _( "Ip-Copyright" )            ;
   m_tb_col[ COL_IPTC_COPYRIGHT ].m_grp    = GRP_IPTC                       ;
   m_tb_col[ COL_IPTC_COPYRIGHT ].m_s_var_name = "%Ycy"                     ;
   m_tb_col[ COL_IPTC_COPYRIGHT ].m_sort   = SORT_STRING                    ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_CREDIT    ].m_i_width_def = 100                       ;
   m_tb_col[ COL_IPTC_CREDIT    ].m_s_name = _( "Ip-Credit" )               ;
   m_tb_col[ COL_IPTC_CREDIT    ].m_grp    = GRP_IPTC                       ;
   m_tb_col[ COL_IPTC_CREDIT    ].m_s_var_name = "%Ycr"                     ;
   m_tb_col[ COL_IPTC_CREDIT    ].m_sort   = SORT_STRING                    ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_SOURCE    ].m_i_width_def = 100                       ;
   m_tb_col[ COL_IPTC_SOURCE    ].m_s_name = _( "Ip-Source" )               ;
   m_tb_col[ COL_IPTC_SOURCE    ].m_grp    = GRP_IPTC                       ;
   m_tb_col[ COL_IPTC_SOURCE    ].m_s_var_name = "%Ysr"                     ;
   m_tb_col[ COL_IPTC_SOURCE    ].m_sort   = SORT_STRING                    ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_CAPTION_WRITER ].m_i_width_def = 100                  ;
   m_tb_col[ COL_IPTC_CAPTION_WRITER ].m_s_name = _( "Ip-CaptionWriter" )   ;
   m_tb_col[ COL_IPTC_CAPTION_WRITER ].m_grp    = GRP_IPTC                  ;
   m_tb_col[ COL_IPTC_CAPTION_WRITER ].m_s_var_name = "%Ycw"                ;
   m_tb_col[ COL_IPTC_CAPTION_WRITER ].m_sort   = SORT_STRING               ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_CAPTION   ].m_i_width_def = 100                       ;
   m_tb_col[ COL_IPTC_CAPTION   ].m_s_name = _( "Ip-Caption" )              ;
   m_tb_col[ COL_IPTC_CAPTION   ].m_grp    = GRP_IPTC                       ;
   m_tb_col[ COL_IPTC_CAPTION   ].m_s_var_name = "%Ycp"                     ;
   m_tb_col[ COL_IPTC_CAPTION   ].m_sort   = SORT_STRING                    ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_HEADLINE  ].m_i_width_def = 100                       ;
   m_tb_col[ COL_IPTC_HEADLINE  ].m_s_name = _( "Ip-HeadLine" )             ;
   m_tb_col[ COL_IPTC_HEADLINE  ].m_grp    = GRP_IPTC                       ;
   m_tb_col[ COL_IPTC_HEADLINE  ].m_s_var_name = "%Yhl"                     ;
   m_tb_col[ COL_IPTC_HEADLINE  ].m_sort   = SORT_STRING                    ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_SPECIAL_INSTR ].m_i_width_def = 100                   ;
   m_tb_col[ COL_IPTC_SPECIAL_INSTR ].m_s_name = _( "Ip-SpecialInstr" )     ;
   m_tb_col[ COL_IPTC_SPECIAL_INSTR ].m_grp    = GRP_IPTC                   ;
   m_tb_col[ COL_IPTC_SPECIAL_INSTR ].m_s_var_name = "%Ysi"                 ;
   m_tb_col[ COL_IPTC_SPECIAL_INSTR ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_OBJECT_NAME ].m_i_width_def = 100                     ;
   m_tb_col[ COL_IPTC_OBJECT_NAME ].m_s_name = _( "Ip-ObjectName" )         ;
   m_tb_col[ COL_IPTC_OBJECT_NAME ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_OBJECT_NAME ].m_s_var_name = "%Yon"                   ;
   m_tb_col[ COL_IPTC_OBJECT_NAME ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_DATETIME_CREATED ].m_s_name = _( "Ip-DateTimeCreated");
   m_tb_col[ COL_IPTC_DATETIME_CREATED ].m_grp    = GRP_IPTC                ;
   m_tb_col[ COL_IPTC_DATETIME_CREATED ].m_s_var_name = "%Ydc"              ;
   m_tb_col[ COL_IPTC_DATETIME_CREATED ].m_sort   = SORT_DATETIME           ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_DATETIME_RELEASED ].m_s_name
                                               = _( "Ip-DateTimeReleased" ) ;
   m_tb_col[ COL_IPTC_DATETIME_RELEASED ].m_grp    = GRP_IPTC               ;
   m_tb_col[ COL_IPTC_DATETIME_RELEASED ].m_s_var_name = "%Ydr"             ;
   m_tb_col[ COL_IPTC_DATETIME_RELEASED ].m_sort   = SORT_DATETIME          ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_CITY ].m_i_width_def = 100                            ;
   m_tb_col[ COL_IPTC_CITY ].m_s_name = _( "Ip-City" )                      ;
   m_tb_col[ COL_IPTC_CITY ].m_grp    = GRP_IPTC                            ;
   m_tb_col[ COL_IPTC_CITY ].m_s_var_name = "%Yct"                          ;
   m_tb_col[ COL_IPTC_CITY ].m_sort   = SORT_STRING                         ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_SUBLOCATION ].m_i_width_def = 100                     ;
   m_tb_col[ COL_IPTC_SUBLOCATION ].m_s_name = _( "Ip-SubLocation" )        ;
   m_tb_col[ COL_IPTC_SUBLOCATION ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_SUBLOCATION ].m_s_var_name = "%Ysl"                   ;
   m_tb_col[ COL_IPTC_SUBLOCATION ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_STATE       ].m_i_width_def = 100                     ;
   m_tb_col[ COL_IPTC_STATE       ].m_s_name = _( "Ip-State" )              ;
   m_tb_col[ COL_IPTC_STATE       ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_STATE       ].m_s_var_name = "%Yst"                   ;
   m_tb_col[ COL_IPTC_STATE       ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_COUNTRY_CODE ].m_i_width_def = 80                     ;
   m_tb_col[ COL_IPTC_COUNTRY_CODE ].m_s_name = _( "Ip-CountryCode" )       ;
   m_tb_col[ COL_IPTC_COUNTRY_CODE ].m_grp    = GRP_IPTC                    ;
   m_tb_col[ COL_IPTC_COUNTRY_CODE ].m_s_var_name = "%Ycc"                  ;
   m_tb_col[ COL_IPTC_COUNTRY_CODE ].m_sort   = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_COUNTRY     ].m_i_width_def = 100                     ;
   m_tb_col[ COL_IPTC_COUNTRY     ].m_s_name = _( "Ip-Country" )            ;
   m_tb_col[ COL_IPTC_COUNTRY     ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_COUNTRY     ].m_s_var_name = "%Yco"                   ;
   m_tb_col[ COL_IPTC_COUNTRY     ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_ORIGINAL_TRSF ].m_i_width_def = 100                   ;
   m_tb_col[ COL_IPTC_ORIGINAL_TRSF ].m_s_name = _( "Ip-OriginalTrsf" )     ;
   m_tb_col[ COL_IPTC_ORIGINAL_TRSF ].m_grp    = GRP_IPTC                   ;
   m_tb_col[ COL_IPTC_ORIGINAL_TRSF ].m_s_var_name = "%Yot"                 ;
   m_tb_col[ COL_IPTC_ORIGINAL_TRSF ].m_sort   = SORT_STRING                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_CATEGORY    ].m_i_width_def = 100                     ;
   m_tb_col[ COL_IPTC_CATEGORY    ].m_s_name = _( "Ip-Category" )           ;
   m_tb_col[ COL_IPTC_CATEGORY    ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_CATEGORY    ].m_s_var_name = "%Yca"                   ;
   m_tb_col[ COL_IPTC_CATEGORY    ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_SUPPL_CATEGORIES ].m_i_width_def = 100                ;
   m_tb_col[ COL_IPTC_SUPPL_CATEGORIES ].m_s_name
                                                = _( "Ip-SupplCategories" ) ;
   m_tb_col[ COL_IPTC_SUPPL_CATEGORIES ].m_grp    = GRP_IPTC                ;
   m_tb_col[ COL_IPTC_SUPPL_CATEGORIES ].m_s_var_name = "%Ysc"              ;
   m_tb_col[ COL_IPTC_SUPPL_CATEGORIES ].m_sort   = SORT_STRING             ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_EDIT_STATUS ].m_i_width_def = 90                      ;
   m_tb_col[ COL_IPTC_EDIT_STATUS ].m_s_name = _( "Ip-EditStatus" )         ;
   m_tb_col[ COL_IPTC_EDIT_STATUS ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_EDIT_STATUS ].m_s_var_name = "%Yes"                   ;
   m_tb_col[ COL_IPTC_EDIT_STATUS ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_JOBID       ].m_i_width_def = 60                      ;
   m_tb_col[ COL_IPTC_JOBID       ].m_s_name = _( "Ip-JobId" )              ;
   m_tb_col[ COL_IPTC_JOBID       ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_JOBID       ].m_s_var_name = "%Yji"                   ;
   m_tb_col[ COL_IPTC_JOBID       ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_PROGRAM     ].m_i_width_def =  80                     ;
   m_tb_col[ COL_IPTC_PROGRAM     ].m_s_name = _( "Ip-Program" )            ;
   m_tb_col[ COL_IPTC_PROGRAM     ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_PROGRAM     ].m_s_var_name = "%Ypg"                   ;
   m_tb_col[ COL_IPTC_PROGRAM     ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_PROGRAM_VERSION ].m_i_width_def = 80                  ;
   m_tb_col[ COL_IPTC_PROGRAM_VERSION ].m_s_name =  _( "Ip-ProgramVersion" );
   m_tb_col[ COL_IPTC_PROGRAM_VERSION ].m_grp    = GRP_IPTC                 ;
   m_tb_col[ COL_IPTC_PROGRAM_VERSION ].m_s_var_name = "%Ypv"               ;
   m_tb_col[ COL_IPTC_PROGRAM_VERSION ].m_sort   = SORT_STRING              ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_PRIORITY    ].m_i_width_def = 80                      ;
   m_tb_col[ COL_IPTC_PRIORITY    ].m_s_name = _( "Ip-Priority" )           ;
   m_tb_col[ COL_IPTC_PRIORITY    ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_PRIORITY    ].m_s_var_name = "%Ypr"                   ;
   m_tb_col[ COL_IPTC_PRIORITY    ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_OBJECT_CYCLE ].m_i_width_def = 80                     ;
   m_tb_col[ COL_IPTC_OBJECT_CYCLE ].m_s_name = _( "Ip-ObjectCycle" )       ;
   m_tb_col[ COL_IPTC_OBJECT_CYCLE ].m_grp    = GRP_IPTC                    ;
   m_tb_col[ COL_IPTC_OBJECT_CYCLE ].m_s_var_name = "%Yoc"                  ;
   m_tb_col[ COL_IPTC_OBJECT_CYCLE ].m_sort   = SORT_STRING                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_IPTC_KEYWORDS    ].m_i_width_def = 120                     ;
   m_tb_col[ COL_IPTC_KEYWORDS    ].m_s_name = _( "Ip-Keywords" )           ;
   m_tb_col[ COL_IPTC_KEYWORDS    ].m_grp    = GRP_IPTC                     ;
   m_tb_col[ COL_IPTC_KEYWORDS    ].m_s_var_name = "%Ykw"                   ;
   m_tb_col[ COL_IPTC_KEYWORDS    ].m_sort   = SORT_STRING                  ;

   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_TITLE        ].m_i_width_def = 120                     ;
   m_tb_col[ COL_DOC_TITLE        ].m_s_name = _( "Doc-Title" )             ;
   m_tb_col[ COL_DOC_TITLE        ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_TITLE        ].m_s_var_name = "%Ot"                    ;
   m_tb_col[ COL_DOC_TITLE        ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_SUBJECT      ].m_i_width_def = 120                     ;
   m_tb_col[ COL_DOC_SUBJECT      ].m_s_name = _( "Doc-Subject" )           ;
   m_tb_col[ COL_DOC_SUBJECT      ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_SUBJECT      ].m_s_var_name = "%Os"                    ;
   m_tb_col[ COL_DOC_SUBJECT      ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_VERSION      ].m_i_width_def =  80                     ;
   m_tb_col[ COL_DOC_VERSION      ].m_s_name = _( "Doc-Version" )           ;
   m_tb_col[ COL_DOC_VERSION      ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_VERSION      ].m_s_var_name = "%Ov"                    ;
   m_tb_col[ COL_DOC_VERSION      ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_AUTHOR       ].m_i_width_def = 120                     ;
   m_tb_col[ COL_DOC_AUTHOR       ].m_s_name = _( "Doc-Author" )            ;
   m_tb_col[ COL_DOC_AUTHOR       ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_AUTHOR       ].m_s_var_name = "%Oa"                    ;
   m_tb_col[ COL_DOC_AUTHOR       ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_DESTINATION  ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_DESTINATION  ].m_s_name = _( "Doc-Destination" )       ;
   m_tb_col[ COL_DOC_DESTINATION  ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_DESTINATION  ].m_s_var_name = "%Od"                    ;
   m_tb_col[ COL_DOC_DESTINATION  ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_COMMENT      ].m_i_width_def = 120                     ;
   m_tb_col[ COL_DOC_COMMENT      ].m_s_name = _( "Doc-Comment" )           ;
   m_tb_col[ COL_DOC_COMMENT      ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_COMMENT      ].m_s_var_name = "%Oc"                    ;
   m_tb_col[ COL_DOC_COMMENT      ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_INFO         ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_INFO         ].m_s_name = _( "Doc-Info" )              ;
   m_tb_col[ COL_DOC_INFO         ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_INFO         ].m_s_var_name = "%Oi"                    ;
   m_tb_col[ COL_DOC_INFO         ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_ID           ].m_i_width_def = 120                     ;
   m_tb_col[ COL_DOC_ID           ].m_s_name = _( "Doc-Id" )                ;
   m_tb_col[ COL_DOC_ID           ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_ID           ].m_s_var_name = "%OI"                    ;
   m_tb_col[ COL_DOC_ID           ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_KEYWORDS     ].m_i_width_def = 120                     ;
   m_tb_col[ COL_DOC_KEYWORDS     ].m_s_name = _( "Doc-Keywords" )          ;
   m_tb_col[ COL_DOC_KEYWORDS     ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_KEYWORDS     ].m_s_var_name = "%Ok"                    ;
   m_tb_col[ COL_DOC_KEYWORDS     ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_APPLICATION  ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_APPLICATION  ].m_s_name = _( "Doc-Application" )       ;
   m_tb_col[ COL_DOC_APPLICATION  ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_APPLICATION  ].m_s_var_name = "%OA"                    ;
   m_tb_col[ COL_DOC_APPLICATION  ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_COMPANY      ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_COMPANY      ].m_s_name = _( "Doc-Company" )           ;
   m_tb_col[ COL_DOC_COMPANY      ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_COMPANY      ].m_s_var_name = "%ON"                    ;
   m_tb_col[ COL_DOC_COMPANY      ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_COPYRIGHT    ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_COPYRIGHT    ].m_s_name = _( "Doc-Copyright" )         ;
   m_tb_col[ COL_DOC_COPYRIGHT    ].m_grp   = GRP_DOC                       ;
   m_tb_col[ COL_DOC_COPYRIGHT    ].m_s_var_name = "%OC"                    ;
   m_tb_col[ COL_DOC_COPYRIGHT    ].m_sort  = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_TRADEMARKS   ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_TRADEMARKS   ].m_s_name = _( "Doc-Trademarks" )        ;
   m_tb_col[ COL_DOC_TRADEMARKS   ].m_grp   = GRP_DOC                       ;
   m_tb_col[ COL_DOC_TRADEMARKS   ].m_s_var_name = "%OT"                    ;
   m_tb_col[ COL_DOC_TRADEMARKS   ].m_sort  = SORT_STRING                   ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_URL          ].m_i_width_def = 150                     ;
   m_tb_col[ COL_DOC_URL          ].m_s_name = _( "Doc-URL" )               ;
   m_tb_col[ COL_DOC_URL          ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_URL          ].m_s_var_name = "%Ou"                    ;
   m_tb_col[ COL_DOC_URL          ].m_sort   = SORT_STRING                  ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_CRE_DATE     ].m_s_name = _( "Doc-Creation" )          ;
   m_tb_col[ COL_DOC_CRE_DATE     ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_CRE_DATE     ].m_s_var_name = "%On"                    ;
   m_tb_col[ COL_DOC_CRE_DATE     ].m_sort   = SORT_DATETIME                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_MOD_DATE     ].m_s_name = _( "Doc-Modification" )      ;
   m_tb_col[ COL_DOC_MOD_DATE     ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_MOD_DATE     ].m_s_var_name = "%Om"                    ;
   m_tb_col[ COL_DOC_MOD_DATE     ].m_sort   = SORT_DATETIME                ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_FILECOUNT    ].m_i_fmt  = wxLIST_FORMAT_RIGHT          ;
   m_tb_col[ COL_DOC_FILECOUNT    ].m_i_width_def = 80                      ;
   m_tb_col[ COL_DOC_FILECOUNT    ].m_s_name = _( "Doc-File count" )        ;
   m_tb_col[ COL_DOC_FILECOUNT    ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_FILECOUNT    ].m_s_var_name = "%OF"                    ;
   m_tb_col[ COL_DOC_FILECOUNT    ].m_sort   = SORT_INTEGER                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_PAGECOUNT    ].m_i_fmt  = wxLIST_FORMAT_RIGHT          ;
   m_tb_col[ COL_DOC_PAGECOUNT    ].m_i_width_def = 80                      ;
   m_tb_col[ COL_DOC_PAGECOUNT    ].m_s_name = _( "Doc-Page count" )        ;
   m_tb_col[ COL_DOC_PAGECOUNT    ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_PAGECOUNT    ].m_s_var_name = "%OP"                    ;
   m_tb_col[ COL_DOC_PAGECOUNT    ].m_sort   = SORT_INTEGER                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_LINECOUNT    ].m_i_fmt  = wxLIST_FORMAT_RIGHT          ;
   m_tb_col[ COL_DOC_LINECOUNT    ].m_i_width_def = 80                      ;
   m_tb_col[ COL_DOC_LINECOUNT    ].m_s_name = _( "Doc-Line count" )        ;
   m_tb_col[ COL_DOC_LINECOUNT    ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_LINECOUNT    ].m_s_var_name = "%OL"                    ;
   m_tb_col[ COL_DOC_LINECOUNT    ].m_sort   = SORT_INTEGER                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_WORDCOUNT    ].m_i_fmt  = wxLIST_FORMAT_RIGHT          ;
   m_tb_col[ COL_DOC_WORDCOUNT    ].m_i_width_def = 80                      ;
   m_tb_col[ COL_DOC_WORDCOUNT    ].m_s_name = _( "Doc-Word count" )        ;
   m_tb_col[ COL_DOC_WORDCOUNT    ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_WORDCOUNT    ].m_s_var_name = "%OW"                    ;
   m_tb_col[ COL_DOC_WORDCOUNT    ].m_sort   = SORT_INTEGER                 ;
   /*----------------------------------------------------------------------*/
   m_tb_col[ COL_DOC_CHARCOUNT    ].m_i_fmt  = wxLIST_FORMAT_RIGHT          ;
   m_tb_col[ COL_DOC_CHARCOUNT    ].m_i_width_def = 80                      ;
   m_tb_col[ COL_DOC_CHARCOUNT    ].m_s_name = _( "Doc-Char count" )        ;
   m_tb_col[ COL_DOC_CHARCOUNT    ].m_grp    = GRP_DOC                      ;
   m_tb_col[ COL_DOC_CHARCOUNT    ].m_s_var_name = "%OB"                    ;
   m_tb_col[ COL_DOC_CHARCOUNT    ].m_sort   = SORT_INTEGER                 ;

   /*--( Using "now" with a small safety margin )--------------------------*/
   int   i_date_width
       = col_width_for_text(
                   wxDateTime::Now().Format( wxGetApp().get_disp_fmt_date() )
                           ) + 10 ;

   /*--( Init of the other column elements with default values )-----------*/
   int i_width_def ;
   int i_col ;
   for( i_col = 0 ; i_col < COL_NB ; ++i_col )
   {
      /*-------------------------------------------------------------------*/
      m_tb_col[ i_col ].m_i_subitem = i_col ;

      /*--( Try to "compute" the default width )---------------------------*/
      if( m_tb_col[ i_col ].m_sort == SORT_DATETIME )
      {  i_width_def = i_date_width ; }
      else
      {  i_width_def = col_width_for_text( m_tb_col[ i_col ].m_s_name ) ; }
      /*--( The header text has to be fully displayed )--------------------*/
      if( i_width_def > m_tb_col[ i_col ].m_i_width_def )
      {  m_tb_col[ i_col ].m_i_width_def = i_width_def ; }

      /*-------------------------------------------------------------------*/
      m_tb_col[ i_col ].m_boo_on  = m_tb_col[ i_col ].get_on_default() ;
      m_tb_col[ i_col ].m_i_width = m_tb_col[ i_col ].m_i_width_def    ;
      /*-------------------------------------------------------------------*/
      if( i_col == COL_NONE_CHECKBOX || i_col == COL_NONE_ICON  )
      {  continue ; }

      /*--------------------------------------------------------------------+
      ! Check the data ... only in debug mode !!!                           !
      +--------------------------------------------------------------------*/
#ifdef __WXDEBUG__
      if(    m_tb_col[ i_col ].m_i_subitem < 0
          || m_tb_col[ i_col ].m_i_subitem >= COL_NB
        )
      {  wxFAIL_MSG( wxString::Format( "subitem col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if( m_tb_col[ i_col ].m_i_width_def < 0 )
      {  wxFAIL_MSG( wxString::Format( "width def col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if( m_tb_col[ i_col ].m_i_width < 0 )
      {  wxFAIL_MSG( wxString::Format( "width col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if( m_tb_col[ i_col ].m_i_fmt == ~0 )
      {  wxFAIL_MSG( wxString::Format( "fmt col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if( m_tb_col[ i_col ].m_s_name.empty() )
      {  wxFAIL_MSG( wxString::Format( "name col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if(    i_col != COL_NONE_NEW_NAME
          && m_tb_col[ i_col ].m_s_var_name.empty()
        )
      {  wxFAIL_MSG( wxString::Format( "var col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if(    m_tb_col[ i_col ].m_grp < 0
          || m_tb_col[ i_col ].m_grp >= GRP_NB
        )
      {  wxFAIL_MSG( wxString::Format( "grp col %d", i_col ) ) ; }
      /*-------------------------------------------------------------------*/
      if(    m_tb_col[ i_col ].m_sort < 0
          || m_tb_col[ i_col ].m_sort >= SORT_NB
        )
      {  wxFAIL_MSG( wxString::Format( "m_sort col %d", i_col ) ) ; }
#endif // __WXDEBUG__
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   load_col_info() ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of File CFileList_Init.cpp                       !
+==========================================================================*/
