/*====================================+=====================================+
! File CFileInit_xpm.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                          Image files ".xpm"                               !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/convauto.h>
#include <wx/regex.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Not all parameters are used to have a "coherent" prototype for all image  !
! extract information functions.                                            !
! Maybe one day to call them through a function pointer.                    !
+--------------------------------------------------------------------------*/
int CFileInit::xpm_read( wxFileOffset WXUNUSED( fo_image_offset ),
                         wxULongLong WXUNUSED( ull_image_size )
                       )
{
   /*----------------------------------------------------------------------*/
   char   tb_c_buffer[ 1024 ]             ;
   size_t sz_read = sizeof( tb_c_buffer ) ;

   /*--( Try to fill up the buffer )---------------------------------------*/
   if( m_fa.read_buffer_max( sz_read, tb_c_buffer ) != 0 )
   {  return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   wxString s_buffer( tb_c_buffer, wxConvAuto(), sz_read ) ;
   wxRegEx  regex( "\"\\s*(\\d+)\\s+(\\d+)", wxRE_ADVANCED ) ;

   /*----------------------------------------------------------------------*/
   if( !regex.IsValid() ) { wxFAIL ; return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   if( regex.Matches( s_buffer ) )
   {
      /*-------------------------------------------------------------------*/
      long l_width  = 0 ;
      long l_height = 0 ;
      /*-------------------------------------------------------------------*/
      if(    regex.GetMatch( s_buffer, 1 ).ToLong( &l_width )
          && regex.GetMatch( s_buffer, 2 ).ToLong( &l_height )
        )
      {  init_img_x_y( l_width, l_height ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_xpm()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "xpm" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = xpm_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_xpm.cpp                        !
+==========================================================================*/
