/*====================================+=====================================+
! File CFileInit_wav.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                          Audio file: ".wav"                               !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_wav : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_wav( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int wav_read() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
static int st_wav_conv_tag_col( wxUint32 dw_tag )
{
   /*----------------------------------------------------------------------*/
   switch( dw_tag )
   {
      /*-------------------------------------------------------------------*/
      case SR_FOURCC( 'I','N','A','M' ) : return( COL_AUDTAG_TITLE     ) ;
      case SR_FOURCC( 'I','S','B','J' ) : return( COL_AUDTAG_ALBUM     ) ;
      case SR_FOURCC( 'I','A','R','T' ) : return( COL_AUDTAG_ARTIST    ) ;
      case SR_FOURCC( 'I','C','M','T' ) : return( COL_AUDTAG_COMMENT   ) ;
    //case SR_FOURCC( 'I','K','E','Y' ) : return( COL_VIDTAG_KEYWORDS ) ;
      /*-------------------------------------------------------------------*/
      case SR_FOURCC( 'I','E','N','G' ) :
      case SR_FOURCC( 'I','T','C','H' ) : return( COL_AUDTAG_ENCOD_BY  ) ;
      /*-------------------------------------------------------------------*/
      case SR_FOURCC( 'I','G','N','R' ) : return( COL_AUDTAG_GENRE     ) ;
      /*-------------------------------------------------------------------*/
      case SR_FOURCC( 'I','C','R','D' ) :
      case SR_FOURCC( 'D','A','T','E' ) : return( COL_AUDTAG_YEAR      ) ;
      /*-------------------------------------------------------------------*/
    //case SR_FOURCC( 'I','S','R','C' ) : return( COL_VIDTAG_SOURCE    ) ;
      case SR_FOURCC( 'I','C','O','P' ) : return( COL_AUDTAG_COPYRIGHT ) ;
      case SR_FOURCC( 'I','S','F','T' ) : return( COL_AUDIO_INFO       ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_wav::wav_read()
{
   /*----------------------------------------------------------------------*/
   str_chunk        chunk ;
   wxUint32         dw_id ;
   str_WAVEFORMATEX wfx   ;
   const int co_i_min_wave_size     = offsetof( str_WAVEFORMATEX, cbSize ) ;
   wxUint32         dw_size_to_skip = 0     ;
   wxUint32         dw_size_data    = 0     ;
   int              i_duration      = 0     ;
   bool             boo_fmt         = false ;
   bool             boo_data        = false ;

   /*----------------------------------------------------------------------*/
   SR_SET_0( wfx ) ;

   /*--( First read the header )-------------------------------------------*/
   if( m_fa.read_le_data( chunk ) != 0 || m_fa.read_data( dw_id ) != 0 )
   {  return( -1 ) ; }

   /*--( And then check it )-----------------------------------------------*/
   if(    chunk.dw_id != SR_FOURCC( 'R','I','F','F' )
       || dw_id       != SR_FOURCC( 'W','A','V','E' )
     )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   while( m_fa.read_le_data( chunk ) == 0 )
   {
      /*-------------------------------------------------------------------*/
      dw_size_to_skip = chunk.dw_size ;
      /*-------------------------------------------------------------------*/
      switch( chunk.dw_id )
      {
         /*----------------------------------------------------------------*/
         case SR_FOURCC( 'f','m','t',' ' ) :
            /*-------------------------------------------------------------*/
            if( ( int )chunk.dw_size < co_i_min_wave_size ) { break ; }
            /*-------------------------------------------------------------*/
            if( m_fa.read_le_data( wfx, co_i_min_wave_size ) != 0 )
            {  return( -3 ) ; }
            /*-------------------------------------------------------------*/
            dw_size_to_skip = chunk.dw_size - co_i_min_wave_size ;
            boo_fmt = true ;
            /*-------------------------------------------------------------*/
            break ;

         /*----------------------------------------------------------------*/
         case SR_FOURCC( 'd','a','t','a' ) :
            /*-------------------------------------------------------------*/
            dw_size_data = chunk.dw_size ;
            boo_data = true ;
            /*-------------------------------------------------------------*/
            break ;

         /*--( Something undocumented ... )--------------------------------*/
         case SR_FOURCC( 'D','I','S','P' ) :
         {
            /*--( Jump here to avoid the padding byte )--------------------*/
            if(    dw_size_to_skip > 0
                && m_fa.skip_nb_byte( dw_size_to_skip ) != 0
              )
            {  return( -4 ) ; }
            /*-------------------------------------------------------------*/
            dw_size_to_skip = 0 ;
            /*-------------------------------------------------------------*/
            wxUint8 b_pad ;
            /*--( If the char is ok then no padding )----------------------*/
            if(    m_fa.read_data( b_pad ) == 0 && b_pad != 0x00
                && m_fa.skip_nb_byte( -1 ) != 0
              )
            {  return( -5 ) ; }
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }

         /*----------------------------------------------------------------*/
         case SR_FOURCC( 'L','I','S','T' ) :
         {  /*-------------------------------------------------------------*/
            wxUint32 dw_id_info ;
            /*-------------------------------------------------------------*/
            if( dw_size_to_skip < sizeof( dw_id_info ) )
            {  break ; }
            /*-------------------------------------------------------------*/
            if( m_fa.read_data( dw_id_info ) != 0 )
            {  return( -6 ) ; }
            /*-------------------------------------------------------------*/
            dw_size_to_skip -= sizeof( dw_id_info ) ;
            /*-------------------------------------------------------------*/
            if( dw_id_info != SR_FOURCC( 'I','N','F','O' ) )
            {  break ; }
            /*-------------------------------------------------------------*/
            if( m_fi.riff_read_serie_info( dw_size_to_skip,
                                           st_wav_conv_tag_col
                                         ) != 0
              )
            {  return( -7 ) ; }
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }

      /*--( Some files seem strangely padded with chunk_id set to 0 )------*/
      if(    dw_size_to_skip > 0
          && m_fa.skip_nb_byte( dw_size_to_skip ) != 0
        )
      {  break ; }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   if( !boo_fmt || !boo_data ) { return( -9 ) ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_audio_channel( wfx.nChannels )       ;
   m_fi.init_audio_samprate( wfx.nSamplesPerSec ) ;
   /*----------------------------------------------------------------------*/
   if(    wfx.wBitsPerSample != 0
       && wfx.nChannels      != 0
       && wfx.nSamplesPerSec != 0
     )
   {  /*-------------------------------------------------------------------*/
      i_duration = ( int )(   ( double )dw_size_data * 8
                            / wfx.nChannels
                            / wfx.wBitsPerSample
                            / wfx.nSamplesPerSec
                          ) ;
      /*-------------------------------------------------------------------*/
      m_fi.init_audio_duration( i_duration ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   if( wfx.nAvgBytesPerSec != 0 )
   {
      /*-------------------------------------------------------------------*/
      i_duration = ( int )(   ( double )dw_size_data
                            / wfx.nChannels
                            / wfx.nAvgBytesPerSec
                          ) ;
      /*-------------------------------------------------------------------*/
      m_fi.init_audio_duration( i_duration ) ;
      /*-------------------------------------------------------------------*/
   }
   /*--( Bitrate computation )---------------------------------------------*/
   if( wfx.nAvgBytesPerSec > 0 )
   {  m_fi.init_audio_bitrate( TBR_CBR,
                               ( int )(   ( double )wfx.nAvgBytesPerSec
                                        * 8 / 1000
                                      )
                             ) ;
   }
   else
   if( i_duration > 0 )
   {  m_fi.init_audio_bitrate( TBR_CBR,
                               ( int )(   m_f.get_size().ToDouble()
                                        * 8 / 1000 / i_duration
                                      )
                             ) ;
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_wav()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "wav" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_wav( *this ).wav_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_wav.cpp                       !
+==========================================================================*/
