/*====================================+=====================================+
! File CFileInit_torrent.cpp          ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!           Torrent file: ".torrent" : bittorent "announcement" file        !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Even if strings are supposed to be UTF8 encoded, some software used to    !
! to create torrent files add a suffix to the variable name to specify the  !
! encoding method.                                                          !
! For example, two versions of "name" can exist:                            !
!     name encoded in "something"                                           !
! and name.utf-8 representing the same string but utf-8 encoded.            !
! Of course if this last one exists it has to be extracted and stored.      !
! So if the column reservation is done, the value will be overwritten.      !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--( Maximum size )-------------------------------------------------------*/
static const int st_co_i_torrent_max_size = 2 * 1024 * 1024 ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_torrent : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_torrent( CFileInit &parent )
                       : CFileInit_type_base( parent ),
                         m_p_b_buffer( NULL ), // for cppcheck
                         m_i_buffer_len( 0 ),  // for cppcheck
                         m_i_pos( 0 ),         // for cppcheck
                         m_ull_files_size( 0 ),
                         m_i_nb_files( 0 )
      {  ; }

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxMemoryBuffer m_mb_buffer    ;
      wxUint8        *m_p_b_buffer  ;
      int            m_i_buffer_len ;
      int            m_i_pos        ;
      /*-------------------------------------------------------------------*/
      wxULongLong    m_ull_files_size ;
      int            m_i_nb_files     ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int benc_int( wxULongLong *p_ull_val ) ;
      int benc_string( char *p_c_val, int i_sz_val = 0,
                       int *p_i_len_val = NULL
                     ) ;
      int skip_benc_list() ;
      int skip_benc_dict() ;
      int skip_benc_val()  ;
      /*-------------------------------------------------------------------*/
      int read_string_ascii( wxString &s ) ;
      int read_string( wxString &s ) ;
      int read_files() ;
      int read_info() ;
      int main_dict() ;
      int torrent_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*--( NULL is used to not assign the value and so jump over it )-----------*/
int CFileInit_torrent::benc_int( wxULongLong *p_ull_val )
{
   /*----------------------------------------------------------------------*/
   wxULongLong ull_val = 0 ;
   /*--( Prefix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'i' ) { return( -1 ) ; }
   /*--( The number of characters )----------------------------------------*/
   for( ++m_i_pos ;
        m_i_pos < m_i_buffer_len && isdigit( m_p_b_buffer[ m_i_pos ] ) ;
        ++m_i_pos
      )
   {  ull_val = ull_val * 10 + sr::char_value( m_p_b_buffer[ m_i_pos ] ) ; }

   /*--( Suffix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'e' ) { return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   if( p_ull_val != NULL ) { *p_ull_val = ull_val ; }
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--( NULL is used to not assign the value and so jump over it )-----------*/
int CFileInit_torrent::benc_string( char *p_c_val, int i_sz_val,
                                    int *p_i_len_val
                                  )
{
   /*----------------------------------------------------------------------*/
   int i_len ;

   /*----------------------------------------------------------------------*/
   if( p_c_val != NULL )
   {  /*--( Minimal control )----------------------------------------------*/
      if( p_i_len_val == NULL ) { return( -1 ) ; }
      *p_i_len_val = 0 ;
      /*-------------------------------------------------------------------*/
   }

   /*--( It begins with the size in characters )---------------------------*/
   if( !isdigit( m_p_b_buffer[ m_i_pos ] ) ) { return( -2 ) ; }

   /*--( Then the number of characters )-----------------------------------*/
   for( i_len = 0 ;
        m_i_pos < m_i_buffer_len && isdigit( m_p_b_buffer[ m_i_pos ] ) ;
        ++m_i_pos
      )
   {  i_len = i_len * 10 + sr::char_value( m_p_b_buffer[ m_i_pos ] ) ; }

   /*----------------------------------------------------------------------*/
   if( m_i_pos + i_len > m_i_buffer_len ) { return( -3 ) ; }

   /*--( The separator )---------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != ':' ) { return( -4 ) ; }
   ++m_i_pos ;

   /*----------------------------------------------------------------------*/
   if( p_c_val != NULL )
   {
      /*-------------------------------------------------------------------*/
      *p_i_len_val = wxMin( i_len, i_sz_val ) ;
      memcpy( p_c_val, &m_p_b_buffer[ m_i_pos ], *p_i_len_val ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   m_i_pos += i_len ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::skip_benc_list()
{
   /*--( Prefix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'l' ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   while( m_p_b_buffer[ m_i_pos ] != 'e' )
   {  if( skip_benc_val() != 0 ) { return( -2 ) ; } }
   /*--( Suffix to jump ... )----------------------------------------------*/
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::skip_benc_dict()
{
   /*--( Prefix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'd' ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   while( m_p_b_buffer[ m_i_pos ] != 'e' )
   {  if( benc_string( NULL ) != 0 ) { return( -2 ) ; }
      if( skip_benc_val() != 0 ) { return( -3 ) ; }
   }
   /*--( Suffix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'e' ) { return( -4 ) ; }
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::skip_benc_val()
{
   /*----------------------------------------------------------------------*/
   switch( m_p_b_buffer[ m_i_pos ] )
   {
      /*-------------------------------------------------------------------*/
      case 'i' : if( benc_int( NULL ) != 0 ) { return( -1 ) ; } ; break ;
      case 'l' : if( skip_benc_list() != 0 ) { return( -2 ) ; } ; break ;
      case 'd' : if( skip_benc_dict() != 0 ) { return( -3 ) ; } ; break ;
      /*-------------------------------------------------------------------*/
      default :
         /*----------------------------------------------------------------*/
         if( isdigit( m_p_b_buffer[ m_i_pos ] ) )
         {  if( benc_string( NULL ) != 0 ) { return( -4 ) ; } }
         else
         {  wxFAIL ; return( -5 ) ; }
         break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::read_string_ascii( wxString &s )
{
   /*----------------------------------------------------------------------*/
   char tb_c_buffer[ g_co_i_string_sz_max ] ;
   int  i_len_buffer ;
   /*----------------------------------------------------------------------*/
   if( benc_string( tb_c_buffer, sizeof( tb_c_buffer ), &i_len_buffer ) != 0)
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   s = wxString::FromAscii( tb_c_buffer, i_len_buffer ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::read_string( wxString &s )
{
   /*----------------------------------------------------------------------*/
   char tb_c_buffer[ g_co_i_string_sz_max ] ;
   int  i_len_buffer ;
   /*----------------------------------------------------------------------*/
   if( benc_string( tb_c_buffer, sizeof( tb_c_buffer ), &i_len_buffer
                  ) != 0
     )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   m_fi.prepare_string( tb_c_buffer, i_len_buffer, s ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
static bool st_var_content_is_utf8( wxString &s_var )
{
   /*----------------------------------------------------------------------*/
   if( s_var.EndsWith( ".utf-8" ) )
   {  s_var.Remove( s_var.length() - 6 ) ;
      return( true ) ;
   }
   /*----------------------------------------------------------------------*/
   return( false ) ;
   /*----------------------------------------------------------------------*/
}

/*--( The interesting information is the size of each file )---------------*/
int CFileInit_torrent::read_files()
{
   /*----------------------------------------------------------------------*/
   wxString s_var ;

   /*--( This is a list of dictionaries )----------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'l' ) { return( -1 ) ; }
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   while( m_p_b_buffer[ m_i_pos ] != 'e' )
   {
      /*--( Dictionary prefix )--------------------------------------------*/
      if( m_p_b_buffer[ m_i_pos ] != 'd' ) { return( -2 ) ; }
      ++m_i_pos ;

      /*-------------------------------------------------------------------*/
      while( m_p_b_buffer[ m_i_pos ] != 'e' )
      {
         /*--( The name of the dictionary element )------------------------*/
         if( read_string_ascii( s_var ) != 0 )
         {  return( -3 ) ; }
         /*----------------------------------------------------------------*/
         if( s_var == "length" )
         {
            /*-------------------------------------------------------------*/
            wxULongLong ull_val ;
            /*-------------------------------------------------------------*/
            if( benc_int( &ull_val ) != 0 ) { return( -4 ) ; }
            m_ull_files_size += ull_val ;
            ++m_i_nb_files ;
            /*-------------------------------------------------------------*/
         }
         else
         if( skip_benc_val() != 0 )
         {  return( -5 ) ; }
         /*----------------------------------------------------------------*/
      }
      /*--( Dictionary suffix )--------------------------------------------*/
      if( m_p_b_buffer[ m_i_pos ] != 'e' ) { return( -6 ) ; }
      ++m_i_pos ;
      /*-------------------------------------------------------------------*/
   }
   /*--( Suffix of the list )----------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'e' ) { return( -7 ) ; }
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::read_info()
{
   /*----------------------------------------------------------------------*/
   wxString s_var ;
   bool     boo_string_content_utf8 ;

   /*--( Prefix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'd' ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   while( m_p_b_buffer[ m_i_pos ] != 'e' )
   {
      /*--( The name of the dictionary element )---------------------------*/
      if( read_string_ascii( s_var ) != 0 ) { return( -2 ) ; }

      /*--( Sub-Dictionary ? )---------------------------------------------*/
      if( s_var == "files" )
      {  /*----------------------------------------------------------------*/
         if( read_files() != 0 ) { return( -3 ) ; }
         /*----------------------------------------------------------------*/
         continue ;
         /*----------------------------------------------------------------*/
      }

      /*-------------------------------------------------------------------*/
      boo_string_content_utf8 = st_var_content_is_utf8( s_var ) ;

      /*-------------------------------------------------------------------*/
      if( s_var == "name" )
      {
         /*--( The UTF8 content overrides any other value )----------------*/
         if( m_fi.reserve_col( COL_DOC_TITLE ) || boo_string_content_utf8 )
         {
            /*-------------------------------------------------------------*/
            wxString s_val ;
            /*-------------------------------------------------------------*/
            if( read_string( s_val ) != 0 ) { return( -4 ) ; }
            if( !s_val.empty() ) { m_f.val_s( COL_DOC_TITLE ) = s_val ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      else
      if( s_var == "length" )
      {  /*----------------------------------------------------------------*/
         wxULongLong ull_val ;
         /*----------------------------------------------------------------*/
         if( benc_int( &ull_val ) != 0 ) { return( -5 ) ; }
         m_ull_files_size += ull_val ;
         ++m_i_nb_files ;
         /*----------------------------------------------------------------*/
      }
      else
      if( skip_benc_val() != 0 )
      {  return( -6 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Suffix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'e' ) { return( -7 ) ; }
   ++m_i_pos ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::main_dict()
{
   /*----------------------------------------------------------------------*/
   wxString s_var ;
   bool     boo_string_content_utf8 ;
   int      i_col ;
   int      i_ret ;

   /*--( Prefix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'd' ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   while( m_p_b_buffer[ m_i_pos ] != 'e' )
   {
      /*--( The name of the dictionary element )---------------------------*/
      if( read_string_ascii( s_var ) != 0 ) { return( -2 ) ; }

      /*--( Sub-Dictionary ? )---------------------------------------------*/
      if( s_var == "info" )
      {  /*----------------------------------------------------------------*/
         if( ( i_ret = read_info() ) != 0 ) { return( i_ret ) ; }
         /*----------------------------------------------------------------*/
         continue ;
         /*----------------------------------------------------------------*/
      }

      /*-------------------------------------------------------------------*/
      boo_string_content_utf8 = st_var_content_is_utf8( s_var ) ;

      /*-------------------------------------------------------------------*/
      if( s_var == "announce" )
      {  i_col = COL_DOC_URL ; }
      else if( s_var == "created by" )
      {  i_col = COL_DOC_AUTHOR ; }
      else if( s_var == "comment" )
      {  i_col = COL_DOC_COMMENT ; }
      else if( s_var == "creation date" )
      {  i_col = COL_DOC_CRE_DATE ; }
      else
      {  i_col = COL_NB ; }

      /*--( The UTF8 content overwrites any other value )------------------*/
      if(    i_col != COL_NB
          && ( m_fi.reserve_col( i_col ) || boo_string_content_utf8 )
        )
      {
         /*----------------------------------------------------------------*/
         if( i_col == COL_DOC_CRE_DATE )
         {  /*-------------------------------------------------------------*/
            wxULongLong ull_val ;
            wxDateTime  dt      ;
            /*-------------------------------------------------------------*/
            if( benc_int( &ull_val ) != 0 ) { return( -3 ) ; }
            if( sr::init_datetime( ( time_t )ull_val.ToULong(), dt ) == 0 )
            {  m_fi.init_date( i_col, dt ) ; }
            /*-------------------------------------------------------------*/
         }
         else
         {  /*-------------------------------------------------------------*/
            wxString s_val ;
            /*-------------------------------------------------------------*/
            if( read_string( s_val ) != 0 ) { return( -4 ) ; }
            if( !s_val.empty() ) { m_f.val_s( i_col ) = s_val ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }
      else
      if( skip_benc_val() != 0 )
      {  return( -5 ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*--( Suffix ... )------------------------------------------------------*/
   if( m_p_b_buffer[ m_i_pos ] != 'e' ) { return( -6 ) ; }
   ++m_i_pos ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_torrent::torrent_read()
{
   /*----------------------------------------------------------------------*/
     m_i_buffer_len
   = wxMin( ( int )m_f.get_size().ToULong(), st_co_i_torrent_max_size ) ;
   /*--( All the strings are supposed to be encoded in "UTF8" )------------*/
   m_fi.set_conv_from_utf8() ;
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( m_i_buffer_len, m_mb_buffer ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   m_p_b_buffer = ( wxUint8 * )m_mb_buffer.GetData() ;

   /*--( Minimal length )--------------------------------------------------*/
   if( m_i_buffer_len <= 100 ) { return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   m_i_pos = 0 ;
   /*----------------------------------------------------------------------*/
   if( main_dict() != 0 ) { return( -3 ) ; }

   /*--( Total file size )-------------------------------------------------*/
   if( m_fi.reserve_col( COL_DOC_CHARCOUNT ) )
   {
      /*-------------------------------------------------------------------*/
        m_f.val_s( COL_DOC_CHARCOUNT )
      = sr::size_in_most_appropriate_unit( m_ull_files_size ) ;
      /*-------------------------------------------------------------------*/
      m_f.val_ll( COL_DOC_CHARCOUNT ) = m_ull_files_size ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Number of files )-------------------------------------------------*/
   m_fi.init_doc_nb_files( m_i_nb_files ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_torrent()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "torrent" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_torrent( *this ).torrent_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                    End of file CFileInit_torrent.cpp                      !
+==========================================================================*/
