/*====================================+=====================================+
! File CFileInit_swf.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                 Interactive file: ".swf" (Adobe Flash)                    !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/wfstream.h>
#include <wx/zstream.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_swf_header1 ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_swf : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_swf( CFileInit &parent )
                   : CFileInit_type_base( parent ), m_p_input( NULL )
      {  read_nb_bits_reset() ; }

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxInputStream *m_p_input       ;
      wxUint8       m_b_in           ; // Bytes non completely read yet
      int           m_i_nb_bits_left ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int  read_le_data( str_swf_header1 &sh1 ) ;
      int read_nb_bits( int i_nb_bits, int &i_res ) ;
      void read_nb_bits_reset()
      {  m_i_nb_bits_left = 0 ; }
      int read_buffer( void *p_buffer, size_t sz ) ;
      int read_data( wxUint16 &ui ) ;
      int swf_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_swf_header1
{
   /*----------------------------------------------------------------------*/
   char     tb_c_signature[ 3 ] ; // FWS: uncompressed, CWS: compressed(>=v6)
   wxUint8  b_version           ; // Single byte version
   wxUint32 dw_file_length      ; // Length of uncompressed file in bytes
                                  // including header
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_swf::read_le_data( str_swf_header1 &sh1 )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( sh1 ), &sh1 ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   sh1.dw_file_length = wxUINT32_SWAP_ALWAYS( sh1.dw_file_length ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_swf::read_buffer( void *p_buffer, size_t sz )
{
   /*----------------------------------------------------------------------*/
   if( m_p_input->Read( p_buffer, sz ).LastRead() != sz )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_swf::read_data( wxUint16 &ui )
{
   /*----------------------------------------------------------------------*/
   if( read_buffer( &ui, sizeof( ui ) ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   ui = wxUINT16_SWAP_ALWAYS( ui ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_swf::read_nb_bits( int i_nb_bits, int &i_res )
{
   /*----------------------------------------------------------------------*/
   int i_nb ;

   /*--( Limit ... )-------------------------------------------------------*/
   if( i_nb_bits > 31 ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   i_res = 0 ;
   /*----------------------------------------------------------------------*/
   while( i_nb_bits > 0 )
   {
      /*-------------------------------------------------------------------*/
      if( m_i_nb_bits_left == 0 )
      {
         /*----------------------------------------------------------------*/
         if( read_buffer( &m_b_in, 1 ) != 0 ) { return( -2 ) ; }
         m_i_nb_bits_left = 8 ;
         /*----------------------------------------------------------------*/
      }

      /*-------------------------------------------------------------------*/
      i_nb = wxMin( m_i_nb_bits_left, i_nb_bits ) ;
      /*--( The bits are taken from the left )-----------------------------*/
      i_res <<= i_nb ;
      i_res |= ( ( m_b_in >> ( 8 - i_nb ) ) & ~( 0xFF << i_nb ) ) ;
      m_b_in <<= i_nb ;
      /*-------------------------------------------------------------------*/
      m_i_nb_bits_left -= i_nb ;
      i_nb_bits        -= i_nb ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_swf::swf_read()
{
   /*----------------------------------------------------------------------*/
   str_swf_header1 header1        ;
   bool            boo_compressed ;
   int             i_nb_bits      ;
   int             i_width        ;
   int             i_height       ;
   int             i_dummy        ;
   wxUint16        w_fps          ;

   /*----------------------------------------------------------------------*/
   if( read_le_data( header1 ) != 0 )
   {  return( -1 ) ; }

   /*--( Compressed or uncompressed file ? )-------------------------------*/
   boo_compressed = ( memcmp( header1.tb_c_signature, "CWS", 3 ) == 0 ) ;
   if( !boo_compressed && memcmp( header1.tb_c_signature, "FWS", 3 ) != 0 )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   m_f.val_s( COL_VIDTAG_COMMENT ).Printf( "Version %d %s",
                                           header1.b_version,
                                           boo_compressed
                                           ? "compressed" : "uncompressed"
                                         ) ;

   /*--( Create a stream based on the file )-------------------------------*/
   wxFileInputStream file_input( m_fa ) ;
   m_p_input = &file_input ;

   /*----------------------------------------------------------------------*/
   if( boo_compressed )
   {  m_p_input = new wxZlibInputStream( *m_p_input ) ; }

   /*--( Read the rect )---------------------------------------------------*/
   if(    read_nb_bits( 5, i_nb_bits ) != 0
       || read_nb_bits( i_nb_bits, i_dummy  ) != 0
       || read_nb_bits( i_nb_bits, i_width  ) != 0
       || read_nb_bits( i_nb_bits, i_dummy  ) != 0
       || read_nb_bits( i_nb_bits, i_height ) != 0
     )
   {  return( -3 ) ; }

   /*--( Size expressed in twips => divide by 20 )-------------------------*/
   m_fi.init_video_x_y( i_width / 20, i_height / 20 ) ;

   /*----------------------------------------------------------------------*/
   read_nb_bits_reset() ;

   /*-----------------------------------------------------------------------+
   ! The FPS                                                                !
   ! Computing duration is not very interesting for swf (interactive flash) !
   ! so the frame count is not extracted.                                   !
   +-----------------------------------------------------------------------*/
   if( read_data( w_fps ) != 0 ) { return( -4 ) ; }
   if( w_fps > 0 )
   {  m_fi.init_video_fps( w_fps / 256 + ( w_fps % 256 ) / 1000.0 ) ; }

   /*--( Release the "stream" data )---------------------------------------*/
   if( boo_compressed ) { delete m_p_input ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_swf()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "swf" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_swf( *this ).swf_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_swf.cpp                        !
+==========================================================================*/
