/*====================================+=====================================+
! File CFileInit_real.cpp             ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                         Real file format : audio                          !
!                                                                           !
! Audio file: ".ra" ...                                                     !
! Video file: ".rm" ...                                                     !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_real_video_data ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_real : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_real( CFileInit &parent )
                    : CFileInit_type_base( parent ),
                      m_boo_audio_file( false ), m_boo_has_video( false ),
                      m_boo_audio_done( false ), m_boo_video_done( false ),
                      m_i_duration( -1 ), m_i_nb_channel( -1 ),
                      m_i_bitrate( -1 ), m_i_samprate( -1 )
      {  ; }

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool     m_boo_audio_file ; // Pure audio file ?
      bool     m_boo_has_video  ; // The file is video one ?
      /*-------------------------------------------------------------------*/
      bool     m_boo_audio_done ;
      bool     m_boo_video_done ;
      /*-------------------------------------------------------------------*/
      int      m_i_duration     ;
      int      m_i_nb_channel   ;
      int      m_i_bitrate      ;
      int      m_i_samprate     ;
      /*-------------------------------------------------------------------*/
      wxString m_s_audio_info   ;
      wxString m_s_video_info   ;
      /*-------------------------------------------------------------------*/
      wxString m_s_title        ;
      wxString m_s_artist       ;
      wxString m_s_copyright    ;
      wxString m_s_comment      ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int  read_be_data( str_real_video_data &rvd ) ;
      int  read_val_size1( wxString &s_val ) ;
      int  read_meta_audio() ;
      int  read_val_size2( wxString &s_val ) ;
      int  read_cont() ;
      int  audio_codec() ;
      int  video_codec() ;
      int  read_prop() ;
      int  read_mdpr() ;
      void init_col() ;
      int  real_read() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )
/*-------------------------------------------------------------------------*/
struct str_real_video_data
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_codec           ;
   wxUint16 w_width            ;
   wxUint16 w_height           ;
   // cppcheck-suppress unusedStructMember
   char     ___tb_c_dummy[ 6 ] ;
   wxUint16 w_fps1             ;
   wxUint16 w_fps2             ;
   /*----------------------------------------------------------------------*/
} ;
/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_be_data( str_real_video_data &rvd )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( rvd ), &rvd ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   //rvd.dw_codec = wxUINT32_SWAP_ALWAYS( rvd.dw_codec ) ;
   rvd.w_width  = wxUINT16_SWAP_ALWAYS( rvd.w_width ) ;
   rvd.w_height = wxUINT16_SWAP_ALWAYS( rvd.w_height ) ;
   rvd.w_fps1   = wxUINT16_SWAP_ALWAYS( rvd.w_fps1 ) ;
   rvd.w_fps2   = wxUINT16_SWAP_ALWAYS( rvd.w_fps2 ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_val_size1( wxString &s_val )
{
   /*----------------------------------------------------------------------*/
   wxUint8 b_val_len ;

   /*--( The length )------------------------------------------------------*/
   if( m_fa.read_data( b_val_len ) != 0 )
   {  return( -1 ) ; }
   /*--( The value in ascii )----------------------------------------------*/
   if( m_fi.file_read_tb_c( b_val_len, s_val ) != 0 )
   {  return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_meta_audio()
{
   /*----------------------------------------------------------------------*/
   if( read_val_size1( m_s_title )     != 0 ) { return( -1 ) ; }
   if( read_val_size1( m_s_artist )    != 0 ) { return( -2 ) ; }
   if( read_val_size1( m_s_copyright ) != 0 ) { return( -3 ) ; }
   if( read_val_size1( m_s_comment )   != 0 ) { return( -4 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_val_size2( wxString &s_val )
{
   /*----------------------------------------------------------------------*/
   wxUint16 w_val_len ;

   /*--( The length )------------------------------------------------------*/
   if( m_fa.read_be_data( w_val_len ) != 0 )
   {  return( -1 ) ; }
   /*--( The value in ascii )----------------------------------------------*/
   if( m_fi.file_read_tb_c( w_val_len, s_val ) != 0 )
   {  return( -2 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_cont()
{
   /*----------------------------------------------------------------------*/
   if( read_val_size2( m_s_title )     != 0 ) { return( -1 ) ; }
   if( read_val_size2( m_s_artist )    != 0 ) { return( -2 ) ; }
   if( read_val_size2( m_s_copyright ) != 0 ) { return( -3 ) ; }
   if( read_val_size2( m_s_comment )   != 0 ) { return( -4 ) ; }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
static wxString st_real_info_fcc_audio( wxUint32 dw_fcc )
{
   /*----------------------------------------------------------------------*/
   const char *p_c_fcc = ( char * )&dw_fcc ;

   /*----------------------------------------------------------------------*/
   if(    !isprint( p_c_fcc[ 0 ] )
       || !isprint( p_c_fcc[ 1 ] )
       || !isprint( p_c_fcc[ 2 ] )
       || !isprint( p_c_fcc[ 3 ] )
     )
   {  return( wxEmptyString ) ; }

   /*----------------------------------------------------------------------*/
   switch( SR_FOURCC( toupper( p_c_fcc[ 0 ] ),
                      toupper( p_c_fcc[ 1 ] ),
                      toupper( p_c_fcc[ 2 ] ),
                      toupper( p_c_fcc[ 3 ] )
                    )
         )
   {
      /*-------------------------------------------------------------------*/
      case SR_FOURCC( 'L','P','C','J' ) :
      case SR_FOURCC( '1','4','_','4' ) :
         return( "RealAudio 1.0" ) ;
      case SR_FOURCC( '2','8','_','8' ) :
         return( "RealAudio 2.0" ) ;
      case SR_FOURCC( 'D','N','E','T' ) :
         return( "AC3" ) ;
      case SR_FOURCC( 'S','I','P','R' ) :
         return( "Sipro" ) ;
      case SR_FOURCC( 'C','O','O','K' ) :
         return( "Cook" ) ;
      case SR_FOURCC( 'A','T','R','C' ) :
         return( "ATRAC" ) ;
      case SR_FOURCC( 'R','A','L','F' ) :
         return( "RealAudio Lossless" ) ;
      case SR_FOURCC( 'R','A','A','C' ) :
         return( "LC AAC" ) ;
      case SR_FOURCC( 'R','A','C','P' ) :
         return( "HE AAC" ) ;
      /*-------------------------------------------------------------------*/
      default :
         return( wxString::Format( "Audio (%c%c%c%c)",
                                   p_c_fcc[ 0 ], p_c_fcc[ 1 ],
                                   p_c_fcc[ 2 ], p_c_fcc[ 3 ]
                                 )
               ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::audio_codec()
{
   /*----------------------------------------------------------------------*/
   wxUint16 w_version    ;
   wxUint32 dw_codec = 0 ;

   /*----------------------------------------------------------------------*/
   if( m_fa.read_be_data( w_version ) != 0 ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   if( w_version == 3 )
   {
      /*-------------------------------------------------------------------*/
      wxUint16 w_header_size = 0 ;
      /*-------------------------------------------------------------------*/
      if( m_fa.read_be_data( w_header_size ) != 0 ) { return( -2 ) ; }
      if( m_fa.skip_nb_byte( 10 + 4 ) != 0 ) { return( -3 ) ; }
      /*-------------------------------------------------------------------*/
      if( read_meta_audio() != 0 ) { return( -4 ) ; }
      /*--( Codec info are present ? )-------------------------------------*/
      if( w_header_size + 8 - m_fa.get_offset() >= 4 )
      {  if( m_fa.skip_nb_byte( 2 ) != 0 ) { return( -5 ) ; }
         if( m_fa.read_data( dw_codec ) != 0 ) { return( -6 ) ; }
      }
      /*--( Always the case in rm3 )---------------------------------------*/
      m_i_nb_channel = 1    ;
      m_i_samprate   = 8000 ;
      /*-------------------------------------------------------------------*/
      if( m_boo_audio_file && m_i_samprate > 0 )
      {  m_i_duration =   ( m_f.get_size().ToULong() - m_fa.get_offset() )
                        * 8 / m_i_samprate ;
      }
      /*-------------------------------------------------------------------*/
   }
   else
   {
      /*-------------------------------------------------------------------*/
      wxUint16 w_samprate ;
      wxUint16 w_bitrate  ;
      wxUint16 w_channels ;
      /*-------------------------------------------------------------------*/
      if( m_fa.skip_nb_byte(   2 + 4 + 4 + 2 + 4 + 2 + 4 + 12 + 4 * 2
                             + ( w_version == 5 ? 6 : 0 )
                           ) != 0
        )
      {  return( -7 ) ; }
      if( m_fa.read_be_data( w_samprate ) != 0 ) { return( -8 ) ; }
      if( m_fa.skip_nb_byte( 2 ) != 0 ) { return( -9 ) ; }
      if( m_fa.read_be_data( w_bitrate ) != 0 ) { return( -10 ) ; }
      if( m_fa.read_be_data( w_channels ) != 0 ) { return( -11 ) ; }

      /*-------------------------------------------------------------------*/
      if( m_fa.skip_nb_byte( w_version == 5 ? 4 : 6 ) != 0 )
      { return( -12 ) ; }
      if( m_fa.read_data( dw_codec ) != 0 )
      {  return( -13 ) ; }

      /*-------------------------------------------------------------------*/
      m_i_samprate   = w_samprate ;
      m_i_bitrate    = w_bitrate  ;
      m_i_nb_channel = w_channels ;

      /*-------------------------------------------------------------------*/
      if( m_boo_audio_file )
      {
         /*----------------------------------------------------------------*/
         if( m_fa.skip_nb_byte( 3 ) != 0 ) { return( -14 ) ; }
         /*----------------------------------------------------------------*/
         if( read_meta_audio() != 0 ) { return( -15 ) ; }
         /*----------------------------------------------------------------*/
         if( m_i_samprate > 0 && m_i_nb_channel > 0 )
         {  m_i_duration =   ( m_f.get_size().ToULong() - m_fa.get_offset() )
                           * 8 / m_i_nb_channel
                           / m_i_samprate ;
         }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( Codec description )-----------------------------------------------*/
   m_fi.add_codec_info( st_real_info_fcc_audio( dw_codec ), m_s_audio_info );
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::video_codec()
{
   /*----------------------------------------------------------------------*/
   str_real_video_data rvd     ;
   wxString            s_codec ;

   /*----------------------------------------------------------------------*/
   m_boo_has_video = true ;
   /*----------------------------------------------------------------------*/
   if( read_be_data( rvd ) != 0 ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_video_x_y( rvd.w_width, rvd.w_height ) ;
   m_fi.init_video_fps( ( double )( ( rvd.w_fps1 << 16 ) | rvd.w_fps2
                                  ) / ( 1 << 16 )
                      ) ;
   /*----------------------------------------------------------------------*/
   m_fi.info_fcc_video( ( char * )&rvd.dw_codec, s_codec ) ;
   m_fi.add_codec_info( s_codec, m_s_video_info ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_prop()
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_duration_ms ;
   /*----------------------------------------------------------------------*/
   if( m_fa.skip_nb_byte( 20 ) != 0 ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( m_fa.read_be_data( dw_duration_ms ) != 0 ) { return( -2 ) ; }
   m_i_duration = dw_duration_ms / 1000 ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::read_mdpr()
{
   /*----------------------------------------------------------------------*/
   wxUint8  b_len ;
   str_atom atom  ;

   /*----------------------------------------------------------------------*/
   if( m_fa.skip_nb_byte( 30 ) != 0 ) { return( -1 ) ; }

   /*--( Skip the name of the stream )-------------------------------------*/
   if(    m_fa.read_data( b_len ) != 0
       || m_fa.skip_nb_byte( b_len ) != 0
      )
   {  return( -2 ) ; }

   /*--( Skip the mime type of the stream )--------------------------------*/
   if(    m_fa.read_data( b_len ) != 0
       || m_fa.skip_nb_byte( b_len ) != 0
     )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   if( m_fa.read_be_data( atom ) != 0 ) { return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   if( atom.dw_id == SR_FOURCC( '.','r','a',0xFD ) )
   {  /*--( Only one of a kind ! )-----------------------------------------*/
      if( !m_boo_audio_done )
      {  if( audio_codec() != 0 ) { return( -5 ) ; }
         m_boo_audio_done = true ;
      }
      /*-------------------------------------------------------------------*/
   }
   else
   {  /*-------------------------------------------------------------------*/
      if( m_fa.read_data( atom.dw_id ) != 0 ) { return( -6 ) ; }
      /*-------------------------------------------------------------------*/
      if( atom.dw_id == SR_FOURCC( 'V','I','D','O' ) )
      {  /*--( Only one of a kind ! )--------------------------------------*/
         if( !m_boo_video_done )
         {  if( video_codec() != 0 ) { return( -7 ) ; }
            m_boo_video_done = true ;
         }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CFileInit_real::init_col()
{
   /*----------------------------------------------------------------------*/
   if( m_i_duration >= 0 )
   {  /*-------------------------------------------------------------------*/
      if( m_boo_has_video )
      {  m_fi.init_video_duration( m_i_duration ) ; }
      else
      {  m_fi.init_audio_duration( m_i_duration ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( m_i_nb_channel > 0 )
   {  /*-------------------------------------------------------------------*/
      if( m_boo_has_video )
      {  m_fi.init_video_channel( m_i_nb_channel ) ; }
      else
      {  m_fi.init_audio_channel( m_i_nb_channel ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( !m_boo_has_video && m_i_bitrate > 1 )
   {  m_fi.init_audio_bitrate( TBR_CBR, m_i_bitrate ) ; }
   /*----------------------------------------------------------------------*/
   if( m_i_samprate > 0 )
   {  /*-------------------------------------------------------------------*/
      if( m_boo_has_video )
      {  m_fi.init_video_samprate( m_i_samprate ) ; }
      else
      {  m_fi.init_audio_samprate( m_i_samprate ) ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( !m_s_audio_info.empty() || !m_s_video_info.empty() )
   {  /*-------------------------------------------------------------------*/
      m_f.val_s( m_boo_has_video ? COL_VIDEO_INFO : COL_AUDIO_INFO
               ) = m_fi.concat_av_codecs( m_s_audio_info, m_s_video_info ) ;
      /*-------------------------------------------------------------------*/
   }

   /*--( Convert numbers to strings )--------------------------------------*/
   if( !m_boo_has_video ) { m_f.init_info_s_track() ; }

   /*----------------------------------------------------------------------*/
   if( !m_s_title.empty() )
   {  /*-------------------------------------------------------------------*/
      m_f.val_s( m_boo_has_video ? COL_VIDTAG_TITLE : COL_AUDTAG_TITLE
               ) = m_s_title ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( !m_s_artist.empty() )
   {  /*-------------------------------------------------------------------*/
      m_f.val_s( m_boo_has_video ? COL_VIDTAG_ARTIST : COL_AUDTAG_ARTIST
               ) = m_s_artist ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( !m_s_copyright.empty() )
   {  /*-------------------------------------------------------------------*/
      m_f.val_s( m_boo_has_video
                 ? COL_VIDTAG_COPYRIGHT : COL_AUDTAG_COPYRIGHT
               ) = m_s_copyright ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( !m_s_comment.empty() )
   {  /*-------------------------------------------------------------------*/
      m_f.val_s( m_boo_has_video ? COL_VIDTAG_COMMENT : COL_AUDTAG_COMMENT
               ) = m_s_comment ;
      /*-------------------------------------------------------------------*/
   }
   /*--( Set here because there are two exits in "real_read" )-------------*/
   m_fi.m_s_type_det = ( m_boo_has_video ? "rm" : "ra" ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_real::real_read()
{
   /*----------------------------------------------------------------------*/
   str_chunk chunk     ;
   wxUint32  dw_size   ;
   wxUint16  w_version ;

   /*--( Is it a valid REAL file ? )---------------------------------------*/
   if( m_fa.read_data( chunk.dw_id ) != 0 )
   {  return( -1 ) ; }

   /*-----------------------------------------------------------------------+
   ! Pure audio file ?                                                      !
   +-----------------------------------------------------------------------*/
   if( chunk.dw_id == SR_FOURCC( '.','r','a',0xFD ) )
   {  /*-------------------------------------------------------------------*/
      m_boo_audio_file = true ;
      if( audio_codec() != 0 ) { return( -2 ) ; }
      init_col() ;
      return( 0 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! Else it should be a Real Media File                                    !
   +-----------------------------------------------------------------------*/
   if( chunk.dw_id != SR_FOURCC( '.','R','M','F' ) )
   {  return( -3 ) ; }

   /*--( Skip this RMF )---------------------------------------------------*/
   if(    m_fa.read_be_data( chunk.dw_size ) != 0
       || m_fa.skip_nb_byte( chunk.dw_size - sizeof( chunk ) ) != 0
     )
   {  return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   while(    m_fa.read_be_data( chunk ) == 0
          && chunk.dw_id != SR_FOURCC( 'D','A','T','A' )
        )
   {
      /*-------------------------------------------------------------------*/
      if( m_fa.read_be_data( w_version ) != 0 ) { return( -5 ) ; }
      /*-------------------------------------------------------------------*/
      dw_size = chunk.dw_size - sizeof( chunk ) - sizeof( w_version ) ;
      /*--( Only the 0 version will be "analysed" )------------------------*/
      if( w_version == 0 )
      {
         /*----------------------------------------------------------------*/
         wxFileOffset fo_sav = m_fa.get_offset() ;
         /*----------------------------------------------------------------*/
         switch( chunk.dw_id )
         {
            /*-------------------------------------------------------------*/
            case SR_FOURCC( 'P','R','O','P' ) :
               if( read_prop() != 0 ) { return( -6 ) ; }
               break ;
            /*-------------------------------------------------------------*/
            case SR_FOURCC( 'M','D','P','R' ) :
               if( read_mdpr() != 0 ) { return( -7 ) ; }
               break ;
            /*-------------------------------------------------------------*/
            case SR_FOURCC( 'C','O','N','T' ) :
               if( read_cont() != 0 ) { return( -8 ) ; }
               break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         dw_size -= m_fa.get_offset() - fo_sav ;
         /*----------------------------------------------------------------*/
      }

      /*--( Skip the unread part of the chunk )----------------------------*/
      if( dw_size > 0 && m_fa.skip_nb_byte( dw_size ) != 0 )
      {  return( -9 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( The info has to be put in the right group: audio/video )----------*/
   init_col() ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_real()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "ra/rm" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_real( *this ).real_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_real.cpp                       !
+==========================================================================*/
