/*====================================+=====================================+
! File CFileInit_pnm.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                       Image files ".pnm", ".ppm"                          !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/wfstream.h>
#include <wx/txtstrm.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Not all parameters are used to have a "coherent" prototype for all image  !
! extract information functions.                                            !
! Maybe one day to call them through a function pointer.                    !
+--------------------------------------------------------------------------*/
int CFileInit::pnm_read( wxFileOffset WXUNUSED( fo_image_offset ),
                         wxULongLong WXUNUSED( ull_image_size )
                       )
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream input( m_fa ) ;
   wxTextInputStream text( input ) ;
   wxString          s_line        ;
   long              l_width       ;
   long              l_height      ;

   /*--( The first line begins with a code identifying the PNM format )----*/
   s_line = text.ReadLine() ;
   if(    s_line.empty() || input.Eof()
       || s_line.size() > 3 || s_line[ 0 ] != 'P'
     )
   {  return( -1 ) ; }

   /*--( Then may come a comment )-----------------------------------------*/
   s_line = text.ReadLine() ;
   if( s_line.empty() || input.Eof() )
   {  return( -2 ) ; }
   if( s_line[ 0 ] == '#' )
   {
      /*-------------------------------------------------------------------*/
      s_line.Remove( 0, 1 ).Trim( false ) ;
      if( prepare_string( s_line ) > 0 )
      {  m_f.val_s( COL_IMG_INFO ) = s_line ; }
      /*-------------------------------------------------------------------*/
      s_line = text.ReadLine() ;
      if( s_line.empty() || input.Eof() )
      {  return( -3 ) ; }
      /*-------------------------------------------------------------------*/
   }

   /*--( Then comes a line with the image size )---------------------------*/
   if( wxSscanf( s_line, "%d %d", &l_width, &l_height ) != 2 )
   {  return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   init_img_x_y( l_width, l_height ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_pnm()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "pnm" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = pnm_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_pnm.cpp                       !
+==========================================================================*/
