/*====================================+=====================================+
! File CFileInit_pcx.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                          Image files ".pcx"                               !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_pcx_header ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_pcx : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_pcx( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_le_data( str_pcx_header &pxh ) ;
      int pcx_read( wxFileOffset WXUNUSED( fo_image_offset ),
                    wxULongLong WXUNUSED( ull_image_size )
                  ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_pcx_header
{
   /*----------------------------------------------------------------------*/
   wxUint8  b_Manufacturer      ; // Constant Flag, 10 = ZSoft .pcx
   wxUint8  b_Version           ;
   wxUint8  b_Encoding          ; // 1 = .PCX run length encoding
   wxUint8  b_BitsPerPixel      ;
   wxUint16 w_window_xmin       ;
   wxUint16 w_window_ymin       ;
   wxUint16 w_window_xmax       ;
   wxUint16 w_window_ymax       ;
   wxUint16 ___w_HDpi           ; // Horizontal Resolution of image in DPI
   wxUint16 ___w_VDpi           ; // Vertical Resolution of image in DPI*
   wxUint8  tb_b_Colormap[ 48 ] ; // Colour palette setting, see text
   wxUint8  b_Reserved          ; // Should be set to 0.
   wxUint8  b_NPlanes           ; // Number of colour planes
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_pcx::read_le_data( str_pcx_header &pxh )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( pxh ), &pxh ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   pxh.w_window_xmin = wxUINT16_SWAP_ALWAYS( pxh.w_window_xmin ) ;
   pxh.w_window_ymin = wxUINT16_SWAP_ALWAYS( pxh.w_window_ymin ) ;
   pxh.w_window_xmax = wxUINT16_SWAP_ALWAYS( pxh.w_window_xmax ) ;
   pxh.w_window_ymax = wxUINT16_SWAP_ALWAYS( pxh.w_window_ymax ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Not all parameters are used to have a "coherent" prototype for all image  !
! extract information functions.                                            !
! Maybe one day to call them through a function pointer.                    !
+--------------------------------------------------------------------------*/
int CFileInit_pcx::pcx_read( wxFileOffset WXUNUSED( fo_image_offset ),
                             wxULongLong WXUNUSED( ull_image_size )
                           )
{
   /*----------------------------------------------------------------------*/
   str_pcx_header header    ;
   const char     *p_c_info ;

   /*----------------------------------------------------------------------*/
   if( read_le_data( header ) != 0 ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( header.b_Manufacturer != 0x0A || header.b_Encoding != 0x01 )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   switch( header.b_Version )
   {
      /*-------------------------------------------------------------------*/
      case 0 : p_c_info = "PC Paintbrush 2.5" ; break ;
      case 2 : p_c_info = "PC Paintbrush 2.8 w/palette info" ; break ;
      case 3 : p_c_info = "PC Paintbrush 2.8 w/o palette info" ; break ;
      case 4 : p_c_info = "PC Paintbrush for Windows" ; break ;
      case 5 : p_c_info = "PC Paintbrush 3.0" ; break ;
      /*-------------------------------------------------------------------*/
      default : p_c_info = NULL ; break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( p_c_info != NULL ) { m_f.val_s( COL_IMG_INFO ) = p_c_info ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_img_x_y( header.w_window_xmax - header.w_window_xmin + 1 ,
                      header.w_window_ymax - header.w_window_ymin + 1
                    ) ;
   /*----------------------------------------------------------------------*/
   m_fi.init_img_bpp( header.b_BitsPerPixel * header.b_NPlanes ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_pcx()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "pcx" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = pcx_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
!                                                                           !
! This function is directly used by other init modules ...                  !
!                                                                           !
+--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int CFileInit::pcx_read( wxFileOffset fo_offset, wxULongLong ull_size )
{  return( CFileInit_pcx( *this ).pcx_read( fo_offset, ull_size ) ) ; }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_pcx.cpp                       !
+==========================================================================*/
