/*====================================+=====================================+
! File CFileInit_mrw.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                  Image files ".mrw": Minolta RAW                          !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_mrw_block ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_mrw : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_mrw( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_be_data( str_mrw_block &mb ) ;
      int mrw_read() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_mrw_block
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_signature ;
   wxUint32 dw_size      ; // Following data size
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_mrw::read_be_data( str_mrw_block &mb )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( mb ), &mb ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   mb.dw_signature = wxUINT32_SWAP_ALWAYS( mb.dw_signature ) ;
   mb.dw_size      = wxUINT32_SWAP_ALWAYS( mb.dw_size      ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_mrw::mrw_read()
{
   /*----------------------------------------------------------------------*/
   str_mrw_block block                 ;
   bool          boo_data_read = false ;

   /*----------------------------------------------------------------------*/
   if( read_be_data( block ) != 0 )
   {  return( -1 ) ; }

   /*--( File main block )-------------------------------------------------*/
   if( block.dw_signature != SR_FOURCC( 'M', 'R', 'M', '\0' ) )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   do
   {  /*-------------------------------------------------------------------*/
      if( read_be_data( block ) != 0 )
      {  return( -3 ) ; }
      /*--------------------------------------------------------------------+
      ! Seems all the data in the other blocks are present in the TTW ...   !
      +--------------------------------------------------------------------*/
      if( block.dw_signature == SR_FOURCC( 'W', 'T', 'T', '\0' ) )
      {
         /*----------------------------------------------------------------*/
         boo_data_read = true ;
         /*--( After this call the pointer is at the end of the data )-----*/
         if( m_fi.tiff_read_tiff( m_fa.get_offset(), block.dw_size ) != 0 )
         {  return( -4 ) ; }
         /*----------------------------------------------------------------*/
      }
      else /*--( Jump over the data )--------------------------------------*/
      if( block.dw_size != 0 && m_fa.skip_nb_byte( block.dw_size ) != 0 )
      {  return( -5 ) ; }
      /*-------------------------------------------------------------------*/
   } while( !boo_data_read ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_mrw()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "mrw" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_mrw( *this ).mrw_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_mrw.cpp                        !
+==========================================================================*/
