/*====================================+=====================================+
! File CFileInit_mo.cpp               ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!             GNU MO Files: ".mo" : "compiled" translation file             !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_mo : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_mo( CFileInit &parent )
                  : CFileInit_type_base( parent ),
                    m_boo_swap( false ) // for cppcheck
      {  ; }

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool m_boo_swap ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxUint32 swap_if_needed( const wxUint32 dw )
      {  return( m_boo_swap ? wxUINT32_SWAP_ALWAYS( dw ) : dw ) ; }
      int mo_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_mo_header
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_magic_number   ;
   wxUint32 dw_format_rev     ;
   wxUint32 dw_nb_strings     ;
   wxUint32 dw_off_original   ;
   wxUint32 dw_off_translated ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
struct str_mo_len_off
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_length ;
   wxUint32 dw_offset ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
static int st_mo_conv_tag_col( const wxString &s_var )
{
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Project-Id-Version" ) == 0 )
   {  return( COL_DOC_TITLE ) ; }
   if( s_var.CmpNoCase( "Content-Type" ) == 0 )
   {  return( COL_DOC_VERSION ) ; }
   if( s_var.CmpNoCase( "POT-Creation-Date" ) == 0 )
   {  return( COL_DOC_CRE_DATE ) ; }
   if( s_var.CmpNoCase( "PO-Revision-Date" ) == 0 )
   {  return( COL_DOC_MOD_DATE ) ; }
   if( s_var.CmpNoCase( "Language-Team" ) == 0 )
   {  return( COL_DOC_AUTHOR ) ; }
   /*--( Normally they appear in the same order as below )-----------------*/
   if(    s_var.CmpNoCase( "Language" ) == 0
       || s_var.CmpNoCase( "X-Poedit-Language" ) == 0
     )
   {  return( COL_DOC_SUBJECT ) ; }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_mo::mo_read()
{
   /*----------------------------------------------------------------------*/
   const wxUint32 co_dw_magic_number = 0x950412de ;
   str_mo_header  header  ;
   str_mo_len_off len_off ;
   wxMemoryBuffer mb_info ;

   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( header ), &header ) != 0 )
   {  return( -1 ) ; }

   /*-----------------------------------------------------------------------+
   ! The file may have been generated on a little or a big endian system.   !
   ! The magic number will tell.                                            !
   +-----------------------------------------------------------------------*/
   if( header.dw_magic_number == co_dw_magic_number )
   {  m_boo_swap = false ; }
   else
   if( wxUINT32_SWAP_ALWAYS( header.dw_magic_number ) == co_dw_magic_number )
   {  m_boo_swap = true ; }
   else
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   unsigned long ul_nb_strings = swap_if_needed( header.dw_nb_strings ) ;
   /*--( The translation information is part of this "count" )-------------*/
   m_f.val_ll( COL_DOC_LINECOUNT ) = ul_nb_strings ;
   m_f.val_s( COL_DOC_LINECOUNT ).Printf( "%lu", ul_nb_strings ) ;
   /*----------------------------------------------------------------------*/
   if( ul_nb_strings == 0 )
   {  return( 0 ) ; }

   /*-----------------------------------------------------------------------+
   ! The first "translated" string is supposed to contain information.      !
   ! The original must be empty.                                            !
   +-----------------------------------------------------------------------*/
   if(    m_fa.set_offset( swap_if_needed( header.dw_off_original ) ) != 0
       || m_fa.read_buffer( sizeof( len_off ), &len_off ) != 0
     )
   {  return( -3 ) ; }
   /*--( The original must be empty )--------------------------------------*/
   if( len_off.dw_length != 0 )
   {  return( 0 ) ; }

   /*--( First read the information of the translated string )-------------*/
   if(    m_fa.set_offset( swap_if_needed( header.dw_off_translated ) ) != 0
       || m_fa.read_buffer( sizeof( len_off ), &len_off ) != 0
     )
   {  return( -4 ) ; }

   /*--( Something to work on ? )------------------------------------------*/
   if( len_off.dw_length == 0 )
   {  return( 0 ) ; }

   /*--( Then read it: the final '\0' which is not counted in the length )-*/
   if(    m_fa.set_offset( swap_if_needed( len_off.dw_offset ) ) != 0
       || m_fa.read_buffer( swap_if_needed( len_off.dw_length ) + 1,
                            mb_info
                          ) != 0
     )
   {  return( -5 ) ; }

   /*--( Check the presence of the final '\0' )----------------------------*/
   char *p_c_buffer = ( char * )mb_info.GetData() ;
   if( p_c_buffer[ mb_info.GetDataLen() - 1 ] != '\0' )
   {  return( -6 ) ; }

   /*-----------------------------------------------------------------------+
   ! Data are stored as "var:val" lines                                     !
   ! Date format doesn't seem to be clearly specified. wxWidgets will find  !
   ! it ... cf: wxParseDateTime                                             !
   ! Lines maybe be separated with "\r\n" or "\n". It is interesting        !
   ! because "strtok" doesn't return an empty item when delimiters are      !
   ! contiguous.                                                            !
   +-----------------------------------------------------------------------*/
   const wxString co_s_delim = "\r\n" ;
   char     *p_c_line ;
   char     *p_c_save ;
   wxString s_var ;
   wxString s_val ;
   int      i_col ;
   /*----------------------------------------------------------------------*/
   for( p_c_line = wxStrtok( p_c_buffer, co_s_delim, &p_c_save ) ;
        p_c_line != NULL ;
        p_c_line = wxStrtok( NULL, co_s_delim, &p_c_save )
      )
   {
      /*--( Name and value are separated by a ':' )------------------------*/
      s_var = wxString( p_c_line, wxConvUTF8 ).BeforeFirst( ':', &s_val ) ;
      /*--( The ':' is normally followed by a space )----------------------*/
      if( !s_val.empty() && s_val[ 0 ] == ' ' )
      {  s_val.erase( 0, 1 ) ; }

      /*--( Managed variable ? )-------------------------------------------*/
      if( ( i_col = st_mo_conv_tag_col( s_var ) ) == COL_NB )
      {  continue ; }
      /*-------------------------------------------------------------------*/
      sr::clean_string( s_val ) ;
      /*--------------------------------------------------------------------+
      ! "Language" can be empty. Therefore it is not reserved to use        !
      ! "poedit"'s specific tag.                                            !
      +--------------------------------------------------------------------*/
      if(    ( i_col != COL_DOC_SUBJECT || !s_val.empty() )
          && !m_fi.reserve_col( i_col )
        )
      {  continue ; }

      /*--( Remove "useless" stuff to keep only the charset info )---------*/
      if(    i_col == COL_DOC_VERSION
          && s_val.StartsWith( "text/plain; charset=" )
        )
      {  s_val.erase( 0, 20 ) ; }

      /*-------------------------------------------------------------------*/
      if( s_val.empty() ) { continue ; }

      /*-------------------------------------------------------------------*/
      if( i_col != COL_DOC_CRE_DATE && i_col != COL_DOC_MOD_DATE )
      {  m_f.val_s( i_col ) = s_val ; }
      else
      {  /*----------------------------------------------------------------*/
         wxDateTime       dt  ;
         sr::wxString_cit cit ;
         /*----------------------------------------------------------------*/
         if( dt.ParseDateTime( s_val, &cit ) )
         {  m_fi.init_date( i_col, dt ) ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_mo()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "mo" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_mo( *this ).mo_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_mo.cpp                         !
+==========================================================================*/
