/*====================================+=====================================+
! File CFileInit_jpg.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                        Image files ".ipg"                                 !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! Only the first image of the file is scanned/analysed.                     !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_jpg_sof_header ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_jpg : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_jpg( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_be_data( str_jpg_sof_header &jsh ) ;
      int jpg_read( wxFileOffset WXUNUSED( fo_offset_image ),
                    wxULongLong  WXUNUSED( ull_image_size )
                  ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_jpg_sof_header
{
   /*----------------------------------------------------------------------*/
   wxUint8  ___b_sample_precision ;
   wxUint16 w_y                   ;
   wxUint16 w_x                   ;
   wxUint8  b_nf                  ;
   wxUint8  ___b_comp_ident       ;
   wxUint8  ___b_sampling_factor  ;
   wxUint8  ___b_quant_table      ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_jpg::read_be_data( str_jpg_sof_header &jsh )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( jsh ), &jsh ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxLITTLE_ENDIAN
   jsh.w_y = wxUINT16_SWAP_ALWAYS( jsh.w_y ) ;
   jsh.w_x = wxUINT16_SWAP_ALWAYS( jsh.w_x ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}


/*-------------------------------------------------------------------------*/
typedef wxUint8 t_jpg_marker     [ 2 ] ;
typedef char    t_jpg_exif_header[ 6 ] ;
/*-------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------*/
int CFileInit_jpg::jpg_read( wxFileOffset WXUNUSED( fo_offset_image ),
                             wxULongLong  WXUNUSED( ull_image_size )
                           )
{
   /*----------------------------------------------------------------------*/
   t_jpg_marker       marker                 ;
   wxUint16           w_marker_size          ;
   t_jpg_exif_header  exif_header            ;
   str_jpg_sof_header sof_header             ;
   bool               boo_end        = false ;
   bool               boo_sof_found  = false ;
   bool               boo_com_found  = false ;
   wxFileOffset       fo_offset_exif = -1    ;
   wxFileOffset       fo_offset_iptc = -1    ;
   int                i_marker_size          ;

   /*--( First, read the SOI : FFD8 )--------------------------------------*/
   if(    m_fa.read_buffer( sizeof( marker ), &marker ) != 0
       || marker[ 0 ] != 0xFF
       || marker[ 1 ] != 0xD8
     )
   {  return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   do
   {
      /*--( Read the marker )----------------------------------------------*/
      if( m_fa.read_buffer( sizeof( marker ), &marker ) != 0 )
      {  return( -2 ) ; }

      /*--( Only 0xFF markers should be found )----------------------------*/
      if( marker[ 0 ] != 0xFF ) { return( -3 ) ; }

      /*--------------------------------------------------------------------+
      ! Found the SOS : Start of scan ?                                     !
      ! Found the EOI : End of image ?                                      !
      ! The SOS (Start of scan) seems to be last in the list of the ones    !
      ! that are interesting.                                               !
      +--------------------------------------------------------------------*/
      if( marker[ 1 ] == 0xDA || marker[ 1 ] == 0xD9 )
      {  boo_end = true ; continue ; }

      /*--( Read the associated size )-------------------------------------*/
      if( m_fa.read_be_data( w_marker_size ) != 0 )
      {  return( -4 ) ; }

      /*--( Size is included in total size ... it has to be subtracted )---*/
      i_marker_size = ( int )w_marker_size - sizeof( w_marker_size ) ;

      /*--( Tag APP1 ? )---------------------------------------------------*/
      switch( marker[ 1 ] )
      {
         /*--( Tag APP1 : may contain Exif information )-------------------*/
         case 0xE1 :
         {
            /*-------------------------------------------------------------*/
            if( fo_offset_exif >= 0 ) { break ; }
            /*--( It must be followed by a constant string: "Exif\0\0" )---*/
            if( i_marker_size < ( int )sizeof( exif_header ) )
            {  break ; }
            /*-------------------------------------------------------------*/
            if( m_fa.read_buffer( sizeof( exif_header ), exif_header ) != 0 )
            {  return( -5 ) ; }
            /*-------------------------------------------------------------*/
            i_marker_size -= sizeof( exif_header ) ;
            /*--( The string constant ends with two '\0' )-----------------*/
            if( memcmp( exif_header, "Exif\0", sizeof( exif_header ) ) == 0 )
            {  /*----------------------------------------------------------*/
               fo_offset_exif = m_fa.get_offset() ;
               /*--( Don't exit on an error )------------------------------*/
               m_fi.tiff_read_exif( fo_offset_exif, i_marker_size ) ;
               /*--( Set the file pointer after the data ... )-------------*/
               if( m_fa.set_offset( fo_offset_exif + i_marker_size ) != 0 )
               {  return( -6 ) ; }
               /*--( Don't need to jump any more, it's already done )------*/
               i_marker_size = 0 ;
               /*----------------------------------------------------------*/
            }
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }

         /*--( Tag APP13: may contain IPTC information )-------------------*/
         case 0xED :
         {
            /*-------------------------------------------------------------*/
            if( fo_offset_iptc >= 0 ) { break ; }
            /*-------------------------------------------------------------*/
            fo_offset_iptc = m_fa.get_offset() ;
            /*-------------------------------------------------------------*/
            m_fi.read_iptc( fo_offset_iptc, i_marker_size, true ) ;
            /*--( Don't exit on an error )---------------------------------*/
            if( m_fa.set_offset( fo_offset_iptc + i_marker_size ) != 0 )
            {  return( -7 ) ; }
            /*--( Don't need to jump any more, it's already done )---------*/
            i_marker_size = 0 ;
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }

         /*--( Tag SOF ... It contains the general information ... )-------*/
         case 0xC0 : case 0xC1 : case 0xC2 : case 0xC3 :
         case 0xC9 : case 0xCA : case 0xCB :
         {
            /*-------------------------------------------------------------*/
            if( boo_sof_found ) { break ; }
            /*-------------------------------------------------------------*/
            if( i_marker_size < ( int )sizeof( sof_header ) ) { break ; }
            /*-------------------------------------------------------------*/
            if( read_be_data( sof_header ) != 0 )
            {  return( -7 ) ; }
            /*-------------------------------------------------------------*/
            boo_sof_found  = true                 ;
            i_marker_size -= sizeof( sof_header ) ;
            /*-------------------------------------------------------------*/
            m_fi.init_img_x_y( sof_header.w_x, sof_header.w_y ) ;
            m_fi.init_img_bpp( sof_header.b_nf * 8 ) ;
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }

         /*--( Tag COM )---------------------------------------------------*/
         case 0xFE :
         {
            /*-------------------------------------------------------------*/
            if( boo_com_found ) { break ; }
            /*--( At least one char ... )----------------------------------*/
            if( i_marker_size <= 0 ) { break ; }
            /*-------------------------------------------------------------*/
            wxString s_com ;
            /*--( Gimp allows UTF8 in comments )---------------------------*/
            m_fi.set_conv_from_utf8() ;
            /*-------------------------------------------------------------*/
            if( m_fi.file_read_tb_c( i_marker_size, s_com ) != 0 )
            {  break ; }
            /*-------------------------------------------------------------*/
            boo_com_found = true ;
            /*-------------------------------------------------------------*/
            if( !s_com.empty() )
            {  m_f.val_s( COL_IMG_INFO ) = s_com ; }
            /*--( Don't need to jump any more, it's already done )---------*/
            i_marker_size = 0 ;
            /*-------------------------------------------------------------*/
            break ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }

      /*--( Jump !! )------------------------------------------------------*/
      if( i_marker_size > 0 && m_fa.skip_nb_byte( i_marker_size ) != 0 )
      {  return( -9 ) ; }

      /*--( The Exif marker is before the SOFs (standard) )----------------*/
   } while( !boo_end && ( !boo_sof_found || !boo_com_found ) ) ;

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_jpg()
{
   /*----------------------------------------------------------------------*/
   wxULongLong ull_image_size = m_f.get_size() ;
   int         i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "jpg" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = jpg_read( 0, ull_image_size ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
!                                                                           !
! This function is directly used by other init modules ...                  !
!                                                                           !
+--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int CFileInit::jpg_read( wxFileOffset fo_offset, wxULongLong ull_size )
{  return( CFileInit_jpg( *this ).jpg_read( fo_offset, ull_size ) ) ; }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CFileInit_jpg.cpp                      !
+==========================================================================*/
