/*====================================+=====================================+
! File CFileInit_ico.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                        Image files ".ico",".cur"                          !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_ICONDIR ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_ico : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_ico( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_le_data( str_ICONDIR &id ) ;
      int ico_read( wxFileOffset fo_image_offset,
                    wxULongLong  ull_image_size
                  ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_ICONDIR
{
   /*----------------------------------------------------------------------*/
   wxUint16 w_idReserved     ; // Reserved (must be 0)
   wxUint16 w_idType         ; // Resource Type (1:icons,2:cursor)
   wxUint16 w_idCount        ; // How many images?
   /*--( First Icon info )----------------------------------------------*/
   wxUint8  b_bWidth         ; // Width, in pixels, of the image
   wxUint8  b_bHeight        ; // Height, in pixels, of the image
   wxUint8  ___b_bColorCount ; // Nb of colors in image (0 if >=8bpp)
   wxUint8  ___b_bReserved   ; // Reserved (must be 0)
   wxUint16 ___w_wPlanes     ; // Color Planes
   wxUint16 w_wBitCount      ; // Bits per pixel
   wxUint32 dw_dwBytesInRes  ; // How many bytes in this resource?
   wxUint32 dw_dwImageOffset ; // Where in the file is this image?
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_ico::read_le_data( str_ICONDIR &id )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( id ), &id ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   id.w_idReserved     = wxUINT16_SWAP_ALWAYS( id.w_idReserved     ) ;
   id.w_idType         = wxUINT16_SWAP_ALWAYS( id.w_idType         ) ;
   id.w_idCount        = wxUINT16_SWAP_ALWAYS( id.w_idCount        ) ;
   id.w_wBitCount      = wxUINT16_SWAP_ALWAYS( id.w_wBitCount      ) ;
   id.dw_dwBytesInRes  = wxUINT32_SWAP_ALWAYS( id.dw_dwBytesInRes  ) ;
   id.dw_dwImageOffset = wxUINT32_SWAP_ALWAYS( id.dw_dwImageOffset ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_ico::ico_read( wxFileOffset fo_image_offset,
                             wxULongLong  ull_image_size
                           )
{
   /*----------------------------------------------------------------------*/
   str_ICONDIR          ico_dir ;
   str_BITMAPINFOHEADER bmp_ih  ;

   /*----------------------------------------------------------------------*/
   if( read_le_data( ico_dir ) != 0 ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   if(    ico_dir.w_idReserved != 0
       || ( ico_dir.w_idType != 1 && ico_dir.w_idType != 2 )
       || ico_dir.w_idCount < 1
     )
   {  return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   if(    m_fa.set_offset( fo_image_offset + ico_dir.dw_dwImageOffset ) != 0
       || m_fa.read_le_data( bmp_ih ) != 0
     )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_img_x_y( ico_dir.b_bWidth, ico_dir.b_bHeight ) ;
   /*----------------------------------------------------------------------*/
   m_fi.init_img_bpp( bmp_ih.biBitCount ) ;
   /*----------------------------------------------------------------------*/
   wxString s_info ;
   if( ico_dir.w_idType == 1 )
   {  s_info = ( ico_dir.w_idCount ? "%02d icon" : "%02d icons" ) ; }
   else
   {  s_info = ( ico_dir.w_idCount ? "%02d cursor" : "%02d cursors" ) ; }
   m_f.val_s( COL_IMG_INFO ).Printf( s_info, ico_dir.w_idCount ) ;

   /*-----------------------------------------------------------------------+
   ! Minimal control for visualization problem ... it's a beginning         !
   +-----------------------------------------------------------------------*/
   if( ico_dir.dw_dwBytesInRes >= ull_image_size )
   {  return( -4 ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_ico()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "ico" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = ico_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
!                                                                           !
! This function is directly used by other init modules ...                  !
!                                                                           !
+--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int CFileInit::ico_read( wxFileOffset fo_offset, wxULongLong ull_size )
{  return( CFileInit_ico( *this ).ico_read( fo_offset, ull_size ) ) ; }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_ico.cpp                       !
+==========================================================================*/
