/*====================================+=====================================+
! File CFileInit_gif.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                        Image file ".gif"                                  !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_gif_header ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_gif : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_gif( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_le_data( str_gif_header &gh ) ;
      int gif_read( wxFileOffset fo_image_offset,
                    wxULongLong  ull_image_size
                  ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_gif_header
{
   /*----------------------------------------------------------------------*/
   wxUint8  tb_b_gif [ 3 ] ;
   wxUint8  tb_b_vers[ 3 ] ;
   wxUint16 w_x            ;
   wxUint16 w_y            ;
   wxUint8  b_pf           ; // packed fields
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_gif::read_le_data( str_gif_header &gh )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( gh ), &gh ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   gh.w_x = wxUINT16_SWAP_ALWAYS( gh.w_x ) ;
   gh.w_y = wxUINT16_SWAP_ALWAYS( gh.w_y ) ;
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_gif::gif_read( wxFileOffset fo_image_offset,
                             wxULongLong  ull_image_size
                           )
{
   /*----------------------------------------------------------------------*/
   str_gif_header header          ;
   wxUint8        b_eoi           ;
   wxUint8        tb_b_info[ 10 ] ;
   int            i_info_size     ;
   wxString       s_info          ;

   /*----------------------------------------------------------------------*/
   if( read_le_data( header ) != 0 ) { return( -1 ) ; }
   /*----------------------------------------------------------------------*/
   if( memcmp( header.tb_b_gif, "GIF", 3 ) != 0 )  { return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_img_x_y( header.w_x, header.w_y ) ;
   m_fi.init_img_bpp( ( header.b_pf & 0x07 ) + 1 ) ;

   /*----------------------------------------------------------------------*/
   i_info_size = sizeof( header.tb_b_gif ) + sizeof( header.tb_b_vers ) ;
   memcpy( tb_b_info, header.tb_b_gif, i_info_size ) ;
   if( m_fi.prepare_string( ( char * )tb_b_info, i_info_size, s_info ) > 0 )
   {  m_f.val_s( COL_IMG_INFO ) = s_info ; }

   /*--( Check that the image is not "corrupted" )-------------------------*/
   if(    m_fa.set_offset(   fo_image_offset
                           + ull_image_size.ToULong()
                           - sizeof( b_eoi )
                         ) != 0
       || m_fa.read_data( b_eoi ) != 0
       || b_eoi != 0x3B
     )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_gif()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "gif" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = gif_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
!                                                                           !
! This function is directly used by other init modules ...                  !
!                                                                           !
+--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int CFileInit::gif_read( wxFileOffset fo_offset, wxULongLong ull_size )
{  return( CFileInit_gif( *this ).gif_read( fo_offset, ull_size ) ) ; }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_gif.cpp                       !
+==========================================================================*/
