/*====================================+=====================================+
! File CFileInit_deb.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                         Debian packages: ".deb"                           !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <memory>
#include <wx/tarstrm.h>
#include <wx/wfstream.h>
#include <wx/zstream.h>
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
#include "common/CArInputStream.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_deb : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_deb( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }

      /*-------------------------------------------------------------------*/
      int read_var_val( wxTarInputStream &tar_is,
                        wxString &s_var, wxString &s_val
                      ) ;
      int deb_read() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
static int st_deb_conv_tag_col( const wxString &s_var )
{
   /*----------------------------------------------------------------------*/
   if( s_var.CmpNoCase( "Version" ) == 0 )
   {  return( COL_DOC_VERSION ) ; }
   if( s_var.CmpNoCase( "Description" ) == 0 )
   {  return( COL_DOC_SUBJECT ) ; }
   if( s_var.CmpNoCase( "Package" ) == 0 )
   {  return( COL_DOC_APPLICATION ) ; }
   if( s_var.CmpNoCase( "Maintainer" ) == 0 )
   {  return( COL_DOC_AUTHOR ) ; }
   if( s_var.CmpNoCase( "Homepage" ) == 0 )
   {  return( COL_DOC_URL ) ; }
   if( s_var.CmpNoCase( "Architecture" ) == 0 )
   {  return( COL_DOC_DESTINATION ) ; }
   if( s_var.CmpNoCase( "Section" ) == 0 )
   {  return( COL_DOC_INFO ) ; }
   /*----------------------------------------------------------------------*/
   return( COL_NB ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_deb::read_var_val( wxTarInputStream &tar_is,
                                 wxString &s_var, wxString &s_val
                               )
{
   /*----------------------------------------------------------------------*/
   int  i_c_read = 0 ;
   bool boo_var_ok   ;

   /*----------------------------------------------------------------------*/
   do
   {
      /*-------------------------------------------------------------------*/
      s_var.clear() ;
      s_val.clear() ;
      /*-------------------------------------------------------------------*/
      while( tar_is.IsOk() && ( i_c_read = tar_is.GetC() ) != ':' )
      {  s_var.append( ( wxUniChar )i_c_read ) ; }
      /*-------------------------------------------------------------------*/
        boo_var_ok
      = ( i_c_read == ':' && !s_var.empty() && s_var[ 0 ] != ' ' ) ;
      /*-------------------------------------------------------------------*/
      while(    tar_is.IsOk()
             && ( i_c_read = tar_is.GetC() ) != '\n'
           )
      {  if( i_c_read != '\r' ) { s_val.append( ( wxUniChar )i_c_read ) ; } }
      /*-------------------------------------------------------------------*/
   } while( tar_is.IsOk() && !boo_var_ok ) ;

   /*----------------------------------------------------------------------*/
   s_val.Trim( false ) ;
   m_fi.prepare_string( s_val ) ;
   /*----------------------------------------------------------------------*/
   return( tar_is.IsOk() ? 0 : -1 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit_deb::deb_read()
{
   /*----------------------------------------------------------------------*/
   wxFileInputStream           finput( m_fa )  ;
   CArInputStream              ar_is( finput ) ;
   std::auto_ptr< CArEntry >   ptr_ar_entry    ;
   std::auto_ptr< wxTarEntry > ptr_tar_entry   ;
   wxString                    s_var           ;
   wxString                    s_val           ;
   int                         i_col           ;

   /*----------------------------------------------------------------------*/
   if( !ar_is.IsOk() ) { return( -1 ) ; }

   /*--( Looking for the "control.tar.gz" file in the archive )------------*/
   do
   {  ptr_ar_entry.reset( ar_is.GetNextEntry() ) ;
   } while(    ptr_ar_entry.get() != NULL
            && ptr_ar_entry->GetInternalName() != "control.tar.gz"
          ) ;
   /*----------------------------------------------------------------------*/
   if( ptr_ar_entry.get() == NULL ) { return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   wxZlibInputStream zlib_is( ar_is )  ;
   wxTarInputStream  tar_is( zlib_is ) ;

   /*--( Looking for the "control" file in the tar (it contains the meta) )*/
   do
   {  ptr_tar_entry.reset( tar_is.GetNextEntry() ) ;
   } while(    ptr_tar_entry.get() != NULL
            && ptr_tar_entry->GetInternalName() != "control"
          ) ;
   /*----------------------------------------------------------------------*/
   if( ptr_tar_entry.get() == NULL ) { return( -3 ) ; }

   /*--( Extract the data )------------------------------------------------*/
   while( read_var_val( tar_is, s_var, s_val ) == 0 )
   {
      /*-------------------------------------------------------------------*/
      i_col = st_deb_conv_tag_col( s_var ) ;
      /*-------------------------------------------------------------------*/
      if( m_fi.reserve_col( i_col ) && !s_var.empty() )
      {  m_f.val_s( i_col ) = s_val ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_deb()
{
   /*----------------------------------------------------------------------*/
   m_s_type_det = "deb" ;
   /*----------------------------------------------------------------------*/
   return( CFileInit_deb( *this ).deb_read() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_deb.cpp                        !
+==========================================================================*/
