/*====================================+=====================================+
! File CFileInit_bmp.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                      Image files ".bmp", ".dib"                           !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
struct str_BITMAPFILEHEADER ;
struct str_BITMAPINFOHEADER ;

/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_bmp : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_bmp( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int read_le_data( str_BITMAPFILEHEADER &bfh ) ;
      int bmp_read( wxFileOffset WXUNUSED( fo_image_offset ),
                    wxULongLong ull_image_size
                  ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( push, 1 )

/*-------------------------------------------------------------------------*/
struct str_BITMAPFILEHEADER
{
   /*----------------------------------------------------------------------*/
   wxUint16 bfType      ;
   wxUint32 bfSize      ;
   wxUint16 bfReserved1 ;
   wxUint16 bfReserved2 ;
   wxUint32 bfOffBits   ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
#pragma pack( pop )

/*-------------------------------------------------------------------------*/
int CFileInit_bmp::read_le_data( str_BITMAPFILEHEADER &bfh )
{
   /*----------------------------------------------------------------------*/
   if( m_fa.read_buffer( sizeof( bfh ), &bfh ) != 0 )
   {  return( -1 ) ; }
   /*----------------------------------------------------------------------*/
#if wxBYTE_ORDER == wxBIG_ENDIAN
   /*----------------------------------------------------------------------*/
   bfh.bfType    = wxUINT16_SWAP_ALWAYS( bfh.bfType    ) ;
   bfh.bfSize    = wxUINT32_SWAP_ALWAYS( bfh.bfSize    ) ;
   //wxUint16 bfReserved1 ;
   //wxUint16 bfReserved2 ;
   bfh.bfOffBits = wxUINT32_SWAP_ALWAYS( bfh.bfOffBits ) ;
   /*----------------------------------------------------------------------*/
#endif
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Not all parameters are used to have a "coherent" prototype for all image  !
! extract information functions.                                            !
! Maybe one day to call them through a function pointer.                    !
+--------------------------------------------------------------------------*/
int CFileInit_bmp::bmp_read( wxFileOffset WXUNUSED( fo_image_offset ),
                             wxULongLong ull_image_size
                           )
{
   /*----------------------------------------------------------------------*/
   str_BITMAPFILEHEADER bmp_fh    ;
   str_BITMAPINFOHEADER bmp_ih    ;
   const char           *p_c_info ;

   /*----------------------------------------------------------------------*/
   if(    read_le_data( bmp_fh ) != 0
       || m_fa.read_le_data( bmp_ih ) != 0
     )
   {  return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   switch( bmp_fh.bfType )
   {
      /*-------------------------------------------------------------------*/
      case SR_TWOCC( 'B','M' ) : p_c_info = "BMP Windows"            ; break;
      case SR_TWOCC( 'B','A' ) : p_c_info = "BMP OS/2 Bitmap Array"  ; break;
      case SR_TWOCC( 'C','I' ) : p_c_info = "BMP OS/2 Color Icon"    ; break;
      case SR_TWOCC( 'C','P' ) : p_c_info = "BMP OS/2 Color Pointer" ; break;
      case SR_TWOCC( 'I','C' ) : p_c_info = "BMP OS/2 Icon"          ; break;
      case SR_TWOCC( 'P','T' ) : p_c_info = "BMP OS/2 Pointer"       ; break;
      /*-------------------------------------------------------------------*/
      default : p_c_info = NULL ; break ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   if( p_c_info != NULL )
   {  m_f.val_s( COL_IMG_INFO ) = p_c_info ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_img_x_y( bmp_ih.biWidth, bmp_ih.biHeight ) ;
   /*----------------------------------------------------------------------*/
   m_fi.init_img_bpp( bmp_ih.biBitCount ) ;

   /*--( Check that the image is not "corrupted" )-------------------------*/
   if( bmp_fh.bfSize != ull_image_size )
   {  return( -3 ) ; }

   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_bmp()
{
   /*----------------------------------------------------------------------*/
   int i_ret ;
   /*----------------------------------------------------------------------*/
   m_s_type_det = "bmp" ;
   /*----------------------------------------------------------------------*/
   if( ( i_ret = bmp_read( 0, m_f.get_size() ) ) == 0 )
   {  m_f.set_image_offset( 0 ) ; }
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
!                                                                           !
! This function is directly used by other init modules ...                  !
!                                                                           !
+--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int CFileInit::bmp_read( wxFileOffset fo_offset, wxULongLong ull_size )
{  return( CFileInit_bmp( *this ).bmp_read( fo_offset, ull_size ) ) ; }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CFileInit_bmp.cpp                       !
+==========================================================================*/
