/*====================================+=====================================+
! File CFileInit_aac.cpp              ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!                   Audio file: ".aac" ADTS format                          !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/sr_lib.h"
#include "CFileInit.h"
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Data/Treatment used during the loading                                    !
+--------------------------------------------------------------------------*/
class CFileInit_aac : public CFileInit_type_base
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFileInit_aac( CFileInit &parent ) : CFileInit_type_base( parent )
      {  ; }
      /*-------------------------------------------------------------------*/
      int aac_read() ;

   /*----------------------------------------------------------------------*/
} ;



/*-------------------------------------------------------------------------*/
static const int st_tb_i_aac_adts_samprate[]
= { 96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050,
    16000, 12000, 11025,  8000,  7350,     0,     0,     0
  } ;

/*-------------------------------------------------------------------------*/
static const char * const st_tb_c_aac_profile[]
= { "MAIN", "LC", "SSR", "LTP" } ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
int CFileInit_aac::aac_read()
{
   /*----------------------------------------------------------------------*/
   wxUint32 dw_header ;
   /*----------------------------------------------------------------------*/
   int i_synchro        ;
   int i_layer          ;
   int i_profile        ;
   int i_samprate_index ;
   int i_channel        ;

   /*--( Header )----------------------------------------------------------*/
   if( m_fa.read_be_data( dw_header ) != 0 )
   {  return( -1 ) ; }

   /*-----------------------------------------------------------------------+
   ! AAAAAAAA AAAABCCD EEFFFFGH HHIJKLMM MMMMMMMM MMMNNNNN NNNNNNOP         !
   !                                                                        !
   ! A: syncword, always: '111111111111'                  12                !
   ! B: ID, 0: MPEG-4, 1: MPEG-2                           1                !
   ! C: Layer, always: '00'                                2                !
   ! D: protection absent                                  1                !
   ! E: profile                                            2                !
   ! F: sampling frequency index                           4                !
   ! G: private bit                                        1                !
   ! H: channel configuration                              3                !
   ! I: original/copy                                      1                !
   ! J: home                                               1                !
   ! K: copyright identification bit                       1                !
   ! L: copyright identification start                     1                !
   ! M: aac_frame_length including header (in bytes)      13                !
   ! N: adts_buffer_fullness     0x7FF indicates VBR      11                !
   ! O: no_raw_data_blocks_in_frame                        1                !
   ! P: crc check (if protection absent == 0)             16                !
   !                                                                        !
   ! Some elaborations:                                                     !
   ! profile                                                                !
   ! bits    ID 1 (MPEG-2 profile)              ID 0 (MPEG-4 Object type)   !
   ! 00 (0)  Main profile                       AAC MAIN                    !
   ! 01 (1)  Low Complexity profile (LC)        AAC LC                      !
   ! 10 (2)  Scalable Sample Rate profile (SSR) AAC SSR                     !
   ! 11 (3)  (reserved)                         AAC LTP                     !
   +-----------------------------------------------------------------------*/


   /*----------------------------------------------------------------------*/
   i_synchro        = ( dw_header >> 20 ) & 0xFFF ;
   i_layer          = ( dw_header >> 17 ) & 0x03  ;
   i_profile        = ( dw_header >> 14 ) & 0x03  ;
   i_samprate_index = ( dw_header >> 10 ) & 0x0F  ;
   i_channel        = ( dw_header >>  6 ) & 0x07  ;

   /*----------------------------------------------------------------------*/
   if( i_synchro != 0xFFF || i_layer != 0 ) { return( -2 ) ; }

   /*----------------------------------------------------------------------*/
   m_fi.init_audio_samprate( st_tb_i_aac_adts_samprate[ i_samprate_index ] );
   m_fi.init_audio_channel( i_channel ) ;
   /*----------------------------------------------------------------------*/
   m_f.val_s( COL_AUDIO_INFO ).Printf( "AAC %s",
                                       st_tb_c_aac_profile[ i_profile ]
                                     ) ;
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CFileInit::init_aac()
{
   /*----------------------------------------------------------------------*/
   wxFileOffset fo_offset_end ;

   /*----------------------------------------------------------------------*/
   m_s_type_det = "aac" ;

   /*--( AAC files can be tagged with ape or id3 ... )---------------------*/
   if( ape_init_apetag( fo_offset_end ) == 0 )
   {  m_fa.set_offset( 0 ) ; }
   else
   {  mp3_read_id3v1( fo_offset_end ) ;
      mp3_read_id3v2() ;
   }
   /*--( Read will start at the file pointer position )--------------------*/
   int i_ret = CFileInit_aac( *this ).aac_read() ;
   /*----------------------------------------------------------------------*/
   m_f.init_info_s_track() ;
   /*----------------------------------------------------------------------*/
   return( i_ret ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CFileInit_aac.cpp                        !
+==========================================================================*/
