/*====================================+=====================================+
! File CTool.cpp                      ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include <wx/mimetype.h>
#include "CApp.h"
#include "siren.h"
#include "common/sr_lib.h"
#include "dynmenu/CTool.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CDlgToolEdit::CDlgToolEdit( wxWindow *parent, CDynMenu *p_dm )
            : CDlgDynMenuEdit( parent, p_dm )
{
   /*----------------------------------------------------------------------*/
   SetTitle( _( "Tool" ) ) ;
   m_st_name->SetLabel( _( "Name" ) ) ;
   m_st_exp->SetLabel( _( "Command" ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgToolEdit::~CDlgToolEdit()
{  ; }

/*-------------------------------------------------------------------------*/
int CDlgToolEdit::validate_data()
{
   /*----------------------------------------------------------------------*/
   if( m_s_exp->GetValue().empty() )
   {  sr::error_message( _( "The command is mandatory" ) ) ;
      return( -1 ) ;
   }
   /*----------------------------------------------------------------------*/
   return( 0 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgTool::CDlgTool( CDynMenu *p_dm ) : CDlgDynMenu( p_dm )
{
   /*----------------------------------------------------------------------*/
   SetTitle( _( "Tools" ) ) ;
   m_st_help->SetLabel( _( "A command follows the renaming expression "
                           "syntax. "
                           "It is evaluated and executed on highlighted "
                           "files."
                         )
                      ) ;
   /*----------------------------------------------------------------------*/
   m_lv->InsertColumn( 0, _( "Name" ), wxLIST_FORMAT_LEFT,
                       m_p_dm->M_i_list_colw_name.get()
                     ) ;
   m_lv->InsertColumn( 1, _( "Command" ), wxLIST_FORMAT_LEFT,
                       m_p_dm->M_i_list_colw_exp.get()
                     ) ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, m_p_dm->M_rec_dlg ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgTool::~CDlgTool()
{  ; }

/*-------------------------------------------------------------------------*/
CTool::CTool() : CDynMenu( 4, TOOL_MENU_ID_START, DMF_KEY_SHORTCUTS )
{  ; }

/*-------------------------------------------------------------------------*/
CTool::~CTool()
{  ; }

/*--------------------------------------------------------------------------+
! These elements are supposed to serve as examples and therefore are        !
! created at very first start                                               !
+--------------------------------------------------------------------------*/
void CTool::create_default_elmts()
{
   /*-----------------------------------------------------------------------+
   ! Using ' rather than " because " are used as delimiters by the          !
   ! "GetOpenCommand" function                                              !
   +-----------------------------------------------------------------------*/
   wxString s_command ;
   const wxString co_s_exp_gps
                = "http://maps.google.com?q="
                  "%Xla('m0s','m')(s/[dms]/ /g)(',','.')(' ','%20')%XlA,"
                  "%Xlo('m0s','m')(s/[dms]/ /g)(',','.')(' ','%20')%XlO" ;

   /*--( Get the default open command for html files : browser )-----------*/
     wxFileType *p_file_type
   = wxTheMimeTypesManager->GetFileTypeFromExtension( "html" ) ;
   /*----------------------------------------------------------------------*/
   if( p_file_type == NULL ) { return ; }

   /*----------------------------------------------------------------------*/
   p_file_type->GetOpenCommand( &s_command,
                                wxFileType::MessageParameters( co_s_exp_gps )
                              ) ;
   delete p_file_type ;

   /*--( Add some commands to "help" )-------------------------------------*/
   if( !s_command.empty() )
   {
#ifdef __WXMSW__
      /*--------------------------------------------------------------------+
      ! wx adds a "DDE" hack intercepted by "wxExecute".                    !
      ! To have an "understandable" tool command this "hack" is removed.    !
      +--------------------------------------------------------------------*/
      s_command = s_command.AfterFirst( '#' ).BeforeFirst( '#' ) ;
#endif // __WXMSW__
      /*--( The command will be "computed", so the "\" have to be doubled )*/
      sr::double_backslash( s_command ) ;
      /*-------------------------------------------------------------------*/
      M_tb_s_name.set( m_i_nb_active, _( "Example : Exif GPS location" ) ) ;
      M_tb_s_exp.set(  m_i_nb_active, s_command ) ;
      ++m_i_nb_active ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTool::add()
{
   /*----------------------------------------------------------------------*/
   CDlgToolEdit dlg( wxGetApp().m_frame, this ) ;
   CDynMenu::add( &dlg ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTool::organize()
{
   /*----------------------------------------------------------------------*/
   CDlgTool dlg( this ) ;
   CDynMenu::organize( &dlg ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTool::menu_item_action( int i_id_menu )
{
   /*----------------------------------------------------------------------*/
   int i_num = i_id_menu - m_co_i_menu_id_start ;
   /*----------------------------------------------------------------------*/
   if( i_num < 0 || i_num >= m_i_nb_active )
   {  return ; }
   /*----------------------------------------------------------------------*/
   m_i_current = i_num ;

   /*----------------------------------------------------------------------*/
   CFileList *p_fl = wxGetApp().get_fl() ;
   wxString  s_exp = M_tb_s_exp.get( i_num ) ;
   wxString  s_cmd ;
   long      l_file_num = -1 ;
   /*----------------------------------------------------------------------*/
   while( ( l_file_num = p_fl->get_next_hil_item( l_file_num ) ) != -1 )
   {
      /*-------------------------------------------------------------------*/
      s_cmd = p_fl->m_dir[ l_file_num ].compute_exp_tool( s_exp ) ;
      /*-------------------------------------------------------------------*/
      wxExecute( s_cmd ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CTool.cpp                            !
+==========================================================================*/
