/*====================================+=====================================+
! File CDynMenu.cpp                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/menu.h>
#include "CApp.h"
#include "siren.h"
#include "common/sr_lib.h"
#include "dynmenu/CDynMenu.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CDlgDynMenuEdit::CDlgDynMenuEdit( wxWindow *parent, CDynMenu *p_dm  )
                : CDlgDynMenuEditBase( parent ),
                  m_p_dm( p_dm )
{
   /*----------------------------------------------------------------------*/
   m_s_name->SetFocus() ;
   m_s_exp->SetFont( wxGetApp().m_frame->m_cb_exp->GetFont() ) ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, m_p_dm->M_rec_dlg_edit ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgDynMenuEdit::~CDlgDynMenuEdit()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, m_p_dm->M_rec_dlg_edit ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgDynMenuEdit::OnBtCopyMainExp( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_s_exp->SetValue( wxGetApp().m_frame->m_cb_exp->GetValue() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgDynMenuEdit::OnBtOk( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   if( validate_data() == 0 )
   {  EndModal( wxID_OK ) ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDlgDynMenuEdit::get_modal( wxString &s_name, wxString &s_exp )
{
   /*----------------------------------------------------------------------*/
   m_s_name->SetValue( s_name ) ;
   m_s_exp->SetValue( s_exp )   ;
   /*----------------------------------------------------------------------*/
   if( ShowModal() == wxID_OK )
   {  /*-------------------------------------------------------------------*/
      s_name = m_s_name->GetValue() ;
      s_exp  = m_s_exp->GetValue()  ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( GetReturnCode() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgDynMenu::CDlgDynMenu( CDynMenu *p_dm )
           : CDlgDynMenuBase( wxGetApp().m_frame ),
             m_p_dm( p_dm )
{  ; }

/*-------------------------------------------------------------------------*/
CDlgDynMenu::~CDlgDynMenu()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, m_p_dm->M_rec_dlg ) ;
   m_p_dm->M_i_list_colw_name.set( m_lv->GetColumnWidth( 0 ) ) ;
   m_p_dm->M_i_list_colw_exp.set( m_lv->GetColumnWidth( 1 ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnBtUp( wxCommandEvent & WXUNUSED( event ) )
{  m_lv->move_hil_up() ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnBtDown( wxCommandEvent & WXUNUSED( event ) )
{  m_lv->move_hil_down() ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnBtAdd( wxCommandEvent & WXUNUSED( event ) )
{  edit( -1 ) ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnBtModify( wxCommandEvent & WXUNUSED( event ) )
{  edit( m_lv->get_item_focus() ) ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnBtDelete( wxCommandEvent & WXUNUSED( event ) )
{  m_lv->delete_hil() ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnBtOk( wxCommandEvent & WXUNUSED( event ) )
{  EndModal( wxID_OK ) ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnListItemActivated( wxListEvent & WXUNUSED( event ) )
{  edit( m_lv->get_item_focus() ) ; }

/*-------------------------------------------------------------------------*/
void CDlgDynMenu::OnKeyDown( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   switch( event.GetKeyCode() )
   {
      /*--( Highlight all elements )---------------------------------------*/
      case 'A' :
         if( event.GetModifiers() == wxMOD_CMD )
         {  m_lv->set_item_hil( -1, true ) ; }
         else
         {  event.Skip() ; }
         break ;

      /*-------------------------------------------------------------------*/
      case WXK_DELETE :
         if( event.GetModifiers() == 0 )
         {  m_lv->delete_hil() ; }
         else
         {  event.Skip() ; }
         break ;

      /*--( Ctrl+Alt+F5: Test generate elements )--------------------------*/
#ifdef __WXDEBUG__
      case WXK_F5 :
      {
         /*----------------------------------------------------------------*/
         if( event.GetModifiers() != ( wxMOD_CMD | wxMOD_ALT ) )
         {  event.Skip() ; break ; }
         /*----------------------------------------------------------------*/
         int i_num     = m_lv->GetItemCount() ;
         int i_num_max = i_num + 10 ;
         /*----------------------------------------------------------------*/
         for( ; i_num < i_num_max ; ++i_num )
         {  m_lv->InsertItem( i_num, wxString::Format( "Name %d", i_num ) ) ;
            m_lv->set_item_text( i_num, 1,
                                 wxString::Format( "Expression %d", i_num )
                               ) ;
         }
         /*----------------------------------------------------------------*/
         m_lv->set_item_active( i_num - 1 ) ;
         /*----------------------------------------------------------------*/
      }
#endif // __WXDEBUG__
      /*-------------------------------------------------------------------*/
      default:
         event.Skip() ;
         break ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! l_item < 0 means "creation"                                               !
+--------------------------------------------------------------------------*/
void CDlgDynMenu::edit( long l_item )
{
   /*----------------------------------------------------------------------*/
   wxString s_name ;
   wxString s_exp  ;

   /*--( Existing item ? )-------------------------------------------------*/
   if( l_item >= 0 )
   {
      /*-------------------------------------------------------------------*/
      s_name = m_lv->get_item_text( l_item, 0 ) ;
      s_exp  = m_lv->get_item_text( l_item, 1 ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   if( m_lv->GetItemCount() >= g_co_i_reserve_menu_id )
   {  return ; }

   /*----------------------------------------------------------------------*/
   if( get_modal_edit( s_name, s_exp ) == wxID_OK )
   {
      /*-------------------------------------------------------------------*/
      if( l_item < 0 )
      {  l_item = m_lv->GetItemCount() ;
         m_lv->InsertItem( l_item, s_name ) ;
      }
      else
      {  m_lv->set_item_text( l_item, 0, s_name ) ; }

      /*-------------------------------------------------------------------*/
      m_lv->set_item_text( l_item, 1, s_exp  ) ;
      m_lv->set_item_active( l_item ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   m_lv->SetFocus() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDynMenu::CDynMenu( int i_menu_bar_pos, int i_menu_id_start, int i_flags
                  ) : m_co_i_menu_bar_pos( i_menu_bar_pos ),
                      m_co_i_menu_id_start( i_menu_id_start ),
                      m_co_i_flags( i_flags ),
                      m_i_nb_active( 0 ),
                      m_i_current( 0 ),
                      m_i_nb_menu_opt_when_empty( -1 )
{  ; }

/*-------------------------------------------------------------------------*/
CDynMenu::~CDynMenu()
{  ; }

/*-------------------------------------------------------------------------*/
void CDynMenu::init_var( const wxString &s_key_prefix )
{
   /*-----------------------------------------------------------------------+
   ! Small trick:                                                           !
   ! Only the expression is mandatory (the name is not).                    !
   ! So, the loading is stopped on the first empty expression and as much   !
   ! names are tried to be loaded.                                          !
   ! Immediately after that "infinite" number of names is set.              !
   +-----------------------------------------------------------------------*/
   M_tb_s_exp.init( s_key_prefix + "exp_%03d", -1, wxEmptyString ) ;
   /*----------------------------------------------------------------------*/
   m_i_nb_active = M_tb_s_exp.size() ;
   /*----------------------------------------------------------------------*/
   M_tb_s_name.init( s_key_prefix + "name_%03d",
                     m_i_nb_active, wxEmptyString
                   ) ;
   M_tb_s_name.set_max_nb_elmt( -1 ) ;
   /*----------------------------------------------------------------------*/
   M_rec_dlg.init( s_key_prefix + "rec_dlg" ) ;
   M_rec_dlg_edit.init( s_key_prefix + "rec_dlg_edit" ) ;
   M_i_list_colw_name.init( s_key_prefix + "list_colw_name", 150 ) ;
   M_i_list_colw_exp.init( s_key_prefix + "list_colw_exp", 500 ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::save_var()
{
   /*----------------------------------------------------------------------*/
   M_tb_s_name.set_nb_elmt_to_save( m_i_nb_active ) ;
   M_tb_s_name.save() ;
   /*----------------------------------------------------------------------*/
   M_tb_s_exp.set_nb_elmt_to_save( m_i_nb_active ) ;
   M_tb_s_exp.save() ;
   /*----------------------------------------------------------------------*/
   M_rec_dlg.save() ;
   M_rec_dlg_edit.save() ;
   M_i_list_colw_name.save() ;
   M_i_list_colw_exp.save() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::var_to_listview( CListCtrlBase *lv )
{
   /*----------------------------------------------------------------------*/
   int i_num ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0 ; i_num < m_i_nb_active ; ++i_num )
   {
      /*-------------------------------------------------------------------*/
      lv->InsertItem( i_num, M_tb_s_name.get( i_num ) )      ;
      lv->set_item_text( i_num, 1, M_tb_s_exp.get( i_num ) ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::listview_to_var( const CListCtrlBase *lv )
{
   /*----------------------------------------------------------------------*/
   wxString s_name ;
   wxString s_exp  ;
   int      i_num  ;
   /*----------------------------------------------------------------------*/
   m_i_nb_active = lv->GetItemCount() ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0 ; i_num < m_i_nb_active ; ++i_num )
   {
      /*-------------------------------------------------------------------*/
      M_tb_s_name.set( i_num, lv->get_item_text( i_num, 0 ) ) ;
      M_tb_s_exp.set( i_num, lv->get_item_text( i_num, 1 ) ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
wxString CDynMenu::get_exp( const wxString &s_name ) const
{
   /*----------------------------------------------------------------------*/
   int i_name = M_tb_s_name.search_val( s_name ) ;
   /*----------------------------------------------------------------------*/
   return( i_name < 0 ? wxString() : M_tb_s_exp.get( i_name ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::add( CDlgDynMenuEdit *p_dlg )
{
   /*----------------------------------------------------------------------*/
   wxString s_name ;
   wxString s_exp  ;
   /*----------------------------------------------------------------------*/
   s_exp = wxGetApp().m_frame->m_cb_exp->GetValue().Trim() ;
   /*----------------------------------------------------------------------*/
   if( p_dlg->get_modal( s_name, s_exp ) == wxID_OK )
   {
      /*-------------------------------------------------------------------*/
      m_i_current = m_i_nb_active++ ;
      /*-------------------------------------------------------------------*/
      M_tb_s_name.set( m_i_current, s_name ) ;
      M_tb_s_exp.set( m_i_current , s_exp  ) ;
      /*-------------------------------------------------------------------*/
      update_menu() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::organize( CDlgDynMenu *p_dlg )
{
   /*----------------------------------------------------------------------*/
   var_to_listview( p_dlg->m_lv ) ;
   p_dlg->m_lv->set_item_active( m_i_current ) ;
   p_dlg->m_lv->SetFocus() ;
   /*----------------------------------------------------------------------*/
   if( p_dlg->ShowModal() == wxID_OK )
   {  listview_to_var( p_dlg->m_lv ) ;
      update_menu() ;
   }
   /*----------------------------------------------------------------------*/
   m_i_current = p_dlg->m_lv->get_item_focus() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::update_menu()
{
   /*----------------------------------------------------------------------*/
   wxMenu   *menu       ;
   wxString s_text      ;
   wxString s_exp       ;
   int      i_num       ;
   wxString s_mod_ctrl  ;
   wxString s_mod_alt   ;
   wxString s_mod_shift ;

   /*----------------------------------------------------------------------*/
   menu  = wxGetApp().m_frame->GetMenuBar()->GetMenu( m_co_i_menu_bar_pos ) ;
   i_num = menu->GetMenuItemCount() ;

   /*--( At the first call the "entry point" is computed )-----------------*/
   if( m_i_nb_menu_opt_when_empty < 0 )
   {  m_i_nb_menu_opt_when_empty = i_num ; }

   /*--( First, clean the current content )--------------------------------*/
   while( i_num > m_i_nb_menu_opt_when_empty )
   {  menu->Delete( menu->FindItemByPosition( --i_num ) ) ; }

   /*--( Then create the menu items )--------------------------------------*/
   for( i_num = 0 ; i_num < m_i_nb_active ; ++i_num )
   {
      /*--------------------------------------------------------------------+
      ! If there is no name, the expression is used as menu title           !
      ! and, if the expression contains "&" they are "escaped" to make      !
      ! them appear                                                         !
      +--------------------------------------------------------------------*/
      s_text = M_tb_s_name.get( i_num ) ;
      s_exp  = M_tb_s_exp.get( i_num )  ;
      if( s_text.empty() )
      {  s_text = wxControl::EscapeMnemonics( s_exp ) ; }

      /*--------------------------------------------------------------------+
      ! The menu item key shortcuts are automatically given based on their  !
      ! positions.                                                          !
      ! Alt+1 -> Alt+0 are not used because they seem to be intercepted     !
      ! under GTK/Ubuntu/Gnome                                              !
      !                                                                     !
      ! Why making things so complicated ?                                  !
      ! At least under MSW the accelerator text is not updated during menu  !
      ! item insertion. It is taken as it is and analysed to determine the  !
      ! key combination. The modifier text is searched translated or not.   !
      ! The modifier text has to be build with already translated text.     !
      ! Calling accelerator.ToString would not help much because it looks   !
      ! for translations of "Ctrl+", "Alt+" and "Shift+" which would have   !
      ! add three "useless" entries in the "po" file.                       !
      +--------------------------------------------------------------------*/
      if( ( m_co_i_flags & DMF_KEY_SHORTCUTS ) != 0 && i_num < 20 )
      {
         /*--( Init done only the first time )-----------------------------*/
         if( i_num == 0 )
         {  /*-------------------------------------------------------------*/
            s_mod_ctrl  = wxString( _( "ctrl" ) ).Capitalize()  + '+' ;
            s_mod_alt   = wxString( _( "alt" ) ).Capitalize()   + '+' ;
            s_mod_shift = wxString( _( "shift" ) ).Capitalize() + '+' ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
         s_text += '\t' ;
         if( i_num >= 10 )
         {  s_text += s_mod_ctrl ; }
         /*----------------------------------------------------------------*/
         s_text +=   s_mod_alt
                   + s_mod_shift
                   + wxString::Format( "%c", '0' + ( i_num + 1 ) % 10 ) ;
         /*----------------------------------------------------------------*/
      }
      /*--( The expression is shown as "long help" of the menu item )------*/
      menu->Append( m_co_i_menu_id_start + i_num, s_text, s_exp ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDynMenu::append_to_menu( wxMenu *menu_out )
{
   /*----------------------------------------------------------------------*/
   wxMenuItemList::compatibility_iterator it_node ;
   wxMenuItemList menu_item_list ;
   wxMenuItem     *p_menu_item ;
   int            i_num ;

   /*----------------------------------------------------------------------*/
     menu_item_list
   = wxGetApp().m_frame->GetMenuBar()->GetMenu( m_co_i_menu_bar_pos
                                              )->GetMenuItems() ;

   /*----------------------------------------------------------------------*/
   for( it_node = menu_item_list.GetFirst(), i_num = 0 ;
        it_node != NULL ;
        it_node = it_node->GetNext(), ++i_num
      )
   {
      /*--( Skip the non dynamic part of the menu )------------------------*/
      if( i_num < m_i_nb_menu_opt_when_empty )
      {  continue ; }

      /*--------------------------------------------------------------------+
      ! As wxMenu takes ownership of the menu item, a complete copy is done !
      +--------------------------------------------------------------------*/
      p_menu_item = it_node->GetData() ;
      menu_out->Append( p_menu_item->GetId(),
                        p_menu_item->GetItemLabel(),
                        p_menu_item->GetHelp(),
                        p_menu_item->GetKind()
                      ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CDynMenu.cpp                           !
+==========================================================================*/
