/*====================================+=====================================+
! File CLogGuiGrouped.cpp             ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/wx.h>
#include "common/CLogGuiGrouped.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
void CLogGuiGrouped::Flush()
{
   /*----------------------------------------------------------------------*/
   if( !has_err() ) { return ; }

   /*----------------------------------------------------------------------*/
   wxString s_final_message ;
   /*----------------------------------------------------------------------*/
   s_final_message.Printf( m_aMessages.GetCount() <= 1
                           ? _( "%d error occurred" )
                           : _( "%d errors occurred" ),
                           ( int )m_aMessages.GetCount()
                         ) ;
   /*----------------------------------------------------------------------*/
   if( !m_s_info.empty() )
   {  s_final_message += '\n' + m_s_info ; }
   /*--( This last error will look like a title )--------------------------*/
   wxLogError( s_final_message ) ;
   /*----------------------------------------------------------------------*/
   wxLogGui::Flush() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                     End of file CLogGuiGrouped.cpp                        !
+==========================================================================*/
