/*====================================+=====================================+
! File CChoice.cpp                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "common/CChoice.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
wxString CChoice::get_stringdata( int i_item ) const
{
   /*--( Current selection ? )---------------------------------------------*/
   if( i_item < 0 ) { i_item = GetCurrentSelection() ; }
   /*----------------------------------------------------------------------*/
   void *p_client_data = GetClientObject( i_item ) ;
   /*----------------------------------------------------------------------*/
   if( p_client_data == NULL ) { return( wxEmptyString ) ; }
   /*----------------------------------------------------------------------*/
   return( ( ( wxStringClientData * )p_client_data )->GetData() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CChoice::append_all_stringdata( const CChoice *p_in )
{
   /*----------------------------------------------------------------------*/
   const int co_i_nb = p_in->GetCount() ;
   int       i_num ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0 ; i_num < co_i_nb ; ++i_num )
   {  /*-------------------------------------------------------------------*/
      append_stringdata( p_in->GetString( i_num ),
                         p_in->get_stringdata( i_num )
                       ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CChoice.cpp                             !
+==========================================================================*/
