/*====================================+=====================================+
! File CTestbed.cpp                   ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
! Once opened, the window is kept alive via a pointer in CFrame.            !
! This will allow the user to review the parameters used.                   !
!                                                                           !
! Why no "get_modal" function ?                                             !
! Because at least under GTK the completion window can't be closed by       !
! clicking on its "X" (close) button if its parent is modal.                !
! So, it is used "modeless" which is not a bad thing.                       !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/datetime.h>
#include <wx/menu.h>
#include "CApp.h"
#include "CFileInit.h"
#include "CTestbed.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CTestbed::CTestbed( wxWindow *parent ) : CTestbedBase( parent )
{
   /*----------------------------------------------------------------------*/
   init() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CTestbed::~CTestbed()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_testbed ) ;
   /*--( Avoid the delete from the Frame )---------------------------------*/
   wxGetApp().m_frame->m_testbed = NULL ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnClose( wxCloseEvent &event )
{
   /*----------------------------------------------------------------------*/
   close_completion() ;
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnBtCompletion( wxCommandEvent & WXUNUSED( event ) )
{
   /*--( The action opens/closes the completion window )-------------------*/
   if( m_completion != NULL )
   {  m_completion->Destroy() ; }
   else
   {  /*-------------------------------------------------------------------*/
        m_completion
      = new CCompletion( m_s_exp,
                         m_to_exp->FindById( ID_DUMMY_TB_BT_COMPLETION ),
                         NULL, _( "Completion for the expression testbed" ),
                         m_completion, wxGetApp().M_rec_completion_tb
                       ) ;
      /*-------------------------------------------------------------------*/
      m_completion->assign_focus() ;
      m_completion->show_current_var() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnBtCompute( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   compute() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnBtCopyMainExp( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_s_exp->SetValue( wxGetApp().m_frame->m_cb_exp->GetValue() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnBtCopyMainDir( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_s_dir->SetValue( wxGetApp().m_frame->m_cb_dir->GetValue() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnBtCopyMainSel( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   m_s_current_names->SetValue(
            wxGetApp().get_fl()->col_selected_list_to_string( COL_NONE_NAME )
                              ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::OnKeyDownTextCtrl( wxKeyEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( g_is_edit_info_event( event ) )
   {  g_disp_edit_info( ( wxTextCtrl * )event.GetEventObject() ) ; }
   else
   {  event.Skip() ; }
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! EVT_CLOSE "event" doesn't seem to be called at least under MSW because    !
! the dialog is not modal.                                                  !
+--------------------------------------------------------------------------*/
void CTestbed::OnBtOk( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   Destroy() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::init()
{
   /*----------------------------------------------------------------------*/
   m_completion = NULL ;
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_s_exp, wxGetApp().M_boo_exp_fix.get() ) ;
   sr::set_font_fix( m_s_current_names, wxGetApp().M_boo_exp_fix.get() ) ;
   sr::set_font_fix( m_s_new_names, wxGetApp().M_boo_exp_fix.get() ) ;
   /*----------------------------------------------------------------------*/
   wxMenuBar *menu = wxGetApp().m_frame->GetMenuBar() ;
   m_to_exp->SetToolShortHelp( m_to_exp->GetToolByPos( 0 )->GetId(),
                               menu->GetHelpString( ID_BT_COMPLETION )
                             ) ;
   m_to_exp->SetToolShortHelp( m_to_exp->GetToolByPos( 1 )->GetId(),
                               menu->GetHelpString( ID_ACT_COMPUTE )
                             ) ;
   /*----------------------------------------------------------------------*/
   m_s_dir->SetValue( wxGetApp().M_s_dir.get() ) ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, wxGetApp().M_rec_testbed ) ;
   /*----------------------------------------------------------------------*/
   setup_immediate_recompute() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::setup_immediate_recompute()
{
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_imm_recompute.get() )
   {
      /*-------------------------------------------------------------------*/
      m_s_exp->Bind( wxEVT_COMMAND_TEXT_UPDATED,
                     &CTestbed::OnBtCompute, this
                   ) ;
      /*-------------------------------------------------------------------*/
      m_s_current_names->Bind( wxEVT_COMMAND_TEXT_UPDATED,
                               &CTestbed::OnBtCompute, this
                             ) ;
      /*-------------------------------------------------------------------*/
   }
   else
   {  /*-------------------------------------------------------------------*/
      m_s_exp->Unbind( wxEVT_COMMAND_TEXT_UPDATED,
                       &CTestbed::OnBtCompute, this
                     ) ;
      /*-------------------------------------------------------------------*/
      m_s_current_names->Unbind( wxEVT_COMMAND_TEXT_UPDATED,
                                 &CTestbed::OnBtCompute, this
                               ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::close_completion()
{
   /*----------------------------------------------------------------------*/
   if( m_completion != NULL )
   {  m_completion->Destroy() ;
      m_completion = NULL ;
   }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CFile CTestbed::new_file( const wxString &s_name )
{
   /*----------------------------------------------------------------------*/
   CFile     f ;
   CFileInit fi( f ) ;
   /*--( Date when the first 3.00 expression computation worked ;-) )------*/
   wxDateTime dt( 23, wxDateTime::Jan, 2008, 16, 8, 4 ) ;
   /*--( Seen as a standard file )-----------------------------------------*/
   f.reset( false ) ;
   fi.init_mini_name( s_name ) ;
   /*----------------------------------------------------------------------*/
   fi.init_date( COL_BASE_CRE_DATE, dt ) ;
   fi.init_date( COL_BASE_ACC_DATE, dt ) ;
   fi.init_date( COL_BASE_MOD_DATE, dt ) ;
   /*----------------------------------------------------------------------*/
   f.set_size( 0 ) ;
   f.init_s_size() ;
   f.val_s( COL_BASE_ATTR ) = "--rw-" ;
   /*----------------------------------------------------------------------*/
   f.val_s( COL_BASE_TYPE ) = fi.get_type_desc() ;
   /*----------------------------------------------------------------------*/
   return( f ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CTestbed::compute()
{
   /*----------------------------------------------------------------------*/
   wxString s_exp ;
   wxString s_dir ;

   /*----------------------------------------------------------------------*/
   s_exp = m_s_exp->GetValue().Trim() ;
   s_dir = m_s_dir->GetValue().Trim() ;

   /*----------------------------------------------------------------------*/
   if( s_exp.empty() || s_dir.empty() )
   {  /*-------------------------------------------------------------------*/
      m_s_new_names->Clear() ;
      return ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   CDir     dir    ;
   wxString s_name ;
   int      i_num  ;
   int      co_i_nb = m_s_current_names->GetNumberOfLines() ;

   /*----------------------------------------------------------------------*/
   dir.set_fake_dir( s_dir ) ;

   /*--( Structures creation and files selection )-------------------------*/
   for( i_num = 0 ; i_num < co_i_nb ; ++i_num )
   {
      /*-------------------------------------------------------------------*/
      s_name = m_s_current_names->GetLineText( i_num ).Trim( false ).Trim() ;
      /*-------------------------------------------------------------------*/
      if( s_name.empty() ) { continue ; }
      /*-------------------------------------------------------------------*/
      dir.push_back( new_file( s_name ) ) ;
      dir.back().set_cdir( &dir ) ;
      /*-------------------------------------------------------------------*/
      dir.sel( dir.size() - 1 ) ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
   dir.compute_new_names( s_exp ) ;

   /*----------------------------------------------------------------------*/
   wxString       s_new ;
   const wxString co_s_empty_new_name( _( "<empty>" ) ) ;
   /*----------------------------------------------------------------------*/
   m_s_new_names->SetValue( wxEmptyString ) ;
   /*----------------------------------------------------------------------*/
   for( i_num = 0 ; i_num < dir.size() ; ++i_num )
   {
      /*-------------------------------------------------------------------*/
      s_new = dir[ i_num ].get_new_full_path() ;
      /*-------------------------------------------------------------------*/
      if( !s_new.empty() )
      {  *m_s_new_names << s_new ; }
      else
      {  /*--( The emptiness is an important information )-----------------*/
         m_s_new_names->SetDefaultStyle( wxTextAttr( *wxRED ) ) ;
         *m_s_new_names << co_s_empty_new_name ;
         m_s_new_names->SetDefaultStyle( wxTextAttr( wxNullColour ) ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
      *m_s_new_names << SR_EOL ;
      /*-------------------------------------------------------------------*/
   }

   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CTestbed.cpp                           !
+==========================================================================*/
