/*====================================+=====================================+
! File CRunInfoMessage.cpp            ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/stopwatch.h>
#include "CApp.h"
#include "CRunInfoMessage.h"
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Reimplementation of "wxBusyInfo" because of a Ubuntu issue.               !
! At least under Ubuntu 10.10 (Maverick) the window WON'T appear if the     !
! frame style doesn't contain: wxCAPTION                                    !
!                and contains: wxBORDER_SIMPLE                              !
! (wx ticket #13262)                                                        !
! A "recursive" Yield can be generated ...                                  !
+--------------------------------------------------------------------------*/
CInfoFrame::CInfoFrame( wxWindow *parent, const wxString s_msg )
           : wxFrame( parent, wxID_ANY, wxEmptyString,
                      wxDefaultPosition, wxDefaultSize,
                      wxFRAME_FLOAT_ON_PARENT | wxFRAME_TOOL_WINDOW
#ifdef __WXGTK__
                      | wxCAPTION
#else
                      | wxBORDER_SIMPLE
#endif // __WXGTK__
                    )
{
   /*----------------------------------------------------------------------*/
   wxPanel      *panel     = new wxPanel( this ) ;
   wxBoxSizer   *box_sizer = new wxBoxSizer( wxHORIZONTAL ) ;
   wxStaticText *text_msg  = new wxStaticText( panel, wxID_ANY, s_msg ) ;
   /*----------------------------------------------------------------------*/
   box_sizer->AddSpacer( 100 ) ;
   box_sizer->Add( text_msg, 0, wxALL | wxALIGN_CENTER, 50 ) ;
   box_sizer->AddSpacer( 100 ) ;
   /*----------------------------------------------------------------------*/
   panel->SetSizer( box_sizer ) ;
   box_sizer->Fit( this ) ;
   CentreOnParent() ;
   /*----------------------------------------------------------------------*/
   Show( true ) ;
   Refresh() ;
   Update() ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! "m_ll_time_last_info" is set to 0 to force display during the first call  !
+--------------------------------------------------------------------------*/
CRunInfoMessage::CRunInfoMessage()
               : m_ll_time_last_info( 0 ), m_i_nb_disp( 0 ),
                 m_p_win_info( NULL )
{  ; }

/*-------------------------------------------------------------------------*/
CRunInfoMessage::CRunInfoMessage( const wxString &s_msg_0,
                                  const wxString &s_msg_N
                                )
               : m_s_msg_0( s_msg_0 ), m_s_msg_N( s_msg_N ),
                 m_ll_time_last_info( 0 ), m_i_nb_disp( 0 ),
                 m_p_win_info( NULL )
{  ; }

/*-------------------------------------------------------------------------*/
CRunInfoMessage::~CRunInfoMessage()
{
   /*----------------------------------------------------------------------*/
   if( m_p_win_info != NULL )
   {  m_p_win_info->Show( false ) ;
      m_p_win_info->Close() ;
      m_p_win_info = NULL ;
   }
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->allow_user_input( true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CRunInfoMessage::display( int i_val )
{
   /*--( Display info only after a certain amount of time )----------------*/
   if( wxGetLocalTimeMillis() - m_ll_time_last_info < 500 )
   {  return ; }

   /*--( Display message in the status bar )-------------------------------*/
   if( i_val == 0 )
   {  g_disp_info( m_s_msg_0 ) ; }
   else
   {  g_disp_info( wxString::Format( m_s_msg_N, i_val ) ) ; }

   /*--( Display window and treat events after a longer time )-------------*/
   if( m_i_nb_disp > 0 && m_i_nb_disp % 3 == 0 )
   {
      /*-------------------------------------------------------------------*/
      wxGetApp().m_frame->allow_user_input( false ) ;
      /*-------------------------------------------------------------------*/
      if( m_p_win_info == NULL )
      {  m_p_win_info = new CInfoFrame( wxGetApp().m_frame, m_s_msg_0 ) ; }
      /*--( And refresh all ... )------------------------------------------*/
      wxGetApp().Yield() ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   ++m_i_nb_disp ;
   m_ll_time_last_info = wxGetLocalTimeMillis() ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CRunInfoMessage::reset_display()
{  if( m_i_nb_disp > 0 ) { wxGetApp().m_frame->status_disp_text() ; } }

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                   End of file CRunInfoMessage.cpp                         !
+==========================================================================*/
