/*====================================+=====================================+
! File CNbVisu.cpp                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CApp.h"
#include "CNbVisu.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE( CNbVisu, wxNotebook )
   /*----------------------------------------------------------------------*/
   EVT_NOTEBOOK_PAGE_CHANGED( wxID_ANY, CNbVisu::OnPageChanged )
#ifdef __WXGTK__
   EVT_LEFT_DOWN( CNbVisu::OnLeftDown )
#endif // __WXGTK__
   /*----------------------------------------------------------------------*/
END_EVENT_TABLE()
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CNbVisu::CNbVisu( wxWindow *parent, wxWindowID id )
       : wxNotebook( parent, id )
{  ; }

/*-------------------------------------------------------------------------*/
CNbVisu::~CNbVisu()
{  ; }

/*-------------------------------------------------------------------------*/
void CNbVisu::OnPageChanged( wxNotebookEvent &event )
{
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   wxGetApp().m_frame->visu_file() ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Under GTK there is a problem if one of the tabs is a "wxTreeCtrl".        !
! If a left click is done in the tree, a double click will have to be done  !
! on another tab to make it get the focus.                                  !
! cf http://forums.wxwidgets.org/viewtopic.php?f=1&t=25294                  !
+--------------------------------------------------------------------------*/
#ifdef __WXGTK__
void CNbVisu::OnLeftDown( wxMouseEvent &event )
{
   /*----------------------------------------------------------------------*/
   int i_page = HitTest( ScreenToClient( wxGetMousePosition() ), NULL ) ;
   /*----------------------------------------------------------------------*/
   if( i_page == wxNOT_FOUND ) { return ; }
   /*----------------------------------------------------------------------*/
   if( i_page != GetSelection() ) { SetSelection( i_page ) ; }
   /*----------------------------------------------------------------------*/
   event.Skip() ;
   /*----------------------------------------------------------------------*/
}
#endif // __WXGTK__

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CNbVisu.cpp                          !
+==========================================================================*/
