/*====================================+=====================================+
! File CImageFileList.cpp             ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include <wx/wx.h>
#include <wx/iconloc.h>
#include <wx/artprov.h>
#include <wx/mimetype.h>
#include <wx/renderer.h>
#include <wx/dirctrl.h>
#include "CApp.h"
#include "siren.h"
#include "CImageFileList.h"
/*-------------------------------------------------------------------------*/
#ifndef __WXMSW__
#include "sort_asc.xpm"
#include "sort_desc.xpm"
#endif // ! __WXMSW__
/*-------------------------------------------------------------------------*/
#include "famfamfam/mime_text.xpm"
#include "famfamfam/mime_message.xpm"
#include "famfamfam/mime_pdf.xpm"
#include "famfamfam/mime_zip.xpm"
#include "famfamfam/mime_epub.xpm"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
CImageFileList::CImageFileList()
              : wxImageList( g_co_size_tool.GetX(), g_co_size_tool.GetY() )

{
   /*-----------------------------------------------------------------------+
   ! Add default images to list.                                            !
   ! Under MSW the standard sort up/down is used (min XP)                   !
   +-----------------------------------------------------------------------*/
#ifndef __WXMSW__
   m_i_ind_asc  = Add( wxIcon( sort_asc_xpm ) ) ;
   m_i_ind_desc = Add( wxIcon( sort_desc_xpm ) ) ;
#endif // ! __WXMSW__
   /*-----------------------------------------------------------------------+
   ! Some icons from "wxTheFileIconsTable" have been modified in "CDirTree" !
   +-----------------------------------------------------------------------*/
     m_i_ind_dir
   = Add( wxTheFileIconsTable->GetSmallImageList()->GetIcon(
                                                     wxFileIconsTable::folder
                                                           )
        ) ;
   m_i_ind_file = Add( wxArtProvider::GetIcon( wxART_NORMAL_FILE, wxART_MENU,
                                               g_co_size_tool
                                             )
                     ) ;
   /*----------------------------------------------------------------------*/
   add_checkboxes() ;
   /*----------------------------------------------------------------------*/
     m_i_ind_mime_img
   = Add( wxIcon( wxGetApp().m_colgroup.get_xpm( GRP_IMG ) ) ) ;
     m_i_ind_mime_audio
   = Add( wxIcon( wxGetApp().m_colgroup.get_xpm( GRP_AUDIO ) ) ) ;
     m_i_ind_mime_video
   = Add( wxIcon( wxGetApp().m_colgroup.get_xpm( GRP_VIDEO ) ) ) ;
   /*----------------------------------------------------------------------*/
   m_i_ind_mime_text    = Add( wxIcon( mime_text_xpm ) ) ;
   m_i_ind_mime_message = Add( wxIcon( mime_message_xpm ) ) ;
   m_i_ind_mime_pdf     = Add( wxIcon( mime_pdf_xpm ) ) ;
   m_i_ind_mime_zip     = Add( wxIcon( mime_zip_xpm ) ) ;
   m_i_ind_mime_epub    = Add( wxIcon( mime_epub_xpm ) ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! Platform native checkboxes are added to the image list                    !
+--------------------------------------------------------------------------*/
void CImageFileList::add_checkboxes()
{
   /*----------------------------------------------------------------------*/
   wxWindow         *win_ref  = wxGetApp().m_frame ;
   wxRendererNative &renderer = wxRendererNative::Get() ;
   const wxSize     size_cb( renderer.GetCheckBoxSize( win_ref ) ) ;
   const wxPoint    point( ( g_co_size_tool.GetX() - size_cb.GetX() ) / 2,
                           ( g_co_size_tool.GetY() - size_cb.GetY() ) / 2
                         ) ;
   const wxRect     rect( point, size_cb ) ;
   wxBitmap         bmp( g_co_size_tool ) ;
   wxMemoryDC       dc ;

   /*----------------------------------------------------------------------*/
   dc.SelectObject( bmp ) ;
   dc.Clear() ;
   renderer.DrawCheckBox( win_ref, dc, rect,
                          wxCONTROL_FLAT | wxCONTROL_CHECKED
                        ) ;
   dc.SelectObject( wxNullBitmap ) ;
   m_i_ind_check = Add( bmp ) ;
   /*----------------------------------------------------------------------*/
   dc.SelectObject( bmp ) ;
   dc.Clear() ;
   renderer.DrawCheckBox( win_ref, dc, rect,
                          wxCONTROL_FLAT
                        ) ;
   dc.SelectObject( wxNullBitmap ) ;
   m_i_ind_uncheck = Add( bmp ) ;
   /*----------------------------------------------------------------------*/
}

/*--------------------------------------------------------------------------+
! The path given as parameter is relative to the current directory.         !
! The absolute full path is stored because using relative ones could be     !
! "confusing" (same file name stored in different places).                  !
+--------------------------------------------------------------------------*/
int CImageFileList::get_icon_index_file( const CFile &file,
                                         const wxString &s_ext
                                       )
{
   /*----------------------------------------------------------------------*/
   wxString                s_abs_full_path ;
   t_map_file_ico_info_cit cit_file ;
   str_file_ico_info       fii ;

   /*----------------------------------------------------------------------*/
   s_abs_full_path = file.get_abs_full_path() ;
   /*-----------------------------------------------------------------------+
   ! For "case insensitive" systems the "trick" is to compare the names in  !
   ! lower case.                                                            !
   +-----------------------------------------------------------------------*/
   if( !wxFileName::IsCaseSensitive() )
   {  s_abs_full_path.MakeLower() ; }

   /*----------------------------------------------------------------------*/
   cit_file = m_map_file_ico.find( s_abs_full_path ) ;

   /*--( The file may have changed, so some information is kept )----------*/
   fii.m_dt_mod   = file.get_dt_val( COL_BASE_MOD_DATE ) ;
   fii.m_ull_size = file.get_size() ;

   /*--( Right version already extracted ? )-------------------------------*/
   if(    cit_file != m_map_file_ico.end()
       && cit_file->second.m_dt_mod == fii.m_dt_mod
       && cit_file->second.m_ull_size == fii.m_ull_size
     )
   {  return( cit_file->second.m_i_ico ) ; }

   /*-----------------------------------------------------------------------+
   ! Under MSW, an executable file can contain an icon in its resources     !
   +-----------------------------------------------------------------------*/
   wxIcon ico ;
   /*----------------------------------------------------------------------*/
#ifdef __WXMSW__
   if( s_ext == "exe" || s_ext == "ico" || s_ext == "cur" )
   {  /*-------------------------------------------------------------------*/
      HICON hico ;
      /*-------------------------------------------------------------------*/
      if( ExtractIconEx( s_abs_full_path.fn_str(), 0, NULL, &hico, 1 ) == 1 )
      {  ico.SetHICON( hico ) ; }
      /*-------------------------------------------------------------------*/
   }
   else
#endif // __WXMSW__
   /*--( For all other cases, the wx functions are used )------------------*/
   if(    ico.LoadFile( s_abs_full_path, wxBITMAP_TYPE_ANY,
                        g_co_size_tool.GetX(), g_co_size_tool.GetY()
                      )
       && ico.GetSize() != g_co_size_tool
     )
   {  /*-------------------------------------------------------------------*/
      wxBitmap bmp ;
      /*-------------------------------------------------------------------*/
      if( bmp.CopyFromIcon( ico ) )
      {  /*----------------------------------------------------------------*/
         wxImage img( bmp.ConvertToImage() ) ;
         /*----------------------------------------------------------------*/
         img.Rescale( g_co_size_tool.GetX(), g_co_size_tool.GetY(),
                      wxGetApp().M_boo_img_hq_manip.get()
                      ? wxIMAGE_QUALITY_HIGH : wxIMAGE_QUALITY_NORMAL
                    ) ;
         ico.CopyFromBitmap( img ) ;
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*-----------------------------------------------------------------------+
   ! If the file doesn't contain any (or with a problem) the one associated !
   ! to the lowercase extension (as expected) is used.                      !
   +-----------------------------------------------------------------------*/
   if( !ico.IsOk() )
   {  fii.m_i_ico = get_icon_index_ext( s_ext ) ; }
   else /*--( Add icon if not already present )----------------------------*/
   if( cit_file == m_map_file_ico.end() )
   {  fii.m_i_ico = Add( ico ) ; }
   else
   {  /*-------------------------------------------------------------------*/
      fii.m_i_ico = cit_file->second.m_i_ico ;
      Replace( fii.m_i_ico, ico ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   m_map_file_ico[ s_abs_full_path ] = fii ;
   /*----------------------------------------------------------------------*/
   return( fii.m_i_ico ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CImageFileList::get_icon_index_ext( const wxString &s_ext )
{
   /*----------------------------------------------------------------------*/
   if( s_ext.empty() ) { return( -1 ) ; }

   /*----------------------------------------------------------------------*/
   sr::t_map_str_int_cit cit_ext( m_map_ext_ico.find( s_ext ) ) ;
   /*----------------------------------------------------------------------*/
   if( cit_ext != m_map_ext_ico.end() )
   {  return( cit_ext->second ) ; }

   /*-----------------------------------------------------------------------+
   ! The extension has not been found. It has to be added.                  !
   ! First, try to get the icon associated to the extension.                !
   +-----------------------------------------------------------------------*/
   wxIcon ico ;

   /*----------------------------------------------------------------------*/
#ifdef __WXMSW__
   /*--( Get "msw" icon )--------------------------------------------------*/
   SHFILEINFO sfi ;
   /*----------------------------------------------------------------------*/
   if( SHGetFileInfo( wxString( '.' + s_ext ).fn_str(),
                      FILE_ATTRIBUTE_NORMAL,
                      &sfi, sizeof( sfi ),
                      SHGFI_USEFILEATTRIBUTES | SHGFI_ICON | SHGFI_SMALLICON
                    ) != 0
     )
   {  ico.SetHICON( sfi.hIcon ) ; }
   /*----------------------------------------------------------------------*/
#else
   /*--( All the work is based on mime types )-----------------------------*/
     wxFileType *p_file_type
   = wxTheMimeTypesManager->GetFileTypeFromExtension( s_ext ) ;
   /*----------------------------------------------------------------------*/
   if( p_file_type != NULL )
   {
      /*-------------------------------------------------------------------*/
      wxIconLocation ico_loc ;
      /*--( First, try the standard way which may not work )---------------*/
      if( p_file_type->GetIcon( &ico_loc ) && ico_loc.IsOk() )
      {  ico = wxIcon( ico_loc ) ; }
      /*-------------------------------------------------------------------*/
      delete p_file_type ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
#endif // __WXMSW__

   /*----------------------------------------------------------------------*/
   if( !ico.IsOk() ) { return( -1 ) ; }
   /*--( Icon found ! Store it )-------------------------------------------*/
   return( m_map_ext_ico[ s_ext ] = Add( ico ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CImageFileList::get_icon_index_mime( const wxString &s_ext )
{
   /*----------------------------------------------------------------------*/
     wxFileType *p_file_type
   = wxTheMimeTypesManager->GetFileTypeFromExtension( s_ext ) ;
   int i_icon_index = -1 ;

   /*----------------------------------------------------------------------*/
   if( p_file_type == NULL ) { return( i_icon_index ) ; }

   /*----------------------------------------------------------------------*/
   wxString s_mime_type ;
   /*----------------------------------------------------------------------*/
   if( p_file_type->GetMimeType( &s_mime_type ) && !s_mime_type.empty() )
   {
      /*-------------------------------------------------------------------*/
      if( s_mime_type.StartsWith( "image/" ) )
      {  i_icon_index = m_i_ind_mime_img ; }
      else
      if( s_mime_type.StartsWith( "audio/" ) )
      {  i_icon_index = m_i_ind_mime_audio ; }
      else
      if( s_mime_type.StartsWith( "video/" ) )
      {  i_icon_index = m_i_ind_mime_video ; }
      else
      if( s_mime_type.StartsWith( "text/" ) )
      {  i_icon_index = m_i_ind_mime_text ; }
      else
      if( s_mime_type.StartsWith( "message/" ) )
      {  i_icon_index = m_i_ind_mime_message ; }
      else
      if( s_mime_type == "application/pdf" )
      {  i_icon_index = m_i_ind_mime_pdf ; }
      else
      if( s_mime_type == "application/zip" )
      {  i_icon_index = m_i_ind_mime_zip ; }
      else
      if( s_mime_type == "application/epub+zip" )
      {  i_icon_index = m_i_ind_mime_epub ; }
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   delete p_file_type ;
   /*----------------------------------------------------------------------*/
   return( i_icon_index ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CImageFileList::icon_index( const CFile &file )
{
   /*--( All is done on lowercase extensions: like std MSW & Ubuntu )------*/
   wxString  s_ext_lc( file.get_name().GetExt().Lower() ) ;
   wxLogNull no_log ; // Don't want any error message
   int       i_icon_index ;

   /*----------------------------------------------------------------------*/
   if( s_ext_lc.empty() ) { return( m_i_ind_file ) ; }

   /*--( Extract icon from file. For non exe there is a size limit )-------*/
   if(    (
#ifdef __WXMSW__
            s_ext_lc == "exe" ||
#endif // __WXMSW__
            (    (    s_ext_lc == "ico" || s_ext_lc == "cur"
                   || s_ext_lc == "xpm" || s_ext_lc == "png"
                 )
              && file.get_size() <= 5 * 1024
            )
          )
       && ( i_icon_index = get_icon_index_file( file, s_ext_lc ) ) >= 0
     )
   {  return( i_icon_index ) ; }

   /*--( Try to find an icon based on the file extension )-----------------*/
   if( ( i_icon_index = get_icon_index_ext( s_ext_lc ) ) >= 0 )
   {  return( i_icon_index ) ; }

   /*--( Try to find an icon based on the mime type )----------------------*/
   if( ( i_icon_index = get_icon_index_mime( s_ext_lc ) ) >= 0 )
   {  return( i_icon_index ) ; }

   /*--( Nothing found, use the standard icon )----------------------------*/
   return( m_i_ind_file ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CImageFileList.cpp                      !
+==========================================================================*/
