/*====================================+=====================================+
! File CDragAndDrop.cpp               ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CApp.h"
#include "CDragAndDrop.h"
/*-------------------------------------------------------------------------*/



/*--( CDropDir : The first element is supposed to be a directory )---------*/
bool CDropDir::OnDropFiles( wxCoord WXUNUSED( x ), wxCoord WXUNUSED( y ),
                            const wxArrayString &ar_filenames
                          )
{
   /*----------------------------------------------------------------------*/
   if( ar_filenames.GetCount() == 0 )
   {  return( false ) ; }
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->load_directory( ar_filenames[ 0 ] ) ;
   return( true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
bool CDropOnFileList::OnDropFiles( wxCoord WXUNUSED( x ),
                                   wxCoord WXUNUSED( y ),
                                   const wxArrayString &ar_filenames
                                 )
{
   /*----------------------------------------------------------------------*/
   const int co_i_nb_filenames = ar_filenames.GetCount() ;
   if( co_i_nb_filenames == 0 ) { return( false ) ; }

   /*----------------------------------------------------------------------*/
   int        i_num_file ;
   wxFileName filename   ;
   /*----------------------------------------------------------------------*/
   int      i_num_file_found   = -1 ;
   int      i_min_file_visible = -1 ;
   int      i_max_file_visible = -1 ;
   wxString s_dir                   ;

   /*----------------------------------------------------------------------*/
   wxGetApp().get_fl()->Freeze() ;

   /*----------------------------------------------------------------------*/
   for( i_num_file = 0 ; i_num_file < co_i_nb_filenames ; ++i_num_file )
   {
      /*-------------------------------------------------------------------*/
      filename.Assign( ar_filenames[ i_num_file ] ) ;

      /*--( The directory used is the one associated to the first file )---*/
      if( i_num_file == 0 )
      {
         /*----------------------------------------------------------------*/
         s_dir = filename.GetPath( wxPATH_GET_VOLUME ) ;

         /*--( Reload the current directory ? )----------------------------*/
         if(    (     !wxGetApp().get_fl()->m_dir.get_recurse()
                   && s_dir != wxGetApp().M_s_dir.get()
                )
             || (     wxGetApp().get_fl()->m_dir.get_recurse()
                   && s_dir.StartsWith(   wxGetApp().M_s_dir.get()
                                        + wxFileName::GetPathSeparator()
                                      )
                )
           )
         {  /*--------------------------------------------------------------+
            ! No thread loading ... the selection can work only if the      !
            ! loading is finished.                                          !
            +--------------------------------------------------------------*/
            if( wxGetApp().m_frame->load_directory( s_dir, LM_NON_THREADED
                                                  ) != 0
              )
            {  goto func_end ; }
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      }

      /*--( All files have to be in the same directory )-------------------*/
      if( !filename.MakeRelativeTo( s_dir ) )
      {  continue ; }

      /*--( This file is present is the list ? )---------------------------*/
        i_num_file_found
      = wxGetApp().get_fl()->m_dir.file_with_name( filename.GetFullPath() ) ;

      /*--( If found, it is selected )-------------------------------------*/
      if( i_num_file_found >= 0 )
      {  /*----------------------------------------------------------------*/
         wxGetApp().get_fl()->sel( i_num_file_found ) ;
         /*----------------------------------------------------------------*/
         if(    i_min_file_visible < 0
             || i_min_file_visible > i_num_file_found
           )
         {  i_min_file_visible = i_num_file_found ; }
         /*----------------------------------------------------------------*/
         if(    i_max_file_visible < 0
             || i_max_file_visible < i_num_file_found
           )
         {  i_max_file_visible = i_num_file_found ; }
         /*----------------------------------------------------------------*/
      }
      /*-------------------------------------------------------------------*/
   }

   /*--( If possible the two elements will be seen )-----------------------*/
   if( i_max_file_visible >= 0 )
   {  wxGetApp().get_fl()->set_item_visible( i_max_file_visible ) ; }
   /*--( The minimum will be the visible one )-----------------------------*/
   if( i_min_file_visible >= 0 )
   {  wxGetApp().get_fl()->set_item_active( i_min_file_visible ) ; }

   /*--( A re-sort may be needed because of the modifications done by sel )*/
   if( i_num_file_found >= 0 )
   {  wxGetApp().get_fl()->sort_file_list_after_selection_change() ; }

   /*----------------------------------------------------------------------*/
func_end :
   /*----------------------------------------------------------------------*/
   wxGetApp().get_fl()->compute_new_names() ;
   /*----------------------------------------------------------------------*/
   wxGetApp().m_frame->gui_update_oper() ;
   wxGetApp().get_fl()->Thaw() ;
   wxGetApp().m_frame->Refresh() ;
   /*----------------------------------------------------------------------*/
   return( true ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CDragAndDrop.cpp                         !
+==========================================================================*/
