/*====================================+=====================================+
! File CDlgFilter.cpp                 ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CApp.h"
#include "CDlgFilter.h"
#include "CCombo.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
wxString CDlgFilter::st_get_match_dialog_text( bool boo_match )
{
   /*----------------------------------------------------------------------*/
   return( boo_match
           ? _( "matching the filter" )
           : _( "not matching the filter" )
         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFilter::CDlgFilter( wxWindow *parent,
                        const wxString &s_title,
                        const wxString &s_text_file,
                        const wxString &s_text_dir
                      )
          : CDlgFilterBase( parent, wxID_ANY, s_title )
{
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_cb_fil, wxGetApp().M_boo_fil_fix.get() ) ;
   m_cb_fil->set_simulate_enter_key( false ) ;
   m_cb_fil->Append( wxGetApp().M_as_opfil.get() ) ;
   m_cb_fil->SetValue( wxGetApp().M_s_opfil.get() ) ;
   m_sb_sizer->GetStaticBox()->SetLabel( s_text_file ) ;
   /*----------------------------------------------------------------------*/
   m_boo_match->SetLabel( st_get_match_dialog_text( true ) ) ;
   m_boo_not_match->SetLabel( st_get_match_dialog_text( false ) ) ;
   /*----------------------------------------------------------------------*/
   if( wxGetApp().M_boo_opfil_match.get() )
   {  m_boo_match->SetValue( true ) ; }
   else
   {  m_boo_not_match->SetValue( true ) ; }
   /*----------------------------------------------------------------------*/
   m_boo_dir->SetLabel( s_text_dir ) ;
   m_boo_dir->SetValue( wxGetApp().M_boo_opfil_dir.get() ) ;
   /*----------------------------------------------------------------------*/
   m_cb_fil->SetFocus() ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, wxGetApp().M_rec_filter ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFilter::~CDlgFilter()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_filter ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgFilter::OnBtOk( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   EndModal( wxID_OK ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgFilter::OnFilChange( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetEventType() == wxEVT_COMMAND_COMBOBOX_SELECTED )
   {  m_cb_fil->move_current_value_to_top() ; }
   else
   {  m_cb_fil->add_current_value_to_list() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDlgFilter::get_modal()
{
   /*----------------------------------------------------------------------*/
   if( ShowModal() == wxID_OK )
   {
      /*--( Save dialog modifications )------------------------------------*/
      m_cb_fil->add_current_value_to_list() ;
      /*-------------------------------------------------------------------*/
      wxGetApp().M_as_opfil.set( m_cb_fil->GetStrings() ) ;
      wxGetApp().M_s_opfil.set( m_cb_fil->GetValue() ) ;
      wxGetApp().M_boo_opfil_match.set( m_boo_match->GetValue() ) ;
      wxGetApp().M_boo_opfil_dir.set( m_boo_dir->GetValue() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( GetReturnCode() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFilterSearch::CDlgFilterSearch( wxWindow *parent )
                : CDlgFilterSearchBase( parent, wxID_ANY )
{
   /*----------------------------------------------------------------------*/
   sr::set_font_fix( m_cb_fil, wxGetApp().M_boo_fil_fix.get() ) ;
   m_cb_fil->set_simulate_enter_key( false ) ;
   m_cb_fil->Append( wxGetApp().M_as_opfil.get() ) ;
   m_cb_fil->SetValue( wxGetApp().M_s_opfil.get() ) ;
   /*----------------------------------------------------------------------*/
   m_boo_match->SetLabel( CDlgFilter::st_get_match_dialog_text( true ) ) ;
   m_boo_not_match->SetLabel( CDlgFilter::st_get_match_dialog_text( false ));
   if( wxGetApp().M_boo_opfil_match.get() )
   {  m_boo_match->SetValue( true ) ; }
   else
   {  m_boo_not_match->SetValue( true ) ; }
   /*----------------------------------------------------------------------*/
   m_boo_dir->SetValue( wxGetApp().M_boo_opfil_dir.get() ) ;
   /*----------------------------------------------------------------------*/
   m_cb_fil->SetFocus() ;
   /*----------------------------------------------------------------------*/
   wxGetApp().init_tlw_rect( this, wxGetApp().M_rec_filter_search ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
CDlgFilterSearch::~CDlgFilterSearch()
{
   /*----------------------------------------------------------------------*/
   wxGetApp().save_tlw_rect( this, wxGetApp().M_rec_filter_search ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgFilterSearch::OnTextEnter( wxCommandEvent & WXUNUSED( event ) )
{
   /*----------------------------------------------------------------------*/
   EndModal( DLG_IDM_FIND_FIRST ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
void CDlgFilterSearch::OnFilChange( wxCommandEvent &event )
{
   /*----------------------------------------------------------------------*/
   if( event.GetEventType() == wxEVT_COMMAND_COMBOBOX_SELECTED )
   {  m_cb_fil->move_current_value_to_top() ; }
   else
   {  m_cb_fil->add_current_value_to_list() ; }
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
int CDlgFilterSearch::get_modal()
{
   /*----------------------------------------------------------------------*/
   if( ShowModal() != wxID_CANCEL )
   {
      /*--( Save dialog modifications )------------------------------------*/
      m_cb_fil->add_current_value_to_list() ;
      /*-------------------------------------------------------------------*/
      wxGetApp().M_as_opfil.set( m_cb_fil->GetStrings() ) ;
      wxGetApp().M_s_opfil.set( m_cb_fil->GetValue() ) ;
      wxGetApp().M_boo_opfil_match.set( m_boo_match->GetValue() ) ;
      wxGetApp().M_boo_opfil_dir.set( m_boo_dir->GetValue() ) ;
      /*-------------------------------------------------------------------*/
   }
   /*----------------------------------------------------------------------*/
   return( GetReturnCode() ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CDlgFilter.cpp                          !
+==========================================================================*/
