/*====================================+=====================================+
! File CColmun.cpp                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#include "CApp.h"
#include "CColumn.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
bool operator == ( const CColumn &col, int i_subitem )
{  return( col.m_i_subitem == i_subitem ) ; }

/*-------------------------------------------------------------------------*/
bool operator == ( const CColumn &c1, const CColumn &c2 )
{  return(    c1.m_i_subitem == c2.m_i_subitem
           && c1.m_boo_on    == c2.m_boo_on
           && c1.m_i_width   == c2.m_i_width
         ) ;
}

/*-------------------------------------------------------------------------*/
bool CColumn::get_on_default()
{
   /*----------------------------------------------------------------------*/
   return(    m_grp != GRP_BASE
           || m_i_subitem == COL_BASE_SIZE
           || m_i_subitem == COL_BASE_TYPE
           || m_i_subitem == COL_BASE_MOD_DATE
         ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/
bool CColumn::to_display() const
{
   /*--( Some info are always displayed )----------------------------------*/
   if( m_boo_on_forced ) { return( true ) ; }
   /*--( If it is not wanted then it is not displayed it ... )-------------*/
   if( !m_boo_on ) { return( false ) ; }
   /*--( The columns without groups are displayed )------------------------*/
   if( m_grp == GRP_NONE ) { return( true ) ; }
   /*--( Empty columns are wanted ? )--------------------------------------*/
   if( wxGetApp().M_boo_col_used.get() && !m_boo_used )
   {  return( false ) ; }
   /*-----------------------------------------------------------------------+
   ! Then it depends on what is wanted ...                                  !
   ! This will work in "automatic" mode or not.                             !
   +-----------------------------------------------------------------------*/
   return( wxGetApp().m_colgroup.to_display( m_grp ) ) ;
   /*----------------------------------------------------------------------*/
}

/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CColumn.cpp                            !
+==========================================================================*/
