/*====================================+=====================================+
! File sr_string.h                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef SR_STRING_H
#define SR_STRING_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
namespace sr
{

/*--( Conversion type to use for strings )---------------------------------*/
enum e_conv_type
{  CONV_FROM_8BIT, CONV_FROM_UTF8, CONV_FROM_MAC,
   CONV_FROM_UTF16LE, CONV_FROM_UTF16BE, CONV_FROM_UTF16LEBE,
   CONV_FROM_NB
} ;

/*--( sr_string.cpp )------------------------------------------------------*/
inline void double_backslash( wxString &s )
{  s.Replace( "\\", "\\\\", true ) ; }
inline bool ic_equal( const wxUniChar &c1, const wxUniChar &c2 )
{  return( wxToupper( c1 ) == wxToupper( c2 ) ) ; }
inline bool bool_isdigit( const wxUniChar &c )
{  return( wxIsdigit( c ) != 0 ) ; }
inline bool bool_isxdigit( const wxUniChar &c )
{  return( wxIsxdigit( c ) != 0 ) ; }
inline bool bool_isodigit( const wxUniChar &c )
{  return( wxIsdigit( c ) != 0 && c < '8' ) ; }
inline bool bool_isalpha( const wxUniChar &c )
{  return( wxIsalpha( c ) != 0 ) ; }
inline bool bool_isalnum( const wxUniChar &c )
{  return( wxIsalnum( c ) != 0 ) ; }
inline bool bool_isspace( const wxUniChar &c )
{  return( wxIsspace( c ) != 0 ) ; }
inline int char_value( int c )
{  return( c - '0' ) ; }
inline int xchar_value( int c )
{  return( bool_isdigit( c ) ? c - '0' : wxToupper( c ) - 'A' + 10 ) ; }
inline int ctrl_char( const wxUniChar &c )
{  return( c.GetValue() - 'A' + 1 ) ; }
inline bool is_string_delimiter( const wxUniChar &c )
{  return( c == '"' || c == '\'' ) ; }

void next_non_space( sr::wxString_cit it_end, sr::wxString_cit &it ) ;
bool ic_is_lower( const wxUniChar &a, const wxUniChar &b ) ;
int ic_comp( sr::wxString_cit it1, sr::wxString_cit it2, int i_nb );
int ic_comp( const wxString &s1, const wxString &s2 ) ;
int natural_comp( const wxString &s1, const wxString &s2 ) ;
wxUniChar unaccent( const wxUniChar &c ) ;
wxString unaccent( const wxString &s ) ;

enum e_cls { CLS_DONT_CLEAN_STRING, CLS_DO_CLEAN_STRING } ;
wxString replace_percent_xx( const wxString &s,
                             e_cls cls = CLS_DONT_CLEAN_STRING
                           ) ;
wxString convert_ascii_utf8( const wxString &s,
                             e_cls cls = CLS_DONT_CLEAN_STRING
                           ) ;

wxString keep_one_of( const wxString &s ) ;
void replace_filename_forbidden_chars( wxString &s_name,
                                       const wxString &s_by
                                     ) ;
void delete_chars( wxString &s, const wxString &s_char_list ) ;
void delete_repeat_chars( wxString &s, const wxString &s_char_list ) ;
wxString lpad_ll_with_0( const wxLongLong &ll, int i_pad ) ;
wxString::size_type ic_search_beg( const wxString &s,
                                   const wxString &s_what,
                                   wxString::size_type pos
                                 ) ;
wxString::size_type ic_search_end( const wxString &s,
                                   const wxString &s_what,
                                   wxString::size_type pos
                                 ) ;
/*-------------------------------------------------------------------------*/
bool has_BOM16( const char *p_c, int i_len ) ;
void utf16_to_string( const char *p_c, int i_len, wxString &s ) ;
/*-------------------------------------------------------------------------*/
sr::wxString_cit conv_str_to_int( sr::wxString_cit it,
                                  sr::wxString_cit it_end,
                                  int &i_val
                                ) ;
sr::wxString_cit conv_time_to_nb_sec( sr::wxString_cit it,
                                      sr::wxString_cit it_end,
                                      int &i_nb_sec
                                    ) ;
void replace_string( wxString &s,
                     const wxString &s_from, const wxString &s_to,
                     bool boo_case_sens, int i_start_occ, int i_nb_rep
                   ) ;
void replace_chars( wxString &s,
                    const wxUniChar &c_from, const wxUniChar &c_to
                  ) ;
void replace_chars( wxString &s,
                    const wxString &s_from, const wxString &s_to
                  ) ;
int  clean_string( wxString &s ) ;
int  prepare_string( const char *p_c_val, int i_len, wxString &s,
                     sr::e_conv_type conv_type_local
                   ) ;
/*-------------------------------------------------------------------------*/
enum e_fcw { FCW_DONT_FORCE_CASE, FCW_DO_FORCE_CASE } ;
void fcw_update( wxString &s ) ;
void fcw_upper( wxString &s, e_fcw fcw_force ) ;
void fcw_upper_first_word_letter( wxString &s, e_fcw fcw_force ) ;
void fcw_lower( wxString &s, e_fcw fcw_force ) ;
void fcw_upper_first_letter_lower_rest( wxString &s, e_fcw fcw_force ) ;
/*-------------------------------------------------------------------------*/
void prepend_with_sep( const wxString &s_toadd, const wxString &s_sep,
                       wxString &s_result
                     ) ;
void append_with_sep( const wxString &s_toadd, const wxString &s_sep,
                      wxString &s_result
                    ) ;
/*-------------------------------------------------------------------------*/
wxString conv_to_hex( void *p_v, size_t sz ) ;
wxString byte_to_string( wxUint8 b ) ;
/*-------------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // SR_STRING_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file sr_string.h                           !
+==========================================================================*/
