/*====================================+=====================================+
! File CLogGuiGrouped.h               ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
! This class is a wxLogGui version appending information to its end:        !
! the number of errors and, if needed, a complementary message.             !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CLOGGUIGROUPED_H
#define CLOGGUIGROUPED_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/log.h>
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CLogGuiGrouped : public wxLogGui
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CLogGuiGrouped( const wxString s_info = wxEmptyString )
                    : wxLogGui(), m_s_info( s_info )
      {  m_p_log_previous = wxLog::SetActiveTarget( this ) ; }
      virtual ~CLogGuiGrouped()
      {  wxLog::SetActiveTarget( m_p_log_previous ) ; }
      /*-------------------------------------------------------------------*/
      wxString get_last_err() const { return( m_aMessages.Last() ) ; }
      bool has_err() const { return( m_bHasMessages ) ; }
      /*-------------------------------------------------------------------*/
      void Clear() { wxLogGui::Clear() ; }
      virtual void Flush() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxLog    *m_p_log_previous ;
      wxString m_s_info ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CLOGGUIGROUPED_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                        End of file CLogGuiGrouped.h                       !
+==========================================================================*/
