/*====================================+=====================================+
! File CExternalData.h                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CEXTDATA_H
#define CEXTDATA_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <map>
/*-------------------------------------------------------------------------*/
#include <wx/datetime.h>
#include <wx/arrstr.h>
#include <wx/filename.h>
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! System Time stored as a wxDateTime                                        !
! Having the same date time for all files in a computation batch seems      !
! good idea                                                                 !
+--------------------------------------------------------------------------*/
class CExternalData_Systime
{
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxDateTime m_dt_st ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void reset() { m_dt_st = wxDateTime::Now() ; }
      wxDateTime get_data() { return( m_dt_st ) ; }
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CExternalDataLine
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CExternalDataLine()
      {  reset() ; }
      virtual ~CExternalDataLine()
      {  ; }
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxArrayString m_as_line    ;
      bool          m_boo_reload ;
   /*----------------------------------------------------------------------*/
   protected :
      /*-------------------------------------------------------------------*/
      void zero_tab_line() { m_as_line.clear() ; }
      /*-------------------------------------------------------------------*/
      void add_all_lines( const wxString &s_text ) ;
      /*--( reload can be called by "get_line" )---------------------------*/
      virtual int reload() = 0 ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool get_reload() const { return( m_boo_reload ) ; }
      void set_reload( bool boo_val ) { m_boo_reload = boo_val ; }
      void reset() { set_reload( true ) ; }
      /*-------------------------------------------------------------------*/
      wxString get_line( int i_num_line ) ;
   /*----------------------------------------------------------------------*/
} ;

/*--( ClipBoard )----------------------------------------------------------*/
class CExternalData_Clipboard : public CExternalDataLine
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      //CExternalData_Clipboard()  ;
      //~CExternalData_Clipboard() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      virtual int reload() ;
   /*----------------------------------------------------------------------*/
} ;

/*--( Text files )---------------------------------------------------------*/
class CExternalData_File
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CExternalData_File() ;
      virtual ~CExternalData_File() ;
   /*----------------------------------------------------------------------*/
   private :

      /*--( One file )-----------------------------------------------------*/
      class CTextFile : public CExternalDataLine
      {
         /*----------------------------------------------------------------*/
         public :
            /*-------------------------------------------------------------*/
            CTextFile( const wxFileName &name ) ;
            //~CTextFile() ;
         /*----------------------------------------------------------------*/
         private :
            /*-------------------------------------------------------------*/
            wxFileName m_name   ;
            wxDateTime m_dt_mod ; // Last modification date of the file
         /*----------------------------------------------------------------*/
         private :
            /*-------------------------------------------------------------*/
            void zero_dt_mod()
            {  m_dt_mod = wxDefaultDateTime ; }
            virtual int reload() ;
         /*----------------------------------------------------------------*/
         public :
            /*-------------------------------------------------------------*/
            const wxFileName &get_name() const { return( m_name ) ; }
         /*----------------------------------------------------------------*/
      } ;

      /*-------------------------------------------------------------------*/
      typedef std::map< wxString, CTextFile > t_map_file_text ;
      typedef t_map_file_text::iterator       t_map_file_text_it ;
      /*-------------------------------------------------------------------*/
      t_map_file_text    m_map_file_text  ;
      t_map_file_text_it m_it_active_file ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void set_active_file( const wxString &s_dir,
                            const wxString &s_name
                          ) ;
      void reset_active_file() { m_it_active_file = m_map_file_text.end() ; }
      /*-------------------------------------------------------------------*/
      void reset() ;
      wxString get_line( int i_num_line ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CEXTDATA_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CExternalData.h                       !
+==========================================================================*/
