/*====================================+=====================================+
! File CCrypt.h                       ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCRYPT_H
#define CCRYPT_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <string.h>
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Be careful:                                                               !
! The member variable "m_tb_uc_S" is modified during the crypt phase.       !
! To crypt/decrypt different messages with the same password don't forget   !
! to call the "init" function of the object.                                !
! Not calling it supposes the message is made of different chunks.          !
+--------------------------------------------------------------------------*/
class CCryptRC4
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCryptRC4()
      {  ; }
      CCryptRC4( const unsigned char *p_uc_pwd, size_t sz_pwd_len )
      {  init( p_uc_pwd, sz_pwd_len ) ; }
      CCryptRC4( const char *p_c_pwd )
      {  init( ( const unsigned char * )p_c_pwd, strlen( p_c_pwd ) ) ; }
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      unsigned char m_tb_uc_S[ 256 ] ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void init( const unsigned char *p_uc_pwd, size_t sz_pwd_len ) ;
      void init( const char *p_c_pwd )
      {  init( ( unsigned char * )p_c_pwd, strlen( p_c_pwd ) ) ; }

      /*--( "In" and "Out" can be the same )-------------------------------*/
      void crypt( const unsigned char *p_uc_in, size_t sz_in_len,
                  unsigned char *p_uc_out
                ) ;
      void crypt( unsigned char *p_uc_in, size_t sz_in_len )
      {  crypt( p_uc_in, sz_in_len, p_uc_in ) ; }
      void crypt( const char *p_c_in, char *p_c_out ) ;
      void crypt( char *p_c_in )
      {  crypt( p_c_in, p_c_in ) ; }
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCHOICE_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                           End of file CCrypt.h                            !
+==========================================================================*/
