/*====================================+=====================================+
! File CChecksum.h                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCHECKSUM_H
#define CCHECKSUM_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CChecksum
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CChecksum( const char *co_p_c_checksum_name )
               : m_co_p_c_checksum_name( co_p_c_checksum_name )
      {  ; }
      virtual ~CChecksum() { ; }
      /*-------------------------------------------------------------------*/
      typedef void ( *t_fnc_progress_info )( const wxString &s ) ;
   /*----------------------------------------------------------------------*/
   protected :
      /*-------------------------------------------------------------------*/
      unsigned char m_tb_uc_result[ 32 ] ;
      int           m_i_result_len       ;
      /*--( Chacksum type for the "running" message )----------------------*/
      const char *m_co_p_c_checksum_name ;

   /*----------------------------------------------------------------------*/
   protected :
      /*-------------------------------------------------------------------*/
      virtual void add_data( const unsigned char *p_uc_buffer,
                             size_t sz_buffer_len
                           ) = 0 ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void init() = 0 ;
      virtual void final() = 0 ;
      /*-------------------------------------------------------------------*/
      void result_to_string( wxString &s_result ) const ;
      int update( const wxFileName &filename,
                  t_fnc_progress_info p_fnc_progress = NULL
                ) ;
      void update( const unsigned char *p_uc_buffer,
                   size_t sz_buffer_len
                 )
      {  add_data( p_uc_buffer, sz_buffer_len ) ; }
      void update( const char *p_c_buffer )
      {  add_data( ( unsigned char * )p_c_buffer, strlen( p_c_buffer ) ) ; }
      void update( wxUint32 dw )
      {  add_data( ( unsigned char * )&dw, sizeof( dw ) ) ; }

      /*--( One single step ... )------------------------------------------*/
      void calc( const unsigned char *p_uc_buffer, size_t sz_buffer_len,
                 unsigned char *p_uc_result
               ) ;
      void calc( const char *p_c_buffer, unsigned char *p_uc_result ) ;
      wxString calc( const wxString &s_in ) ;
      /*-------------------------------------------------------------------*/
      int  calc( const wxFileName &filename, wxString &s_result,
                 t_fnc_progress_info p_fnc_progress = NULL
               ) ;

      /*-------------------------------------------------------------------*/
      int get_result_len() const
      {  return( m_i_result_len ) ; }
      const unsigned char *get_result() const
      {  return( m_tb_uc_result ) ; }
      void copy_result( unsigned char *p_c_result ) const
      {  memcpy( p_c_result, m_tb_uc_result, m_i_result_len ) ; }
      /*-------------------------------------------------------------------*/
      wxUint32 leftrotate( wxUint32 dw, wxUint32 dw_nb )
      {  return( ( dw << dw_nb ) | ( dw >> ( 32 - dw_nb ) ) ) ; }

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CChecksumMD5 : public CChecksum
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CChecksumMD5( const char *co_p_c_checksum_name = "MD5" )
                  : CChecksum( co_p_c_checksum_name )
      {  ; }
      virtual void init() ;
      virtual void final() ;
   /*----------------------------------------------------------------------*/
   protected :
      /*--( Number of bytes participating to this checksum )---------------*/
      wxULongLong m_ull_total_size ;
      /*--( This will hold the rest of the 64 bytes block between updates )*/
      unsigned char m_tb_uc_not_treated_buffer[ 64 ] ;
      int m_i_not_treated_buffer_len ;

      /*-------------------------------------------------------------------*/
      wxUint32 m_dw_h0 ;
      wxUint32 m_dw_h1 ;
      wxUint32 m_dw_h2 ;
      wxUint32 m_dw_h3 ;
   /*----------------------------------------------------------------------*/
   private :
      /*--( Constant data )------------------------------------------------*/
      static bool m_st_boo_init_done     ;
      static wxUint32 m_st_tb_dw_r[ 64 ] ;
      static wxUint32 m_st_tb_dw_k[ 64 ] ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      enum e_sltt { DONT_SUM_LENGTH_TO_TOTAL, DO_SUM_LENGTH_TO_TOTAL } ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      virtual void add_data_64bytes( const unsigned char *p_uc_buffer,
                                     e_sltt sltt = DO_SUM_LENGTH_TO_TOTAL
                                   ) ;
      virtual void add_data( const unsigned char *p_uc_buffer,
                             size_t sz_buffer_len
                           ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CChecksumSHA1 : public CChecksumMD5
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CChecksumSHA1() : CChecksumMD5( "SHA1" )
      {  ; }
      virtual void init() ;
      virtual void final() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxUint32 m_dw_h4 ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      virtual void add_data_64bytes( const unsigned char *p_uc_buffer,
                                     e_sltt sltt = DO_SUM_LENGTH_TO_TOTAL
                                   ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CChecksumCRC32 : public CChecksum
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CChecksumCRC32() : CChecksum( "CRC32" )
      {  ; }
      virtual void init() ;
      virtual void final() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxUint32 m_dw_result ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      inline void crc32_byte( const unsigned char uc_byte ) ;
      virtual void add_data( const unsigned char *p_uc_buffer,
                             size_t sz_buffer_len
                           ) ;

      /*--( Useless to recompute these constant data )---------------------*/
      static bool m_st_boo_init_done ;
      static wxUint32 m_st_tb_crc32[ 256 ] ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCHECKSUM_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CChecksum.h                          !
+==========================================================================*/
