/*====================================+=====================================+
! File CTestbed.h                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CTESTBED_H
#define CTESTBED_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include "sr_testbed.h"
#include "CCompletion.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CTestbed : public CTestbedBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CTestbed( wxWindow *parent ) ;
      virtual ~CTestbed() ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCompletion *m_completion ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual void OnClose( wxCloseEvent &event ) ;
      virtual void OnBtCompletion( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtCompute( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtCopyMainExp( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtCopyMainDir( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnBtCopyMainSel( wxCommandEvent & WXUNUSED( event ) ) ;
      virtual void OnKeyDownTextCtrl( wxKeyEvent &event ) ;
      virtual void OnBtOk( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void init() ;
      void setup_immediate_recompute() ;
      void close_completion() ;
      CFile new_file( const wxString &s_name ) ;
      void compute() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CTESTBED_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CTestbed.h                            !
+==========================================================================*/

