/*====================================+=====================================+
! File CLoadDir.h                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CLOADDIR_H
#define CLOADDIR_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/dir.h>
#include "CDir.h"
#include "CFileList.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
enum e_loading_mode
{  LM_THREADED,
   LM_NON_THREADED
} ;
/*-------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------+
! Some loading parameters are optional. They are used only in a few         !
! circumstances (repositioning on the name given as parameter ...)          !
! It is necessary to have a copy of it in the loading code else due to the  !
! multi-threading some of these parameters could be modified while being    !
! used.                                                                     !
! These parameters are the ones used in the post loading phase.             !
+--------------------------------------------------------------------------*/
class CLoadDirParam
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CLoadDirParam()  ;
      ~CLoadDirParam() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxString m_s_repos_name        ;
      wxString m_s_sel_filter        ;
      bool     m_boo_add_dir_to_hist ;
      bool     m_boo_keep_oper_err   ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      const wxString &get_repos_name() const
      {  return( m_s_repos_name ) ; }
      void set_repos_name( const wxString &s_val )
      {  m_s_repos_name = s_val ; }
      void raz_repos_name() { m_s_repos_name.clear() ; }
      /*-------------------------------------------------------------------*/
      const wxString &get_sel_filter() const
      {  return( m_s_sel_filter ) ; }
      void set_sel_filter( const wxString &s_val )
      {  m_s_sel_filter = s_val ; }
      void raz_sel_filter() { m_s_sel_filter.clear() ; }
      /*-------------------------------------------------------------------*/
      bool get_add_dir_to_hist() const
      {  return( m_boo_add_dir_to_hist ) ; }
      void set_add_dir_to_hist( bool boo_val )
      {  m_boo_add_dir_to_hist = boo_val ; }
      /*-------------------------------------------------------------------*/
      bool get_keep_oper_err() const
      {  return( m_boo_keep_oper_err ) ; }
      void set_keep_oper_err( bool boo_val )
      {  m_boo_keep_oper_err = boo_val ; }
      /*-------------------------------------------------------------------*/
      void init() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CThreadLoadDir ;

/*-------------------------------------------------------------------------*/
class CLoadDir : public wxDirTraverser
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CLoadDir()  ;
      ~CLoadDir() ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxString   m_s_path               ;
      wxString   m_s_filter             ;
      bool       m_boo_same_dir         ;
      bool       m_boo_list_dir         ; // List directories ?
      bool       m_boo_filter_dir       ; // Filter applied on dir too ?
      bool       m_boo_list_hidden      ; // List hidden files ?
      /*-------------------------------------------------------------------*/
      int        m_i_nb_disp            ;
      bool       m_boo_display_run_info ;
      wxLongLong m_ll_time_last_info    ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CThreadLoadDir    *m_p_thread     ;
      wxCriticalSection m_csec_p_thread ;
      /*-------------------------------------------------------------------*/
      CDir          m_dir   ;
      CLoadDirParam m_param ;
      bool          m_boo_thread_stopping ;
      /*--------------------------------------------------------------------+
      ! After a certain time the file list is cleared (standard display     !
      ! scheme under MSW and Gnome). The focus, highlight ... have to be    !
      ! kept to set them back if the loaded directory stays the same.       !
      +--------------------------------------------------------------------*/
      CFileListDisplayState m_fl_display_state ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      void display_run_info() ;
      virtual wxDirTraverseResult OnDir( const wxString &s_dirname ) ;
      virtual wxDirTraverseResult OnFile( const wxString &s_filename ) ;
      void exec() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int add_name( const wxString &s_name, bool boo_is_dir ) ;
      /*-------------------------------------------------------------------*/
      void send_end_event( bool boo_synchronized = false ) ;
      void non_threaded_exec() ;
      void thread_start() ;
      void thread_stop() ;
      /*-------------------------------------------------------------------*/
      bool thread_running() ;
      bool can_display_run_info() const
      {  return( m_boo_display_run_info ) ; }
      /*-------------------------------------------------------------------*/
      wxString get_path() const { return( m_s_path ) ; }
      void set_path( const wxString &s ) { m_s_path = s ; }
      wxString get_filter() const { return( m_s_filter ) ; }
      void set_filter( const wxString &s ) { m_s_filter = s ; }
      bool get_same_dir() const { return( m_boo_same_dir ) ; }
      void set_same_dir( bool boo_val ) { m_boo_same_dir = boo_val ; }
      /*-------------------------------------------------------------------*/
      bool get_list_dir() const { return( m_boo_list_dir ) ; }
      void set_list_dir( bool boo_val ) { m_boo_list_dir = boo_val ; }
      bool get_filter_dir() const { return( m_boo_filter_dir ) ; }
      void set_filter_dir( bool boo_val ) { m_boo_filter_dir = boo_val ; }
      bool get_list_hidden() const { return( m_boo_list_hidden ) ; }
      void set_list_hidden( bool boo_val ) { m_boo_list_hidden = boo_val ; }

   /*----------------------------------------------------------------------*/
   friend class CThreadLoadDir ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CThreadLoadDir : public wxThread
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CThreadLoadDir( CLoadDir *p_ld ) ;
      ~CThreadLoadDir() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      CLoadDir         *m_p_ld ;
      e_send_end_event m_seevt ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      e_send_end_event get_send_end_event() const
      {  return( m_seevt ) ; }
      void set_send_end_event( e_send_end_event seevt )
      {  m_seevt = seevt ; }
      /*-------------------------------------------------------------------*/
      void gui_enable_stop_loading( bool boo_on ) ;
      /*--( Will be executed by "Run" )------------------------------------*/
      virtual wxThread::ExitCode Entry() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CLOADDIR_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CLoadDir.h                            !
+==========================================================================*/
