/*====================================+=====================================+
! File CFrame.h                       ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CFRAME_H
#define CFRAME_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/frame.h>
#include <wx/artprov.h>
/*-------------------------------------------------------------------------*/
#include "CLoadDir.h"
#include "CCheckVersion.h"
#include "CDirHistory.h"
/*-------------------------------------------------------------------------*/
class wxBoxSizer ;
class wxNotebook ;
class wxStaticLine ;
class wxSplitterWindow ;
class wxHtmlHelpController ;
/*-------------------------------------------------------------------------*/
class CComboExp ;
class CComboDir ;
class CComboFil ;
class CFileList ;
class CDirTree ;
class CImageVisu ;
class CTagVisu ;
class CLoadDirParam ;
class CCompletion ;
class CWizard ;
class CTestbed ;
class CFSWatcher ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CFrame : public wxFrame
{
   /*----------------------------------------------------------------------*/
   public :
      /*--( CFrame_Init.cpp )----------------------------------------------*/
      CFrame() ;
      virtual ~CFrame() ;

   /*----------------------------------------------------------------------*/
   private :
      /*--------------------------------------------------------------------+
      ! Current "recurse" state. The recurse member of the CDir class       !
      ! corresponds to the recurse state when the loading has been done.    !
      +--------------------------------------------------------------------*/
      bool m_boo_recurse ;
      /*--------------------------------------------------------------------+
      ! Temporarily not display images                                      !
      +--------------------------------------------------------------------*/
      bool m_boo_disp_image ;
      /*--------------------------------------------------------------------+
      ! Disabling inputs can be necessary if a Yield is started. This is    !
      ! useful in conjunction with CRunInfoMessage and other running task   !
      ! information.                                                        !
      +--------------------------------------------------------------------*/
      wxWindowDisabler *m_p_win_disabler ; // Helper disabling inputs
      /*--------------------------------------------------------------------+
      ! To enable other searches like next, first ... the search dialog     !
      ! (search First) must have been validated                             !
      +--------------------------------------------------------------------*/
      bool m_boo_search_dialog_done ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxPanel           *m_panel        ;
      wxBoxSizer        *m_bsz_gen      ;
      wxBoxSizer        *m_bsz_act      ;
      /*-------------------------------------------------------------------*/
      wxBoxSizer        *m_bsz_exp_glob ; // Global sizer for exp
      wxStaticLine      *m_sep_exp      ; // Separation line in front of exp
      wxBoxSizer        *m_bsz_exp      ; // Exp Label + Combo
      /*-------------------------------------------------------------------*/
      wxToolBar         *m_to_act       ;
      wxToolBar         *m_to_sel       ;
      wxToolBar         *m_to_grp       ; // Column groups
      CComboExp         *m_cb_exp       ;
      wxToolBar         *m_to_exp       ;
      CCompletion       *m_completion   ;
      CWizard           *m_wizard       ;
      CTestbed          *m_testbed      ;
      CComboDir         *m_cb_dir       ;
      wxToolBar         *m_to_aco_dir   ;
      wxToolBar         *m_to_dir       ;
      CComboFil         *m_cb_fil       ;
      /*-------------------------------------------------------------------*/
      wxSplitterWindow  *m_spl_ver      ;
      wxSplitterWindow  *m_spl_hor      ;
      /*-------------------------------------------------------------------*/
      CFileList         *m_fl           ; // File list
      CDirTree          *m_dt           ; // Directory tree
      wxNotebook        *m_nb           ; // Notebook: image / tag
      CImageVisu        *m_iv           ; // Image view
      CTagVisu          *m_tv           ; // Tag view
      /*-------------------------------------------------------------------*/
      wxStatusBar       *m_statusbar    ;
      CFSWatcher        *m_fswatcher    ;
      /*--------------------------------------------------------------------+
      ! m_loaddir is the class in charge of the file/metadata loading in a  !
      ! separate thread (or not).                                           !
      ! m_loaddir_param is the class containing some "external" parameters  !
      ! that can possibly be changed by the main thread.                    !
      ! Due to this m_loaddir_param is defined in m_loaddir and here.       !
      ! The first one is used during the loading while the second can be    !
      ! modified.                                                           !
      +--------------------------------------------------------------------*/
      CLoadDir          m_loaddir       ;
      CLoadDirParam     m_loaddir_param ;
      /*-------------------------------------------------------------------*/
      CCheckVersion     m_checkversion  ;
      /*--( Directory location history )-----------------------------------*/
      CDirHistory       m_dir_history   ;
      /*-------------------------------------------------------------------*/
      wxHtmlHelpController *m_help ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool get_search_dialog_done() const
      {  return( m_boo_search_dialog_done ) ; }
      /*-------------------------------------------------------------------*/
      wxBitmap get_toolbar_bmp( const wxArtID &id )
      {  return( wxArtProvider::GetBitmap( id, wxART_TOOLBAR, g_co_size_tool
                                         )
               ) ;
      }
      /*-------------------------------------------------------------------*/
      bool get_disp_image() const { return( m_boo_disp_image ) ; }
      void set_disp_image( bool boo_val ) { m_boo_disp_image = boo_val ; }
      bool get_recurse() const { return( m_boo_recurse ) ; }
      void set_recurse( bool boo_val ) { m_boo_recurse = boo_val ; }

      /*--------------------------------------------------------------------+
      ! CFrame_Init.cpp                                                     !
      +--------------------------------------------------------------------*/
      void init() ;
      void create_fswatcher() ;
      void add_menu_bar() ;
      void add_layout_components() ;
      void add_status_bar() ;

      /*--------------------------------------------------------------------+
      ! CFrame_Base.cpp                                                     !
      +--------------------------------------------------------------------*/
      void adapt_toolbars_layout() ;
      void adapt_splitter_layout() ;
      void set_global_layout( e_layout layout ) ;
      bool get_fswatcher_active() const ;
      void gui_enable_search() ;
      void gui_enable_stop_loading( bool boo_on ) ;

      void gui_update_oper() ;
      void gui_update_recurse() ;
      void gui_update_dir() ;
      void status_disp_text( long l_item = -1 ) ;

      void stop_current_load_directory( e_send_end_event seevt ) ;
      int  load_directory( const wxString &s_path = wxEmptyString,
                           e_loading_mode loading_mode = LM_THREADED
                         ) ;
      int  change_directory( const wxString &s_dir,
                             e_loading_mode loading_mode = LM_THREADED
                           ) ;
      void setup_immediate_recompute() ;
      void first_contact_dialog() ;
      int  show_help( const wxString &s_page = wxEmptyString ) ;
      /*-------------------------------------------------------------------*/
      void allow_user_input( bool boo_on ) ;
      /*-------------------------------------------------------------------*/
      void visu_file( long l_item ) ;
      void visu_file() ;
      /*-------------------------------------------------------------------*/
      void trsf_exp_combo_var() ;

      /*--------------------------------------------------------------------+
      ! CFrame_On.cpp                                                     !
      +--------------------------------------------------------------------*/
      void OnFirstIdle( wxIdleEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnLoadDirEnd( wxCommandEvent &event ) ;
      void OnCheckVersionAutoEnd( wxCommandEvent &event ) ;
      void OnGetNewVersion( wxCommandEvent &event ) ;
      void OnDispInfo( wxCommandEvent &event ) ;
      void OnSetBtStopLoading( wxCommandEvent &event ) ;
      void OnClearFileList( wxCommandEvent &event ) ;
      void OnExpChange( wxCommandEvent &event ) ;
      void OnDirChange( wxCommandEvent &event ) ;
      void OnFilChange( wxCommandEvent &event ) ;
      void OnAddDirToCbDir( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnCbcList( wxCommandEvent &event ) ;
      void OnCbcListName( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnFind( wxCommandEvent &event ) ;
      void OnFindFirst( wxCommandEvent &event ) ;
      void OnFindNext( wxCommandEvent &event ) ;
      void OnFindPrev( wxCommandEvent &event ) ;
      void OnFindLast( wxCommandEvent &event ) ;
      void OnFindSelFirst( wxCommandEvent &event ) ;
      void OnFindSelNext( wxCommandEvent &event ) ;
      void OnFindSelPrev( wxCommandEvent &event ) ;
      void OnFindSelLast( wxCommandEvent &event ) ;
      void OnHilFil( wxCommandEvent &event ) ;
      void OnHilSel( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnToolbarGrp( wxCommandEvent &event ) ;
      void OnThreeToolbars( wxCommandEvent &event ) ;
      void OnVisuOff( wxCommandEvent &event ) ;
      void OnVisuLeft( wxCommandEvent &event ) ;
      void OnVisuRight( wxCommandEvent &event ) ;
      void OnShowStatusbar( wxCommandEvent &event ) ;
      void OnThumbnail( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnRename( wxCommandEvent &event ) ;
      void OnCompute( wxCommandEvent &event ) ;
      void OnCopy( wxCommandEvent &event ) ;
      void OnUndo( wxCommandEvent &event ) ;
      void OnRedo( wxCommandEvent &event ) ;
      void OnPrefs( wxCommandEvent &event ) ;
      void OnQuit( wxCommandEvent &event ) ;
      void OnFirstContact( wxCommandEvent &event ) ;
      void OnAbout( wxCommandEvent &event ) ;
      void OnHelp( wxCommandEvent &event ) ;
      void OnDirHistory( wxCommandEvent &event ) ;
      void OnDirHistoryMenu( wxCommandEvent &event ) ;
      void OnDirHistoryMenuItemChosen( wxCommandEvent &event ) ;
      void OnDirUp( wxCommandEvent &event ) ;
      void OnDirRefresh( wxCommandEvent &event ) ;
      void OnDirRecurse( wxCommandEvent &event ) ;
      void OnDirStopLoading( wxCommandEvent &event ) ;
      void OnExploreDir( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnFavouriteAdd( wxCommandEvent &event ) ;
      void OnFavouriteOrganize( wxCommandEvent &event ) ;
      void OnFavouriteMenuItemChosen( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnToolAdd( wxCommandEvent &event ) ;
      void OnToolOrganize( wxCommandEvent &event ) ;
      void OnToolMenuItemChosen( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnSelAll( wxCommandEvent &event ) ;
      void OnUnselAll( wxCommandEvent &event ) ;
      void OnSelInv( wxCommandEvent &event ) ;
      void OnSelUnselHil( wxCommandEvent &event ) ;
      void OnSelHil( wxCommandEvent &event ) ;
      void OnUnselHil( wxCommandEvent &event ) ;
      void OnSelFil( wxCommandEvent &event ) ;
      void OnUnselFil( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnColGroup( wxCommandEvent &event ) ;
      void OnCompletion( wxCommandEvent &event ) ;
      void OnDirChoose( wxCommandEvent &event ) ;
      /*-------------------------------------------------------------------*/
      void OnWizard( wxCommandEvent &event ) ;
      void OnCheckVersionManual( wxCommandEvent &event ) ;
      void OnMakeDonation( wxCommandEvent &event ) ;
      void OnTestbed( wxCommandEvent &event ) ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CFRAME_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                           End of file CFrame.h                            !
+==========================================================================*/
