/*====================================+=====================================+
! File CDirTree.h                     ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CDIRTREE_H
#define CDIRTREE_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/dirctrl.h>
#include "CDragAndDrop.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CDirTree : public wxGenericDirCtrl
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDirTree( wxWindow *parent, wxWindowID id = -1 ) ;
      ~CDirTree() ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      wxTreeCtrl *m_p_tree ;
      /*--------------------------------------------------------------------+
      ! Many operations generate SEL_CHANGING and SEL_CHANGED events.       !
      ! Sometimes "reentrance" is not wanted.                               !
      +--------------------------------------------------------------------*/
      bool m_boo_treat_sel_change_events ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      virtual wxTreeCtrl *CreateTreeCtrl( wxWindow *parent,
                                          wxWindowID treeid,
                                          const wxPoint &pos,
                                          const wxSize &size,
                                          long treeStyle
                                        ) ;
      /*-------------------------------------------------------------------*/
      void setup_events( bool boo_connect ) ;
      void init() ;
      wxString get_item_full_path( wxTreeItemId ti ) ;
#ifdef __WXMSW__
      int add_special_folder( size_t sz_before, int i_folder, int i_tfit ) ;
      void add_special_folders() ;
#endif // __WXMSW__

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void init_drop_target()
      {  SetDropTarget( new CDropDir() ) ; }
      void reset_drop_target()
      {  SetDropTarget( NULL ) ; }
      /*-------------------------------------------------------------------*/
      void ensurevisible_current_path() ;
      void OnSelChanging( wxTreeEvent &event ) ;
      void OnSelChanged( wxTreeEvent &event ) ;
      void OnKeyDown( wxTreeEvent &event ) ;
      void OnItemMenu( wxTreeEvent &event ) ;
      /*-------------------------------------------------------------------*/
      int  set_path( const wxString &s_path_abs ) ;
      void apply_hidden() ;
      void recreate() ;
      void refresh() ;
      void recreate_and_refresh() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CDIRTREE_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CDirTree.h                            !
+==========================================================================*/
