/*====================================+=====================================+
! File CDirHistory.h                  ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CDIRHISTORY_H
#define CDIRHISTORY_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CDirHistory
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDirHistory() : m_i_curr_val( 0 )
      {  ; }

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      enum { HISTORY_MAX_SIZE = 100 } ;
      /*-------------------------------------------------------------------*/
      wxArrayString  m_as_val     ;
      int            m_i_curr_val ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      enum e_dh_direction { DH_BACK, DH_FORWARD } ;
      /*-------------------------------------------------------------------*/
      void add( const wxString &s_val ) ;
      bool get_relative_exists( int i_pos ) const ;
      int  get_relative( int i_pos, wxString &s_val ) const ;
      bool get_back_possible() const
      {  return( get_relative_exists( -1 ) ) ; }
      bool get_forward_possible() const
      {  return( get_relative_exists( +1 ) ) ; }
      int  move_back( wxString &s_val ) ;
      int  move_forward( wxString &s_val ) ;
      int  move_to( int i_num, wxString &s_val ) ;
      int  fill_menu( wxMenu *p_menu, e_dh_direction dh_direction ) const ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CDIRHISTORY_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                       End of file CDirHistory.h                           !
+==========================================================================*/
