/*====================================+=====================================+
! File CDir.h                         ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CDIR_H
#define CDIR_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include "CFile.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CDir
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CDir() : m_boo_recurse( false ),
               m_ull_sel_size( 0 ),
               m_i_sel_duration( 0 )
      {  ; }
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      typedef std::vector< CFile >               t_vec_file      ;
      typedef t_vec_file::iterator               t_vec_file_it   ;
      typedef t_vec_file::reverse_iterator       t_vec_file_rit  ;
      typedef t_vec_file::const_iterator         t_vec_file_cit  ;
      typedef t_vec_file::const_reverse_iterator t_vec_file_crit ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      bool       m_boo_recurse ;
      t_vec_file m_vec_file    ;
      /*--------------------------------------------------------------------+
      ! Selected files:                                                     !
      ! - The index in the vector is the selection number                   !
      ! - The value at the position of the index is the position of the     !
      !   file in "m_vec_file"                                              !
      +--------------------------------------------------------------------*/
      sr::t_vec_int m_vec_i_sel      ;
      wxULongLong   m_ull_sel_size   ;
      int           m_i_sel_duration ;
      /*--------------------------------------------------------------------+
      ! In some cases the current directory might be fake. For example for  !
      ! the "Expression testbed".                                           !
      ! If this variable is filled it will indicate two things:             !
      ! - the instance of this class does not reflect reality. Path and     !
      !   files are not supposed to exist                                   !
      ! - the value of the faked path                                       !
      +--------------------------------------------------------------------*/
      wxString m_s_fake_dir ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      void zero()
      {  m_vec_file.clear() ; m_vec_i_sel.clear() ;
         m_ull_sel_size = 0 ; m_i_sel_duration = 0 ;
         m_s_fake_dir.clear() ;
      }
      /*-------------------------------------------------------------------*/
      bool  empty() const { return( m_vec_file.empty() ) ; }
      long  size() const { return( m_vec_file.size() ) ; }
      void  push_back( const CFile &f ) { m_vec_file.push_back( f ) ; }
      CFile &back() { return( m_vec_file.back() ) ; }
      /*-------------------------------------------------------------------*/
      CFile & operator []( int i_num )
      {  return( m_vec_file[ i_num ] ) ; }
      const CFile & operator []( int i_num ) const
      {  return( m_vec_file[ i_num ] ) ; }
      /*-------------------------------------------------------------------*/
      wxString get_dir() const ;
      bool get_recurse() const
      {  return( m_boo_recurse ) ; }
      void set_recurse( bool boo_val )
      {  m_boo_recurse = boo_val ; }
      /*-------------------------------------------------------------------*/
      int get_sel_file_num( int i_num ) const
      {  return( m_vec_i_sel[ i_num ] ) ; }
      int get_nb_sel() const { return( m_vec_i_sel.size() ) ; }
      wxULongLong get_sel_size() const { return( m_ull_sel_size ) ; }
      int get_sel_duration() const { return( m_i_sel_duration ) ; }
      /*-------------------------------------------------------------------*/
      bool is_fake() const { return( !m_s_fake_dir.empty() ) ; }
      wxString get_fake_dir() const { return( m_s_fake_dir ) ; }
      void set_fake_dir( const wxString &s ) { m_s_fake_dir = s ; }
      /*-------------------------------------------------------------------*/
      void add_sel_cumul_info( const CFile &file ) ;
      void sub_sel_cumul_info( const CFile &file ) ;
      int sel( int i_item ) ;
      int unsel( int i_item ) ;
      /*-------------------------------------------------------------------*/
      CFile *get_p_file( size_t sz_num )
      {  if( sz_num >= m_vec_file.size() ) { return( NULL ) ; }
         return( &m_vec_file[ sz_num ] ) ;
      }
      /*-------------------------------------------------------------------*/
      const CFile *get_p_file( size_t sz_num ) const
      {  if( sz_num >= m_vec_file.size() ) { return( NULL ) ; }
         return( &m_vec_file[ sz_num ] ) ;
      }
      /*-------------------------------------------------------------------*/
      void sort( bool boo_natural_sort, bool boo_dir_top, int i_si,
                 int i_sort_type, bool boo_asc,
                 CRunInfoMessage &runinfomessage
               ) ;
      /*-------------------------------------------------------------------*/
      int file_with_name( const wxString &s_name ) const ;
      int file_with_name( const wxFileName &name ) const
      {  return( file_with_name( name.GetFullPath() ) ) ; }
      int file_with_prefix_circle( int i_start, const wxString &s_prefix
                                 ) const ;
      /*-------------------------------------------------------------------*/
      int remove_element( int i_num ) ;
      /*-------------------------------------------------------------------*/
      void init_file_cdir_pointer() ;
      void swap( CDir &dir ) ;
      /*-------------------------------------------------------------------*/
      int get_s_sel_num_rel_dir( const CFile &file ) const ;
      int get_s_sel_num_rel_collision( const CFile &file,
                                       wxString    s_beg_name,
                                       bool        boo_without_path
                                     ) const ;
      void compute_new_names( const wxString &s_exp_src ) ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CDIR_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                           End of file CDir.h                              !
+==========================================================================*/
