/*====================================+=====================================+
! File CColumn.h                      ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCOLUMN_H
#define CCOLUMN_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/listctrl.h>
#include "siren.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CColumn
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CColumn() : m_i_subitem( COL_NB ), m_boo_on_forced( false ),
                  m_boo_on( true ), m_boo_used( false ),
                  m_boo_width_modifiable( true ),
                  m_i_width_def( -1 ), m_i_width( -1 ),
                  m_i_fmt( wxLIST_FORMAT_LEFT ),
                  m_grp( GRP_NB ), m_sort( SORT_NB )
      {  reset_col_disp() ; }
      ~CColumn()
      {  ; }
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      int      m_i_subitem     ; // Subitem associated to this col (COL_NAME)
      bool     m_boo_on_forced ; // Some cols HAVE to be displayed and can't
                                 // be moved.
                                 // Ex: COL_NONE_ICON, COL_NONE_NAME ...
      bool     m_boo_on        ; // Is it displayable ? (checked)
      int      m_i_col_disp    ; // Col in wxListCtrl sens or -1
      bool     m_boo_used      ; // Is it used ?
      int      m_boo_width_modifiable ; // Width can be changed ?
      int      m_i_width_def   ; // Default width
      int      m_i_width       ; // Current width
      int      m_i_fmt         ; // wxListCtrl colmun format
      wxString m_s_name        ; // Column header text
      e_grp    m_grp           ; // Member of group ...
      e_sort   m_sort          ; // How to sort data in this column ?
      wxString m_s_var_name    ; // Associated expression variable
   /*----------------------------------------------------------------------*/
   public :
      /*--( Save / restore data to/from wxConfig file )--------------------*/
      wxString datas_to_string()
      {  return( wxString::Format( "%d %d %d",
                                   m_i_subitem, m_boo_on, m_i_width
                                 )
               ) ;
      }
      /*-------------------------------------------------------------------*/
      void string_to_datas( const wxString &s_val )
      {  int i_bool ;
         wxSscanf( s_val, "%d %d %d", &m_i_subitem, &i_bool, &m_i_width ) ;
         m_boo_on = ( i_bool != 0 ) ;
      }
      /*-------------------------------------------------------------------*/
      int get_width_def() const { return( m_i_width_def ) ; }
      void reset_col_disp() { m_i_col_disp = -1 ; }
      bool displayed() const { return( m_i_col_disp >= 0 ) ; }
      bool get_on_default() ;
      bool to_display() const ;
      /*-------------------------------------------------------------------*/
      friend bool operator == ( const CColumn &col, int i_subitem ) ;
      /*--( Test used during the "apply preferences changes" phase )-------*/
      friend bool operator == ( const CColumn &c1, const CColumn &c2 ) ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CColumnSubItemComp
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool operator() ( const CColumn &c1, const CColumn &c2 ) const
      {  return( c1.m_i_subitem < c2.m_i_subitem ) ; }
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCOLUMN_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                          End of file CColumn.h                            !
+==========================================================================*/
